#include "MMMB.h"
#include <qapplication.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <VrAR5000Source.h>
#include "TVAudioReceiver.h"
#include "AMFMReceiver.h"
#include "CBRadio.h"
#include "Maxon49HX.h"
#include "MidlandFRS.h"
#include "CordlessPhone.h"

const int gupPages = 20;
const int gupRate = 33000000;

const int numModes = 6;

MMMB::MMMB(QWidget *parent = 0, const char *name = 0) :
  QButtonGroup(parent, name),
  curWidget(0)
{
  source = new VrAR5000Source<char>(gupRate);

  setExclusive(true);
  
  QBoxLayout *layout = new QVBoxLayout(this);
  
  QPushButton *b = new QPushButton("AM/FM Radio", this);
  b->setToggleButton(true);
  b->setMinimumSize(b->sizeHint());
  layout->addWidget(b);

  b = new QPushButton("TV Audio", this);
  b->setToggleButton(true);
  b->setMinimumSize(b->sizeHint());
  layout->addWidget(b);

  b = new QPushButton("CB Radio", this);
  b->setToggleButton(true);
  b->setMinimumSize(b->sizeHint());
  layout->addWidget(b);

  b = new QPushButton("Maxon 49-HX", this);
  b->setToggleButton(true);
  b->setMinimumSize(b->sizeHint());
  layout->addWidget(b);

  b = new QPushButton("Midland FRS", this);
  b->setToggleButton(true);
  b->setMinimumSize(b->sizeHint());
  layout->addWidget(b);

  b = new QPushButton("Cordless Phone", this);
  b->setToggleButton(true);
  b->setMinimumSize(b->sizeHint());
  layout->addWidget(b);

  layout->activate();

  connect(this, SIGNAL(clicked(int)), SLOT(buttonClicked(int)));
}

MMMB::~MMMB()
{
  if (curWidget != 0)
    delete curWidget;

  delete source;
}

QSize
MMMB::sizeHint() const
{
  return minimumSize();
}

void
MMMB::buttonClicked(int id)
{
  if (curWidget != 0)
    delete curWidget;

  curWidget = 0;

  if (find(id)->isOn())
    {
      switch (id)
	{
	case 0:
	  curWidget = new AMFMReceiver(source);
	  curWidget->setCaption("AM/FM Radio");
	  break;
	case 1:
	  curWidget = new TVAudioReceiver(source);
	  curWidget->setCaption("TV Audio");
	  break;
	case 2:
	  curWidget = new CBRadio(source);
	  curWidget->setCaption("CB Radio");
	  break;
	case 3:
	  curWidget = new Maxon49HX(source);
	  curWidget->setCaption("Maxon 49-HX");
	  break;
	case 4:
	  curWidget = new MidlandFRS(source);
	  curWidget->setCaption("Midland FRS");
	  break;
	case 5:
	  curWidget = new CordlessPhone(source);
	  curWidget->setCaption("Cordless Phone");
	  break;
	default:
	  break;
	}
    }

  if (curWidget != 0)
    {
      curWidget->adjustSize();
      curWidget->show();
    }

}

int
main(int argc, char **argv)
{
  QApplication a(argc, argv);

  MMMB w;
  a.setMainWidget(&w);
  w.adjustSize();
  w.show();

  return a.exec();
}
