/** @file cmdline.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22.6
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef CMDLINE_H
#define CMDLINE_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE PACKAGE
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#ifdef PACKAGE_NAME
#define CMDLINE_PARSER_PACKAGE_NAME PACKAGE_NAME
#else
#define CMDLINE_PARSER_PACKAGE_NAME PACKAGE
#endif
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION VERSION
#endif

enum enum_scoring { scoring__NULL = -1, scoring_arg_wpm = 0, scoring_arg_cpm };

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  int personal_best_flag;	/**< @brief track personal best typing speeds (default=off).  */
  const char *personal_best_help; /**< @brief track personal best typing speeds help description.  */
  float max_error_arg;	/**< @brief default maximum error percentage; valid values are between 0.0 and 100.0 (default='3.0').  */
  char * max_error_orig;	/**< @brief default maximum error percentage; valid values are between 0.0 and 100.0 original value given at command line.  */
  const char *max_error_help; /**< @brief default maximum error percentage; valid values are between 0.0 and 100.0 help description.  */
  int notimer_flag;	/**< @brief turn off WPM timer in drills (default=off).  */
  const char *notimer_help; /**< @brief turn off WPM timer in drills help description.  */
  int term_cursor_flag;	/**< @brief use the terminal's hardware cursor (default=off).  */
  const char *term_cursor_help; /**< @brief use the terminal's hardware cursor help description.  */
  int curs_flash_arg;	/**< @brief cursor flash period P*.1 sec; valid values are between 0 and 512; this is ignored if -t is specified (default='10').  */
  char * curs_flash_orig;	/**< @brief cursor flash period P*.1 sec; valid values are between 0 and 512; this is ignored if -t is specified original value given at command line.  */
  const char *curs_flash_help; /**< @brief cursor flash period P*.1 sec; valid values are between 0 and 512; this is ignored if -t is specified help description.  */
  char * colours_arg;	/**< @brief set (F)orground and (B)ackground colours, where available (default='7,0').  */
  char * colours_orig;	/**< @brief set (F)orground and (B)ackground colours, where available original value given at command line.  */
  const char *colours_help; /**< @brief set (F)orground and (B)ackground colours, where available help description.  */
  int silent_flag;	/**< @brief don't beep on errors (default=off).  */
  const char *silent_help; /**< @brief don't beep on errors help description.  */
  int quiet_flag;	/**< @brief same as --silent (default=off).  */
  const char *quiet_help; /**< @brief same as --silent help description.  */
  char * start_label_arg;	/**< @brief start the lesson at the given label.  */
  char * start_label_orig;	/**< @brief start the lesson at the given label original value given at command line.  */
  const char *start_label_help; /**< @brief start the lesson at the given label help description.  */
  int word_processor_flag;	/**< @brief try to mimic word processors (default=off).  */
  const char *word_processor_help; /**< @brief try to mimic word processors help description.  */
  int no_skip_flag;	/**< @brief forbid the user to skip exercises (default=off).  */
  const char *no_skip_help; /**< @brief forbid the user to skip exercises help description.  */
  int show_errors_flag;	/**< @brief highlight errors with reverse video (default=off).  */
  const char *show_errors_help; /**< @brief highlight errors with reverse video help description.  */
  int sync_ahead_flag;	/**< @brief try to sync ahead (i.e. h_s if you type hs) (default=on).  */
  const char *sync_ahead_help; /**< @brief try to sync ahead (i.e. h_s if you type hs) help description.  */
  int always_sure_flag;	/**< @brief do not ask confirmation questions (default=off).  */
  const char *always_sure_help; /**< @brief do not ask confirmation questions help description.  */
  char * banner_colors_arg;	/**< @brief set top banner colours: (F)oreground, (B)ackground, (P)ackage and (V)ersion (default='6,0,5,1').  */
  char * banner_colors_orig;	/**< @brief set top banner colours: (F)oreground, (B)ackground, (P)ackage and (V)ersion original value given at command line.  */
  const char *banner_colors_help; /**< @brief set top banner colours: (F)oreground, (B)ackground, (P)ackage and (V)ersion help description.  */
  enum enum_scoring scoring_arg;	/**< @brief set scoring mode; valid values are \"wpm\" (words per minute) and \"cpm\" (characters per minute).  */
  char * scoring_orig;	/**< @brief set scoring mode; valid values are \"wpm\" (words per minute) and \"cpm\" (characters per minute) original value given at command line.  */
  const char *scoring_help; /**< @brief set scoring mode; valid values are \"wpm\" (words per minute) and \"cpm\" (characters per minute) help description.  */
  int no_welcome_screen_flag;	/**< @brief don't show beginner tutorial message at start-up (default=off).  */
  const char *no_welcome_screen_help; /**< @brief don't show beginner tutorial message at start-up help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int personal_best_given ;	/**< @brief Whether personal-best was given.  */
  unsigned int max_error_given ;	/**< @brief Whether max-error was given.  */
  unsigned int notimer_given ;	/**< @brief Whether notimer was given.  */
  unsigned int term_cursor_given ;	/**< @brief Whether term-cursor was given.  */
  unsigned int curs_flash_given ;	/**< @brief Whether curs-flash was given.  */
  unsigned int colours_given ;	/**< @brief Whether colours was given.  */
  unsigned int silent_given ;	/**< @brief Whether silent was given.  */
  unsigned int quiet_given ;	/**< @brief Whether quiet was given.  */
  unsigned int start_label_given ;	/**< @brief Whether start-label was given.  */
  unsigned int word_processor_given ;	/**< @brief Whether word-processor was given.  */
  unsigned int no_skip_given ;	/**< @brief Whether no-skip was given.  */
  unsigned int show_errors_given ;	/**< @brief Whether show-errors was given.  */
  unsigned int sync_ahead_given ;	/**< @brief Whether sync-ahead was given.  */
  unsigned int always_sure_given ;	/**< @brief Whether always-sure was given.  */
  unsigned int banner_colors_given ;	/**< @brief Whether banner-colors was given.  */
  unsigned int scoring_given ;	/**< @brief Whether scoring was given.  */
  unsigned int no_welcome_screen_given ;	/**< @brief Whether no-welcome-screen was given.  */

  char **inputs ; /**< @brief unamed options (options without names) */
  unsigned inputs_num ; /**< @brief unamed options number */
} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char **argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * The config file parser (deprecated version)
 * @param filename the name of the config file
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_config_file() instead
 */
int cmdline_parser_configfile (const char *filename,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The config file parser
 * @param filename the name of the config file
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_config_file (const char *filename,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);

extern const char *cmdline_parser_scoring_values[];  /**< @brief Possible values for scoring. */


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* CMDLINE_H */
