/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.debug.Debug;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class ImageLoader
extends ClassLoader {
    String name;
    byte[] bytes;
    Class c;
    ClassLoader parent;
    private static volatile transient long expressionUID = 0L;
    public static String classNamePrefix = "gnu/jel/generated/E_";

    private ImageLoader(String name, byte[] bytes) {
        this.name = name;
        this.bytes = bytes;
        this.c = null;
        this.parent = this.getClass().getClassLoader();
    }

    public static Class load(byte[] image) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(image);
            DataInputStream dis = new DataInputStream(bais);
            dis.skip(10L);
            Debug.assert(dis.readUnsignedByte() == 1, "Attempt to load non-JEL generated class file");
            String name = dis.readUTF();
            ImageLoader il = new ImageLoader(name, image);
            return il.loadClass(name);
        }
        catch (Exception e) {
            Debug.reportThrowable(e);
            return null;
        }
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (!name.equals(this.name)) {
            if (this.parent != null) {
                return this.parent.loadClass(name);
            }
            return this.findSystemClass(name);
        }
        if (this.c == null) {
            this.c = this.defineClass(name, this.bytes, 0, this.bytes.length);
            if (resolve) {
                this.resolveClass(this.c);
            }
        }
        return this.c;
    }

    public static Class loadRenamed(byte[] image) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(image);
            DataInputStream dis = new DataInputStream(bais);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            byte[] buf = new byte[15];
            int rc = dis.read(buf, 0, 11);
            Debug.assert(rc == 11 && buf[10] == 1, "Attempt to load non-JEL generated class file");
            String name = dis.readUTF();
            dos.write(buf, 0, 11);
            dos.writeUTF(String.valueOf(classNamePrefix) + Long.toString(expressionUID++));
            while ((rc = dis.read(buf)) > 0) {
                dos.write(buf, 0, rc);
            }
            ImageLoader il = new ImageLoader(name, baos.toByteArray());
            return il.loadClass(name);
        }
        catch (Exception e) {
            Debug.reportThrowable(e);
            return null;
        }
    }
}

