
(defun pow (x y)
  (exp (* y (log x))))

;; (pow 2 (- 16 4)) = 4095 tiles


(defun fact (n)
  "Inefficient"
  (if (> n 1)
      (* n (fact (- n 1)))
    1))

(defun fact (n)
  "Efficient"
  (let ((answer 1)
        (count  1))
    (while (<= count n)
      (setq answer (* count answer))
      (incf count))
    answer))

;; (fact 4) (fact 7) (fact 3)

;; nCr = n! / (n-r)! r!

(defun combinations (n r)
  (/ (fact n) (fact (- n r)) (fact r)))

;; (combinations 4 0)

;; (setq shift 2)
;; (setq i 22)
;; (lsl 2 10)
(defun lsl (i shift)
  (while (> shift 0)
    (setq i (* i 2))
    (setq shift (- shift 1)))
  i)

(provide 'd-math)
;;; d-math.el ends here
