/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.kawa.io.CheckConsole;
import gnu.kawa.io.InPort;
import gnu.text.SourceLocator;
import gnu.text.SourceMapper;
import java.io.File;
import java.io.IOException;

public class SourceError
extends SourceLocator.Simple {
    public SourceError next;
    public char severity;
    public String code;
    public String message;
    public Throwable fakeException;

    public SourceError(char severity, String filename, int line, int column, String message) {
        this.severity = severity;
        this.filename = filename;
        this.position = SourceMapper.simpleEncode(line, column);
        this.message = message;
    }

    public SourceError(char severity, SourceLocator location2, String message) {
        this.severity = severity;
        this.filename = location2.getFileName();
        this.position = SourceMapper.simpleEncode(location2);
        this.message = message;
    }

    public SourceError(InPort port, char severity, String message) {
        this(severity, port.getName(), SourceError.adjustFromPort(port.getLineNumber()), SourceError.adjustFromPort(port.getColumnNumber()), message);
    }

    private static int adjustFromPort(int portPosition) {
        return portPosition >= 0 ? portPosition + 1 : portPosition;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean stripDirectories) {
        StringBuilder buffer = new StringBuilder();
        this.appendTo(buffer, stripDirectories, null);
        return buffer.toString();
    }

    public static void appendEscaped(Appendable out, CharSequence str) throws IOException {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '<' || ch == '>' || ch == '&') {
                out.append(ch == '<' ? "&lt;" : (ch == '>' ? "&gt;" : "&amp;"));
                continue;
            }
            out.append(ch);
        }
    }

    public void appendTo(Appendable out, boolean stripDirectories, String newLine) {
        boolean isDomTerm = CheckConsole.forDomTerm(out);
        try {
            String fname;
            if (isDomTerm) {
                out.append("\u001b]44;" + (this.isRepl() ? "repl: true" : "") + "\u0007");
            }
            if (isDomTerm) {
                out.append("\u001b[44;0u");
            }
            if (this.filename == null) {
                fname = "<unknown>";
            } else {
                fname = this.filename;
                if (stripDirectories) {
                    fname = new File(fname).getName();
                }
            }
            StringBuilder position = new StringBuilder();
            String endpos = "";
            int line = this.getStartLine();
            int column = this.getStartColumn();
            if (line > 0 || column > 0) {
                position.append(Integer.toString(line));
                if (column > 0) {
                    position.append(':');
                    position.append(Integer.toString(column));
                }
                int eline = this.getEndLine();
                int ecolumn = this.getEndColumn();
                if (eline > 0 && ecolumn > 0 && column > 0) {
                    if (line == eline && ecolumn > column) {
                        endpos = "-" + ecolumn;
                    } else if (eline > line) {
                        endpos = "-" + eline + ":" + ecolumn;
                    }
                }
            }
            if (isDomTerm) {
                out.append("\u001b]72;");
                out.append("<a class='subtle' href='");
                out.append(new File(fname).toURI().toString());
                if (position.length() > 0) {
                    out.append("#position=");
                    out.append(position);
                    out.append(endpos);
                }
                out.append("'>");
                SourceError.appendEscaped(out, fname);
            } else {
                out.append(fname);
            }
            if (position.length() > 0) {
                out.append(':');
                out.append(position);
            }
            if (isDomTerm) {
                out.append("</a>\u0007");
            }
            out.append(": ");
            if (this.severity == 'w') {
                out.append("warning - ");
            } else if (this.severity == 'i') {
                out.append("note - ");
            }
            out.append(this.message);
            if (this.code != null) {
                out.append(" [");
                out.append(this.code);
                out.append("]");
            }
            if (this.fakeException != null) {
                StackTraceElement[] stackTrace = this.fakeException.getStackTrace();
                for (int i = 0; i < stackTrace.length; ++i) {
                    out.append(newLine != null ? newLine : "\n");
                    out.append("    ");
                    out.append(stackTrace[i].toString());
                }
            }
            if (isDomTerm) {
                out.append("\u001b[44;0u");
            }
            if (newLine != null) {
                out.append(newLine);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void print(Appendable out) {
        this.appendTo(out, false, null);
    }

    public void println(Appendable out, boolean stripDirectories) {
        this.appendTo(out, stripDirectories, System.getProperty("line.separator", "\n"));
    }
}

