<?php

//        # Copyright (C) 2012-2013 GNU remotecontrol authors.
//        #
//        # This program is free software: you can redistribute it and/or modify
//        # it under the terms of the GNU Affero General Public License as
//        # published by the Free Software Foundation, either version 3 of the
//        # License, or (at your option) any later version.
//        #
//        # This program is distributed in the hope that it will be useful,
//        # but WITHOUT ANY WARRANTY; without even the implied warranty of
//        # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//        # GNU Affero General Public License for more details.
//        #
//        # You should have received a copy of the GNU Affero General Public License
//        # along with this program.  If not, see <http://www.gnu.org/licenses/>.

	class IPThermostatObject
	{
		// Properties
		public $OID;
		public $Name;
		public $CurrentValue;
		public $NewValue;

		// Constructor
		public function __construct()
		{
			$numargs = func_num_args();
			$args = func_get_args();
			
			switch($numargs)
			{
				case 1:

					$this->OID = $args[0];
					$this->Name = $this->GetName();
					$this->CurrentValue = '';
					$this->NewValue = '';

					break;

				case 2:

					$this->OID = $args[0];
					$this->Name = $args[1];
					$this->CurrentValue = '';
					$this->NewValue = '';

					break;

				case 3:

					$this->OID = $args[0];
					$this->Name = $args[1];
					$this->CurrentValue = '';
					$this->NewValue = $args[2];

					break;

				default:

					$this->OID = '';
					$this->Name = '';
					$this->CurrentValue = '';
					$this->NewValue = '';

					break;
			}					
		}

		// Methods
		private function GetName()
		{
			$dataAccess = new MySqlDataAccess(Common::ConnectionString);
			$dataAccess->Command->CommandType = CommandType::StoredProcedure;
			$dataAccess->Command->CommandText = 'CALL sp_OID_FieldName_Load(\''.substr($this->OID, 3).'\')';

			$name = $dataAccess->Command->ExecuteScalar();

			$dataAccess->Cleanup();

			return $name;
		}
	}

?>
