<?php


//        # Copyright (C) 2012-2013 GNU remotecontrol authors.
//        #
//        # This program is free software: you can redistribute it and/or modify
//        # it under the terms of the GNU Affero General Public License as
//        # published by the Free Software Foundation, either version 3 of the
//        # License, or (at your option) any later version.
//        #
//        # This program is distributed in the hope that it will be useful,
//        # but WITHOUT ANY WARRANTY; without even the implied warranty of
//        # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//        # GNU Affero General Public License for more details.
//        #
//        # You should have received a copy of the GNU Affero General Public License
//        # along with this program.  If not, see <http://www.gnu.org/licenses/>.

	class User
	{
		// Properties
	       public $ID;
	       public $UserName;
	       public $MaxTherms;
               //public $LangCode;
               //public $LangDesc;
               public $Language;
               public $_loadByUserName;
               public $ThermostatSort;

		// Constructor
		public function __construct()
		{
			$numargs = func_num_args();
			$args = func_get_args();
			switch($numargs)
			{
				case 1:

					$this->UserName = $args[0];

					$this->_loadByUserName = true;

					$this->Load();

					break;

				case 2:

					$this->ID = $args[0];

					$this->_loadByUserName = false;

					if($args[1] === true)
					{
						$this->Load();
					}

					break;

				case 4:

					$this->ID = $args[0];
					$this->UserName = $args[1];
					$this->MaxTherms = $args[2];

                                        $this->Language = new Language($args[3], true);

                                       break;
			}
		}

		// Methods
		private function Load()
		{
			$dataAccess = new MySqlDataAccess(Common::ConnectionString);
			$dataAccess->Command->CommandType = CommandType::StoredProcedure;

			if($this->_loadByUserName)
			{
				$dataAccess->Command->CommandText = "CALL sp_User_Load_Details_By_UserName('$this->UserName')";
			}
			else
			{
				$dataAccess->Command->CommandText = "CALL sp_User_Load_Details_By_UserID($this->ID)";
			}

			$dataAccess->GetData();

			$row = $dataAccess->ResultSet->fetch_assoc();

			if($this->_loadByUserName)
			{
				$this->ID = $row['UserId'];
			}
			else
			{
				$this->UserName = $row['UserName'];
			}

			$this->MaxTherms = $row['MaxNumThermostats'];
                        $this->Language = new Language($row['LangCode'], $row['LangDesc']);
                        $this->ThermostatSort = $row['ThermostatSort'];

			$dataAccess->Cleanup();
		}

		public function displayMaxTherms()
		{
		    return (number_format($this->MaxTherms));
		}

		public function updateThermostatSortField($sortField)
		{
		    if (!is_string($sortField)) {
		        throw new Exception('sort field is not string');
		    }
		    $dataAccess = new MySqlDataAccess(Common::ConnectionString);
		    $dataAccess->Command->CommandType = CommandType::StoredProcedure;
		    $dataAccess->Command->CommandText =
			"CALL sp_User_Update_Thermostat_Sort_Field($this->ID, '{$sortField}')";
		    $dataAccess->Command->ExecuteNonQuery();
		    $this->ThermostatSort = $sortField;
			$dataAccess->Cleanup();
		    return $sortField;

		}

	}

?>
