%{
/*
 * Copyright (C) 2003  Lorenzo Bettini <bettini@gnu.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

static  int lineno = 1 ; /* number of scanned lines */

#include "genfun.h"

#define PUSH(s) yy_push_state(s);
#define POP() yy_pop_state();

%}
%option prefix="caml_scanner_"
%option noyywrap
%option stack

nl \n
cr \r
STRING \"[^\"\n]*\"
not_alpha [^a-zA-Z0-9]

%s COMMENT_STATE
%s STRING_STATE
%s CHAR_STATE
%s PREPROC_STATE

IDE [a-zA-Z_]([a-zA-Z0-9_])*
wspace [ \t\n\r]
templspec \<({wspace}|{IDE})*\>


keyword (and|as|assert|asr|begin|class|closed|constraint|do|done|downto|else|end|exception|false|for|fun|function|functor|if|in|inherit|land|lazy|let|lor|lsl|lsr|lxor|match|method|mod|module|mutable|new|of|or|parser|private|rec|sig|struct|then|to|true|try|type|val|virtual|when|while|with)
preproc (external|open|include)
symbol [\~\!\%\^\*\(\)\-\+\=\[\]\|\\\:\;\,\.\/\?\&\<\>]
cbracket [\{\}]

funccall {IDE}/{wspace}*({templspec}){0,1}{wspace}*\(

%%

<INITIAL>"(*" { BEGIN COMMENT_STATE ;
       startComment( yytext ) ;      
     }
<INITIAL>"(*".*"*)" { generateComment( yytext ) ;  }

<COMMENT_STATE>\r*\n { 
   endComment (""); 
   ++lineno;
   generateNewLine(yytext) ;
   startComment ("");
   /* if we encounter another (* during a comment we simply
      treat it as a ordinary string */
 }
<COMMENT_STATE>"*)" { endComment(yytext) ;
                      BEGIN INITIAL ; /* end of the comment */ }

<INITIAL>\" { BEGIN STRING_STATE ; startString( yytext );  }
<STRING_STATE>\\\\ {  generate_preproc( yytext ) ; }
<STRING_STATE>"\\\"" {  generate_preproc( yytext ) ; }
<STRING_STATE>\" { BEGIN INITIAL ; endString( yytext ) ; }

<INITIAL>\' { generate_normal( yytext );  }

<INITIAL>{preproc} {
        generatePreProc( yytext) ; 
}

<INITIAL>\#[ \t]*[^\"\n\t\r ]* {
        yyless (1); // put back anything after the #
        generatePreProc( yytext) ; 
        PUSH (PREPROC_STATE);
}

<PREPROC_STATE>{IDE} {
        generatePreProc (yytext);
        POP ();
}

<INITIAL>{keyword} { generateKeyWord( yytext ) ; }
<INITIAL>{symbol} { generateSymbol( yytext ); }
<INITIAL>[\{\}] { generateCBracket ( yytext ); }

<INITIAL>0[xX][0-9a-fA-F]* { generateNumber( yytext ) ; }
<INITIAL>[0-9][0-9]*(\.[0-9]*[eE]?[-+]?[0-9]*)? { generateNumber( yytext ) ; }

<INITIAL>[a-zA-Z_]([a-zA-Z0-9_])* { generate_normal( yytext ) ; }

\t {
        generateTab() ;
}

\r* {
        generate_preproc(&yytext[yyleng-1]);
        // skip the previous ones, only generate one
}

. { generate_preproc( yytext ) ; /* anything else */ }

\n { 
       ++lineno;
       generateNewLine() ;
}

%%
/*
void yyerror( char *s ) ;

void yyerror( char *s )
{  
  fprintf( stderr, "%d: %s: %s\n%s\n", lineno, s, yytext, linebuf ) ;
  fprintf( stderr, "%*s\n", tokenpos, "^" ) ;
}
*/
/* vim:set ft=flex expandtab cindent tabstop=4 softtabstop=4 shiftwidth=4 textwidth=0: */
