/*
   This file is part of TALER
   Copyright (C) 2024 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_select_donau_instances_filtered.h
 * @brief implementation of the select_donau_instance function for Postgres
 * @author Bohdan Potuzhnyi
 * @author Vlada Svirsh
 */
#ifndef PG_SELECT_DONAU_INSTANCE_FILTERED_H
#define PG_SELECT_DONAU_INSTANCE_FILTERED_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"
#include "taler_merchant_donau.h"
#include "donau/donau_util.h"

/**
 * Select multiple Donau instances from the database.
 *
 * @param cls the closure for the database context
 * @param currency currency to filter donau instances by
 * @param cb callback function to call with each result
 * @param cb_cls closure for the callback
 * @return status of the PG
 */
enum GNUNET_DB_QueryStatus
TMH_PG_select_donau_instances_filtered (
  void *cls,
  const char *currency,
  TALER_MERCHANTDB_DonauInstanceFilteredCallback cb,
  void *cb_cls);

#endif
