(*^

::[paletteColors = 128; 
	fontset = title, "Helvetica-Bold", 24, L2, center, bold, nohscroll;
	fontset = subtitle, "Helvetica-Bold", 18, L2, center, bold, nohscroll;
	fontset = subsubtitle, "Helvetica-Bold", 14, L2, center, bold, nohscroll;
	fontset = section, "Helvetica-Bold", 16, L2, bold, nohscroll, grayBox;
	fontset = subsection, "Helvetica-Bold", 13, L2, bold, nohscroll, blackBox;
	fontset = subsubsection, "Helvetica-Bold", 12, L2, bold, nohscroll, whiteBox;
	fontset = text, "Times-Roman", 12, L2, nohscroll;
	fontset = smalltext, "Times-Roman", 10, L2, nohscroll;
	fontset = input, "Courier-Bold", 12, L2, bold, nowordwrap;
	fontset = output, "Courier", 12, L2, nowordwrap;
	fontset = message, "Courier", 12, L2, R21845, G21845, B21845, nowordwrap;
	fontset = print, "Courier", 12, L2, nowordwrap;
	fontset = info, "Courier", 12, L2, nowordwrap;
	fontset = postscript, "Courier", 12, L2, nowordwrap;
	fontset = name, "Times-Italic", 11, L2, italic, R21845, G21845, B21845, nowordwrap, nohscroll;
	fontset = header, "Times", 10, L2;
	fontset = footer, "Times", 12, L2, center;
	fontset = help, "Times-Roman", 13, L2, nohscroll;
	fontset = clipboard, "New York", 12, L2;
	fontset = completions, "Courier", 16, L2, nowordwrap;
	fontset = network, "Courier", 10, L2, nowordwrap;
	fontset = graphlabel, "Courier", 12, L2, nowordwrap;
	fontset = special1, "New York", 12, L2, nowordwrap;
	fontset = special2, "New York", 12, L2, center, nowordwrap;
	fontset = special3, "New York", 12, L2, right, nowordwrap;
	fontset = special4, "New York", 12, L2, nowordwrap;
	fontset = special5, "New York", 12, L2, nowordwrap;]
:[font = title; inactive; ]
Book Pictures
:[font = text; inactive; ]
This is the code to generate most of the pictures used for title pages of the chapters.
:[font = subsubsection; inactive; locked; startGroup; Cclosed; ]
Copyright Notice
:[font = smalltext; inactive; locked; endGroup; ]

	Copyright 1989 by Roman Maeder.
	
	Adapted from	Roman E. Maeder: Programming in Mathematica, Addison-Wesley, 1989.
	
	Permission is hereby granted to make copies of	this file for any purpose other than direct profit,	or as part of a commercial product, provided this copyright notice is left intact.	Sale, other than for the cost of media, is prohibited.
	
	Permission is hereby granted to reproduce part or all of this file provided that the source is acknowledged.

:[font = section; inactive; startGroup; Cclosed; ]
Initialization
:[font = input; initialization; ]
*)

Needs["RMPackages`ComplexMap`"]
Needs["RMPackages`NewParametricPlot3D`"]
Needs["Graphics`Shapes`"]
Needs["Graphics`Polyhedra`"]
Needs["RMPackages`RungeKutta`"]
Needs["RMPackages`RandomWalk`"]
(*
:[font = text; inactive; startGroup; Cclosed; ]
fix bug in EdgeForm[GrayLevel[..]] (in V1.2)
:[font = input; initialization; endGroup; endGroup; ]
*)
Unprotect[ GrayLevel ];
GrayLevel[lev_] := RGBColor[lev, lev, lev];
Protect[GrayLevel];
(*
:[font = section; inactive; startGroup; Cclosed; ]
Chapter 1: Moebius Transform
:[font = input; endGroup; ]
PolarMap[ (2#-I)/(#-1)&,
	{0.001, 5.001, 0.25}, {0, 2Pi, Pi/15},
    Framed->True ];
:[font = section; inactive; startGroup; Cclosed; ]
Chapter 2: Minimal Surface
:[font = input; endGroup; ]
ParametricPlot3D[
	{r*Cos[phi] - (r^2*Cos[2*phi])/2,
	 -(r*Sin[phi]) - (r^2*Sin[2*phi])/2,
	 (4*r^(3/2)*Cos[(3*phi)/2])/3},
	{r, 0.0001, 1, 0.9999/8}, {phi, 0, 4Pi, Pi/12} ];
:[font = section; inactive; startGroup; Cclosed; ]
Chapter 3: Rotationally Symmetric Parametric Surface
:[font = input; endGroup; ]
ParametricPlot3D[
	{r Cos[Cos[r]] Cos[psi],
	 r Cos[Cos[r]] Sin[psi],
	 r Sin[Cos[r]]},
	{r, 0.001, 9Pi/2 + 0.001, Pi/16},
	{psi, 0, 3Pi/2, Pi/16} ];
:[font = section; inactive; startGroup; Cclosed; ]
Chapter 4: Fractal Tile
:[font = text; inactive; ]
The number iterations determines the time it takes.
:[font = input; ]
iterations = 5;
:[font = input; endGroup; ]
om7 = N[-1+Sqrt[-3]]/2; l7=om7-2;
r7 = {0, 1,-1,om7,-om7,om7+1,-om7-1};
g7[x_] := Flatten[Outer[Plus, r7 , l7 x]];
points = Point[{Re[#],Im[#]}]& /@
			Nest[g7, {0.}, iterations];
graph4 = Graphics[Prepend[points, PointSize[0.003]]];
Show[graph4, AspectRatio->1, Axes->None, Framed->True];
:[font = section; inactive; startGroup; Cclosed; ]
Chapter 5: Sphere with Random Holes
:[font = input; endGroup; ]
Show[ Graphics3D[Select[Sphere[][[1]], Random[]>0.5&]] ];
:[font = section; inactive; startGroup; Cclosed; ]
Chapter 6: Saddle Surface
:[font = input; endGroup; ]
CylindricalPlot3D[r^2 Cos[2 phi],
		{r, 0, 1/2, 1/16}, {phi, 0, 2Pi, 2Pi/24}];
:[font = section; inactive; startGroup; Cclosed; ]
Chapter 7: Van-der-Pol Equation
:[font = text; inactive; ]
coupling constant
:[font = input; ]
eps = 1.5;
:[font = input; endGroup; ]
vdp = RungeKutta[{xdot, eps (1 - x^2) xdot - x}, {x, xdot},
	{2, 0}, {4Pi, 0.05}];
ListPlot[vdp, PlotJoined->True, AspectRatio -> Automatic];
:[font = section; inactive; startGroup; Cclosed; ]
Chapter 9: Fourier Approximations of Saw-Tooth
:[font = text; inactive; ]
number of approximations
:[font = input; ]
approx = 5;
:[font = input; endGroup; ]
fourier = Table[ Sum[Sin[i x]/i, {i, n}], {n, approx} ];
Plot[ Release[fourier], {x, -0.3, 2Pi+0.3}, Framed->True ];
:[font = section; inactive; startGroup; Cclosed; ]
Chapter 10: Spiral with Varying Radius
:[font = input; endGroup; ]
ParametricPlot3D[
	{r (1 + phi/2) Cos[phi],
	 r (1 + phi/2) Sin[phi],
	 -phi/2},
	{r, 0.1, 1.1, 0.125}, {phi, 0, 11Pi/2, Pi/12}];
:[font = section; inactive; startGroup; Cclosed; ]
Chapter 11: Diagonally Shaded Surface
:[font = input; endGroup; ]
SphericalPlot3D[
	{Sin[theta],
	 FaceForm[GrayLevel[0.05 + 0.9 Sin[2theta + phi]^2],
	          GrayLevel[0.05 + 0.9 Sin[2theta - phi]^2]]},
	{theta, 0, Pi, Pi/24}, {phi, 0, 3Pi/2, Pi/12},
	Lighting->False ];
:[font = section; inactive; startGroup; Cclosed; ]
Appendix A: Random Walk
:[font = input; endGroup; ]
RandomWalk[5000];
:[font = section; inactive; startGroup; Cclosed; ]
Appendix B: Great Icosahedron
:[font = text; inactive; startGroup; Cclosed; ]
vertices computed from icosahedron
:[font = input; initialization; ]
*)
AdjacentTo[face_, flist_] :=
	Select[flist, Length[Intersection[face, #]] == 2&]
(*
:[font = input; initialization; ]
*)
Opposite[face_, flist_] :=
	Block[ {adjacent, next},
		adjacent = AdjacentTo[ face, flist ];
		next = AdjacentTo[#, flist]& /@ adjacent;
		next = Complement[#, {face}]& /@ next;
		Flatten[ Intersection @@ #& /@ next ]
	]
(*
:[font = input; initialization; ]
*)
AppendTo[Polyhedra, GreatIcosahedron]
(*
:[font = input; initialization; ]
*)
GreatIcosahedron/:
Vertices[GreatIcosahedron] = Vertices[Icosahedron];
(*
:[font = input; initialization; endGroup; ]
*)
GreatIcosahedron/:
Faces[GreatIcosahedron] =
	Opposite[#, Faces[Icosahedron]]& /@ Faces[Icosahedron];
(*
:[font = input; endGroup; ]
Show[ Polyhedron[GreatIcosahedron] ];

^*)