(*^

::[paletteColors = 128; 
	fontset = title, "Helvetica-Bold", 24, L2, center, bold, nohscroll;
	fontset = subtitle, "Helvetica-Bold", 18, L2, center, bold, nohscroll;
	fontset = subsubtitle, "Helvetica-Bold", 14, L2, center, bold, nohscroll;
	fontset = section, "Helvetica-Bold", 16, L2, bold, nohscroll, grayBox;
	fontset = subsection, "Helvetica-Bold", 13, L2, bold, nohscroll, blackBox;
	fontset = subsubsection, "Helvetica-Bold", 12, L2, bold, nohscroll, whiteBox;
	fontset = text, "Times-Roman", 12, L2, nohscroll;
	fontset = smalltext, "Times-Roman", 10, L2, nohscroll;
	fontset = input, "Courier-Bold", 12, L2, bold, nowordwrap;
	fontset = output, "Courier", 12, L2, nowordwrap;
	fontset = message, "Courier", 12, L2, R21845, G21845, B21845, nowordwrap;
	fontset = print, "Courier", 12, L2, nowordwrap;
	fontset = info, "Courier", 12, L2, nowordwrap;
	fontset = postscript, "Courier", 12, L2, nowordwrap;
	fontset = name, "Times-Italic", 11, L2, italic, R21845, G21845, B21845, nowordwrap, nohscroll;
	fontset = header, "Times", 10, L2;
	fontset = footer, "Times", 12, L2, center;
	fontset = help, "Times-Roman", 13, L2, nohscroll;
	fontset = clipboard, "New York", 12, L2;
	fontset = completions, "Courier", 16, L2, nowordwrap;
	fontset = network, "Courier", 10, L2, nowordwrap;
	fontset = graphlabel, "Courier", 12, L2, nowordwrap;
	fontset = special1, "New York", 12, L2, nowordwrap;
	fontset = special2, "New York", 12, L2, center, nowordwrap;
	fontset = special3, "New York", 12, L2, right, nowordwrap;
	fontset = special4, "New York", 12, L2, nowordwrap;
	fontset = special5, "New York", 12, L2, nowordwrap;]
:[font = title; inactive; ]
Simplifications with Re[] and Im[]
:[font = text; inactive; ]
This example comes from subsection 2.3.2.
:[font = text; inactive; ]
Note: this package can replace the one that comes with V1.2 of Mathematica.  (In the Algebra folder of the Packages folder.)
:[font = subsubsection; inactive; locked; startGroup; Cclosed; ]
Copyright Notice
:[font = smalltext; inactive; locked; endGroup; ]

	Copyright 1989 by Roman Maeder.
	
	Adapted from	Roman E. Maeder: Programming in Mathematica, Addison-Wesley, 1989.
	
	Permission is hereby granted to make copies of	this file for any purpose other than direct profit,	or as part of a commercial product, provided this copyright notice is left intact.	Sale, other than for the cost of media, is prohibited.
	
	Permission is hereby granted to reproduce part or all of this file provided that the source is acknowledged.

:[font = section; inactive; startGroup; Cclosed; ]
Examples
:[font = subsection; inactive; startGroup; Cclosed; ]
Declaring Variables to be Real
:[font = text; inactive; ]
A variable is declared real by setting its imaginary part to 0.
:[font = input; ]
x/: Im[x] = 0
:[font = text; inactive; ]
Expressions involving x are now simplified
:[font = input; ]
Re[x y]
:[font = input; ]
Im[E^(x+z)]
:[font = input; endGroup; endGroup; ]
Conjugate[I x]
:[font = section; inactive; startGroup; Cclosed; ]
Implementation
:[font = input; initialization; ]
*)
BeginPackage["RMPackages`ReIm`"]
(*
:[font = input; initialization; ]
*)
(*  to declare a variable x to be real, define    x/: Im[x] = 0  *)
(*
:[font = input; initialization; ]
*)
(* no exports *)
(*
:[font = input; initialization; ]
*)
Begin["`Private`"]
(*
:[font = input; initialization; ]
*)
protected = Unprotect[Re,Im, Abs, Conjugate, Arg]
(*
:[font = input; initialization; ]
*)
(* fundamental rules, Im[x]==0 serves as our test for 'reality' *)
(*
:[font = input; initialization; ]
*)
Re[x_] := x  /; Im[x] == 0
Conjugate[x_] :=  x /; Im[x] == 0
Conjugate[x_] := -x /; Re[x] == 0
(*
:[font = input; initialization; ]
*)
(* there must not be a rule for Im[x] in terms of Re[x] !! *)
(*
:[font = input; initialization; ]
*)
(* things known to be real *)
(*
:[font = input; initialization; ]
*)
Im[Re[ _ ]]  := 0
Im[Im[ _ ]]  := 0
Im[Abs[ _ ]] := 0
Im[Arg[ _ ]] := 0
(*
:[font = input; initialization; ]
*)
(* arithmetic *)
(*
:[font = input; initialization; ]
*)
Re[x_ + y_] := Re[x] + Re[y]
Im[x_ + y_] := Im[x] + Im[y]
(*
:[font = input; initialization; ]
*)
Re[x_ y_] := Re[x] Re[y] - Im[x] Im[y]
Im[x_ y_] := Re[x] Im[y] + Im[x] Re[y]
(*
:[font = input; initialization; ]
*)
Re[ 1/x_ ] :=  Re[x] / (Re[x]^2 + Im[x]^2)
Im[ 1/x_ ] := -Im[x] / (Re[x]^2 + Im[x]^2)
(*
:[font = input; initialization; ]
*)
Re[E^x_] := Cos[Im[x]] Exp[Re[x]]
Im[E^x_] := Sin[Im[x]] Exp[Re[x]]
(*
:[font = input; initialization; ]
*)
Im[x_^2] := 2 Re[x] Im[x]
(*
:[font = input; initialization; ]
*)
Re[ x_^n_Integer ] :=
	Block[{a, b},
		a = Round[n/2]; b = n-a;
		Re[x^a] Re[x^b] - Im[x^a] Im[x^b]
	]
(*
:[font = input; initialization; ]
*)
Im[ x_^n_Integer ] :=
	Block[{a, b},
		a = Round[n/2]; b = n-a;
		Re[x^a] Im[x^b] + Im[x^a] Re[x^b]
	]
(*
:[font = input; initialization; ]
*)
Re[x_Integer^n_Rational] := 0                /; IntegerQ[2n] && x<0
Im[x_Integer^n_Rational] := 
	(-x)^n (-1)^((Numerator[n]-1)/2) /; IntegerQ[2n] && x<0
(*
:[font = input; initialization; ]
*)
Re[x_Integer^n_Rational] := x^n /; OddQ[Denominator[n]] || x>0
Im[x_Integer^n_Rational] := 0   /; OddQ[Denominator[n]] || x>0
(*
:[font = input; initialization; ]
*)
Re[(-1)^n_Rational] := Cos[n Pi]
Im[(-1)^n_Rational] := Sin[n Pi]
(*
:[font = input; initialization; ]
*)
(* functions *)
(*
:[font = input; initialization; ]
*)
Re[Sin[x_]] := Sin[Re[x]] Cosh[Im[x]]
Im[Sin[x_]] := Cos[Re[x]] Sinh[Im[x]]
(*
:[font = input; initialization; ]
*)
Re[Cos[x_]] :=  Cos[Re[x]] Cosh[Im[x]]
Im[Cos[x_]] := -Sin[Re[x]] Sinh[Im[x]]
(*
:[font = input; initialization; ]
*)
Re[Log[r_?Positive]] := Log[r]
Im[Log[r_?Positive]] := 0
Re[Log[r_?Negative]] := Log[-r]
Im[Log[r_?Negative]] := Pi
(*
:[font = input; initialization; ]
*)
Re[Log[z_]] := (1/2) Log[Re[z]^2 + Im[z]^2]
Im[Log[z_]] := Arg[z]
(*
:[font = input; initialization; ]
*)
Re[Log[a_ b_]] := Re[Log[a] + Log[b]]
Im[Log[a_ b_]] := Im[Log[a] + Log[b]]
Re[Log[a_^c_]] := Re[c Log[a]]
Im[Log[a_^c_]] := Im[c Log[a]]
(*
:[font = input; initialization; ]
*)
Re[Tan[x_]] := Re[Sin[x]/Cos[x]]
Im[Tan[x_]] := Im[Sin[x]/Cos[x]]
(*
:[font = input; initialization; ]
*)
(* conjugates *)
(*
:[font = input; initialization; ]
*)
Re[Conjugate[z_]] :=  Re[z]
Im[Conjugate[z_]] := -Im[z]
(*
:[font = input; initialization; ]
*)
Conjugate[x_+y_]:= Conjugate[x]+Conjugate[y]
Conjugate[x_ y_]:= Conjugate[x] Conjugate[y]
Conjugate[x_^n_Integer]:= Conjugate[x]^n
Conjugate[Conjugate[x_]]:= x
(*
:[font = input; initialization; ]
*)
Protect[Release[protected]]
(*
:[font = input; initialization; endGroup; ]
*)
End[]
EndPackage[]
(*
^*)