(*^

::[paletteColors = 128; 
	fontset = title, "Helvetica-Bold", 24, L2, center, bold, nohscroll;
	fontset = subtitle, "Helvetica-Bold", 18, L2, center, bold, nohscroll;
	fontset = subsubtitle, "Helvetica-Bold", 14, L2, center, bold, nohscroll;
	fontset = section, "Helvetica-Bold", 16, L2, bold, nohscroll, grayBox;
	fontset = subsection, "Helvetica-Bold", 13, L2, bold, nohscroll, blackBox;
	fontset = subsubsection, "Helvetica-Bold", 12, L2, bold, nohscroll, whiteBox;
	fontset = text, "Times-Roman", 12, L2, nohscroll;
	fontset = smalltext, "Times-Roman", 10, L2, nohscroll;
	fontset = input, "Courier-Bold", 12, L2, bold, nowordwrap;
	fontset = output, "Courier", 12, L2, nowordwrap;
	fontset = message, "Courier", 12, L2, R21845, G21845, B21845, nowordwrap;
	fontset = print, "Courier", 12, L2, nowordwrap;
	fontset = info, "Courier", 12, L2, nowordwrap;
	fontset = postscript, "Courier", 12, L2, nowordwrap;
	fontset = name, "Times-Italic", 11, L2, italic, R21845, G21845, B21845, nowordwrap, nohscroll;
	fontset = header, "Times", 10, L2;
	fontset = footer, "Times", 12, L2, center;
	fontset = help, "Times-Roman", 13, L2, nohscroll;
	fontset = clipboard, "New York", 12, L2;
	fontset = completions, "Courier", 16, L2, nowordwrap;
	fontset = network, "Courier", 10, L2, nowordwrap;
	fontset = graphlabel, "Courier", 12, L2, nowordwrap;
	fontset = special1, "New York", 12, L2, nowordwrap;
	fontset = special2, "New York", 12, L2, center, nowordwrap;
	fontset = special3, "New York", 12, L2, right, nowordwrap;
	fontset = special4, "New York", 12, L2, nowordwrap;
	fontset = special5, "New York", 12, L2, nowordwrap;]
:[font = title; inactive; ]
Vector Calculus in Cartesian Coordinates
:[font = text; inactive; ]
This example comes from subsections 4.6.3 and 4.6.4.
:[font = subsubsection; inactive; locked; startGroup; Cclosed; ]
Copyright Notice
:[font = smalltext; inactive; locked; endGroup; ]

	Copyright 1989 by Roman Maeder.
	
	Adapted from	Roman E. Maeder: Programming in Mathematica, Addison-Wesley, 1989.
	
	Permission is hereby granted to make copies of	this file for any purpose other than direct profit,	or as part of a commercial product, provided this copyright notice is left intact.	Sale, other than for the cost of media, is prohibited.
	
	Permission is hereby granted to reproduce part or all of this file provided that the source is acknowledged.

:[font = section; inactive; startGroup; Cclosed; ]
Examples
:[font = subsection; inactive; startGroup; Cclosed; ]
A symbolic Laplacian
:[font = text; inactive; ]
This example is from page 103
:[font = input; endGroup; ]
Laplacian[ v[x, y], {x, y} ]
:[font = subsection; inactive; startGroup; Cclosed; ]
The Graviational of Electrical Force Field
:[font = text; inactive; ]
Components of the central force field
:[font = input; ]
e = { x, y, z } / (x^2 + y^2 + z^2)^(3/2)
:[font = text; inactive; ]
Its divergence should be 0.
:[font = input; ]
Div[ e, {x, y, z} ]
:[font = text; inactive; ]
It needs to be simplified to see that the result is correct.
:[font = input; endGroup; ]
Together[ % ]
:[font = subsection; inactive; startGroup; Cclosed; ]
The Jacobian Matrix
:[font = text; inactive; ]
This example is from page 6.
:[font = input; endGroup; endGroup; ]
JacobianMatrix[ {f[x, y, z], g[x, y, z]}, {x, y, z} ] //
	MatrixForm
:[font = section; inactive; startGroup; Cclosed; ]
Implementation
:[font = input; initialization; ]
*)
BeginPackage["RMPackages`VectorCalculus`"]
(*
:[font = input; initialization; ]
*)
Div::usage = "Div[v, varlist] computes the divergence of
	the vectorfield v w.r.t. the given variables in Cartesian coordinates."
(*
:[font = input; initialization; ]
*)
Laplacian::usage = "Laplacian[s, varlist] computes the Laplacian of
	the scalar field s w.r.t. the given variables in Cartesian coordinates."
(*
:[font = input; initialization; ]
*)
Grad::usage = "Grad[s, varlist] computes the gradient of s
	w.r.t. the given variables in Cartesian coordinates."
(*
:[font = input; initialization; ]
*)
JacobianMatrix::usage = "JacobianMatrix[flist, varlist] computes the Jacobian of
	the functions flist w.r.t. the given variables."
(*
:[font = input; initialization; ]
*)
Begin["`Private`"]
(*
:[font = input; initialization; ]
*)
Div[v_List, var_List] := Inner[D, v, var, Plus]
(*
:[font = input; initialization; ]
*)
Grad[s_, var_List] := D[s, #]& /@ var
(*
:[font = input; initialization; ]
*)
Laplacian[s_, var_List] := Div[ Grad[s, var], var]
(*
:[font = input; initialization; ]
*)
JacobianMatrix[f_List, var_List] := Outer[D, f, var]
(*
:[font = input; initialization; ]
*)
End[]
(*
:[font = input; initialization; ]
*)
Protect[ Div, Laplacian, Grad, JacobianMatrix ]
(*
:[font = input; initialization; endGroup; ]
*)
EndPackage[]
(*
^*)