#ifndef READ_OBJECTS
#define READ_OBJECTS

/***************************************
  $Revision: 1.6 $

  Objects module (ob) - this _should_ eventually get merged in with the
  config module.

  Status: NOT REVUED, NOT TESTED

  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/
#include "bitmask.h"
#include "attributes.h"

/*
  NB. These were grabbed from /ncc/dbcon/config-2.1.3 on (Tue Jul  6 15:20:10 CEST 1999)

# ATSQ  - all defined attributes in this object, also defines print order
# MAND  - these attributes are mandatory
# MULT  - these attributes can appear more than once per object
# UNIQ  - these attributes define the unique key
# KEYS  - these attributes define all possible keys
# REC   - these attributes must be looked up if referenced
# INV   - these attributes may be used in inverse look-ups
*/
typedef struct Object_t {
  AT_Type attr_index;
  char *description;
  int attr_order[100];   /* XXX Don't need - because order is not important. */
  mask_t ATSQ;
  mask_t MAND;
  mask_t MULT;
  mask_t UNIQ;
  mask_t KEYS;
  mask_t REC;
  mask_t INV;
} Object;

/* Objects */

#define OBJECT_MASK A_AN, A_AS, A_DC, A_DN, A_FS, A_KC, A_I6, A_IN, A_IR, A_IS, A_LI, A_MT, A_PN, A_PS, A_RO, A_RS, A_RT, MA_END

/*
 * aut_nums
 */
#define O_AN 0
/* XXX - some undefined attributes.
#define O_AN_ATSQ   A_AN, A_AA, A_DE, A_AI, A_AO, A_CN, A_CT, A_IT, A_IO, A_AE, A_AV, A_DF, A_GD, A_AC, A_TC, A_RM, A_NY, A_MB, A_CH, A_SO, MA_END
*/
#define O_AN_ATSQ   A_AN, A_AA, A_DE, A_CN, A_CT, A_DF, A_AC, A_TC, A_RM, A_NY, A_MB, A_CH, A_SO, MA_END
#define O_AN_MAND   A_AN, A_DE, A_AC, A_TC, A_MB, A_CH, A_SO, MA_END
/* XXX  - some undefined attributes.
#define O_AN_MULT   A_DE, A_AI, A_AO, A_CN, A_CT, A_IT, A_IO, A_AE, A_DF, A_AC, A_TC, A_RM, A_CH, A_NY, A_MB, MA_END
*/
#define O_AN_MULT   A_DE, A_CN, A_CT, A_DF, A_AC, A_TC, A_RM, A_CH, A_NY, A_MB, MA_END
#define O_AN_UNIQ   A_AN, MA_END
#define O_AN_KEYS   A_AN, MA_END
#define O_AN_REC    A_AC, A_TC, MA_END
#define O_AN_INV    A_AC, A_TC, A_NY, A_MB, MA_END

/*
 * as_set
 */
#define O_AS 1
#define O_AS_ATSQ   MA_END
#define O_AS_MAND   MA_END
#define O_AS_MULT   MA_END
#define O_AS_UNIQ   MA_END
#define O_AS_KEYS   MA_END
#define O_AS_REC    MA_END
#define O_AS_INV    MA_END

/*
 * dictionary
 */
#define O_DC 2
#define O_DC_ATSQ   MA_END
#define O_DC_MAND   MA_END
#define O_DC_MULT   MA_END
#define O_DC_UNIQ   MA_END
#define O_DC_KEYS   MA_END
#define O_DC_REC    MA_END
#define O_DC_INV    MA_END

/*
 * domains
 */
#define O_DN 3
#define O_DN_ATSQ   A_DN, A_DE, A_AC, A_TC, A_ZC, A_NS, A_SD, A_DI, A_RM, A_NY, A_MB, A_ML, A_RF, A_CH, A_SO, MA_END
#define O_DN_MAND   A_DN, A_DE, A_AC, A_TC, A_ZC, A_CH, A_SO, MA_END
#define O_DN_MULT   A_AC, A_CH, A_DE, A_DI, A_NS, A_RM, A_SD, A_TC, A_ZC, A_NY, A_MB, A_ML, MA_END
#define O_DN_UNIQ   A_DN, MA_END
#define O_DN_KEYS   A_DN, MA_END
#define O_DN_REC    A_AC, A_TC, A_ZC, MA_END
#define O_DN_INV    A_AC, A_TC, A_ZC, A_NS, A_SD, A_NY, A_MB, MA_END

/*
 * filter_set
 */
#define O_FS 4
#define O_FS_ATSQ   MA_END
#define O_FS_MAND   MA_END
#define O_FS_MULT   MA_END
#define O_FS_UNIQ   MA_END
#define O_FS_KEYS   MA_END
#define O_FS_REC    MA_END
#define O_FS_INV    MA_END

/*
 * key_cert
 */
#define O_KC 5
#define O_KC_ATSQ   MA_END
#define O_KC_ATSQ   MA_END
#define O_KC_MAND   MA_END
#define O_KC_MULT   MA_END
#define O_KC_UNIQ   MA_END
#define O_KC_KEYS   MA_END
#define O_KC_REC    MA_END
#define O_KC_INV    MA_END

/*
 * inet6num (experimental IPv6 allocation/assignment object)
 * XXX NB Carefully check anything to do with IP6 - my vim macros don't like a number in the name. XXX - ottrey.
 */
#define O_I6 6
#define O_I6_ATSQ   A_I6, A_NA, A_DE, A_CY, A_AC, A_TC, A_RZ, A_RM, A_NY, A_MB, A_CH, A_SO, MA_END
#define O_I6_MAND   A_I6, A_AC, A_CH, A_CY, A_DE, A_NA, A_SO, A_TC, MA_END
#define O_I6_MULT   A_AC, A_CH, A_DE, A_CY, A_RM, A_RZ, A_TC, A_NY, A_MB, MA_END
#define O_I6_UNIQ   A_I6
#define O_I6_KEYS   A_I6, A_NA, MA_END
#define O_I6_REC    A_AC, A_TC, MA_END
#define O_I6_INV    A_AC, A_TC, A_NY, A_MB, MA_END

/*
 * inetnum
 */
#define O_IN 7
/* XXX - some undefined attributes.
#define O_IN_ATSQ   A_IN, A_NA, A_DE, A_CY, A_AC, A_TC, A_AS, A_CL, A_II, A_GW, A_RZ, A_ST, A_RM, A_NY, A_MB, A_ML, A_CH, A_SO, MA_END
*/
#define O_IN_ATSQ   A_IN, A_NA, A_DE, A_CY, A_AC, A_TC, A_AS, A_RZ, A_ST, A_RM, A_NY, A_MB, A_ML, A_CH, A_SO, MA_END
#define O_IN_MAND   A_AC, A_CH, A_DE, A_CY, A_IN, A_NA, A_SO, A_TC, A_ST, MA_END
#define O_IN_MULT   A_AC, A_CH, A_DE, A_CY, A_RM, A_RZ, A_TC, A_NY, A_MB, A_ML, MA_END
#define O_IN_UNIQ   A_IN, MA_END
#define O_IN_KEYS   A_IN, A_NA, MA_END
#define O_IN_REC    A_AC, A_TC, MA_END
#define O_IN_INV    A_AC, A_TC, A_NY, A_MB, MA_END

/*
 * inet_rtr
 */
#define O_IR 8
#define O_IR_ATSQ   A_IR, A_LA, A_IF, A_PE, A_AC, A_TC, A_RM, A_NY, A_MB, A_CH, A_SO, MA_END
#define O_IR_MAND   A_IR, A_LA, A_IF, A_TC, A_AC, A_MB, A_CH, A_SO, MA_END
#define O_IR_MULT   A_IF, A_PE, A_TC, A_AC, A_RM, A_NY, A_CH, A_MB, MA_END
#define O_IR_UNIQ   A_IR, MA_END
#define O_IR_KEYS   A_IR, A_IF, MA_END
#define O_IR_REC    A_TC, A_AC, MA_END
#define O_IR_INV    A_AC, A_TC, A_NY, A_MB, MA_END

/*
 * rtr_set
 */
#define O_IS 9
#define O_IS_ATSQ   MA_END
#define O_IS_MAND   MA_END
#define O_IS_MULT   MA_END
#define O_IS_UNIQ   MA_END
#define O_IS_KEYS   MA_END
#define O_IS_REC    MA_END
#define O_IS_INV    MA_END

/*
 * limerick - RIPE special ;-)
 */
#define O_LI 10
#define O_LI_ATSQ   A_LI, A_DE, A_TX, A_AC, A_AH, A_RM, A_NY, A_MB, A_CH, A_SO, MA_END
#define O_LI_MAND   A_LI, A_TX, A_AC, A_AH, A_CH, A_SO, A_MB, MA_END
#define O_LI_MULT   A_DE, A_TX, A_AC, A_AH, A_RM, A_NY, A_MB, A_CH, MA_END
#define O_LI_UNIQ   A_LI, MA_END
#define O_LI_KEYS   A_LI, MA_END
#define O_LI_REC    A_AH, MA_END
#define O_LI_INV    A_AH, A_NY, A_MB, MA_END

/*
 * maintainer
 */
#define O_MT 11
#define O_MT_ATSQ   A_MT, A_DE, A_AC, A_TC, A_DT, A_MN, A_AT, A_RM, A_NY, A_MB, A_CH, A_SO, MA_END
#define O_MT_MAND   A_MT, A_DE, A_AC, A_DT, A_AT, A_MB, A_CH, A_SO, MA_END
#define O_MT_MULT   A_DE, A_AC, A_TC, A_DT, A_MN, A_AT, A_RM, A_NY, A_MB, A_CH, MA_END
#define O_MT_UNIQ   A_MT, MA_END
#define O_MT_KEYS   A_MT, MA_END
#define O_MT_REC    A_AC, A_TC, MA_END
#define O_MT_INV    A_AC, A_TC, A_NY, A_MB, MA_END

/*
 * person
 */
#define O_PN 12
#define O_PN_ATSQ   A_PN, A_AD, A_PH, A_FX, A_EM, A_NH, A_RM, A_NY, A_MB, A_CH, A_SO, MA_END
#define O_PN_MAND   A_PN, A_AD, A_PH, A_NH, A_CH, A_SO, MA_END
#define O_PN_MULT   A_AD, A_CH, A_EM, A_FX, A_PH, A_RM, A_NY, A_MB, MA_END
#define O_PN_UNIQ   A_PN, A_NH, MA_END
#define O_PN_KEYS   A_PN, A_NH, A_EM, MA_END
#define O_PN_REC    MA_END
#define O_PN_INV    A_NY, A_MB, MA_END

/*
 * peering_set
 */
#define O_PS 13
#define O_PS_ATSQ   MA_END
#define O_PS_MAND   MA_END
#define O_PS_MULT   MA_END
#define O_PS_UNIQ   MA_END
#define O_PS_KEYS   MA_END
#define O_PS_REC    MA_END
#define O_PS_INV    MA_END

/*
 * role
 */
#define O_RO 14
#define O_RO_ATSQ   A_RO, A_AD, A_PH, A_FX, A_EM, A_TB, A_AC, A_TC, A_NH, A_RM, A_NY, A_MB, A_CH, A_SO, MA_END
#define O_RO_MAND   A_RO, A_AD, A_CH, A_EM, A_AC, A_TC, A_SO, A_NH, MA_END
#define O_RO_MULT   A_AD, A_CH, A_EM, A_FX, A_PH, A_RM, A_NY, A_MB, A_AC, A_TC, A_TB, MA_END
#define O_RO_UNIQ   A_RO, A_NH, MA_END
#define O_RO_KEYS   A_RO, A_NH, A_EM, MA_END
#define O_RO_REC    A_AC, A_TC, MA_END
#define O_RO_INV    A_AC, A_TC, A_NY, A_MB, MA_END

/*
 * route_set
 */
#define O_RS 15
#define O_RS_ATSQ   MA_END
#define O_RS_MAND   MA_END
#define O_RS_MULT   MA_END
#define O_RS_UNIQ   MA_END
#define O_RS_KEYS   MA_END
#define O_RS_REC    MA_END
#define O_RS_INV    MA_END

/*
 * route
 */
#define O_RT 16
/* XXX - some undefined attributes.
#define O_RT_ATSQ   A_RT, A_DE, A_OR, A_HO, A_WD, A_CL, A_AV, A_RM, A_CN, A_CM, A_CT, A_NY, A_MB, A_CH, A_SO, MA_END
*/
#define O_RT_ATSQ   A_RT, A_DE, A_OR, A_HO, A_WD, A_RM, A_CN, A_CT, A_NY, A_MB, A_CH, A_SO, MA_END
#define O_RT_MAND   A_RT, A_DE, A_OR, A_MB, A_CH, A_SO, MA_END
/* XXX - some undefined attributes.
#define O_RT_MULT   A_DE, A_HO, A_CL, A_RM, A_NY, A_CH, A_MB, A_AV, A_CN, A_CM, A_CT, MA_END
*/
/* XXX - some undefined attributes.
#define O_RT_MULT   A_DE, A_HO, A_CL, A_RM, A_NY, A_CH, A_MB, A_AV, A_CN, A_CT, MA_END
*/
#define O_RT_MULT   A_DE, A_HO, A_RM, A_NY, A_CH, A_MB, A_CN, A_CT, MA_END
#define O_RT_UNIQ   A_RT, A_OR, MA_END
#define O_RT_KEYS   A_RT, MA_END
#define O_RT_REC    MA_END
#define O_RT_INV    A_OR, A_NY, A_MB, MA_END

mask_t OB_get_inv_attr_mask(void);
mask_t OB_get_object_mask(void);
char *OB_object_to_string1(Object object);
char *OB_object_to_string2(Object object, int verbose);
char *OB_objects_to_string();
char *OB_object_i_to_string(int obj_index, int format);
char *OB_attribute_i_to_string(int attr_index, int format);
void OB_init(void);

#endif /* READ_OBJECTS */
