#ifndef ER_UP_ERRORS_H 
#define ER_UP_ERRORS_H 


/***************************************
  $Revision: 1.5 $

  
  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

/* step 1 */

typedef enum {
  LOW_UP_AUTH_OK=0, /* Auth succeded */
  LOW_UP_MOR, /* got more than one object from the db, where extected only one */
  LOW_UP_NSO, /* no such object */
  LOW_UP_AUF, /* auth failed */
  LOW_UP_NIY, /* not implemented yet */
  LOW_UP_ABN, /* as-block does not exist */
  LOW_UP_HOF, /* hierarchical auth failed */
  LOW_UP_OVF, /* override failed */
  LOW_UP_OVS, /* override syntax error */
  LOW_UP_NOM, /* no match. the old & nw versions of the object are not the same */
  LOW_UP_ANE, /* AUTO NIC hdl error */
  LOW_UP_INT  /* internal error */

} UP_err_code_t;

/* step 2 */

#define UP_AUTH_OK	ER_SEV_I + (FAC_UP<<16) + LOW_UP_AUTH_OK
#define UP_MOR		ER_SEV_E + (FAC_UP<<16) + LOW_UP_MOR
#define UP_NSO		ER_SEV_E + (FAC_UP<<16) + LOW_UP_NSO  
#define	UP_AUF		ER_SEV_E + (FAC_UP<<16) + LOW_UP_AUF
#define UP_NIY		ER_SEV_E + (FAC_UP<<16) + LOW_UP_NIY
#define UP_ABN		ER_SEV_E + (FAC_UP<<16) + LOW_UP_ABN
#define UP_HOF		ER_SEV_E + (FAC_UP<<16) + LOW_UP_HOF
#define UP_OVF		ER_SEV_E + (FAC_UP<<16) + LOW_UP_OVF
#define UP_OVS		ER_SEV_E + (FAC_UP<<16) + LOW_UP_OVS
#define UP_NOM          ER_SEV_E + (FAC_UP<<16) + LOW_UP_NOM
#define UP_ANE          ER_SEV_E + (FAC_UP<<16) + LOW_UP_ANE
#define UP_INT		ER_SEV_E + (FAC_UP<<16) + LOW_UP_INT

/* step 3 */

#ifdef ER_IMPL
er_list_t UP_mod_err[]={
  { ERDUP(UP_AUTH_OK),  	"Auth OK" },

  { ERDUP(UP_MOR),   "got more than one object from the db, where extected only one" },

  { ERDUP(UP_NSO),   "no such object" },
  { ERDUP(UP_AUF),   "auth failed" },
  { ERDUP(UP_NIY),   "not implemented yet" },
  { ERDUP(UP_ABN),   "as-block does not exist" },
  { ERDUP(UP_HOF),   "hierarchical auth failed" },
  { ERDUP(UP_OVF),   "override failed" },
  { ERDUP(UP_OVS),   "override syntax error" },
  { ERDUP(UP_NOM),   "no match, the old & new versions are not the same" },
  { ERDUP(UP_ANE),   "AUTO NIC hdl error" },

  { ERDUP(UP_INT),   "internal error" },

 ER_LASTTXT
};

#endif /* ER_IMPL */

#endif
