/***************************************
  $Revision: 1.7 $

  NT (Notifications) module

  Status: NOT REVIEWED, NOT TESTED

  Author(s):       Engin Gunduz

  ******************/ /******************
  Modification History:
        engin (06/07/2000) Created.
  ******************/ /******************
  Copyright (c) 2000                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 ***************************************/






#include "notification.h"


/*  Generates a unique file name and returns the full path of the filename 
    for storing notification message.  Creates the file at the same time. 
    May use PID or time or both to ensure uniqueness.  */
      
char * NT_ntfy_filename_generate( const char * tmpdir, const char * e_mail){

   FILE * ntfy_file;
   char * name;
     
   /* allocate space for name.  32 should be enough for PID */
   name = (char*)malloc(strlen(tmpdir) + strlen(e_mail) + strlen("notify") +32 ); 
   
   sprintf(name, "%s/%s-%s.%i", tmpdir, "notify", e_mail, getpid());

   /* create the file */
   if(( ntfy_file = fopen(name, "w")) == NULL){
     fprintf(stderr, "Can't open notification file, %s", name);
   }

   fprintf(ntfy_file, "To: %s\nFrom: %s\nSubject: Notification of RIPE Database changes\nReply-To: %s\n\n%s\n", e_mail, humailbox, humailbox, notitxt);
   if(reading_from_mail){
     fprintf(ntfy_file, "%s\n\n", notimailtxt);
   }
   /* close it */
   fclose(ntfy_file);
    
   return name;
      
}





/* Generates a unique file name and returns the full path of the filename 
   for storing forwarded message. Creates the file at the same time.  */ 
char * NT_forwd_filename_generate( const char * tmpdir, const char * e_mail){

   FILE * forwd_file;
   char * name;
      
   /* allocate space for name.  32 should be enough for PID */
   name = (char*)malloc(strlen(tmpdir) + strlen(e_mail) + strlen("forwd") +32 ); 
   
   sprintf(name, "%s/%s-%s.%i", tmpdir, "forwd", e_mail, getpid());
   //printf("DEBUG: NT_forwd_filename_generate: will generate %s\n", name);
   /* create the file */
   if(( forwd_file = fopen(name, "w")) == NULL){
     fprintf(stderr, "Can't open forward file, %s", name);
   }

   fprintf(forwd_file, "To: %s\nFrom: %s\nSubject:  Requested RIPE database object changes \nReply-To: %s\n\n%s\n", e_mail, humailbox, humailbox, fwtxt);
   if(reading_from_mail){
     fprintf(forwd_file, "\n%s\n", fwmailtxt);
   }

   /* close it */
   fclose(forwd_file);
    
   return name;

}





/* Generates a unique file name and returns the full path of the filename for 
   storing notification message. Creates the file at the same time.  */
char * NT_crossntfy_filename_generate( const char * tmpdir, const char * e_mail){
   FILE * cross_file;
   char * name;
      
   /* allocate space for name.  32 should be enough for PID */
   name = (char*)malloc(strlen(tmpdir) + strlen(e_mail) + strlen("cross") +32 ); 
   
   sprintf(name, "%s/%s-%s.%i", tmpdir, "cross", e_mail, getpid());

   /* create the file */
   if(( cross_file = fopen(name, "w")) == NULL){
     fprintf(stderr, "Can't open cross file, %s", name);
   }

   /* close it */
   fclose(cross_file);
    
   return name;

}





/* Adds the e-mail to the notify hash, generating appropriate temp files */
void NT_add_to_ntfy_hash(GHashTable * ntfy_hash, char * e_mail){

  if(g_hash_table_lookup(ntfy_hash ,e_mail) == NULL){/* there is no such entry, so create it */
    g_hash_table_insert(ntfy_hash, strdup(e_mail), NT_ntfy_filename_generate(tmpdir, e_mail));
  }
    
}


/* Adds the e-mail to the forw hash, generating appropriate temp files */
void NT_add_to_frwd_hash(GHashTable * frwd_hash, char * e_mail){

  if(g_hash_table_lookup(frwd_hash ,e_mail) == NULL){/* there is no such entry, so create it */
    g_hash_table_insert(frwd_hash, strdup(e_mail), NT_forwd_filename_generate(tmpdir, e_mail));
  }
    
}



/* Adds the e-mails in a linked list to the hash */
void NT_add_to_ntfy_hash_list(GHashTable * ntfy_hash, GSList * e_mail_list){

   GSList * temp = NULL;

   for(temp = e_mail_list; temp != NULL; temp = g_slist_next(temp)){
     NT_add_to_ntfy_hash(ntfy_hash, (char *)temp->data);
   }
  
}




/* Adds the e-mails in a linked list to the hash */
void NT_add_to_frwd_hash_list(GHashTable * frwd_hash, GSList * e_mail_list){

   GSList * temp = NULL;

   for(temp = e_mail_list; temp != NULL; temp = g_slist_next(temp)){
     NT_add_to_frwd_hash(frwd_hash, (char *)temp->data);
   }
  
}



/* Appends the argument strings to the file.  */
void NT_add_to_ntfy( char * filename, char * fmt, ... ){
  va_list ap;  /* points to each unnamed arg in turn */
  FILE * ack_file;
 
  if(tracing){
    printf("TRACING: NT_add_to_ntfy\n"); 
  }
  if(( ack_file = fopen(filename, "a")) == NULL){
    fprintf(stderr, "Can't open notification file, %s\n", filename);
  }
    
  va_start(ap, fmt);
  vfprintf(ack_file, fmt, ap);

  va_end(ap); /* clean up */
  fclose(ack_file);
}





/* Appends the argument string to the temp notif files in the list */
void NT_add_to_ntfy_list(GSList * list, GHashTable * hash, char * arg){
  
  GSList * temp = NULL;

  for(temp = list; temp != NULL; temp = g_slist_next(temp)){
    NT_add_to_ntfy((char *)g_hash_table_lookup(hash, ((char *)temp->data)), arg);
  }
}








/* Sends the notification message which is stored in the temporary filefilename.  */
void NT_send_ntfy( const char * filename, const char * to_address, const char * mailercommand){

    char * mail_command_line = NULL;

    if(to_address != NULL){
      mail_command_line = (char *)malloc(strlen(mailercommand) + strlen(filename) + 128);
      sprintf(mail_command_line, "%s %s < %s", mailercommand, to_address, filename);
      system(mail_command_line);
    }

}



/* Adds the notification message which is in the filename into log_file. */
void NT_log_ntfy( const char * filename, const char * logfilename){

  FILE * notif_file, * log_file;
  char * buf;

  buf = (char *)malloc(1024);
  if(( notif_file = fopen(filename, "r")) == NULL){
    fprintf(stderr, "Can't open notification file, [%s]\n", filename);
    return;
  }

  if(( log_file = fopen(logfilename, "a")) == NULL){
    fprintf(stderr, "Can't open log file, %s\n", logfilename);
    return;
  }

  /* must put real time here */
  fprintf(log_file, ">>> time: NOTIF <<<\n\n");


  while((buf=fgets(buf, 1023, notif_file)) > 0){
    fprintf(log_file, "%s", buf);
  }

  fclose(notif_file);
  fclose(log_file);

}


/* Deletes the temporary notification file. */ 
void NT_delete_ntfy( const char * filename){

   unlink(filename);
   
}


/* The function required for NT_send_ntfy_list */
void  nt_gfunc_send(gpointer key, gpointer value, gpointer user_data){
  NT_send_ntfy((char *)value, (char *)key, (char *)user_data);
}


       
/* Sends the notification messages whose temp files are stored in filehash. */              
void NT_send_ntfy_list( GHashTable * filehash, char * mailercommand){

  g_hash_table_foreach( filehash, (GHFunc)nt_gfunc_send, mailercommand);
  
}




/* The function required for NT_log_ntfy_list */
void  nt_gfunc_log(gpointer key, gpointer value, gpointer user_data){
  NT_log_ntfy((char *)value, (char *)user_data);
}




/* Logs the notification whose temp files are in filehash to log_file. */
void NT_log_ntfy_list( GHashTable * filehash, char * log_file){

   g_hash_table_foreach( filehash, (GHFunc)nt_gfunc_log, log_file);
  
}



/* The function required for NT_delete_ntfy_list */
void  nt_gfunc_delete(gpointer key, gpointer value, gpointer user_data){
  NT_delete_ntfy((char *)value);
}



/* Deletes the temporary notification messages in the filehash. Empties and frees 
   the hash too.  */
void NT_delete_ntfy_list( GHashTable * filehash){

  g_hash_table_foreach(filehash, (GHFunc)nt_gfunc_delete, NULL);
  g_hash_table_destroy(filehash);
  
}


/* Gathers e-mail boxes to which we will send normal notification messages. It 
   takes old and new objects, looks up maintainers and less specific inetnums/domains/routes 
   when necessary, finds the addresses (in mnt-nfy and notify attributes) and returns 
   a list of them. */
GSList * NT_gather_ntfy_addresses( char * old_object, char * new_object){
  GSList *temp = NULL;
  GSList * mntners = NULL; 

  if(old_object != NULL && new_object != NULL){/* it was an update */
    temp = get_attr_list(old_object, "notify");
    mntners = get_mntners(old_object);
    temp = g_slist_concat(temp, get_mntnfy_vector(mntners));
  }else if(old_object == NULL && new_object != NULL){/* it was a creation */
    temp = get_attr_list(new_object, "notify");
    mntners = get_mntners(new_object);
    temp = g_slist_concat(temp, get_mntnfy_vector(mntners));
  }else if(old_object != NULL && new_object == NULL){/* it was a deletion */
    temp = get_attr_list(old_object, "notify");
    mntners = get_mntners(old_object);
    temp = g_slist_concat(temp, get_mntnfy_vector(mntners));
  }
  return temp;
}



/* Gathers e-mail boxes to which we will forward messages (or rather, objects). It 
   an object, looks up maintainers, finds the addresses (in upd-to attributes) and returns 
   a list of them. */
GSList * NT_gather_frwd_addresses(char * object){
  GSList *temp = NULL;
  GSList * mntners = NULL; 

  mntners = get_mntners(object);
  temp = get_updto_vector(mntners);
  return temp;
}






/* Gets old and new versions of the object, and creates temporary notification
   files when necessary, and then writes appropriate strings into those
   temporary files. */
void NT_write_all_ntfs(char * old_object, char * new_object, /*const char * notif_log,
                       const char * forw_log,    const char * cross_log,*/ const char * tempdir,
                       GHashTable * ntfy_hash,  GHashTable * forwd_hash, GHashTable * cross_hash, 
                       const char * from_address){ 

   GSList * e_mail_list = NULL;


   if(tracing){
     printf("TRACING: NT_write_all_ntfs\n");
   }
   if(old_object != NULL && new_object != NULL){/* it was an update */
     e_mail_list = NT_gather_ntfy_addresses(old_object, new_object);
     NT_add_to_ntfy_hash_list(ntfy_hash, e_mail_list); 
     NT_add_to_ntfy_list(e_mail_list, ntfy_hash, "---\nPREVIOUS OBJECT:\n\n");
     NT_add_to_ntfy_list(e_mail_list, ntfy_hash, old_object);
     NT_add_to_ntfy_list(e_mail_list, ntfy_hash, "\n\nREPLACED BY:\n\n");
     NT_add_to_ntfy_list(e_mail_list, ntfy_hash, new_object);
     NT_add_to_ntfy_list(e_mail_list, ntfy_hash, "\n");
   }else if(old_object == NULL && new_object != NULL){/* it was a creation */
     e_mail_list = NT_gather_ntfy_addresses(old_object, new_object);
     NT_add_to_ntfy_hash_list(ntfy_hash, e_mail_list); 
     NT_add_to_ntfy_list(e_mail_list, ntfy_hash, "---\nOBJECT BELOW CREATED:\n\n");
     NT_add_to_ntfy_list(e_mail_list, ntfy_hash, new_object);
     NT_add_to_ntfy_list(e_mail_list, ntfy_hash, "\n");
   }else if(old_object != NULL && new_object == NULL){/* it was a deletion */
     e_mail_list = NT_gather_ntfy_addresses(old_object, new_object);
     NT_add_to_ntfy_hash_list(ntfy_hash, e_mail_list); 
     NT_add_to_ntfy_list(e_mail_list, ntfy_hash, "---\nOBJECT BELOW DELETED:\n\n");
     NT_add_to_ntfy_list(e_mail_list, ntfy_hash, old_object);
     NT_add_to_ntfy_list(e_mail_list, ntfy_hash, "\n");
   }
}





/* Gets old and new versions of the object, and creates temporary notification
   files when necessary, and then writes appropriate strings into those
   temporary files. */
void NT_write_all_frwds(char * old_object, char * new_object, /*const char * notif_log,
                       const char * forw_log,    const char * cross_log,*/ const char * tempdir,
                       GHashTable * ntfy_hash,  GHashTable * forwd_hash, GHashTable * cross_hash, 
                       const char * from_address){ 

   GSList * e_mail_list = NULL;


   if(tracing){
     printf("TRACING: NT_write_all_frwds\n");
   }
   if(old_object != NULL && new_object != NULL){/* it was an update */
     e_mail_list = NT_gather_frwd_addresses(old_object);
     NT_add_to_frwd_hash_list(forwd_hash, e_mail_list);
     NT_add_to_ntfy_list(e_mail_list, forwd_hash, "----\nUPDATE REQUESTED FOR:\n\n");
     //NT_add_to_ntfy_list(e_mail_list, forwd_hash, old_object);
     //NT_add_to_ntfy_list(e_mail_list, forwd_hash, "\n\n");
     NT_add_to_ntfy_list(e_mail_list, forwd_hash, new_object);
   }else if(old_object == NULL && new_object != NULL){/* it was a creation */
     e_mail_list = NT_gather_frwd_addresses(new_object);
     NT_add_to_frwd_hash_list(forwd_hash, e_mail_list);
     NT_add_to_ntfy_list(e_mail_list, forwd_hash, "----\nADDITION REQUESTED FOR:\n\n");
     NT_add_to_ntfy_list(e_mail_list, forwd_hash, new_object);
   }else if(old_object != NULL && new_object == NULL){/* it was a deletion */
     e_mail_list = NT_gather_frwd_addresses(old_object);
     NT_add_to_frwd_hash_list(forwd_hash, e_mail_list);
     NT_add_to_ntfy_list(e_mail_list, forwd_hash, "----\nDELETION REQUESTED FOR:\n\n");
     NT_add_to_ntfy_list(e_mail_list, forwd_hash, old_object);
   }
}

