/*  spawn.c

    Source file for spawn operations for  PGPsendmail  (wrapper to sendmail).

    Copyright (C) 1994-1998  Richard Gooch

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Richard Gooch may be reached by email at  rgooch@atnf.csiro.au
    The postal address is:
      Richard Gooch, c/o ATNF, P. O. Box 76, Epping, N.S.W., 2121, Australia.
*/

/*  This programme intercepts messages sent by user mail agents to the
    sendmail daemon and checks to see if messages can be encrypted using the
    recipient's PGP public keys.


    Written by      Richard Gooch   31-MAY-1994

    Updated by      Richard Gooch   31-MAY-1994: Extracted from  pgpsendmail.c

    Updated by      Richard Gooch   18-JUN-1994: Made error messages more
  explicit.

    Updated by      Richard Gooch   27-JUN-1994: Copied  set_env  from
  pgpdaemon.c

    Updated by      Richard Gooch   5-JUL-1994: Changed to use of  m_copy  .

    Updated by      Richard Gooch   14-JUL-1994: Moved  copy_data  and  set_env
  to  misc.c

    Updated by      Richard Gooch   3-DEC-1994: Fixed bug for externally set
  error descriptor.

    Updated by      Richard Gooch   25-SEP-1997: Used new ERRSTRING macro.

    Last updated by Richard Gooch   10-JUL-1998: Removed definitions of system
  errlist array.


*/
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/types.h> 
#include <unistd.h>
#include <string.h>


/* #include "pgpsendmail.h" */

#define ERRSTRING strerror(errno)

#define LINE_LENGTH 1024
#define STRING_LENGTH 255

int spawn_job (char *path, char *argv[], int *in_fd, int *out_fd, int *err_fd)
/*  This routine will fork(2) and execvp(2) a process.
    The file to execute must be pointed to by  path  .
    The NULL terminated list of arguments which will be passed to  main  must
    be pointed to by  argv  .
    The input file descriptor (fd = 0) for the process must be pointed to by
    in_fd  .If the value here is less than 0, then a pipe to the process is
    opened and the writeable end is written to the storage pointed to by  in_fd
    The standard output file descriptor (fd = 1) for the process must be
    pointed to by  out_fd  .If the value here is less than 0, then a pipe to
    the process is opened and the readable end is written to the storage
    pointed to by  out_fd  .
    The standard error output file descriptor (fd = 2) for the process must be
    pointed to by  err_fd  .If the value here is less than 0, then a pipe to
    the process is opened and the readable end is written to the storage
    pointed to by  err_fd  .
    The routine returns the child process ID on success, else it returns -1.
*/
{
    int child_pid;
    /*    char txt[LINE_LENGTH]; */
    int sd1[2], sd2[2];

    if (pipe(sd1) == -1)
      {
	perror("pipe failed");
	return(1);
      }
    if (pipe(sd2) == -1)
      {
	perror("pipe failed");
	return(1);
      }

    /*  Fork and exec  */
    switch ( child_pid = fork () )
    {
      case 0:
	/*  Child: exec  */
	close(sd1[0]);

	dup2( sd1[1], 1 );   /* stdout */

	dup2( sd1[1], 2 );    /* stderr */

	execvp (path, argv);

	fprintf (stderr, "Could not exec: \"%s\"\t%s\n", path, ERRSTRING);
	exit (1); 
	break;
      case -1:
	/*  Error  */
	fprintf (stderr, "Could not fork\t%s\n", ERRSTRING);
	return (-1);
	break;
      default:
	/*  Parent  */
	break;
    }
    /*  Parent only  */

    close(sd1[1]);

    dup2 (sd1[0], 0); 
    
    /*        printf("Reading child output\n");
    while (read(0, txt, 10000) != 0)
      printf("child read %s\n", txt);

      printf("Finished reading child output\n");  */

    return (child_pid);
}   /*  End Function spawn_job  */
