/***************************************
  $Revision: 1.12 $

  Miscellaneous functions to support UD

  Status: NOT REVUED, NOT TESTED

 Author(s):       Chris Ottrey, Andrei Robachevsky

  ******************/ /******************
  Modification History:
        andrei (17/01/2000) Created.
  ******************/ /******************
  Copyright (c) 2000                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 ***************************************/
#include "ud.h"
#include "ud_int.h"
/************************************************************
* void attribute_free()                                     *
*                                                           *
* Frees memory allocated for an attribute                   *
*                                                           *
************************************************************/
void attribute_free(void *data, void *ptr)
{
Attribute_t *attr = data;

	free(attr->value);
	free(attr);
}

/************************************************************
* Attribute_t *attribute_upd()                              *
*                                                           *
* Changes the value of an attribute                         *
*                                                           *
************************************************************/
Attribute_t *attribute_upd(Attribute_t *attr, int newtype, char *newvalue)
{
 attr->type=newtype;
 free(attr->value);
 attr->value=g_strdup(newvalue);
 if(!attr->value)die;
 return(attr);
}

/************************************************************
* Attribute_t *attribute_new1()                             *
*                                                           *
* Creates an attribute and fills the type and value         *
*                                                           *
************************************************************/
Attribute_t *attribute_new1(int type, const char *value) 
{
char *n;
Attribute_t *attr = NULL;      

      attr = (Attribute_t *)calloc(1, sizeof(Attribute_t)+1);
      if(!attr) die;
      attr->type = type;

      /* check for end-of-line comments */
      n = index(value, '#');
      /* if there is no comment check for trailing \n */
      if(n == NULL) n = index(value, '\n');
      /* now copy the clean value into the attribute */
      if(n == NULL) attr->value = g_strdup(value); 
      else  attr->value = g_strndup(value, (n - value));
      /* Strip the whitespace */
      g_strstrip(attr->value);
      return(attr);

}
/************************************************************
* Attribute_t *attribute_new()                              *
*                                                           *
* Determines the type and value of an attribute and         *
* creates it by calling attribute_new1()                    *
*                                                           *
************************************************************/
Attribute_t *attribute_new(const char *line) {
  Attribute_t *attr = NULL;
  int type;
  char *colon;
  gchar *token;

  
  colon = index(line, ':'); 
  if (colon != NULL) {
    if (line[0] =='*') {
      token = g_strndup(line+1, 2);
      type = DF_attribute_code2type(token);
    }
    else {
      token = g_strndup(line, (colon - line));
      type = DF_attribute_name2type(token);
    }
    if(token)free(token);

    colon+=2;
    if (type >= 0) {
	attr=attribute_new1(type, colon);
    }
  }
  return attr;
} /* attribute_new() */

/************************************************************
* void object_free()                                        *
*                                                           *
* Frees memory allocated for an object                      *
*                                                           *
************************************************************/
void object_free(Object_t *obj) {
  if (obj) {
   g_slist_foreach(obj->attributes, attribute_free, NULL);
   g_slist_free(obj->attributes);
   g_string_free(obj->object, TRUE);
   free(obj);
  }
} /* object_free() */

/************************************************************
* Object_t *object_new()                                    *
*                                                           *
* Determines the class type and creates an object           *
*                                                           *
************************************************************/
Object_t *object_new(const char *line) {
  Object_t *obj = NULL;

  int type;
  char *colon;
  gchar *token=NULL;

  colon = index(line, ':'); 
  if (colon != NULL) {
    if (line[0] =='*') {
      token = g_strndup(line+1, 2);
      type = DF_class_code2type(token);
    }
    else {
      token = g_strndup(line, (colon - line));
      type = DF_class_name2type(token);
    }
    if(token)free(token);
    
    if (type >= 0) {
      obj = (Object_t *)calloc(1, sizeof(Object_t)+1);
      if(!obj) die;
      obj->attributes = NULL;
      obj->object = g_string_sized_new(STR_XXXL);
      obj->type = type;
    }
  }
  return obj;
} /* object_new() */


/************************************************************
* void transaction_free()                                   *
*                                                           *
* Frees memory allocated for a transaction                  *
*                                                           *
************************************************************/

void transaction_free(Transaction_t *tr) {
  if(tr) {
    g_string_free(tr->error_script, TRUE);
    /* free nic_handle_t structure used for NHR stuff */
    if(tr->nh)free_nh(tr->nh);
    if(tr->save)free(tr->save);
    if(tr->packptr)free(tr->packptr);
    free(tr);
  }  
} /* transaction_free() */

/************************************************************
* Transaction_t *transaction_new()                          *
*                                                           *
* Creates a transaction                                     *
*                                                           *
************************************************************/
Transaction_t *transaction_new(SQ_connection_t *sql_connection, C_Type_t class_type) {
  Transaction_t *tr = (Transaction_t *)calloc(1, sizeof(Transaction_t));

  if (tr != NULL) {
    tr->sql_connection = sql_connection;
    tr->class_type = class_type;
    tr->thread_upd=TR_UPDATE;
    tr->thread_ins=TR_INSERT;
    tr->object_id = 0; /* Just in case*/
    tr->succeeded = 1;
    tr->error=0;
    tr->error_script = g_string_sized_new(STR_XL);
    tr->dummy = 0; /* By default do not create dummies except for sets*/
    tr->ndummy=0;
    tr->action=100;
    tr->load_pass=0; /* by default*/
    tr->sequence_id=1; /* we start from 1*/
    tr->save=NULL;
    tr->nh=NULL;
    tr->packptr=calloc(1, sizeof(rp_upd_pack_t));

  }
  else die;
  return tr;
} /* transaction_new() */
