# read-attr.pl
#
# Copyright (c) 1993, 1994, 1995, 1996, 1997  The TERENA Association
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
#	$Id: read_attr.pl,v 2.2 1997/10/02 15:26:03 chris Exp $
#
# This is a sub-routine to read the contents of 
# an attributes description file into a set of arrays.



sub read_attr {

  local($att_descs) = @_;
  my($line);

  open(ATT_DES, $att_descs) || 
    &fatalerror("read_conf: Cannot open file \"$att_descs\", $!");

  while (<ATT_DES>) {

    next if (/^\#/);	# ignore comments
    next if (/^\s*$/);	# ignore blank lines

    last if (/^ENDATB/);	# stop when reach "ENDATB"

    if (/^\s*ATB\b/)	{

      # look at current line entry

      $entry = $_;
      # print STDERR ("\nEntry is $entry\n") if ($opt_V);

      # remove ATB from the line

      $entry =~ s/^\s*ATB\b\s+//;
      $entry =~s/\s+/ /g;	# replace > 1 blanks with 1 blank
      $entry =~s/ $//;

      # print STDERR ("\nEntry is $entry\n") if ($opt_V);

      # divide $entry into $fields using spaces as delimiter
      # we need to keep the third part altogether :-)

      ($attribute, $field, $text) = split(/\s/, $entry, 3); 

      if ( $field eq "DESC")	{

	if ($attr_descs{$attribute})	{

	  $attr_descs{$attribute} = join ("\n\t", $attr_descs{$attribute}, $text);
	}
	else	{
	  $attr_descs{$attribute} = $text;
	}
      }

# Is this doing what you expect
# print STDERR ("\nAttribute is $attribute") if (opt_V);
# print STDERR ("\nDescription is $attr_descs{$attribute}\n") if (opt_V);

      if ( $field eq "FRMT")	{

	if ($attr_frmts{$attribute})	{

	  $attr_frmts{$attribute} = join ("\n\t", $attr_frmts{$attribute}, $text);
	}
	else	{
	  $attr_frmts{$attribute} = $text;
	}
      }




    } # End of if statement

  } # End of while loop

  close(ATT_DES);

# Test that it worked

# printf $output "\nLine 83\n";
#
  while ( ( ($attribute, $description) = each (%attr_descs) )
	 && ( ($attribute, $format) = each (%attr_frmts) ) ) {



#	printf "\n$attribute\n$description\n";
#	printf "$format\n\n";


  } # End of while loop

  
} # End of sub read_conf

# Return value of 1
1;

