# The new template.pl file
#
# Copyright (c) 1993, 1994, 1995, 1996, 1997  The TERENA Association
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
# $Id: template.pl,v 2.4 1997/10/02 12:33:33 chris Exp $
#
# new_template.pl
#
# Contains the code for both the "-t" and "-v" options
#
# Two sub-routines: Template, Verbose.

# template.pl - spits out a template for an object, based on the config
# file. Assumes that the config has already been read.
# Takes object type as input. Outputs to currently selected output.
# Assumes that the attribute description file has been read ?


sub Verbose 	{

my ($output, $type) = @_;

my (@obsoleted)=();

#
# Print a description of the object before printing the template.

printf $output "\nThe $ATTL{$type} object:\n\n";
printf $output "$obj_descs{$ATTL{$type}}\n\n";

&Template($output, $type);


	printf $output "\nThe content of the attributes of the $ATTL{$type} object are defined below:\n";

	foreach $attribute(@attributes) {

	if (grep(/\b$attribute\b/, $OBS{$type}) )   {
		
	    push(@obsoleted, sprintf("%-12s\t", $ATTL{$attribute}) );
   }
   else {

		printf $output "\n$ATTL{$attribute}\n";
		printf $output "\t$attr_descs{$ATTL{$attribute}}\n";
		printf $output "\n";
		printf $output "\t$attr_frmts{$ATTL{$attribute}}\n";

	} # End of else statement block

    } # End of foreach statement

    #
    # now print the obsoleted attributes

	unless ($#obsoleted < 0) {

	print $output "\n\nThe following attributes are obsolete in the $ATTL{$type} object:\n\n";
	
	foreach (@obsoleted) {
		print $output $_;
		}
	}

#    foreach (@obsoleted) {
#       print $output $_;
#    }

printf $output "\n\nFurther information may be found at:\n\n";
printf $output "<http://www.ripe.net/docs/ripe-157.html>\n";
printf $output "<ftp://ftp.ripe.net/ripe/docs/ripe-157.ps>\n";
printf $output "<ftp://ftp.ripe.net/ripe/docs/ripe-157.txt>\n";


} # End of sub Verbose


sub Template	{

    my ($output, $type) = @_;

    
    print $output "\n";

	#
	# an array to contain those attributes which are
	# either look-up or inverse look-up keys

	my (%indexes) = ();

	@attributes = split(/\s+/, $OBJATSQ{$type});

	foreach $attribute (@attributes) {

	if (grep(/\b$attribute\b/, $UNIQ{$type}) )   {
		
		$indexes{$attribute} = "[primary key]";	
		}
	elsif (grep(/\b$attribute\b/, $KEYS{$type}) )   {
		$indexes{$attribute} = "[look-up key]";
		}
	else {
		if (grep(/\b$attribute\b/, $INV{$type}) )   {
		$indexes{$attribute} = "[inverse key]";
		}
	   }

	if ( grep(/\b$attribute\b/, $UNIQ{$type})
	   && grep(/\b$attribute\b/, $KEYS{$type}) ) {
	   $indexes{$attribute} = "[primary/look-up key]";
	   }
	} # End of foreach statement
	

	foreach $attribute (@attributes) {
   	
 	next if (grep(/\b$attribute\b/, $OBS{$type}) );


	printf $output "%-12s %-12s %-12s %-25s\n",
	$ATTL{$attribute}.":",
	grep(/\b$attribute\b/, $OBJMAND{$type}) ? "[mandatory]" : "[optional]",
	grep(/\b$attribute\b/, $OBJMULT{$type}) ? "[multiple]"  : "[single]",
	grep(/\b$attribute\b/, keys(%indexes) ) ? $indexes{$attribute} : "[ ]";

   } # End of this foreach statement



} # End of sub Template

1;

