/***************************************
  $Revision: 1.17 $

  Email Parser module (ep) - wrapping functions to parse email,
  calling MM and PA. Header file.

  Status: NOT REVUED, TESTED

  ******************/ /******************
  Filename            : mail_parser.h
  Authors             : filippo@ripe.net
  OSs Tested          : Solaris 7
  ******************/ /******************
  Copyright (c) 2000                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

#ifndef _MAIL_PARSER_H
#define _MAIL_PARSER_H

/* FP: interface file for EP module */

#define LINE_LENGTH 1024
#define STRING_LENGTH 255
#define FILENAME_LENGTH 1024

#define ERRSTRING strerror (errno)

#include "gpg.h"
#include "memwrap.h"

/* FP : global objects used as and interface with gnuPG */

/* Pointer to a node of the parsing results tree */
typedef struct EPNode *EPNodePtr;

/* Whole container for a detailed description of a parsed mail message */

typedef struct MailHeader_Field *Mail_Header_FieldPtr;
typedef struct MailHeader_Field {
  char* field;
  Mail_Header_FieldPtr next;
} Mail_Header_Field;

typedef struct Mail_Descr {
  Mail_Header_Field *from;
  Mail_Header_Field *subject;
  Mail_Header_Field *date;
  Mail_Header_Field *message_id;
  Mail_Header_Field *reply_to;
  Mail_Header_Field *cc;
  Mail_Header_Field *content_type;
  EPNodePtr tree;
} EP_Mail_Descr;

typedef EP_Mail_Descr *EP_Mail_DescrPtr;

typedef short t_MM_type;
typedef unsigned int u32;

/* The actual node describing a stage of the parsing process */
typedef struct EPNode {
  int       nodeID;
  short     isValidPGPSignature;
  t_MM_type MIMEContentType;
  char      *strMIMEContentType;
  u32       keyID;
  char      *file;
  EPNodePtr inner;
  EPNodePtr next;
} EP_mail_node;

#define EP_HasContent(node) (node->inner == NULL ? 1 : 0)

typedef enum {
  vS_IS_VALID = 0,
  vS_IS_NOT_PGP,
  vS_KO,
  vS_CRC_ERROR,
  vS_NO_PUBLIC_KEY,
  vS_NO_OPENPGP_DATA,
  vS_NO_IN_FILES,
  vS_NO_OUT_FILES,
  vS_TO_BE_PGPVERIFIED,
  vS_UNABLE_TO_WRITE_FILE,
  vS_UNMATCHED_PGP_DELIMITERS
} verifySignatureRCs;

/* Tokens are leaves of the parsing tree and thir related
   informations, Such as: list of keys and deepest level MIME type */

typedef struct EP_Token *EPTokenPtr;
typedef struct EP_TokenKeys *EPTokenKeysPtr;

typedef struct EP_Token {
  t_MM_type MIMEContentType;
  char      *file;
  EPTokenKeysPtr keys;
  EPTokenPtr next;
  EPTokenPtr prev;
} EPToken;

typedef struct EP_TokenKeys {
  short     isValidPGPSignature;
  u32       keyID; 
  EPTokenKeysPtr next;
} EPTokenKeys;


#ifdef __cplusplus
extern "C" {
#endif

EP_Mail_DescrPtr EP_ParseMail(   const char *inputFile,
				 const char *outputPath,
				 const char *keyRing,
				 const char *gpgcmd);
EPNodePtr EP_ParseText(          const char *inputFile,
		                 const char *outputPath,
				 const char *keyRing,
				 const char *gpgcmd);
EPNodePtr EP_MIMEParse(          const EPNodePtr p);
EPNodePtr EP_InitializeRootNode( const char *inputFile );
EPNodePtr EP_InitializeNode(     const char *inputFile, 
			         const int nodeID );
EPNodePtr EP_DefineNewNode(      const int nodeID,
			         const short isValidPGPSignature,
			         const t_MM_type MIMEContentType,
				 const char *strMIMEContentType,
			         const u32       keyID);
void EP_TreeCleanUp(             const EPNodePtr ptr);
void EP_MailDescrCleanUp(        const EP_Mail_DescrPtr ptr);
void EP_BuildFilename(           const EPNodePtr ptr);
void EP_ShowTree(                const EPNodePtr p);
EPTokenPtr EP_GetTokens(const EPNodePtr p, const EPTokenPtr prev,
			EPTokenKeysPtr keysList);
void EP_PrintTokens(EPTokenPtr head);
void EP_CleanTokens(const EPTokenPtr head);

#ifdef __cplusplus
}
#endif

#endif /* _MAIL_PARSER_H */
