-- $Id: schema.sql,v 1.1 2002/07/19 13:36:45 tiago Exp $
CREATE TABLE archive (
  serial_id   INT(11),
  object_id   INT(10) UNSIGNED,
  pkey        VARCHAR(254),
  object_type TINYINT(3),
  operation   TINYINT(4),
  timestamp   INT(10),
  sequence_id INT(10),
  object      LONGBLOB
);
CREATE INDEX archive_pkey ON archive(pkey);
CREATE INDEX archive_timestamp ON archive(timestamp);
CREATE INDEX archive_serial_id ON archive(serial_id);

CREATE TABLE pkey_position (
  pkey      VARCHAR(254) NOT NULL,
  position  INT(10)      NOT NULL,
  PRIMARY KEY (pkey)
);

CREATE TABLE archive2 (
  serial_id   INT(11),
  object_id   INT(10) UNSIGNED,
  pkey        VARCHAR(254),
  object_type TINYINT(3),
  operation   TINYINT(4),
  timestamp   INT(10),
  sequence_id INT(10),
  object      LONGBLOB
);

CREATE INDEX archive2_id_seq ON archive2(object_id, sequence_id);

CREATE TABLE dump (
  timestamp INT(10)
);