/*
 Copyright (c) 2003 RIPE

 All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of the author not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
 AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
 DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

 $Id: supconf.c,v 1.14 2003/04/15 12:02:04 can Exp $
*/

#include "supconf.h"

void readConfFile(char *fileName, confFunc func)
{
    FILE *f;
    gchar *p, *buf, *bufv, *key = NULL, *val = NULL, **confLine;

    bufv = g_new(gchar, 1024);
    f = fopen(fileName, "r");
    if (f == NULL) {
        fprintf(stderr, "Can't open %s - %s", fileName, strerror(errno));
        exit(1);
    }
    while (fgets(bufv, 1000, f)) {
        buf = g_strdup(bufv);
        g_strchug(buf);
        g_strchomp(buf);
        if ((buf[0] != '#') && (buf[0] != 0)) {
            /* convert tabs to spaces */
            p = buf;
            while (*p != 0) {
                if (*p == '\t')
                    *p = ' ';
                p++;
            }
            /* remove trailing comment, if any */
            while (p != buf) {
                if ((*p == '"') && (*(p - 1) != '\\')) {
                    break;
                }
                if ((*p == '#') && (*(p - 1) != '\\')) {
                    *p = 0;
                    break;
                }
                p--;
            }
            /* split key-val pair */
            confLine = g_strsplit(buf, " ", 2);
            key = confLine[0];
            val = confLine[1];
            g_strstrip(key);
            g_strstrip(val);
            /* remove quotes from val */
            if (val[0] == '"') {
                val++;
                val[strlen(val) - 1] = 0;
            }
            (*func) (key, val);
            g_strfreev(confLine);
        }
        g_free(buf);
    }
    g_free(bufv);
    fclose(f);
}

confFunc parseConf(gpointer key, gpointer value)
{
    gchar *keyN = NULL;

    keyN = g_ascii_strup(key, -1);
    if ((!g_ascii_strcasecmp(keyN, "LISTENHOST"))
        || (!g_ascii_strcasecmp(keyN, "LISTENPORT"))
        || (!g_ascii_strcasecmp(keyN, "FORWARDHOST"))
        || (!g_ascii_strcasecmp(keyN, "FORWARDPORT"))
        || (!g_ascii_strcasecmp(keyN, "MAXLENACCEPT"))
        || (!g_ascii_strcasecmp(keyN, "MAXLENFORWARD"))
        || (!g_ascii_strcasecmp(keyN, "MAXCONNUNIQUE"))
        || (!g_ascii_strcasecmp(keyN, "MAXCONNUNIQUEWARN"))
        || (!g_ascii_strcasecmp(keyN, "MAXCONN"))
        || (!g_ascii_strcasecmp(keyN, "MAPRANGESTART"))
        || (!g_ascii_strcasecmp(keyN, "MAPRANGEEND"))
        || (!g_ascii_strcasecmp(keyN, "LOGDIR"))
        || (!g_ascii_strcasecmp(keyN, "PIDFILE"))
        || (!g_ascii_strcasecmp(keyN, "SWITCHUSER"))
        || (!g_ascii_strcasecmp(keyN, "DBHOST"))
        || (!g_ascii_strcasecmp(keyN, "DBPORT"))
        || (!g_ascii_strcasecmp(keyN, "DBUSER"))
        || (!g_ascii_strcasecmp(keyN, "DBPASS"))
        || (!g_ascii_strcasecmp(keyN, "DBNAME"))
        || (!g_ascii_strcasecmp(keyN, "MAPTABLE"))
        || (!g_ascii_strcasecmp(keyN, "PROXYTABLE"))
        || (!g_ascii_strcasecmp(keyN, "INPUT_LINE_TOO_LONG"))
        || (!g_ascii_strcasecmp(keyN, "FORWARD_LINE_TOO_LONG"))
        || (!g_ascii_strcasecmp(keyN, "INVALID_ADDRESS_PASSING"))
        || (!g_ascii_strcasecmp(keyN, "ADDRESS_PASSING_FORBIDDEN"))
        || (!g_ascii_strcasecmp(keyN, "TOO_MANY_CONCURRENT_CONNECTIONS"))) {
        g_hash_table_insert(confHash, g_strdup(keyN), g_strdup(value));
    } else {
        local_error("Unknown configuration keyword %s", (char *) key);
    }
    g_free(keyN);
    return NULL;
}

gpointer *getConf(gchar * key)
{
    gpointer *value;

    value = g_hash_table_lookup(confHash, key);
    if (value == NULL) {
        local_error("Configuration variable %s not found", key);
    }
    return value;
}
