//: X1:SimpleFormatterExample.java
import com.bruceeckel.simpletest.*;
import java.util.logging.*;
import java.util.*;

public class SimpleFormatterExample {
  private static Logger myLogger =
    Logger.getLogger("SimpleFormatterExample");
  private static void logMessages() {
    myLogger.info("Line One");
    myLogger.info("Line Two");
  }
  public static void main(String[] args){
    SimpleTest monitor =
      new SimpleTest("SimpleFormatterExample");
    myLogger.setUseParentHandlers(false);
    Handler conHdlr = new ConsoleHandler();
    conHdlr.setFormatter(new Formatter() {
      public String format(LogRecord record) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(record.getLevel() + "  :  ");
        sbuf.append(record.getSourceClassName()
        + " -:- " + record.getSourceMethodName() + 
        " -:- ");
        sbuf.append(record.getMessage());
        sbuf.append(System.getProperty("line.separator"));
        return sbuf.toString();
      }
    });
    myLogger.addHandler(conHdlr);
    logMessages();
    monitor.expect(new String[] {
    });
  }
} ///:~