//: c07:Transmogrify.java
// Dynamically changing the behavior of
// an object via composition.
import com.bruceeckel.simpletest.*;

abstract class Actor {
  abstract void act();
}

class HappyActor extends Actor {
  public void act() { 
    System.out.println("HappyActor"); 
  }
}

class SadActor extends Actor {
  public void act() { 
    System.out.println("SadActor");
  }
}

class Stage {
  Actor a = new HappyActor();
  void change() { a = new SadActor(); }
  void go() { a.act(); }
}

public class Transmogrify {
  public static void main(String[] args) {
    SimpleTest monitor =
      new SimpleTest("Transmogrify");
    Stage s = new Stage();
    s.go(); // Prints "HappyActor"
    s.change();
    s.go(); // Prints "SadActor"
    monitor.expect(new String[] {
      "HappyActor",
      "SadActor"
    });
  }
} ///:~