//: c10:ExceptionMethods.java
// Demonstrating the Exception Methods.
import com.bruceeckel.simpletest.*;

public class ExceptionMethods {
  public static void main(String[] args) {
    SimpleTest monitor =
      new SimpleTest("ExceptionMethods");
    try {
      throw new Exception("Here's my Exception");
    } catch(Exception e) {
      System.err.println("Caught Exception");
      System.err.println(
        "e.getMessage(): " + e.getMessage());
      System.err.println(
        "e.getLocalizedMessage(): " +
         e.getLocalizedMessage());
      System.err.println("e.toString(): " + e);
      System.err.println("e.printStackTrace():");
      e.printStackTrace(System.err);
    }
    monitor.expect(new String[] {
      "Caught Exception",
      "e.getMessage(): Here's my Exception",
      "e.getLocalizedMessage(): Here's my Exception",
      "e.toString(): java.lang.Exception: Here's my Exception",
      "e.printStackTrace():",
      "java.lang.Exception: Here's my Exception",
      "	at ExceptionMethods.main(Unknown Source)"
    });
  }
} ///:~