//: c10:FullConstructors.java
// Inheriting your own exceptions.
import com.bruceeckel.simpletest.*;

class MyException extends Exception {
  public MyException() {}
  public MyException(String msg) {
    super(msg);
  }
}

public class FullConstructors {
  public static void f() throws MyException {
    System.out.println(
      "Throwing MyException from f()");
    throw new MyException();
  }
  public static void g() throws MyException {
    System.out.println(
      "Throwing MyException from g()");
    throw new MyException("Originated in g()");
  }
  public static void main(String[] args) {
    SimpleTest monitor =
      new SimpleTest("FullConstructors");
    try {
      f();
    } catch(MyException e) {
      e.printStackTrace(System.err);
    }
    try {
      g();
    } catch(MyException e) {
      e.printStackTrace(System.err);
    }
    monitor.expect(new String[] {
      "Throwing MyException from f()",
      "MyException",
      "	at FullConstructors.f(Unknown Source)",
      "	at FullConstructors.main(Unknown Source)",
      "Throwing MyException from g()",
      "MyException: Originated in g()",
      "	at FullConstructors.g(Unknown Source)",
      "	at FullConstructors.main(Unknown Source)"
    });
  }
} ///:~