#
# File:		util.pl
# Author:	G. Paul Ziemba
# Date:		93.05.21
# SCCS:		@(#)util.pl	1.3 9/29/94

#
# It's gross to do a fork for every message, but this
# should only be needed for those occasional debugging
# sessions :-)
#
sub logit
{
    local($system, $code, @message);
    $system = shift;
    $code = shift;
    @message = split(/\n+/, join("\n", @_));
    local($fp, $printpid);


    if ($syslogging) {
	    $fp = $LogFP{$system};
	    $fp = $LogFP{'default'} if ($fp eq '');
	    $fp = "daemon.debug" if ($fp eq '');

	    if ($fp ne 'null') {
		    if ($masterpid) {
			    $printpid = $masterpid;
		    } else {
			    $printpid = $$;
		    }
		    if ($$ != $printpid) {
			    $printpid .= ":$$";
		    }

		    &syslogger("$progname[$printpid]", $fp, @message);
	    }
    }

    if ($debug) {
	    &errlogger($code, @message);
    }

}

sub errlogger
{
    local($code) = shift;
    local($last, $_);

    $last = pop(@_);
    for (@_) {
	    print STDERR "${code}-$_\n";
    }
    print STDERR "$code $last\n";
}

sub syslogger
{
    local($Tag, $FaPri, @Message) = @_;
    local($kidpid);

    return if ($FaPri eq 'null');

    for (@Message) {
	    $kidpid = fork;
	    if (!$kidpid) {
		    local($LogProg);
		    ($ENV{'PATH'}, $LogProg, $kidpid) =
			&pathit($LOGGERPATH, "logger");

		    #
		    # Note: $fp comes from config file. We exec without
		    # the shell here, so we don't need to worry about
		    # metacharacters.
		    #
		    exec $LogProg, "-t", $Tag, "-p", $FaPri, $_;
		    exit -1;
	    } else {
		    waitpid($kidpid, 0);
	    }
    }
}


sub pathit # Args: path it; Returns: NewPath, ProgName, OldPath
{
    local($_, $it) = @_[0,1];
    local(@retval);

    if (/./) {
	    if (!/:/) {
		    if (-d) {
			    $_ .= "/$it";
		    }
		    @retval =  ("", $_, $ENV{'PATH'});
		    #printf STDERR "[%s] [%s] [%s]\n", @retval[0..2];
		    return @retval;
	    }
	    @retval =  ($_, $it, $ENV{'PATH'});
	    #printf STDERR "[%s] [%s] [%s]\n", @retval[0..2];
	    return @retval;
    }
    @retval = ($ENV{'PATH'}, $it, $ENV{'PATH'});
    #printf STDERR "[%s] [%s] [%s]\n", @retval[0..2];
    return @retval;
}


sub alarm
{
    local($timeout) = $_[0];

    &logit("alarm", "alarm: called with $timeout");

    #
    # If we forked, make sure we forget about alarm kid of parent
    #
    if ($CallerPid != $$) {
	    &logit("alarm", "alarm: called first time in pid $$");
	    undef $AlarmPid;
	    $CallerPid = $$;
    }

    #
    # If we have an alarm kid, kill it
    #
    if (defined($AlarmPid)) {
	    &logit("alarm", "alarm: killing ak $AlarmPid");
	    kill 'KILL', $AlarmPid;
    }

    #
    # Don't have to do anything else if zero timeout argument
    #
    if (!$timeout) {
	    return 0;
    }

    $AlarmPid = fork;
    if ($AlarmPid) {
	    return 0;
    } elsif (!defined($AlarmPid)) {
	    #
	    # fork failed
	    # (is this the correct test for fork failure?)
	    #
	    &logit("alarm", "alarm: fork failed");
	    return -1;
    }

    #
    # Child from here on
    #
    &logit("alarm", "ak: sleeping for $timeout");
    sleep($timeout);
    &logit("alarm", "ak: alarming $CallerPid");
    kill 'ALRM', $CallerPid;
    exit 0;
}

#
# Sets up a default configuration if there is no config file present
#
sub configfile
{
    local($_, @_, @errors, $readconfig, $prog, $cf);

    $readconfig = 0;

    $CONFIGFILE = "/etc/tcpr.conf" if ($CONFIGFILE eq '');
    $cf = ($ConfigFile ne '')? $ConfigFile: $CONFIGFILE;
    $prog = ($progname ne '')? $progname: $0;

    if (open(CF, "<$cf")) {
	    ++$readconfig;
	    while (<CF>) {
		    chop;
		    s/\#.*$//;
		    s/^\s+//;
		    next if /^$/;

		    ($_, @_) = split;

		    if ($_ eq 'LOG') {
			    $LogFP{$_[0]} = $_[1];
		    } else {
			    push(@errors,
				"line $.: unrecognized keyword: $_");
		    }
	    }
	    close(CF);
    } else {
	    push(@errors, "can't open config file \"$cf\"");
    }

    if (!$readconfig) {
	    %LogFP = (
		"default",	"daemon.debug",
		"request",	"daemon.info",	# request messages
		"connect",	"daemon.info",	# connect messages
		"alarm",	"daemon.debug",	# timeout-related
		"fork",		"daemon.debug",	# process-related
		"exit",		"daemon.debug",	# process exits
		"interface",	"daemon.debug",	# interface selection
		"ftp",		"daemon.debug",	# ftp spoofing
		"bytecount",	"daemon.info",	# transfer byte counts
	    );
    }

    if ($#errors > -1) {
	    &syslogger("$prog[$$]", "daemon.err", @errors);
    }

}
