-- CZ1103A.ADA
--
--                             Grant of Unlimited Rights
--
--     Under contracts F33600-87-D-0337, F33600-84-D-0280, MDA903-79-C-0687,
--     F08630-91-C-0015, and DCA100-97-D-0025, the U.S. Government obtained
--     unlimited rights in the software and documentation contained herein.
--     Unlimited rights are defined in DFAR 252.227-7013(a)(19).  By making
--     this public release, the Government intends to confer upon all
--     recipients unlimited rights  equal to those held by the Government.
--     These rights include rights to use, duplicate, release or disclose the
--     released technical data and computer software in whole or in part, in
--     any manner and for any purpose whatsoever, and to have or permit others
--     to do so.
--
--                                    DISCLAIMER
--
--     ALL MATERIALS OR INFORMATION HEREIN RELEASED, MADE AVAILABLE OR
--     DISCLOSED ARE AS IS.  THE GOVERNMENT MAKES NO EXPRESS OR IMPLIED
--     WARRANTY AS TO ANY MATTER WHATSOEVER, INCLUDING THE CONDITIONS OF THE
--     SOFTWARE, DOCUMENTATION OR OTHER INFORMATION RELEASED, MADE AVAILABLE
--     OR DISCLOSED, OR THE OWNERSHIP, MERCHANTABILITY, OR FITNESS FOR A
--     PARTICULAR PURPOSE OF SAID MATERIAL.
--*
--
-- OBJECTIVE:
--     CHECK THAT THE PROCEDURE CHECK_FILE WORKS CORRECTLY, IN
--     PARTICULAR, THAT IT WILL REPORT INCORRECT FILE CONTENTS
--     AS TEST FAILURES.

--     THIS TEST INTENTIONALLY CONTAINS MISMATCHES BETWEEN FILE
--     CONTENTS AND THE 'CONTENTS' STRING PARAMETER OF PROCEDURE
--     CHECK_FILE.

-- PASS/FAIL CRITERIA:
--     IF AN IMPLEMENTATION SUPPORTS EXTERNAL FILES, IT PASSES THIS TEST
--     IF TEST EXECUTION REPORTS THE FOLLOWING FOUR FAILURES, REPORTS AN
--     INTERMEDIATE "FAILED" RESULT, REPORTS A FINAL "TENTATIVELY PASSED"
--     RESULT, AND REPORTS NO OTHER FAILURES.
--        * CZ1103A FROM CHECK_FILE: END OF LINE EXPECTED - E
--                     ENCOUNTERED.
--        * CZ1103A FROM CHECK_FILE: END_OF_PAGE NOT WHERE EXPECTED.
--        * CZ1103A FROM CHECK_FILE: END_OF_FILE NOT WHERE EXPECTED.
--        * CZ1103A FROM CHECK_FILE: FILE DOES NOT CONTAIN CORRECT
--                      OUTPUT - EXPECTED C - GOT I.
--
--     IF AN IMPLEMENTATION DOES NOT SUPPORT EXTERNAL FILES, IT PASSES THIS
--     TEST IF TEST EXECUTION REPORTS NINE FAILURES FOR INCOMPLETE SUBTESTS
--     SIMILAR TO THE SAMPLE BELOW, REPORTS AN INTERMEDIATE "FAILED" RESULT,
--     REPORTS A FINAL "TENTATIVELY PASSED" RESULT, AND REPORTS NO OTHER
--     FAILURES.
--        * CZ1103A TEST WITH EMPTY FILE INCOMPLETE.

-- HISTORY:
--     SPS 12/09/82  CREATED ORIGINAL TEST.
--     JRK 11/18/85  ADDED COMMENTS ABOUT PASS/FAIL CRITERIA.
--     JET 01/13/88  UPDATED HEADER FORMAT, ADDED FINAL CALL TO
--                   SPECIAL_ACTION.
--     PWB 06/24/88  CORRECTED PASS/FAIL CRITERIA TO INDICATE THE
--                   EXPECTED RESULT (TENTATIVELY PASSED).
--     RLB 03/20/00  CORRECTED PASS/FAIL CRITERIA TO REFLECT PROPER RESULT
--                   FOR AN IMPLEMENTATION THAT DOES NOT SUPPORT EXTERNAL FILES.

WITH REPORT; USE REPORT;
WITH TEXT_IO; USE TEXT_IO;
WITH CHECK_FILE;

PROCEDURE CZ1103A IS

     NULL_FILE : FILE_TYPE;
     FILE_WITH_BLANK_LINES : FILE_TYPE;
     FILE_WITH_BLANK_PAGES : FILE_TYPE;
     FILE_WITH_TRAILING_BLANKS : FILE_TYPE;
     FILE_WITHOUT_TRAILING_BLANKS : FILE_TYPE;
     FILE_WITH_END_OF_LINE_ERROR : FILE_TYPE;
     FILE_WITH_END_OF_PAGE_ERROR : FILE_TYPE;
     FILE_WITH_END_OF_FILE_ERROR : FILE_TYPE;
     FILE_WITH_DATA_ERROR : FILE_TYPE;

BEGIN

     TEST ("CZ1103A", "CHECK THAT PROCEDURE CHECK_FILE WORKS");

-- THIS SECTION TESTS CHECK_FILE WITH AN EMPTY FILE.

     BEGIN
          COMMENT ("BEGIN TEST WITH AN EMPTY FILE");
          CREATE (NULL_FILE, OUT_FILE);
          CHECK_FILE (NULL_FILE, "#@%");
          CLOSE (NULL_FILE);
     EXCEPTION
          WHEN OTHERS =>
               FAILED ("TEST WITH EMPTY FILE INCOMPLETE");

     END;

-- THIS SECTION TESTS CHECK_FILE WITH A FILE WITH BLANK LINES.

     BEGIN
          COMMENT ("BEGIN TEST WITH A FILE WITH BLANK LINES");
          CREATE (FILE_WITH_BLANK_LINES, OUT_FILE);
          NEW_LINE (FILE_WITH_BLANK_LINES, 20);
          CHECK_FILE (FILE_WITH_BLANK_LINES, "####################@%");
          CLOSE (FILE_WITH_BLANK_LINES);
     EXCEPTION
          WHEN OTHERS =>
               FAILED ("TEST WITH FILE WITH BLANK LINES INCOMPLETE");
     END;

-- THIS SECTION TESTS CHECK_FILE WITH A FILE WITH BLANK LINES AND PAGES.

     BEGIN
          COMMENT ("BEGIN TEST WITH A FILE WITH BLANK LINES " &
                   "AND PAGES");
          CREATE (FILE_WITH_BLANK_PAGES, OUT_FILE);
          NEW_LINE (FILE_WITH_BLANK_PAGES, 3);
          NEW_PAGE (FILE_WITH_BLANK_PAGES);
          NEW_LINE (FILE_WITH_BLANK_PAGES, 2);
          NEW_PAGE (FILE_WITH_BLANK_PAGES);
          NEW_PAGE (FILE_WITH_BLANK_PAGES);
          CHECK_FILE (FILE_WITH_BLANK_PAGES, "###@##@#@%");
          CLOSE (FILE_WITH_BLANK_PAGES);
     EXCEPTION
          WHEN OTHERS =>
               FAILED ("TEST WITH FILE WITH BLANK PAGES INCOMPLETE");
     END;

-- THIS SECTION TESTS CHECK_FILE WITH A FILE WITH TRAILING BLANKS.

     BEGIN
          COMMENT ("BEGIN TEST WITH A FILE WITH TRAILING BLANKS");
          CREATE (FILE_WITH_TRAILING_BLANKS, OUT_FILE);
          FOR I IN 1 .. 3 LOOP
               PUT_LINE (FILE_WITH_TRAILING_BLANKS,
                         "LINE WITH TRAILING BLANKS    ");
          END LOOP;
          CHECK_FILE(FILE_WITH_TRAILING_BLANKS, "LINE WITH TRAILING" &
                    " BLANKS#LINE WITH TRAILING BLANKS#LINE" &
                    " WITH TRAILING BLANKS#@%");
          CLOSE (FILE_WITH_TRAILING_BLANKS);
     EXCEPTION
          WHEN OTHERS =>
               FAILED ("TEST WITH FILE WITH TRAILING BLANKS " &
                       "INCOMPLETE");
     END;

-- THIS SECTION TESTS CHECK_FILE WITH A FILE WITHOUT TRAILING BLANKS.

     BEGIN
          COMMENT ("BEGIN TEST WITH A FILE WITHOUT TRAILING BLANKS");
          CREATE (FILE_WITHOUT_TRAILING_BLANKS, OUT_FILE);
          FOR I IN 1 .. 3 LOOP
               PUT_LINE (FILE_WITHOUT_TRAILING_BLANKS,
                         "LINE WITHOUT TRAILING BLANKS");
          END LOOP;
          CHECK_FILE(FILE_WITHOUT_TRAILING_BLANKS, "LINE WITHOUT " &
                    "TRAILING BLANKS#LINE WITHOUT TRAILING BLANKS#" &
                    "LINE WITHOUT TRAILING BLANKS#@%");
          CLOSE (FILE_WITHOUT_TRAILING_BLANKS);
     EXCEPTION
          WHEN OTHERS =>
               FAILED ("TEST WITH FILE WITHOUT TRAILING BLANKS " &
                       "INCOMPLETE");
     END;

-- THIS SECTION TESTS CHECK_FILE WITH A FILE WITH AN END OF LINE ERROR.

     BEGIN
          COMMENT ("BEGIN TEST WITH A FILE WITH AN END OF LINE ERROR");
          CREATE (FILE_WITH_END_OF_LINE_ERROR, OUT_FILE);
          PUT_LINE (FILE_WITH_END_OF_LINE_ERROR, "THIS LINE WILL " &
                    "CONTAIN AN END OF LINE IN THE WRONG PLACE");
          CHECK_FILE (FILE_WITH_END_OF_LINE_ERROR, "THIS LINE WILL " &
               "CONTAIN AN # IN THE WRONG PLACE#@%");
          CLOSE (FILE_WITH_END_OF_LINE_ERROR);
     EXCEPTION
          WHEN OTHERS =>
               FAILED ("TEST WITH END_OF_LINE ERROR INCOMPLETE");
     END;

-- THIS SECTION TESTS CHECK_FILE WITH A FILE WITH AN END OF PAGE ERROR.

     BEGIN
          COMMENT ("BEGIN TEST WITH FILE WITH END OF PAGE ERROR");
          CREATE (FILE_WITH_END_OF_PAGE_ERROR, OUT_FILE);
          PUT_LINE (FILE_WITH_END_OF_PAGE_ERROR, "THIS LINE WILL " &
                    "CONTAIN AN END OF PAGE IN THE WRONG PLACE");
          CHECK_FILE (FILE_WITH_END_OF_PAGE_ERROR, "THIS LINE WILL " &
               "CONTAIN AN @ IN THE WRONG PLACE#@%");
          CLOSE (FILE_WITH_END_OF_PAGE_ERROR);
     EXCEPTION
          WHEN OTHERS =>
               FAILED ("TEST WITH END_OF_PAGE ERROR INCOMPLETE");
     END;

-- THIS SECTION TESTS CHECK_FILE WITH A FILE WITH AN END OF FILE ERROR.

     BEGIN
          COMMENT ("BEGIN TEST WITH FILE WITH END OF FILE ERROR");
          CREATE (FILE_WITH_END_OF_FILE_ERROR, OUT_FILE);
          PUT_LINE (FILE_WITH_END_OF_FILE_ERROR, "THIS LINE WILL " &
                    "CONTAIN AN END OF FILE IN THE WRONG PLACE");
          CHECK_FILE (FILE_WITH_END_OF_FILE_ERROR, "THIS LINE WILL " &
               "CONTAIN AN % IN THE WRONG PLACE#@%");
          CLOSE (FILE_WITH_END_OF_FILE_ERROR);
     EXCEPTION
          WHEN OTHERS =>
               FAILED ("TEST WITH END_OF_FILE ERROR INCOMPLETE");
     END;

-- THIS SECTION TESTS CHECK_FILE WITH A FILE WITH INCORRECT DATA.

     BEGIN
          COMMENT ("BEGIN TEST WITH FILE WITH INCORRECT DATA");
          CREATE (FILE_WITH_DATA_ERROR, OUT_FILE);
          PUT_LINE (FILE_WITH_DATA_ERROR, "LINE WITH INCORRECT " &
                    "DATA");
          CHECK_FILE (FILE_WITH_DATA_ERROR, "LINE WITH CORRECT " &
                      "DATA#@%");
          CLOSE (FILE_WITH_DATA_ERROR);
     EXCEPTION
          WHEN OTHERS =>
               FAILED ("TEST WITH INCORRECT DATA INCOMPLETE");
     END;

     RESULT;

     TEST ("CZ1103A", "THE LINE ABOVE SHOULD REPORT FAILURE");
     SPECIAL_ACTION ("COMPARE THIS OUTPUT TO THE EXPECTED RESULT");
     RESULT;

END CZ1103A;
