/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import jde.debugger.Application;
import jde.debugger.ApplicationCommands;
import jde.debugger.Etc;
import jde.debugger.JDEException;
import jde.debugger.ObjectStore;
import jde.debugger.spec.EventRequestSpec;
import jde.debugger.spec.EventRequestSpecList;
import jde.debugger.spec.WatchpointSpec;

public class SpecCommands
extends ApplicationCommands {
    final EventRequestSpecList eventRequests;

    public void doTraceExceptions(Integer cmd_id, List args) throws JDEException {
        if (args.size() < 2) {
            throw new JDEException("Insufficient arguments");
        }
        String classPattern = args.remove(0).toString();
        String type = args.remove(0).toString().toLowerCase();
        boolean caught = false;
        boolean uncaught = false;
        if (type.equals("both")) {
            caught = true;
            uncaught = true;
        } else if (type.equals("caught")) {
            caught = true;
        } else if (type.equals("uncaught")) {
            uncaught = true;
        } else {
            throw new JDEException("'" + type + "' not understood");
        }
        EventRequestSpec er = this.eventRequests.createExceptionIntercept(classPattern, caught, uncaught);
        er.setThread(Etc.getThreadFromArgs(args));
        er.setSuspendPolicy(Etc.getSuspendPolicyFromArgs(args));
        er.setClassFilters(Etc.getClassFiltersFromArgs(args));
        er.setClassExFilters(Etc.getClassExFiltersFromArgs(args));
        this.eventRequests.install(er);
        this.app.signalCommandResult(cmd_id, er.getID());
    }

    public void doWatch(Integer cmd_id, List args) throws JDEException {
        if (args.size() < 3) {
            throw new JDEException("Insufficient arguments");
        }
        String classPattern = args.remove(0).toString();
        String methodName = args.remove(0).toString();
        String typeString = args.remove(0).toString().toLowerCase();
        WatchpointSpec er = null;
        if (typeString.equals("for_access")) {
            if (!this.app.getVM().canWatchFieldAccess()) {
                throw new JDEException("This VM implementation cannot watch field accesses");
            }
            er = this.eventRequests.createAccessWatchpoint(classPattern, methodName);
        } else if (typeString.equals("for_modification")) {
            if (!this.app.getVM().canWatchFieldModification()) {
                throw new JDEException("This VM implementation cannot watch field modifications");
            }
            er = this.eventRequests.createModificationWatchpoint(classPattern, methodName);
        } else {
            throw new JDEException("'" + typeString + "' not understood: use either 'for_access' or 'for_modification'");
        }
        er.setThread(Etc.getThreadFromArgs(args));
        er.setExpression(Etc.getExprFromArgs(args));
        er.setObjectID(Etc.getObjectIDFromArgs(args));
        er.setSuspendPolicy(Etc.getSuspendPolicyFromArgs(args));
        er.setClassFilters(Etc.getClassFiltersFromArgs(args));
        er.setClassExFilters(Etc.getClassExFiltersFromArgs(args));
        this.eventRequests.install(er);
        this.app.signalCommandResult(cmd_id, er.getID());
    }

    public void doBreak(Integer cmd_id, List args) throws JDEException {
        block6: {
            try {
                String type = args.remove(0).toString().toLowerCase();
                if (type.equals("in_method")) {
                    this.doBreakInMethod(cmd_id, args);
                    break block6;
                }
                if (type.equals("on_line")) {
                    this.doBreakOnLine(cmd_id, args);
                    break block6;
                }
                if (type.equals("absolute")) {
                    this.doBreakAbsolute(cmd_id, args);
                    break block6;
                }
                throw new JDEException("Syntax error: expecting one of 'in_method', 'on_line', or 'absolute'; '" + type + "' is not supported");
            }
            catch (UnsupportedOperationException ex) {
                throw new JDEException("Unspecified Error occured");
            }
            catch (IndexOutOfBoundsException ex) {
                throw new JDEException("Syntax error: argument missing");
            }
        }
    }

    public void doClear(Integer cmd_id, List args) throws JDEException {
        if (args.size() < 1) {
            throw new JDEException("Insufficient arguments");
        }
        Long specID = Etc.safeGetLong(args.remove(0), "spec ID");
        this.eventRequests.removeSpec(specID);
        this.app.signalCommandResult(cmd_id);
    }

    public void doBreakInMethod(Integer cmd_id, List args) throws JDEException {
        String arg;
        if (args.size() < 2) {
            throw new JDEException("Insufficient arguments");
        }
        String classPattern = args.remove(0).toString();
        String method = args.remove(0).toString();
        ArrayList<String> argumentList = null;
        if (args.size() > 0 && (arg = args.remove(0).toString()).startsWith("(")) {
            if (!arg.endsWith(")")) {
                throw new JDEException("The argument list seems to be corrupt");
            }
            arg = arg.substring(1, arg.length() - 1);
            argumentList = new ArrayList<String>();
            StringTokenizer t = new StringTokenizer(arg, ",");
            while (t.hasMoreTokens()) {
                argumentList.add(t.nextToken());
            }
        }
        EventRequestSpec er = this.eventRequests.createMethodBreakpoint(classPattern, method, argumentList);
        er.setThread(Etc.getThreadFromArgs(args));
        er.setExpression(Etc.getExprFromArgs(args));
        er.setSuspendPolicy(Etc.getSuspendPolicyFromArgs(args));
        this.eventRequests.install(er);
        this.app.signalCommandResult(cmd_id, er.getID());
    }

    public void doBreakOnLine(Integer cmd_id, List args) throws JDEException {
        if (args.size() < 2) {
            throw new JDEException("Insufficient arguments");
        }
        String classPattern = args.remove(0).toString();
        int line = Etc.safeGetint(args.remove(0), "line number");
        EventRequestSpec er = this.eventRequests.createClassLineBreakpoint(classPattern, line);
        er.setThread(Etc.getThreadFromArgs(args));
        er.setExpression(Etc.getExprFromArgs(args));
        er.setSuspendPolicy(Etc.getSuspendPolicyFromArgs(args));
        this.eventRequests.install(er);
        this.app.signalCommandResult(cmd_id, er.getID());
    }

    public void doBreakAbsolute(Integer cmd_id, List args) throws JDEException {
        if (args.size() < 2) {
            throw new JDEException("Insufficient arguments");
        }
        String file = args.remove(0).toString();
        int line = Etc.safeGetint(args.remove(0), "line number");
        EventRequestSpec er = this.eventRequests.createSourceLineBreakpoint(file, line);
        er.setThread(Etc.getThreadFromArgs(args));
        er.setExpression(Etc.getExprFromArgs(args));
        er.setSuspendPolicy(Etc.getSuspendPolicyFromArgs(args));
        this.eventRequests.install(er);
        this.app.signalCommandResult(cmd_id, er.getID());
    }

    public SpecCommands(Application a, EventRequestSpecList e, ObjectStore s) {
        super(a, s);
        this.eventRequests = e;
    }
}

