/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BshMethod;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.LHS;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.Reflect;
import bsh.ReflectError;
import bsh.This;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;

class Name
implements Serializable {
    public NameSpace namespace;
    String value = null;
    private String evalName;
    private Object evalBaseObject;
    static /* synthetic */ Class class$bsh$Interpreter;

    public Name(NameSpace nameSpace, String string) {
        this.namespace = nameSpace;
        this.value = string;
    }

    public synchronized Object toObject(Interpreter interpreter) throws EvalError {
        this.evalName = this.value;
        this.evalBaseObject = null;
        Object object = null;
        while (this.evalName != null) {
            object = this.consumeNextObjectField(interpreter);
        }
        if (object == null) {
            throw new InterpreterError("null value in toObject()");
        }
        return object;
    }

    private Object consumeNextObjectField(Interpreter interpreter) throws EvalError {
        Object object;
        if (this.evalBaseObject == null) {
            Interpreter.debug("trying class: " + this.evalName);
            object = null;
            int n = 1;
            while (n <= Name.countParts(this.evalName)) {
                object = this.namespace.getClass(Name.prefix(this.evalName, n));
                if (object != null) break;
                ++n;
            }
            if (object != null) {
                this.evalName = Name.suffix(this.evalName, Name.countParts(this.evalName) - n);
                this.evalBaseObject = new ClassIdentifier((Class)object);
                return this.evalBaseObject;
            }
            Interpreter.debug("not a class, trying var prefix " + this.evalName);
        }
        if (this.evalBaseObject == null || this.evalBaseObject instanceof This) {
            object = Name.prefix(this.evalName, 1);
            Interpreter.debug("trying to resolve variable: " + (String)object);
            Object object2 = this.evalBaseObject == null ? this.resolveThisFieldReference(this.namespace, interpreter, (String)object, false) : this.resolveThisFieldReference(((This)this.evalBaseObject).namespace, interpreter, (String)object, true);
            if (object2 == Primitive.VOID) {
                if (Name.suffix(this.evalName) == null) {
                    this.evalName = null;
                    this.evalBaseObject = object2;
                    return this.evalBaseObject;
                }
                throw new EvalError("Class or variable not found:" + this.evalName);
            }
            Interpreter.debug("resolved variable: " + (String)object + " in namespace: " + this.namespace);
            this.evalName = Name.suffix(this.evalName);
            this.evalBaseObject = object2;
            return this.evalBaseObject;
        }
        if (this.evalBaseObject == Primitive.NULL) {
            throw new EvalError("Null pointer error...");
        }
        if (this.evalBaseObject == Primitive.VOID) {
            throw new EvalError("Void pointer error...");
        }
        if (this.evalBaseObject instanceof Primitive) {
            throw new EvalError("Can't treat primitive like an object.");
        }
        if (this.evalBaseObject instanceof ClassIdentifier) {
            String string;
            Class clazz;
            object = ((ClassIdentifier)this.evalBaseObject).getTargetClass();
            String string2 = Name.prefix(this.evalName, 1);
            Object object3 = null;
            try {
                object3 = Reflect.getStaticField((Class)object, string2);
            }
            catch (ReflectError reflectError) {
                // empty catch block
            }
            if (object3 == null && (clazz = this.namespace.getClass(string = ((Class)object).getName() + "$" + string2)) != null) {
                object3 = new ClassIdentifier(clazz);
            }
            if (object3 == null) {
                throw new EvalError("No static field or inner class: " + string2 + " of " + object);
            }
            this.evalName = Name.suffix(this.evalName);
            this.evalBaseObject = object3;
            return this.evalBaseObject;
        }
        object = Name.prefix(this.evalName, 1);
        if (((String)object).equals("length") && this.evalBaseObject.getClass().isArray()) {
            Primitive primitive = new Primitive(Array.getLength(this.evalBaseObject));
            this.evalName = Name.suffix(this.evalName);
            this.evalBaseObject = primitive;
            return this.evalBaseObject;
        }
        try {
            Object object4 = Reflect.getObjectField(this.evalBaseObject, (String)object);
            this.evalName = Name.suffix(this.evalName);
            this.evalBaseObject = object4;
            return this.evalBaseObject;
        }
        catch (ReflectError reflectError) {
            throw new EvalError("Cannot access field: " + (String)object + ", on object: " + this.evalBaseObject);
        }
    }

    Object resolveThisFieldReference(NameSpace nameSpace, Interpreter interpreter, String string, boolean bl) {
        String[] stringArray = null;
        if (string.equals("this")) {
            stringArray = nameSpace.getThis(interpreter);
        } else if (string.equals("super")) {
            stringArray = nameSpace.getSuper().getThis(interpreter);
        } else if (string.equals("global")) {
            stringArray = nameSpace.getGlobal().getThis(interpreter);
        } else if (bl) {
            if (string.equals("namespace")) {
                stringArray = nameSpace;
            } else if (string.equals("interpreter")) {
                stringArray = interpreter;
            } else if (string.equals("variables")) {
                stringArray = nameSpace.getVariableNames();
            } else if (string.equals("methods")) {
                stringArray = nameSpace.getMethodNames();
            }
        }
        if (stringArray == null) {
            stringArray = nameSpace.getVariable(string);
        }
        return stringArray;
    }

    public synchronized Class toClass() throws EvalError {
        this.evalName = this.value;
        this.evalBaseObject = null;
        Class clazz = this.namespace.getClass(this.evalName);
        if (clazz == null) {
            Object object = null;
            try {
                object = this.toObject(null);
            }
            catch (EvalError evalError) {
                // empty catch block
            }
            if (object instanceof ClassIdentifier) {
                clazz = ((ClassIdentifier)object).getTargetClass();
            } else if (object != null) {
                if (object == Primitive.VOID) {
                    throw new EvalError("\"" + this.value + "\"" + " does not resolve to a " + "class name.  It is undefined.");
                }
                throw new EvalError("\"" + this.value + "\"" + " does not resolve to a " + "class name.  It resolves to an object of type: " + object.getClass().getName());
            }
        }
        if (clazz == null) {
            throw new EvalError("Class: " + this.value + " not found in namespace");
        }
        return clazz;
    }

    public synchronized LHS toLHS(Interpreter interpreter) {
        this.evalName = this.value;
        this.evalBaseObject = null;
        if (!Name.isCompound(this.evalName)) {
            return new LHS(this.namespace, this.evalName);
        }
        Object object = null;
        try {
            while (Name.isCompound(this.evalName)) {
                object = this.consumeNextObjectField(interpreter);
            }
        }
        catch (EvalError evalError) {
            Interpreter.debug("LHS evaluation: " + evalError);
            return null;
        }
        if (object == null) {
            throw new InterpreterError("internal error 2893749283");
        }
        if (object instanceof This) {
            Interpreter.debug("found This reference evaluating LHS");
            return new LHS(((This)object).namespace, this.evalName);
        }
        if (this.evalName != null) {
            try {
                return Reflect.getLHSObjectField(object, this.evalName);
            }
            catch (ReflectError reflectError) {
                Interpreter.debug("reflect error:" + reflectError);
                return null;
            }
        }
        Interpreter.debug("very first field was it...");
        Class clazz = this.namespace.getClass(Name.prefix(this.value));
        if (clazz == null) {
            throw new InterpreterError("internal error 238974983");
        }
        String string = Name.suffix(this.value, 1);
        try {
            return Reflect.getLHSStaticField(clazz, string);
        }
        catch (ReflectError reflectError) {
            Interpreter.debug("reflect error:" + reflectError);
            return null;
        }
    }

    public BshMethod toLocalMethod() {
        return this.namespace.getMethod(this.value);
    }

    public Object invokeMethod(Interpreter interpreter, Object[] objectArray) throws EvalError, ReflectError, InvocationTargetException {
        Name name = this;
        if (!Name.isCompound(name.value)) {
            return name.invokeLocalMethod(interpreter, objectArray);
        }
        Name name2 = new Name(name.namespace, Name.prefix(name.value));
        String string = Name.suffix(name.value, 1);
        Object object = name2.toObject(interpreter);
        if (object == Primitive.VOID) {
            throw new EvalError("Method invocation on void: " + name);
        }
        if (!(object instanceof ClassIdentifier)) {
            if (object instanceof Primitive) {
                if (object == Primitive.NULL) {
                    throw new EvalError("Null pointer error...");
                }
                interpreter.error("Attempt to access method on primitive... allowing bsh.Primitive to peek through for debugging");
            }
            return Reflect.invokeObjectMethod(interpreter, object, string, objectArray);
        }
        Interpreter.debug("invokeMethod: trying static - " + name2);
        Class clazz = ((ClassIdentifier)object).getTargetClass();
        if (clazz != null) {
            return Reflect.invokeStaticMethod(clazz, string, objectArray);
        }
        throw new EvalError("unknown target: " + name2);
    }

    public Object invokeLocalMethod(Interpreter interpreter, Object[] objectArray) throws EvalError, ReflectError, InvocationTargetException {
        Interpreter.debug("invoke local method: " + this.value);
        BshMethod bshMethod = this.toLocalMethod();
        if (bshMethod != null) {
            return bshMethod.invokeDeclaredMethod(objectArray, interpreter);
        }
        Interpreter.debug("no locally declared method: " + this.value);
        String string = "commands/" + this.value + ".bsh";
        InputStream inputStream = (class$bsh$Interpreter == null ? (class$bsh$Interpreter = Name.class$("bsh.Interpreter")) : class$bsh$Interpreter).getResourceAsStream(string);
        if (inputStream != null) {
            Interpreter.debug("loading resource: " + string);
            if (interpreter == null) {
                throw new InterpreterError("2234432 interpreter = null");
            }
            interpreter.eval(new InputStreamReader(inputStream), this.namespace, string);
            bshMethod = this.toLocalMethod();
            if (bshMethod != null) {
                return bshMethod.invokeDeclaredMethod(objectArray, interpreter);
            }
            throw new EvalError("Loaded resource: " + string + "had an error or did not contain the correct method");
        }
        string = "bsh.commands." + this.value;
        Class clazz = NameSpace.getAbsoluteClass(string);
        if (clazz == null) {
            throw new EvalError("Command not found: " + this.value);
        }
        Object[] objectArray2 = new Object[objectArray.length + 2];
        objectArray2[0] = interpreter;
        objectArray2[1] = this.namespace;
        System.arraycopy(objectArray, 0, objectArray2, 2, objectArray.length);
        try {
            return Reflect.invokeStaticMethod(clazz, "invoke", objectArray2);
        }
        catch (ReflectError reflectError) {
            Interpreter.debug("invoke command args error:" + reflectError);
            try {
                String string2 = (String)Reflect.invokeStaticMethod(clazz, "usage", null);
                interpreter.println(string2);
                return Primitive.VOID;
            }
            catch (ReflectError reflectError2) {
                Interpreter.debug("usage threw: " + reflectError2);
                throw new EvalError("Wrong number or type of args for command");
            }
        }
    }

    static boolean isCompound(String string) {
        return Name.countParts(string) > 1;
    }

    static int countParts(String string) {
        if (string == null) {
            return 0;
        }
        int n = 0;
        int n2 = -1;
        while ((n2 = string.indexOf(46, n2 + 1)) != -1) {
            ++n;
        }
        return n + 1;
    }

    static String prefix(String string) {
        if (!Name.isCompound(string)) {
            return null;
        }
        return Name.prefix(string, Name.countParts(string) - 1);
    }

    static String prefix(String string, int n) {
        if (n < 1) {
            return null;
        }
        int n2 = 0;
        int n3 = -1;
        while ((n3 = string.indexOf(46, n3 + 1)) != -1 && ++n2 < n) {
        }
        return n3 == -1 ? string : string.substring(0, n3);
    }

    static String suffix(String string) {
        if (!Name.isCompound(string)) {
            return null;
        }
        return Name.suffix(string, Name.countParts(string) - 1);
    }

    public static String suffix(String string, int n) {
        if (n < 1) {
            return null;
        }
        int n2 = 0;
        int n3 = string.length() + 1;
        while ((n3 = string.lastIndexOf(46, n3 - 1)) != -1 && ++n2 < n) {
        }
        return n3 == -1 ? string : string.substring(n3 + 1);
    }

    public String toString() {
        return this.value;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ClassIdentifier {
        Class clas;

        public ClassIdentifier(Class clazz) {
            this.clas = clazz;
        }

        public Class getTargetClass() {
            return this.clas;
        }

        public String toString() {
            return "Class Identifier: " + this.clas.getName();
        }
    }
}

