/*
 * Decompiled with CFR 0.152.
 */
package jde.wizards;

import java.lang.reflect.Method;
import java.util.Hashtable;
import jde.wizards.ClassRegistry;
import jde.wizards.DefaultNameFactory;
import jde.wizards.NameFactory;
import jde.wizards.Signature;

public class MethodFactory
implements ClassRegistry {
    protected Hashtable imports = new Hashtable();
    protected NameFactory namefactory = null;

    public void setNameFactory(NameFactory nameFactory) {
        this.namefactory = nameFactory;
    }

    public NameFactory getNameFactory() {
        return this.namefactory;
    }

    public Hashtable getImports() {
        return this.imports;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerImport(Class clazz) {
        if (clazz.isArray()) {
            try {
                Class<?> clazz2 = clazz;
                while (true) {
                    if (!clazz2.isArray()) {
                        clazz = clazz2;
                        break;
                    }
                    clazz2 = clazz2.getComponentType();
                }
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Caught error walking up an Array object: " + throwable);
            }
        }
        if (this.shouldImport(clazz)) {
            this.imports.put(clazz, "");
        }
    }

    private final boolean shouldImport(Class clazz) {
        if (clazz.isPrimitive()) {
            return false;
        }
        String string = clazz.getName();
        if (string.startsWith("java.lang")) {
            char[] cArray = string.toCharArray();
            int n = 10;
            while (n < cArray.length) {
                if (cArray[n] == '.') {
                    return true;
                }
                ++n;
            }
            return false;
        }
        return true;
    }

    public String getMethodSkeleton(Signature signature, boolean bl, boolean bl2, String string) {
        String string2 = "";
        string2 = string2 + "\n";
        if (bl) {
            string2 = string2 + signature.toJavaDoc() + "\n";
        }
        if (bl2) {
            string2 = string2 + signature + "\n";
            string2 = string2 + "{\n";
        } else {
            string2 = string2 + signature + " {\n";
        }
        string2 = string2 + string;
        Method method = signature.getMethod();
        Class<?> clazz = method.getReturnType();
        if (!clazz.getName().equals("void")) {
            string2 = string2 + "  return null;\n";
        }
        string2 = string2 + "}\n";
        return string2;
    }

    public void flush() {
        this.imports.clear();
    }

    public static void println(String string) {
        System.out.print(string + "\n");
        System.out.flush();
    }

    public MethodFactory() {
        this(new DefaultNameFactory());
    }

    public MethodFactory(NameFactory nameFactory) {
        this.namefactory = nameFactory;
    }
}

