;;; ucs-cjk-radicals.el --- UCS table of KangXi radicals

;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>
;; Keywords: ISO/IEC 10646, Unicode, charset, MULE, KangXi radicals

;; This file is part of XEmacs-UCS.

;; XEmacs-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.

;; XEmacs-UCS is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Commentary:

;; This is not existed in Unicode 2.0.

;;; Code:

(require 'ucs-util)

(ucs-set-char #x2F00 ?$(G'!(B) ; C01-G-2721
(ucs-set-char #x2F01 ?$(G'"(B) ; C01-G-2722
(ucs-set-char #x2F02 ?$(G'#(B) ; C01-G-2723
(ucs-set-char #x2F03 ?$(G'$(B) ; C01-G-2724
(ucs-set-char #x2F04 ?$(G'%(B) ; C01-G-2725
(ucs-set-char #x2F05 ?$(G'&(B) ; C01-G-2726
(ucs-set-char #x2F06 ?$(G''(B) ; C01-G-2727
(ucs-set-char #x2F07 ?$(G'((B) ; C01-G-2728
(ucs-set-char #x2F08 ?$(G')(B) ; C01-G-2729
(ucs-set-char #x2F09 ?$(G'*(B) ; C01-G-272A
(ucs-set-char #x2F0A ?$(G'+(B) ; C01-G-272B
(ucs-set-char #x2F0B ?$(G',(B) ; C01-G-272C
(ucs-set-char #x2F0C ?$(G'-(B) ; C01-G-272D
(ucs-set-char #x2F0D ?$(G'.(B) ; C01-G-272E
(ucs-set-char #x2F0E ?$(G'/(B) ; C01-G-272F
(ucs-set-char #x2F0F ?$(G'0(B) ; C01-G-2730

(ucs-set-char #x2F10 ?$(G'1(B) ; C01-G-2731
(ucs-set-char #x2F11 ?$(G'2(B) ; C01-G-2732
(ucs-set-char #x2F12 ?$(G'3(B) ; C01-G-2733
(ucs-set-char #x2F13 ?$(G'4(B) ; C01-G-2734
(ucs-set-char #x2F14 ?$(G'5(B) ; C01-G-2735
(ucs-set-char #x2F15 ?$(G'6(B) ; C01-G-2736
(ucs-set-char #x2F16 ?$(G'7(B) ; C01-G-2737
(ucs-set-char #x2F17 ?$(G'8(B) ; C01-G-2738
(ucs-set-char #x2F18 ?$(G'9(B) ; C01-G-2739
(ucs-set-char #x2F19 ?$(G':(B) ; C01-G-273A
(ucs-set-char #x2F1A ?$(G';(B) ; C01-G-273B
(ucs-set-char #x2F1B ?$(G'<(B) ; C01-G-273C
(ucs-set-char #x2F1C ?$(G'=(B) ; C01-G-273D
(ucs-set-char #x2F1D ?$(G'>(B) ; C01-G-273E
(ucs-set-char #x2F1E ?$(G'?(B) ; C01-G-273F
(ucs-set-char #x2F1F ?$(G'@(B) ; C01-G-2740
(ucs-set-char #x2F20 ?$(G'A(B) ; C01-G-2741
(set-ucs-char #x2F21 ?$Ab:(B) ; GB0-A-623A

(ucs-set-char #x2F22 ?$(G'B(B) ; C01-G-2742
(ucs-set-char #x2F23 ?$(G'C(B) ; C01-G-2743
(ucs-set-char #x2F24 ?$(G'D(B) ; C01-G-2744
(ucs-set-char #x2F25 ?$(G'E(B) ; C01-G-2745
(ucs-set-char #x2F26 ?$(G'F(B) ; C01-G-2746
(ucs-set-char #x2F27 ?$(G'G(B) ; C01-G-2747
(ucs-set-char #x2F28 ?$(G'H(B) ; C01-G-2748
(ucs-set-char #x2F29 ?$(G'I(B) ; C01-G-2749
(ucs-set-char #x2F2A ?$(G'J(B) ; C01-G-274A
(ucs-set-char #x2F2B ?$(G'K(B) ; C01-G-274B
(ucs-set-char #x2F2C ?$(G'L(B) ; C01-G-274C
(ucs-set-char #x2F2D ?$(G'M(B) ; C01-G-274D
(ucs-set-char #x2F2E ?$(G'N(B) ; C01-G-274E
(ucs-set-char #x2F2F ?$(G'O(B) ; C01-G-274F
(ucs-set-char #x2F30 ?$(G'P(B) ; C01-G-2750
(ucs-set-char #x2F31 ?$(G'Q(B) ; C01-G-2751
(ucs-set-char #x2F32 ?$(G'R(B) ; C01-G-2752
(ucs-set-char #x2F33 ?$(G'S(B) ; C01-G-2753
(ucs-set-char #x2F34 ?$(G'T(B) ; C01-G-2754
(ucs-set-char #x2F35 ?$(G'U(B) ; C01-G-2755
(ucs-set-char #x2F36 ?$(G'V(B) ; C01-G-2756
(ucs-set-char #x2F37 ?$(G'W(B) ; C01-G-2757
(ucs-set-char #x2F38 ?$(G'X(B) ; C01-G-2758
(ucs-set-char #x2F39 ?$(G'Y(B) ; C01-G-2759
(ucs-set-char #x2F3A ?$(G'Z(B) ; C01-G-275A
(ucs-set-char #x2F3B ?$(G'[(B) ; C01-G-275B
(ucs-set-char #x2F3C ?$(G'\(B) ; C01-G-275C
(ucs-set-char #x2F3D ?$(G'](B) ; C01-G-275D
(ucs-set-char #x2F3E ?$(G'^(B) ; C01-G-275E
(ucs-set-char #x2F3F ?$(G'_(B) ; C01-G-275F
(ucs-set-char #x2F40 ?$(G'`(B) ; C01-G-2760
(ucs-set-char #x2F41 ?$(G'a(B) ; C01-G-2761
(ucs-set-char #x2F42 ?$(G'b(B) ; C01-G-2762
(ucs-set-char #x2F43 ?$(G'c(B) ; C01-G-2763
(ucs-set-char #x2F44 ?$(G'd(B) ; C01-G-2764
(ucs-set-char #x2F45 ?$(G'e(B) ; C01-G-2765
(ucs-set-char #x2F46 ?$(G'f(B) ; C01-G-2766
(ucs-set-char #x2F47 ?$(G'g(B) ; C01-G-2767
(ucs-set-char #x2F48 ?$(G'h(B) ; C01-G-2768
(ucs-set-char #x2F49 ?$(G'i(B) ; C01-G-2769
(ucs-set-char #x2F4A ?$(G'j(B) ; C01-G-276A
(ucs-set-char #x2F4B ?$(G'k(B) ; C01-G-276B
(ucs-set-char #x2F4C ?$(G'l(B) ; C01-G-276C
(ucs-set-char #x2F4D ?$(G'm(B) ; C01-G-276D
(ucs-set-char #x2F4E ?$(G'n(B) ; C01-G-276E
(ucs-set-char #x2F4F ?$(G'o(B) ; C01-G-276F
(ucs-set-char #x2F50 ?$(G'p(B) ; C01-G-2770
(ucs-set-char #x2F51 ?$(G'q(B) ; C01-G-2771
(ucs-set-char #x2F52 ?$(G'r(B) ; C01-G-2772
(ucs-set-char #x2F53 ?$(G's(B) ; C01-G-2773
(ucs-set-char #x2F54 ?$(G't(B) ; C01-G-2774
(ucs-set-char #x2F55 ?$(G'u(B) ; C01-G-2775
(ucs-set-char #x2F56 ?$(G'v(B) ; C01-G-2776
(ucs-set-char #x2F57 ?$(G'w(B) ; C01-G-2777
(ucs-set-char #x2F58 ?$(G'x(B) ; C01-G-2778
(ucs-set-char #x2F59 ?$(G'y(B) ; C01-G-2779
(ucs-set-char #x2F5A ?$(G'z(B) ; C01-G-277A
(ucs-set-char #x2F5B ?$(G'{(B) ; C01-G-277B
(ucs-set-char #x2F5C ?$(G'|(B) ; C01-G-277C
(ucs-set-char #x2F5D ?$(G'}(B) ; C01-G-277D
(ucs-set-char #x2F5E ?$(G'~(B) ; C01-G-277E
(ucs-set-char #x2F5F ?$(G(!(B) ; C01-G-2821
(ucs-set-char #x2F60 ?$(G("(B) ; C01-G-2822
(ucs-set-char #x2F61 ?$(G(#(B) ; C01-G-2823
(ucs-set-char #x2F62 ?$(G($(B) ; C01-G-2824
(ucs-set-char #x2F63 ?$(G(%(B) ; C01-G-2825
(ucs-set-char #x2F64 ?$(G(&(B) ; C01-G-2826
(ucs-set-char #x2F65 ?$(G('(B) ; C01-G-2827
(ucs-set-char #x2F66 ?$(G(((B) ; C01-G-2828
(ucs-set-char #x2F67 ?$(G()(B) ; C01-G-2829
(ucs-set-char #x2F68 ?$(G(*(B) ; C01-G-282A
(ucs-set-char #x2F69 ?$(G(+(B) ; C01-G-282B
(ucs-set-char #x2F6A ?$(G(,(B) ; C01-G-282C
(ucs-set-char #x2F6B ?$(G(-(B) ; C01-G-282D
(ucs-set-char #x2F6C ?$(G(.(B) ; C01-G-282E
(ucs-set-char #x2F6D ?$(G(/(B) ; C01-G-282F
(ucs-set-char #x2F6E ?$(G(0(B) ; C01-G-2830
(ucs-set-char #x2F6F ?$(G(1(B) ; C01-G-2831
(ucs-set-char #x2F70 ?$(G(2(B) ; C01-G-2832
(ucs-set-char #x2F71 ?$(G(3(B) ; C01-G-2833
(ucs-set-char #x2F72 ?$(G(4(B) ; C01-G-2834
(ucs-set-char #x2F73 ?$(G(5(B) ; C01-G-2835
(ucs-set-char #x2F74 ?$(G(6(B) ; C01-G-2836
(ucs-set-char #x2F75 ?$(G(7(B) ; C01-G-2837
(ucs-set-char #x2F76 ?$(G(8(B) ; C01-G-2838
(ucs-set-char #x2F77 ?$(G(9(B) ; C01-G-2839
(ucs-set-char #x2F78 ?$(G(:(B) ; C01-G-283A
(ucs-set-char #x2F79 ?$(G(;(B) ; C01-G-283B
(ucs-set-char #x2F7A ?$(G(<(B) ; C01-G-283C
(ucs-set-char #x2F7B ?$(G(=(B) ; C01-G-283D
(ucs-set-char #x2F7C ?$(G(>(B) ; C01-G-283E
(ucs-set-char #x2F7D ?$(G(?(B) ; C01-G-283F
(ucs-set-char #x2F7E ?$(G(@(B) ; C01-G-2840
(ucs-set-char #x2F7F ?$(G(A(B) ; C01-G-2841
(ucs-set-char #x2F80 ?$(G(B(B) ; C01-G-2842
(ucs-set-char #x2F81 ?$(G(C(B) ; C01-G-2843
(ucs-set-char #x2F82 ?$(G(D(B) ; C01-G-2844
(ucs-set-char #x2F83 ?$(G(E(B) ; C01-G-2845
(ucs-set-char #x2F84 ?$(G(F(B) ; C01-G-2846
(ucs-set-char #x2F85 ?$(G(G(B) ; C01-G-2847
(ucs-set-char #x2F86 ?$(G(H(B) ; C01-G-2848
(ucs-set-char #x2F87 ?$(G(I(B) ; C01-G-2849
(ucs-set-char #x2F88 ?$(G(J(B) ; C01-G-284A
(ucs-set-char #x2F89 ?$(G(K(B) ; C01-G-284B
(ucs-set-char #x2F8A ?$(G(L(B) ; C01-G-284C
(ucs-set-char #x2F8B ?$(G(M(B) ; C01-G-284D
(ucs-set-char #x2F8C ?$(G(N(B) ; C01-G-284E
(ucs-set-char #x2F8D ?$(G(O(B) ; C01-G-284F
(ucs-set-char #x2F8E ?$(G(P(B) ; C01-G-2850
(ucs-set-char #x2F8F ?$(G(Q(B) ; C01-G-2851
(ucs-set-char #x2F90 ?$(G(R(B) ; C01-G-2852
(ucs-set-char #x2F91 ?$(G(S(B) ; C01-G-2853
(ucs-set-char #x2F92 ?$(G(T(B) ; C01-G-2854
(ucs-set-char #x2F93 ?$(G(U(B) ; C01-G-2855
(ucs-set-char #x2F94 ?$(G(V(B) ; C01-G-2856
(ucs-set-char #x2F95 ?$(G(W(B) ; C01-G-2857
(ucs-set-char #x2F96 ?$(G(X(B) ; C01-G-2858
(ucs-set-char #x2F97 ?$(G(Y(B) ; C01-G-2859
(ucs-set-char #x2F98 ?$(G(Z(B) ; C01-G-285A
(ucs-set-char #x2F99 ?$(G([(B) ; C01-G-285B
(ucs-set-char #x2F9A ?$(G(\(B) ; C01-G-285C
(ucs-set-char #x2F9B ?$(G(](B) ; C01-G-285D
(ucs-set-char #x2F9C ?$(G(^(B) ; C01-G-285E
(ucs-set-char #x2F9D ?$(G(_(B) ; C01-G-285F
(ucs-set-char #x2F9E ?$(G(`(B) ; C01-G-2860
(ucs-set-char #x2F9F ?$(G(a(B) ; C01-G-2861
(ucs-set-char #x2FA0 ?$(G(b(B) ; C01-G-2862
(ucs-set-char #x2FA1 ?$(G(c(B) ; C01-G-2863
(ucs-set-char #x2FA2 ?$(G(d(B) ; C01-G-2864
(ucs-set-char #x2FA3 ?$(G(e(B) ; C01-G-2865
(ucs-set-char #x2FA4 ?$(G(f(B) ; C01-G-2866
(ucs-set-char #x2FA5 ?$(G(g(B) ; C01-G-2867
(ucs-set-char #x2FA6 ?$(G(h(B) ; C01-G-2868
(ucs-set-char #x2FA7 ?$(G(i(B) ; C01-G-2869
(ucs-set-char #x2FA8 ?$(G(j(B) ; C01-G-286A
(ucs-set-char #x2FA9 ?$(G(k(B) ; C01-G-286B
(ucs-set-char #x2FAA ?$(G(l(B) ; C01-G-286C
(ucs-set-char #x2FAB ?$(G(m(B) ; C01-G-286D
(ucs-set-char #x2FAC ?$(G(n(B) ; C01-G-286E
(ucs-set-char #x2FAD ?$(G(o(B) ; C01-G-286F
(ucs-set-char #x2FAE ?$(G(p(B) ; C01-G-2870
(ucs-set-char #x2FAF ?$(G(q(B) ; C01-G-2871
(ucs-set-char #x2FB0 ?$(G(r(B) ; C01-G-2872
(ucs-set-char #x2FB1 ?$(G(s(B) ; C01-G-2873
(ucs-set-char #x2FB2 ?$(G(t(B) ; C01-G-2874
(ucs-set-char #x2FB3 ?$(G(u(B) ; C01-G-2875
(ucs-set-char #x2FB4 ?$(G(v(B) ; C01-G-2876
(ucs-set-char #x2FB5 ?$(G(w(B) ; C01-G-2877
(ucs-set-char #x2FB6 ?$(G(x(B) ; C01-G-2878
(ucs-set-char #x2FB7 ?$(G(y(B) ; C01-G-2879
(ucs-set-char #x2FB8 ?$(G(z(B) ; C01-G-287A
(ucs-set-char #x2FB9 ?$(G({(B) ; C01-G-287B
(ucs-set-char #x2FBA ?$(G(|(B) ; C01-G-287C
(ucs-set-char #x2FBB ?$(G(}(B) ; C01-G-287D
(ucs-set-char #x2FBC ?$(G(~(B) ; C01-G-287E
(ucs-set-char #x2FBD ?$(G)!(B) ; C01-G-2921
(ucs-set-char #x2FBE ?$(G)"(B) ; C01-G-2922
(ucs-set-char #x2FBF ?$(G)#(B) ; C01-G-2923
(ucs-set-char #x2FC0 ?$(G)$(B) ; C01-G-2924
(ucs-set-char #x2FC1 ?$(G)%(B) ; C01-G-2925
(ucs-set-char #x2FC2 ?$(G)&(B) ; C01-G-2926
(ucs-set-char #x2FC3 ?$(G)'(B) ; C01-G-2927
(ucs-set-char #x2FC4 ?$(G)((B) ; C01-G-2928
(ucs-set-char #x2FC5 ?$(G))(B) ; C01-G-2929
(ucs-set-char #x2FC6 ?$(G)*(B) ; C01-G-292A
(ucs-set-char #x2FC7 ?$(G)+(B) ; C01-G-292B
(ucs-set-char #x2FC8 ?$(G),(B) ; C01-G-292C
(ucs-set-char #x2FC9 ?$(G)-(B) ; C01-G-292D
(ucs-set-char #x2FCA ?$(G).(B) ; C01-G-292E
(ucs-set-char #x2FCB ?$(G)/(B) ; C01-G-292F
(ucs-set-char #x2FCC ?$(G)0(B) ; C01-G-2930
(ucs-set-char #x2FCD ?$(G)1(B) ; C01-G-2931
(ucs-set-char #x2FCE ?$(G)2(B) ; C01-G-2932
(ucs-set-char #x2FCF ?$(G)3(B) ; C01-G-2933
(ucs-set-char #x2FD0 ?$(G)4(B) ; C01-G-2934
(ucs-set-char #x2FD1 ?$(G)5(B) ; C01-G-2935
(ucs-set-char #x2FD2 ?$(G)6(B) ; C01-G-2936
(ucs-set-char #x2FD3 ?$(G)7(B) ; C01-G-2937
(ucs-set-char #x2FD4 ?$(G)8(B) ; C01-G-2938
(ucs-set-char #x2FD5 ?$(G)9(B) ; C01-G-2939

;;; ucs-cjk-radicals.el ends here
