;;; loaddefs.el --- define standard autoloads of other files

;; Copyright (C) 1985, 1986, 1987, 1992, 1993 Free Software Foundation, Inc.

;; Maintainer: FSF
;; Keywords: internal

;; This file is part of GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Commentary:

;;; !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;;; Special formatting conventions are used in this file!
;;;
;;; a backslash-newline is used at the beginning of a documentation string
;;; when that string should be stored in the file etc/DOCnnn, not in core.
;;;
;;; Such strings read into Lisp as numbers (during the pure-loading phase).
;;;
;;; But you must obey certain rules to make sure the string is understood
;;; and goes into etc/DOCnnn properly.  Otherwise, the string will not go
;;; anywhere!
;;;
;;; The doc string must appear in the standard place in a call to
;;; defun, autoload, defvar or defconst.  No Lisp macros are recognized.
;;; The open-paren starting the definition must appear in column 0.
;;;
;;; In defvar and defconst, there is an additional rule:
;;; The double-quote that starts the string must be on the same
;;; line as the defvar or defconst.
;;; !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

;;; **********************************************************************
;;; You should never need to write autoloads by hand and put them here.
;;;
;;; It is no longer necessary.  Instead use autoload.el to maintain them
;;; for you.  Just insert ";;;###autoload" before defuns or defmacros you
;;; want to be autoloaded, or other forms you want copied into loaddefs.el
;;; (defvars, key definitions, etc.).  For example, 
;;;	;;;###autoload
;;;	(defun foobar () ....)
;;;	;;;###autoload (define-key global-map "f" 'foobar)
;;;	;;;###autoload
;;;	(defvar foobar-var nil "\
;;;	This is foobar-var's doc-string.")
;;;
;;; Then do M-x update-file-autoloads on the file to update loaddefs.el.
;;;
;;; You can also use M-x update-directory-autoloads to update the autoloads
;;; in loaddefs.el for all .el files in the lisp/ directory, or M-x
;;; update-autoloads-here to update the autoloads for each file that
;;; already has an autoload section in this file.
;;; **********************************************************************

;;; Code:

;;; This code was NOT generated by autoload.el.

(defconst mode-line-buffer-identification (purecopy '("Emacs: %17b")) "\
Mode-line control for identifying the buffer being displayed.
Its default value is \"Emacs: %17b\".  Major modes that edit things
other than ordinary files may change this (e.g. Info, Dired,...)")

(make-variable-buffer-local 'mode-line-buffer-identification)

(defconst mode-line-process nil "\
Mode-line control for displaying info on process status.
Normally nil in most modes, since there is no process to display.")

(make-variable-buffer-local 'mode-line-process)

(defconst mode-line-modified (purecopy '("--%1*%1*-")) "\
Mode-line control for displaying whether current buffer is modified.")

(make-variable-buffer-local 'mode-line-modified)

(setq-default mode-line-format
  (list (purecopy "")
   'mode-line-modified
   'mode-line-buffer-identification
   (purecopy "   ")
   'global-mode-string
   (purecopy "   %[(")
   'mode-name 'minor-mode-alist "%n" 'mode-line-process
   (purecopy ")%]----")
   (purecopy '(line-number-mode "L%l--"))
   (purecopy '(-3 . "%p"))
   (purecopy "-%-")))

(defvar minor-mode-alist nil "\
Alist saying how to show minor modes in the mode line.
Each element looks like (VARIABLE STRING);
STRING is included in the mode line iff VARIABLE's value is non-nil.

Actually, STRING need not be a string; any possible mode-line element
is okay.  See `mode-line-format'.")
(setq minor-mode-alist (mapcar 'purecopy
			       '((abbrev-mode " Abbrev")
				 (overwrite-mode overwrite-mode)
				 (auto-fill-function " Fill")
				 ;; not really a minor mode...
				 (defining-kbd-macro " Def"))))

;; These variables are used by autoloadable packages.
;; They are defined here so that they do not get overridden
;; by the loading of those packages.

;; Names in directory that end in one of these
;; are ignored in completion,
;; making it more likely you will get a unique match.
(setq completion-ignored-extensions
      (mapcar 'purecopy
	      (if (eq system-type 'vax-vms)
		  '(".obj" ".elc" ".exe" ".bin" ".lbin" ".sbin"
		    ".dvi" ".toc" ".log" ".aux"
		    ".lof" ".brn" ".rnt" ".mem" ".lni" ".lis"
		    ".olb" ".tlb" ".mlb" ".hlb" ".glo" ".idx" ".lot" ".fmt")
		'(".o" ".elc" "~" ".bin" ".lbin" ".fasl"
		  ".dvi" ".toc" ".log" ".aux" ".a" ".ln"
		  ".lof" ".blg" ".bbl" ".glo" ".idx" ".lot" ".fmt"
		  ".diff" ".oi"))))

(make-variable-buffer-local 'indent-tabs-mode)

;;; This code also was not generated by autoload.el, because VM goes out
;;; of its way to be perverse.

(autoload 'vm "vm"
   "\
View Mail: an alternate mail reader for emacs.
Optional first arg FOLDER specifies the folder to visit.  It defaults
to the value of vm-primary-inbox.  The folder buffer is put into VM
mode, a major mode for reading mail.

Prefix arg or optional second arg READ-ONLY non-nil indicates
that the folder should be considered read only.  No attribute
changes, messages additions or deletions will be allowed in the
visited folder.

Visiting the primary inbox causes any contents of the system mailbox to
be moved and appended to the resulting buffer.

All the messages can be read by repeatedly pressing SPC.  Use `n'ext and
`p'revious to move about in the folder.  Messages are marked for
deletion with `d', and saved to another folder with `s'.  Quitting VM
with `q' expunges deleted messages and saves the buffered folder to
disk.

See the documentation for vm-mode for more information."
 t)

(autoload 'vm-mode "vm" 
  "\
View Mail: an alternate mail reader for emacs.

Commands:
   h - summarize folder contents
   j - discard cached information about the current message

   n - go to next message
   p - go to previous message
   N - like `n' but ignores skip-variable settings
   P - like `p' but ignores skip-variable settings
 M-n - go to next unread message
 M-p - go to previous unread message
 RET - go to numbered message (uses prefix arg or prompts in minibuffer)
 TAB - go to last message seen
 M-s - incremental search through the folder

   t - display hidden headers
 SPC - scroll forward a page (if at end of message, then display next message)
   b - scroll backward a page
   < - go to beginning of current message
   > - go to end of current message

   d - delete message, prefix arg deletes messages forward (flag as deleted)
 C-d - delete message, prefix arg deletes messages backward (flag as deleted)
   u - undelete
   k - flag for deletion all messages with same subject as the current message

   r - reply (only to the sender of the message)
   R - reply with included text for current message
 M-r - extract and resend bounced message
   f - followup (reply to all recipients of message)
   F - followup with included text from the current message
   z - forward the current message
   m - send a message
   B - resend the current message to another user.
   c - continue composing the most recent message you were composing

   @ - digestify and mail entire folder contents (the folder is not modified)
   * - burst a digest into individual messages, and append and assimilate these
       message into the current folder.

   G - sort messages by various keys

   g - get any new mail that has arrived in the system mailbox
       (new mail is appended to the disk and buffer copies of the
       primary inbox.)
   v - visit another mail folder
   V - visit a virtual folder

   e - edit the current message

   s - save current message in a folder (appends if folder already exists)
   w - write current message to a file without its headers (appends if exists)
   S - save entire folder to disk, expunging deleted messages
   A - save unfiled messages to their vm-auto-folder-alist specified folders
   # - expunge deleted messages (without saving folder)
   q - quit VM, deleted messages are expunged, folder saved to disk
   x - exit VM with no change to the folder

 M N - use marks; the next vm command will affect only marked messages
       if it makes sense for the command to do so

       M M - mark the current message
       M U - unmark the current message
       M m - mark all messages
       M u - unmark all messages
       M ? - help for the mark commands

 W S - save the current window configuration to a name
 W D - delete a window configuration
 W W - apply a configuration
 W ? - help for the window configuration commands

 C-_ - undo, special undo that retracts the most recent
             changes in message attributes.  Expunges and saves
             cannot be undone.  C-x u is also bound to this
             command.

   L - reload your VM init file, ~/.vm

   ? - help

   ! - run a shell command
   | - run a shell command with the current message as input

 M-C - view conditions under which you may redistribute VM
 M-W - view the details of VM's lack of a warranty

Variables:
   vm-auto-center-summary
   vm-auto-folder-alist
   vm-auto-folder-case-fold-search
   vm-auto-get-new-mail
   vm-auto-next-message
   vm-berkeley-mail-compatibility
   vm-check-folder-types
   vm-convert-folder-types
   vm-circular-folders
   vm-confirm-new-folders
   vm-confirm-quit
   vm-crash-box
   vm-delete-after-archiving
   vm-delete-after-bursting
   vm-delete-after-saving
   vm-delete-empty-folders
   vm-digest-burst-type
   vm-digest-center-preamble
   vm-digest-preamble-format
   vm-digest-send-type
   vm-folder-directory
   vm-folder-read-only
   vm-follow-summary-cursor
   vm-forwarded-headers
   vm-forwarding-digest-type
   vm-forwarding-subject-format
   vm-gargle-uucp
   vm-highlighted-header-regexp
   vm-honor-page-delimiters
   vm-in-reply-to-format
   vm-included-text-attribution-format
   vm-included-text-prefix
   vm-inhibit-startup-message
   vm-invisible-header-regexp
   vm-jump-to-new-messages
   vm-jump-to-unread-messages
   vm-keep-sent-messages
   vm-mail-header-from
   vm-mail-mode-hook
   vm-mail-window-percentage
   vm-mode-hook
   vm-move-after-deleting
   vm-move-after-undeleting
   vm-mutable-windows
   vm-preview-lines
   vm-preview-read-messages
   vm-primary-inbox
   vm-recognize-pop-maildrops
   vm-reply-ignored-addresses
   vm-reply-subject-prefix
   vm-resend-bounced-headers
   vm-resend-bounced-discard-header-regexp
   vm-resend-headers
   vm-resend-discard-header-regexp
   vm-retain-message-order
   vm-rfc1153-digest-discard-header-regexp
   vm-rfc1153-digest-headers
   vm-rfc934-digest-discard-header-regexp
   vm-rfc934-digest-headers
   vm-search-using-regexps
   vm-skip-deleted-messages
   vm-skip-read-messages
   vm-spool-files
   vm-startup-with-summary
   vm-strip-reply-headers
   vm-summary-format
   vm-unforwarded-header-regexp
   vm-virtual-folder-alist
   vm-virtual-mirror
   vm-visible-headers
   vm-visit-when-saving
   vm-window-configuration-file
"
 t)

(autoload 'vm-visit-folder "vm" 
  "\
Visit a mail file with View Mail, an alternate mail reader for emacs.
See the description of the `vm' and `vm-mode' functions.

VM will parse and present its messages to you in the usual way.

First arg FOLDER specifies the mail file to visit.  When this
command is called interactively the file name is read from the
minibuffer.

Prefix arg or optional second arg READ-ONLY non-nil indicates
that the folder should be considered read only.  No attribute
changes, messages additions or deletions will be allowed in the
visited folder."
  t)

(autoload 'vm-mail "vm"
  "\
Send a mail message from within View Mail, or from without."
  t)



;;; Generated autoloads follow (made by autoload.el).

;;; To sort them, execute the following after narrowing
;;; to a region starting just after the following formfeed (control-l)
;;; and ending just after the last formfeed in the file.

;;;(sort-regexp-fields nil "\n*.*\n.*from \\(.*\\)[^]*" "\\1"
;;;		    (point-min) (point-max))

;;;### (autoloads (batch-byte-recompile-directory batch-byte-compile byte-compile-sexp byte-compile compile-defun byte-compile-buffer byte-compile-and-load-file byte-compile-file byte-recompile-directory) "bytecomp" "bytecomp/bytecomp.el" (11562 15311))
;;; Generated autoloads from bytecomp/bytecomp.el

(autoload 'byte-recompile-directory "bytecomp" "\
Recompile every `.el' file in DIRECTORY that needs recompilation.
This is if a `.elc' file exists but is older than the `.el' file.

If the `.elc' file does not exist, normally the `.el' file is *not* compiled.
But a prefix argument (optional second arg) means ask user,
for each such `.el' file, whether to compile it.  Prefix argument 0 means
don't ask and compile the file anyway." t nil)

(autoload 'byte-compile-file "bytecomp" "\
Compile a file of Lisp code named FILENAME into a file of byte code.
The output file's name is made by appending `c' to the end of FILENAME.
With prefix arg (noninteractively: 2nd arg), load the file after compiling." t nil)

(autoload 'byte-compile-and-load-file "bytecomp" "\
Compile a file of Lisp code named FILENAME into a file of byte code,
and then load it.  The output file's name is made by appending \"c\" to 
the end of FILENAME." t nil)

(autoload 'byte-compile-buffer "bytecomp" "\
Byte-compile and evaluate contents of BUFFER (default: the current buffer)." t nil)

(autoload 'compile-defun "bytecomp" "\
Compile and evaluate the current top-level form.
Print the result in the minibuffer.
With argument, insert value in current buffer after the form." t nil)

(autoload 'byte-compile "bytecomp" "\
If FORM is a symbol, byte-compile its function definition.
If FORM is a lambda or a macro, byte-compile it as a function." nil nil)

(autoload 'byte-compile-sexp "bytecomp" "\
Compile and return SEXP." nil nil)

(autoload 'batch-byte-compile "bytecomp" "\
Run `byte-compile-file' on the files remaining on the command line.
Use this from the command line, with `-batch';
it won't work in an interactive Emacs.
Each file is processed even if an error occurred previously.
For example, invoke \"emacs -batch -f batch-byte-compile $emacs/ ~/*.el\"" nil nil)

(autoload 'batch-byte-recompile-directory "bytecomp" "\
Runs `byte-recompile-directory' on the dirs remaining on the command line.
Must be used only with -batch, and kills emacs on completion.
For example, invoke \"emacs -batch -f batch-byte-recompile-directory .\"" nil nil)

;;;***

;;;### (autoloads (disassemble) "disass" "bytecomp/disass.el" (11555 56278))
;;; Generated autoloads from bytecomp/disass.el

(autoload 'disassemble "disass" "\
Print disassembled code for OBJECT in (optional) BUFFER.
OBJECT can be a symbol defined as a function, or a function itself
\(a lambda expression or a compiled-function object).
If OBJECT is not already compiled, we compile it, but do not
redefine OBJECT if it is a symbol." t nil)

;;;***

;;;### (autoloads (list-yahrzeit-dates calendar) "calendar" "calendar/calendar.el" (11560 51105))
;;; Generated autoloads from calendar/calendar.el

(autoload 'calendar "calendar" "\
Display a three-month calendar in another window.
The three months appear side by side, with the current month in the middle
surrounded by the previous and next months.  The cursor is put on today's date.

If called with an optional prefix argument, prompts for month and year.

This function is suitable for execution in a .emacs file; appropriate setting
of the variable `view-diary-entries-initially' will cause the diary entries for
the current date to be displayed in another window.  The value of the variable
`number-of-diary-entries' controls the number of days of diary entries
displayed upon initial display of the calendar.

An optional prefix argument ARG causes the calendar displayed to be ARG
months in the future if ARG is positive or in the past if ARG is negative;
in this case the cursor goes on the first day of the month.

Once in the calendar window, future or past months can be moved into view.
Arbitrary months can be displayed, or the calendar can be scrolled forward
or backward.

The cursor can be moved forward or backward by one day, one week, one month,
or one year.  All of these commands take prefix arguments which, when negative,
cause movement in the opposite direction.  For convenience, the digit keys
and the minus sign are automatically prefixes.  The window is replotted as
necessary to display the desired date.

Diary entries can be marked on the calendar or displayed in another window.

Use M-x describe-mode for details of the key bindings in the calendar window.

The Gregorian calendar is assumed.

After loading the calendar, the hooks given by the variable
`calendar-load-hook' are run.  This the place to add key bindings to the
calendar-mode-map.

After preparing the calendar window initially, the hooks given by the variable
`initial-calendar-window-hook' are run.

The hooks given by the variable `today-visible-calendar-hook' are run
everytime the calendar window gets scrolled, if the current date is visible
in the window.  If it is not visible, the hooks given by the variable
`today-invisible-calendar-hook' are run.  Thus, for example, setting
`today-visible-calendar-hook' to 'calendar-star-date will cause today's date
to be replaced by asterisks to highlight it whenever it is in the window." t nil)

(autoload 'list-yahrzeit-dates "calendar" "\
List Yahrzeit dates for *Gregorian* DEATH-DATE from START-YEAR to END-YEAR.
When called interactively from the calendar window, the date of death is taken
from the cursor position." t nil)

;;;***

;;;### (autoloads (diary) "diary" "calendar/diary.el" (11558 42255))
;;; Generated autoloads from calendar/diary.el

(autoload 'diary "diary" "\
Generate the diary window for ARG days starting with the current date.
If no argument is provided, the number of days of diary entries is governed
by the variable `number-of-diary-entries'.  This function is suitable for
execution in a `.emacs' file." t nil)

;;;***

;;;### (autoloads (holidays) "holidays" "calendar/holidays.el" (11558 42258))
;;; Generated autoloads from calendar/holidays.el

(autoload 'holidays "holidays" "\
Display the holidays for last month, this month, and next month.
If called with an optional prefix argument, prompts for month and year.

This function is suitable for execution in a .emacs file." t nil)

;;;***

;;;### (autoloads (phases-of-moon) "lunar" "calendar/lunar.el" (11558 42259))
;;; Generated autoloads from calendar/lunar.el

(autoload 'phases-of-moon "lunar" "\
Display the quarters of the moon for last month, this month, and next month.
If called with an optional prefix argument, prompts for month and year.

This function is suitable for execution in a .emacs file." t nil)

;;;***

;;;### (autoloads (solar-equinoxes-solstices sunrise-sunset) "solar" "calendar/solar.el" (11560 51109))
;;; Generated autoloads from calendar/solar.el

(defvar calendar-latitude nil "\
*Latitude of `calendar-location-name' in degrees, + north, - south.
For example, 40.7 for New York City.
It may not be a good idea to set this in advance for your site;
if there may be users running Emacs at your site
who are physically located elsewhere, they would get the wrong
value and might not know how to override it.")

(defvar calendar-longitude nil "\
*Longitude of `calendar-location-name' in degrees, + east, - west.
For example, -74.0 for New York City.
It may not be a good idea to set this in advance for your site;
if there may be users running Emacs at your site
who are physically located elsewhere, they would get the wrong
value and might not know how to override it.")

(autoload 'sunrise-sunset "solar" "\
Local time of sunrise and sunset for today.  Accurate to +/- 2 minutes.
If called with an optional prefix argument, prompts for date.

If called with an optional double prefix argument, prompts for longitude,
latitude, time zone, and date.

This function is suitable for execution in a .emacs file." t nil)

(autoload 'solar-equinoxes-solstices "solar" "\
Date and time of equinoxes and solstices, if visible in the calendar window.
Requires floating point." nil nil)

;;;***

;;;### (autoloads (comint-dynamic-list-completions comint-dynamic-complete make-comint) "comint" "comint/comint.el" (11563 43215))
;;; Generated autoloads from comint/comint.el

(autoload 'make-comint "comint" "\
Make a comint process NAME in a buffer, running PROGRAM.
The name of the buffer is made by surrounding NAME with `*'s.
If there is already a running process in that buffer, it is not restarted.
Optional third arg STARTFILE is the name of a file to send the contents of to 
the process.  Any more args are arguments to PROGRAM." nil nil)

(autoload 'comint-dynamic-complete "comint" "\
Dynamically complete/expand the command/filename/history at point.
If the text contains (a non-absolute line reference) `!' or `^' and
`comint-input-autoexpand' is non-nil, then an attempt is made to complete the
history.  The value of the variable `comint-after-partial-filename-command' is
used to match file names.  Otherwise, an attempt is made to complete the
command.

See also the variables `comint-after-partial-filename-command',
`comint-dynamic-complete-filename-command', and
`comint-dynamic-complete-command-command', and functions
`comint-replace-by-expanded-history' and `comint-magic-space'." t nil)

(autoload 'comint-dynamic-list-completions "comint" "\
List in help buffer sorted COMPLETIONS.
Typing SPC flushes the help buffer." nil nil)

;;;***

;;;### (autoloads (gdb) "gdb" "comint/gdb.el" (11566 22696))
;;; Generated autoloads from comint/gdb.el

(defvar gdb-command-name "gdb" "\
Pathname for executing gdb.")

(autoload 'gdb "gdb" "\
Run gdb on program FILE in buffer *gdb-FILE*.
The directory containing FILE becomes the initial working directory
and source-file directory for GDB.  If you wish to change this, use
the GDB commands `cd DIR' and `directory'." t nil)

;;;***

;;;### (autoloads (shell) "shell" "comint/shell.el" (11563 43230))
;;; Generated autoloads from comint/shell.el

(defvar shell-prompt-pattern (purecopy "^[^#$%>\n]*[#$%>] *") "\
Regexp to match prompts in the inferior shell.
Defaults to \"^[^#$%>\\n]*[#$%>] *\", which works pretty well.
This variable is used to initialise `comint-prompt-regexp' in the
shell buffer.

The pattern should probably not match more than one line.  If it does,
shell-mode may become confused trying to distinguish prompt from input
on lines which don't start with a prompt.

This is a fine thing to set in your `.emacs' file.")

(autoload 'shell "shell" "\
Run an inferior shell, with I/O through buffer *shell*.
If buffer exists but shell process is not running, make new shell.
If buffer exists and shell process is running, 
 just switch to buffer `*shell*'.
Program used comes from variable `explicit-shell-file-name',
 or (if that is nil) from the ESHELL environment variable,
 or else from SHELL if there is no ESHELL.
If a file `~/.emacs_SHELLNAME' exists, it is given as initial input
 (Note that this may lose due to a timing error if the shell
  discards input when it starts up.)
The buffer is put in Shell mode, giving commands for sending input
and controlling the subjobs of the shell.  See `shell-mode'.
See also the variable `shell-prompt-pattern'.

The shell file name (sans directories) is used to make a symbol name
such as `explicit-csh-args'.  If that symbol is a variable,
its value is used as a list of arguments when invoking the shell.
Otherwise, one argument `-i' is passed to the shell.

\(Type \\[describe-mode] in the shell buffer for a list of commands.)" t nil)

;;;***

;;;### (autoloads (rsh telnet) "telnet" "comint/telnet.el" (11566 22719))
;;; Generated autoloads from comint/telnet.el

(autoload 'telnet "telnet" "\
Open a network login connection to host named HOST (a string).
With a prefix argument, prompts for the port name or number as well.
Communication with HOST is recorded in a buffer *HOST-telnet*.
Normally input is edited in Emacs and sent a line at a time.
See also `\\[rsh]'." t nil)

(autoload 'rsh "telnet" "\
Open a network login connection to host named HOST (a string).
Communication with HOST is recorded in a buffer *HOST-rsh*.
Normally input is edited in Emacs and sent a line at a time.
See also `\\[telnet]'." t nil)

;;;***

;;;### (autoloads (dired-cwd-make-magic) "dired-cwd" "dired/dired-cwd.el" (11352 15644))
;;; Generated autoloads from dired/dired-cwd.el

(autoload 'dired-cwd-make-magic "dired-cwd" "\
Modify COMMAND so that it's working directory is the current dired directory.
This works by binding `default-directory' to `(default-directory)'s value.
See also function `default-directory'." t nil)

;;;***

;;;### (autoloads (dired-do-rename-list dired-do-rename-numeric) "dired-num" "dired/dired-num.el" (11352 15647))
;;; Generated autoloads from dired/dired-num.el

(autoload 'dired-do-rename-numeric "dired-num" "\
Rename all marked (or next ARG) files using numbers.
You are prompted for a format string, e.g \"part_%d_of_8\", and a starting
number, e.g. 1.  If there are 8 marked files, this example will rename them to

    part_1_of_8
    part_2_of_8
    ...
    part_8_of_8" t nil)

(autoload 'dired-do-rename-list "dired-num" "\
Rename all marked (or next ARG) files using elements from LIST.
You are prompted for a format string, e.g \"x_%s\", and the list,
e.g. '(foo bar zod).  This example will rename the marked files to

    x_foo
    x_bar
    x_zod

It is an error if LIST has not as many elements as there are files." t nil)

;;;***

;;;### (autoloads (dired-rcs-mark-rcs-files dired-rcs-mark-rcs-locked-files) "dired-rcs" "dired/dired-rcs.el" (11352 15648))
;;; Generated autoloads from dired/dired-rcs.el

(autoload 'dired-rcs-mark-rcs-locked-files "dired-rcs" "\
Mark all files that are under RCS control and RCS-locked.
With prefix argument, unflag all those files.
Mentions RCS files for which a working file was not found in this buffer.
Type \\[dired-why] to see them again." t nil)

(autoload 'dired-rcs-mark-rcs-files "dired-rcs" "\
Mark all files that are under RCS control.
With prefix argument, unflag all those files.
Mentions RCS files for which a working file was not found in this buffer.
Type \\[dired-why] to see them again." t nil)

;;;***

;;;### (autoloads (dired-noselect dired-other-window dired) "dired" "dired/dired.el" (11555 56747))
;;; Generated autoloads from dired/dired.el

(defvar dired-listing-switches (purecopy "-al") "\
*Switches passed to ls for dired. MUST contain the `l' option.
Can contain even `F', `b', `i' and `s'.")

(defvar dired-chown-program (purecopy (if (memq system-type '(dgux-unix hpux usg-unix-v silicon-graphics-unix)) "chown" "/etc/chown")) "\
*Name of chown command (usully `chown' or `/etc/chown').")

(defvar dired-ls-program (purecopy "ls") "\
*Absolute or relative name of the ls program used by dired.")

(defvar dired-ls-F-marks-symlinks t "\
*Informs dired about how ls -lF marks symbolic links.
Set this to t if `dired-ls-program' with -lF marks the symbolic link
itself with a trailing @ (usually the case under Ultrix).

Example: if `ln -s foo bar; ls -F bar' gives `bar -> foo', set it to
nil, if it gives `bar@ -> foo', set it to t.

Dired checks if there is really a @ appended.  Thus, if you have a
marking ls program on one host and a non-marking on another host, and
don't care about symbolic links which really end in a @, you can
always set this variable to t.")

(defvar dired-trivial-filenames (purecopy "^\\.\\.?$\\|^#") "\
*Regexp of files to skip when moving point to the first file of a new directory listing.
Nil means move to the subdir line, t means move to first file.")

(defvar dired-keep-marker-move t "\
If t, moved marked files are marked if their originals were.
If a character, those files (marked or not) are marked with that character.")

(defvar dired-keep-marker-copy 67 "\
If t, copied files are marked if their source files were.
If a character, those files are always marked with that character.")

(defvar dired-keep-marker-hardlink 72 "\
If t, hard-linked files are marked if the linked-to files were.
If a character, those files are always marked with that character.")

(defvar dired-keep-marker-symlink 89 "\
If t, symlinked marked files are marked if the linked-to files were.
If a character, those files are always marked with that character.")

(defvar dired-dwim-target nil "\
*If non-nil, dired tries to guess a default target directory:
If there is a dired buffer displayed in the next window, use
its current subdir, instead of the current subdir of this dired
buffer.

The target is used in the prompt for file copy, move etc.")

(defvar dired-copy-preserve-time nil "\
*If non-nil, Dired preserves the last-modified time in a file copy.
\(This works on only some systems.)\\<dired-mode-map>
Use `\\[dired-do-copy]' with a zero prefix argument to toggle its value.")
(define-key ctl-x-map "d" 'dired)

(autoload 'dired "dired" "\
\"Edit\" directory DIRNAME--delete, rename, print, etc. some files in it.
With an optional prefix argument you can specify the ls SWITCHES that are used.
Dired displays a list of files in DIRNAME (which may also have
  shell wildcards appended to select certain files).
You can move around in it with the usual commands.
You can flag files for deletion with \\<dired-mode-map>\\[dired-flag-file-deleted] and then delete them by
  typing \\[dired-do-deletions].
Type \\[describe-mode] after entering dired for more info.

If DIRNAME is already in a dired buffer, that buffer is used without refresh." t nil)
(define-key ctl-x-4-map "d" 'dired-other-window)

(autoload 'dired-other-window "dired" "\
\"Edit\" directory DIRNAME.  Like `dired' but selects in another window." t nil)

(autoload 'dired-noselect "dired" "\
Like `dired' but returns the dired buffer as value, does not select it." nil nil)

;;;***

;;;### (autoloads (dired-extra-startup) "dired-x" "dired/dired-x.el" (11567 52549))
;;; Generated autoloads from dired/dired-x.el

(autoload 'dired-extra-startup "dired-x" "\
Automatically put on dired-mode-hook to get extra dired features:
\\<dired-mode-map>
  \\[dired-vm]	-- VM on folder
  \\[dired-rmail]	-- Rmail on folder
  \\[dired-do-insert-subdir]	-- insert all marked subdirs
  \\[dired-do-find-file]	-- visit all marked files simultaneously
  \\[dired-set-marker-char], \\[dired-restore-marker-char]	-- change and display dired-marker-char dynamically.
  \\[dired-omit-toggle]	-- toggle omitting of files
  \\[dired-mark-sexp]	-- mark by lisp expression
  \\[dired-do-unmark]	-- replace existing marker with another.
  \\[dired-mark-rcs-files]	-- mark all RCS controlled files
  \\[dired-mark-files-compilation-buffer]	-- mark compilation files
  \\[dired-copy-filename-as-kill]	-- copy the file or subdir names into the kill ring.
  	   You can feed it to other commands using \\[yank].

For more features, see variables

  dired-omit-files
  dired-omit-extenstions
  dired-dangerous-shell-command
  dired-mark-keys
  dired-local-variables-file
  dired-find-subdir
  dired-guess-have-gnutar
  dired-auto-shell-command-alist

See also functions

  dired-sort-on-size
  dired-do-relsymlink
  dired-flag-extension
  dired-virtual
  dired-jump-back
  dired-jump-back-other-window
" t nil)

;;;***

;;;### (autoloads (find-grep-dired find-name-dired find-dired) "find-dired" "dired/find-dired.el" (11555 56750))
;;; Generated autoloads from dired/find-dired.el

(defvar find-ls-option (purecopy (if (eq system-type 'berkeley-unix) "-ls" "-exec ls -ldi {} \\;")) "\
*Option to `find' to produce an `ls -l'-type listing.")

(defvar find-grep-options (purecopy (if (eq system-type 'berkeley-unix) "-s" "-l")) "\
*Option to grep to be as silent as possible.
On Berkeley systems, this is `-s', for others it seems impossible to
suppress all output, so `-l' is used to print nothing more than the
file name.")

(autoload 'find-dired "find-dired" "\
Run `find' and go into dired-mode on a buffer of the output.
The command run (after changing into DIR) is

    find . \\( ARGS \\) -ls" t nil)

(autoload 'find-name-dired "find-dired" "\
Search DIR recursively for files matching the globbing pattern PATTERN,
and run dired on those files.
PATTERN is a shell wildcard (not an Emacs regexp) and need not be quoted.
The command run (after changing into DIR) is

    find . -name 'PATTERN' -ls" t nil)

(autoload 'find-grep-dired "find-dired" "\
Find files in DIR containing a regexp ARG and start Dired on output.
The command run (after changing into DIR) is

    find . -exec grep -s ARG {} \\; -ls

Thus ARG can also contain additional grep options." t nil)

;;;***

;;;### (autoloads (edebug-eval-top-level-form) "edebug" "edebug/edebug.el" (11555 56933))
;;; Generated autoloads from edebug/edebug.el

(fset 'edebug-defun 'edebug-eval-top-level-form)

(autoload 'edebug-eval-top-level-form "edebug" "\
Evaluate a top level form, such as defun or defmacro.
This is like eval-defun, but with edebug calls.
Print its name in the minibuffer and leave point where it is,
or if an error occurs, leave point after it with mark at the original point." t nil)

(defvar global-edebug-prefix (purecopy "X") "\
Prefix key for global edebug commands, available from any buffer.")

;;;***

;;;### (autoloads (electric-buffer-list) "ebuff-menu" "electric/ebuff-menu.el" (11387 38130))
;;; Generated autoloads from electric/ebuff-menu.el

(autoload 'electric-buffer-list "ebuff-menu" "\
Pops up a buffer describing the set of Emacs buffers.
Vaguely like ITS lunar select buffer; combining typeoutoid buffer
listing with menuoid buffer selection.

If the very next character typed is a space then the buffer list
window disappears.  Otherwise, one may move around in the
buffer list window, marking buffers to be selected, saved or deleted.

To exit and select a new buffer, type a space when the cursor is on the
appropriate line of the buffer-list window.

Other commands are much like those of buffer-menu-mode.

Calls value of `electric-buffer-menu-mode-hook' on entry if non-nil.

\\{electric-buffer-menu-mode-map}" t nil)

;;;***

;;;### (autoloads (electric-command-history Electric-command-history-redo-expression) "echistory" "electric/echistory.el" (11557 4849))
;;; Generated autoloads from electric/echistory.el

(autoload 'Electric-command-history-redo-expression "echistory" "\
Edit current history line in minibuffer and execute result.
With prefix argument NOCONFIRM, execute current line as-is without editing." t nil)

(autoload 'electric-command-history "echistory" "\
\\<electric-history-map>Major mode for examining and redoing commands from `command-history'.
This pops up a window with the Command History listing.
The number of command listed is controlled by `list-command-history-max'.
The command history is filtered by `list-command-history-filter' if non-nil.
Combines typeout Command History list window with menu like selection
of an expression from the history for re-evaluation in the *original* buffer.

The history displayed is filtered by `list-command-history-filter' if non-nil.

This pops up a window with the Command History listing.  If the very
next character typed is Space, the listing is killed and the previous
window configuration is restored.  Otherwise, you can browse in the
Command History with  Return  moving down and  Delete  moving up, possibly
selecting an expression to be redone with Space or quitting with `Q'.

Like Emacs-Lisp mode except that characters do not insert themselves and
Tab and Linefeed do not indent.  Instead these commands are provided:
\\{electric-history-map}

Calls the value of `electric-command-history-hook' if that is non-nil.
The Command History listing is recomputed each time this mode is invoked." t nil)

;;;***

;;;### (autoloads (evi) "evi" "emulators/evi.el" (11555 56756))
;;; Generated autoloads from emulators/evi.el

(autoload 'evi "evi" "\
Start vi emulation in this buffer." t nil)

;;;***

;;;### (autoloads (set-gosmacs-bindings) "gosmacs" "emulators/gosmacs.el" (11557 4852))
;;; Generated autoloads from emulators/gosmacs.el

(autoload 'set-gosmacs-bindings "gosmacs" "\
Rebind some keys globally to make GNU Emacs resemble Gosling Emacs.
Use \\[set-gnu-bindings] to restore previous global bindings." t nil)

;;;***

;;;### (autoloads (convert-mocklisp-buffer) "mlconvert" "emulators/mlconvert.el" (11557 4854))
;;; Generated autoloads from emulators/mlconvert.el

(autoload 'convert-mocklisp-buffer "mlconvert" "\
Convert buffer of Mocklisp code to real Lisp that GNU Emacs can run." t nil)

;;;***

;;;### (autoloads (teco-command) "teco" "emulators/teco.el" (11352 15677))
;;; Generated autoloads from emulators/teco.el

(autoload 'teco-command "teco" "\
Read and execute a Teco command string." t nil)

;;;***

;;;### (autoloads (tpu-edt-on) "tpu-edt" "emulators/tpu-edt.el" (11551 28093))
;;; Generated autoloads from emulators/tpu-edt.el

(fset 'tpu-edt-mode 'tpu-edt-on)

(fset 'tpu-edt 'tpu-edt-on)

(autoload 'tpu-edt-on "tpu-edt" "\
Turn on TPU/edt emulation." t nil)

;;;***

;;;### (autoloads (vi-mode) "vi" "emulators/vi.el" (11555 56761))
;;; Generated autoloads from emulators/vi.el

(autoload 'vi-mode "vi" "\
Major mode that acts like the `vi' editor.
The purpose of this mode is to provide you the combined power of vi (namely,
the \"cross product\" effect of commands and repeat last changes) and Emacs.

This command redefines nearly all keys to look like vi commands.
It records the previous major mode, and any vi command for input
\(`i', `a', `s', etc.) switches back to that mode.
Thus, ordinary Emacs (in whatever major mode you had been using)
is \"input\" mode as far as vi is concerned.

To get back into vi from \"input\" mode, you must issue this command again.
Therefore, it is recommended that you assign it to a key.

Major differences between this mode and real vi :

* Limitations and unsupported features
  - Search patterns with line offset (e.g. /pat/+3 or /pat/z.) are
    not supported.
  - Ex commands are not implemented; try ':' to get some hints.
  - No line undo (i.e. the 'U' command), but multi-undo is a standard feature.

* Modifications
  - The stopping positions for some point motion commands (word boundary,
    pattern search) are slightly different from standard 'vi'.
    Also, no automatic wrap around at end of buffer for pattern searching.
  - Since changes are done in two steps (deletion then insertion), you need
    to undo twice to completely undo a change command.  But this is not needed
    for undoing a repeated change command.
  - No need to set/unset 'magic', to search for a string with regular expr
    in it just put a prefix arg for the search commands.  Replace cmds too.
  - ^R is bound to incremental backward search, so use ^L to redraw screen.

* Extensions
  - Some standard (or modified) Emacs commands were integrated, such as
    incremental search, query replace, transpose objects, and keyboard macros.
  - In command state, ^X links to the 'ctl-x-map', and ESC can be linked to
    esc-map or set undefined.  These can give you the full power of Emacs.
  - See vi-com-map for those keys that are extensions to standard vi, e.g.
    `vi-name-last-change-or-macro', `vi-verify-spelling', `vi-locate-def',
    `vi-mark-region', and 'vi-quote-words'.  Some of them are quite handy.
  - Use \\[vi-switch-mode] to switch among different modes quickly.
  
Syntax table and abbrevs while in vi mode remain as they were in Emacs." t nil)

;;;***

;;;### (autoloads (vip-mode) "vip" "emulators/vip.el" (11555 56764))
;;; Generated autoloads from emulators/vip.el

(autoload 'vip-mode "vip" "\
Turn on VIP emulation of VI." t nil)

;;;***

;;;### (autoloads (blackbox) "blackbox" "games/blackbox.el" (11369 53775))
;;; Generated autoloads from games/blackbox.el

(autoload 'blackbox "blackbox" "\
Play blackbox.  Optional prefix argument is the number of balls;
the default is 4.

What is blackbox?

Blackbox is a game of hide and seek played on an 8 by 8 grid (the
Blackbox).  Your opponent (Emacs, in this case) has hidden several
balls (usually 4) within this box.  By shooting rays into the box and
observing where they emerge it is possible to deduce the positions of
the hidden balls.  The fewer rays you use to find the balls, the lower
your score.

Overview of play:

\\<blackbox-mode-map>To play blackbox, type \\[blackbox].  An optional prefix argument
specifies the number of balls to be hidden in the box; the default is
four.

The cursor can be moved around the box with the standard cursor
movement keys.

To shoot a ray, move the cursor to the edge of the box and press SPC.
The result will be determined and the playfield updated.

You may place or remove balls in the box by moving the cursor into the
box and pressing \\[bb-romp].

When you think the configuration of balls you have placed is correct,
press \\[bb-done].  You will be informed whether you are correct or
not, and be given your score.  Your score is the number of letters and
numbers around the outside of the box plus five for each incorrectly
placed ball.  If you placed any balls incorrectly, they will be
indicated with `x', and their actual positions indicated with `o'.

Details:

There are three possible outcomes for each ray you send into the box:

	Detour: the ray is deflected and emerges somewhere other than
		where you sent it in.  On the playfield, detours are
		denoted by matching pairs of numbers -- one where the
		ray went in, and the other where it came out.

	Reflection: the ray is reflected and emerges in the same place
		it was sent in.  On the playfield, reflections are
		denoted by the letter `R'.

	Hit:	the ray strikes a ball directly and is absorbed.  It does
		not emerge from the box.  On the playfield, hits are
		denoted by the letter `H'.

The rules for how balls deflect rays are simple and are best shown by
example.

As a ray approaches a ball it is deflected ninety degrees.  Rays can
be deflected multiple times.  In the diagrams below, the dashes
represent empty box locations and the letter `O' represents a ball.
The entrance and exit points of each ray are marked with numbers as
described under \"Detour\" above.  Note that the entrance and exit
points are always interchangeable.  `*' denotes the path taken by the
ray.

Note carefully the relative positions of the ball and the ninety
degree deflection it causes.

    1                                            
  - * - - - - - -         - - - - - - - -         - - - - - - - -       
  - * - - - - - -         - - - - - - - -         - - - - - - - -       
1 * * - - - - - -         - - - - - - - -         - O - - - - O -       
  - - O - - - - -         - - O - - - - -         - - * * * * - -
  - - - - - - - -         - - - * * * * * 2     3 * * * - - * - -
  - - - - - - - -         - - - * - - - -         - - - O - * - -      
  - - - - - - - -         - - - * - - - -         - - - - * * - -       
  - - - - - - - -         - - - * - - - -         - - - - * - O -       
                                2                         3

As mentioned above, a reflection occurs when a ray emerges from the same point
it was sent in.  This can happen in several ways:

                                                                           
  - - - - - - - -         - - - - - - - -          - - - - - - - -
  - - - - O - - -         - - O - O - - -          - - - - - - - -
R * * * * - - - -         - - - * - - - -          O - - - - - - -
  - - - - O - - -         - - - * - - - -        R - - - - - - - -
  - - - - - - - -         - - - * - - - -          - - - - - - - -
  - - - - - - - -         - - - * - - - -          - - - - - - - -
  - - - - - - - -       R * * * * - - - -          - - - - - - - -
  - - - - - - - -         - - - - O - - -          - - - - - - - -

In the first example, the ray is deflected downwards by the upper
ball, then left by the lower ball, and finally retraces its path to
its point of origin.  The second example is similar.  The third
example is a bit anomalous but can be rationalized by realizing the
ray never gets a chance to get into the box.  Alternatively, the ray
can be thought of as being deflected downwards and immediately
emerging from the box.

A hit occurs when a ray runs straight into a ball:

  - - - - - - - -         - - - - - - - -          - - - - - - - -
  - - - - - - - -         - - - - - - - -          - - - - O - - -
  - - - - - - - -         - - - - O - - -        H * * * * - - - -
  - - - - - - - -       H * * * * O - - -          - - - * - - - -
  - - - - - - - -         - - - - O - - -          - - - O - - - -
H * * * O - - - -         - - - - - - - -          - - - - - - - -
  - - - - - - - -         - - - - - - - -          - - - - - - - -
  - - - - - - - -         - - - - - - - -          - - - - - - - -

Be sure to compare the second example of a hit with the first example of
a reflection." t nil)

;;;***

;;;### (autoloads (conx-load conx conx-region conx-buffer) "conx" "games/conx.el" (11555 56768))
;;; Generated autoloads from games/conx.el

(autoload 'conx-buffer "conx" "\
Absorb the text in the current buffer into the tree." t nil)

(autoload 'conx-region "conx" "\
Absorb the text in the current region into the tree." t nil)

(autoload 'conx "conx" "\
Generate some random sentences in the *conx* buffer." t nil)

(autoload 'conx-load "conx" "\
Load in a CONX database written by the \\[conx-save] command.
This clears the database currently in memory." t nil)

;;;***

;;;### (autoloads (shuffle-vector cookie-snarf cookie-insert cookie) "cookie1" "games/cookie1.el" (11369 53775))
;;; Generated autoloads from games/cookie1.el

(autoload 'cookie "cookie1" "\
Return a random phrase from PHRASE-FILE.  When the phrase file
is read in, display STARTMSG at beginning of load, ENDMSG at end." nil nil)

(autoload 'cookie-insert "cookie1" "\
Insert random phrases from PHRASE-FILE; COUNT of them.  When the phrase file
is read in, display STARTMSG at beginning of load, ENDMSG at end." nil nil)

(autoload 'cookie-snarf "cookie1" "\
Reads in the PHRASE-FILE, returns it as a vector of strings.  Emit
STARTMSG and ENDMSG before and after.  Caches the result; second and
subsequent calls on the same file won't go to disk." nil nil)

(autoload 'shuffle-vector "cookie1" "\
Randomly permute the elements of VECTOR (all permutations equally likely)" nil nil)

;;;***

;;;### (autoloads (dissociated-press) "dissociate" "games/dissociate.el" (11369 53776))
;;; Generated autoloads from games/dissociate.el

(autoload 'dissociated-press "dissociate" "\
Dissociate the text of the current buffer.
Output goes in buffer named *Dissociation*,
which is redisplayed each time text is added to it.
Every so often the user must say whether to continue.
If ARG is positive, require ARG chars of continuity.
If ARG is negative, require -ARG words of continuity.
Default is 2." t nil)

;;;***

;;;### (autoloads (doctor) "doctor" "games/doctor.el" (11369 53776))
;;; Generated autoloads from games/doctor.el

(autoload 'doctor "doctor" "\
Switch to *doctor* buffer and start giving psychotherapy." t nil)

;;;***

;;;### (autoloads (dunnet) "dunnet" "games/dunnet.el" (11493 30592))
;;; Generated autoloads from games/dunnet.el

(autoload 'dunnet "dunnet" "\
Switch to *dungeon* buffer and start game." t nil)

;;;***

;;;### (autoloads (gomoku) "gomoku" "games/gomoku.el" (11412 44318))
;;; Generated autoloads from games/gomoku.el

(autoload 'gomoku "gomoku" "\
Start a Gomoku game between you and Emacs.
If a game is in progress, this command allow you to resume it.
If optional arguments N and M are given, an N by M board is used.

You and Emacs play in turn by marking a free square. You mark it with X
and Emacs marks it with O. The winner is the first to get five contiguous
marks horizontally, vertically or in diagonal.
You play by moving the cursor over the square you choose and hitting
\\<gomoku-mode-map>\\[gomoku-human-plays].
Use \\[describe-mode] for more info." t nil)

;;;***

;;;### (autoloads (hanoi) "hanoi" "games/hanoi.el" (11369 53776))
;;; Generated autoloads from games/hanoi.el

(autoload 'hanoi "hanoi" "\
Towers of Hanoi diversion.  Argument is number of rings." t nil)

;;;***

;;;### (autoloads (life) "life" "games/life.el" (11552 7479))
;;; Generated autoloads from games/life.el

(autoload 'life "life" "\
Run Conway's Life simulation.
The starting pattern is randomly selected.  Prefix arg (optional first
arg non-nil from a program) is the number of seconds to sleep between
generations (this defaults to 1)." t nil)

;;;***

;;;### (autoloads (mpuz) "mpuz" "games/mpuz.el" (11369 53776))
;;; Generated autoloads from games/mpuz.el

(autoload 'mpuz "mpuz" "\
Multiplication puzzle with GNU Emacs." t nil)

;;;***

;;;### (autoloads (spook) "spook" "games/spook.el" (11369 53776))
;;; Generated autoloads from games/spook.el

(autoload 'spook "spook" "\
Adds that special touch of class to your outgoing mail." t nil)

;;;***

;;;### (autoloads (psychoanalyze-pinhead yow) "yow" "games/yow.el" (11493 30776))
;;; Generated autoloads from games/yow.el

(autoload 'yow "yow" "\
Return or display a random Zippy quotation." t nil)

(autoload 'psychoanalyze-pinhead "yow" "\
Zippy goes to the analyst." t nil)

;;;***

;;;### (autoloads (gnus) "gnus" "gnus/gnus.el" (11566 22557))
;;; Generated autoloads from gnus/gnus.el

(autoload 'gnus "gnus" "\
Read network news.
If optional argument CONFIRM is non-nil, ask NNTP server." t nil)

;;;***

;;;### (autoloads (gnus-post-news) "gnuspost" "gnus/gnuspost.el" (11555 58220))
;;; Generated autoloads from gnus/gnuspost.el

(fset 'sendnews 'gnus-post-news)

(fset 'postnews 'gnus-post-news)

(autoload 'gnus-post-news "gnuspost" "\
Begin editing a new USENET news article to be posted.
Type \\[describe-mode] once editing the article to get a list of commands." t nil)

;;;***

;;;### (autoloads (asm-mode) "asm-mode" "modes/asm-mode.el" (11506 27408))
;;; Generated autoloads from modes/asm-mode.el

(autoload 'asm-mode "asm-mode" "\
Major mode for editing typical assembler code.
Features a private abbrev table and the following bindings:

\\[asm-colon]	outdent a preceding label, tab to next tab stop.
\\[tab-to-tab-stop]	tab to next tab stop.
\\[asm-newline]	newline, then tab to next tab stop.
\\[asm-comment]	smart placement of assembler comments.

The character used for making comments is set by the variable
`asm-comment-char' (which defaults to `?;').

Alternatively, you may set this variable in `asm-set-comment-hook', which is
called near the beginning of mode initialization.

Turning on Asm mode runs the hook `asm-mode-hook' at the end of initialization.

Special commands:\\{asm-mode-map}
" t nil)

;;;***

;;;### (autoloads (awk-mode) "awk-mode" "modes/awk-mode.el" (11542 44641))
;;; Generated autoloads from modes/awk-mode.el

(autoload 'awk-mode "awk-mode" "\
Major mode for editing AWK code.
This is much like C mode except for the syntax of comments.  It uses
the same keymap as C mode and has the same variables for customizing
indentation.  It has its own abbrev table and its own syntax table.

Turning on AWK mode calls the value of the variable `awk-mode-hook'
with no args, if that value is non-nil." t nil)

;;;***

;;;### (autoloads (bibtex-mode) "bibtex" "modes/bibtex.el" (11553 17826))
;;; Generated autoloads from modes/bibtex.el

(autoload 'bibtex-mode "bibtex" "\
Major mode for editing bibtex files.

\\{bibtex-mode-map}

A command such as \\[bibtex-Book] will outline the fields for a BibTeX book entry.

The optional fields start with the string OPT, and thus ignored by BibTeX.
The OPT string may be removed from a field with \\[bibtex-remove-OPT].
\\[bibtex-kill-optional-field] kills the current optional field entirely.
\\[bibtex-remove-double-quotes] removes the double-quotes around the text of
the current field.  \\[bibtex-empty-field] replaces the text of the current
field with the default \"\".

The command \\[bibtex-clean-entry] cleans the current entry, i.e. (i) removes
double-quotes from entirely numerical fields, (ii) removes OPT from all
non-empty optional fields, (iii) removes all empty optional fields, and (iv)
checks that no non-optional fields are empty.

Use \\[bibtex-find-text] to position the dot at the end of the current field.
Use \\[bibtex-next-field] to move to end of the next field.

The following may be of interest as well:

  Functions:
    find-bibtex-duplicates
    find-bibtex-entry-location
    hide-bibtex-entry-bodies
    sort-bibtex-entries
    validate-bibtex-buffer

  Variables:
    bibtex-clean-entry-zap-empty-opts
    bibtex-entry-field-alist
    bibtex-include-OPTannote
    bibtex-include-OPTcrossref
    bibtex-include-OPTkey
    bibtex-maintain-sorted-entries
    bibtex-mode-user-optional-fields

Fields:
    address
           Publisher's address
    annote
           Long annotation used for annotated bibliographies (begins sentence)
    author
           Name(s) of author(s), in BibTeX name format
    booktitle
           Book title when the thing being referenced isn't the whole book.
           For book entries, the title field should be used instead.
    chapter
           Chapter number
    crossref
	   The database key of the entry being cross referenced.
    edition
           Edition of a book (e.g., \"second\")
    editor
           Name(s) of editor(s), in BibTeX name format.
           If there is also an author field, then the editor field should be
           for the book or collection that the work appears in
    howpublished
            How something strange has been published (begins sentence)
    institution
           Sponsoring institution
    journal
           Journal name (macros are provided for many)
    key
           Alphabetizing and labeling key (needed when no author or editor)
    month
           Month (macros are provided)
    note
           To help the reader find a reference (begins sentence)
    number
           Number of a journal or technical report
    organization
           Organization (sponsoring a conference)
    pages
           Page number or numbers (use `--' to separate a range)
    publisher
           Publisher name
    school
           School name (for theses)
    series
           The name of a series or set of books.
           An individual book will will also have it's own title
    title
           The title of the thing being referenced
    type
           Type of a technical report (e.g., \"Research Note\") to be used
           instead of the default \"Technical Report\"
    volume
           Volume of a journal or multivolume work
    year
           Year---should contain only numerals
---------------------------------------------------------
Entry to this mode calls the value of bibtex-mode-hook if that value is
non-nil." t nil)

;;;***

;;;### (autoloads (c++-c-mode c++-mode) "c++-mode" "modes/c++-mode.el" (11555 56992))
;;; Generated autoloads from modes/c++-mode.el

(autoload 'c++-mode "c++-mode" "\
Major mode for editing C++ code.  2.353
To submit a problem report, enter `\\[c++-submit-bug-report]' from a
c++-mode buffer.  This automatically sets up a mail buffer with
version information already added.  You just need to add a description
of the problem and send the message.

1. Very much like editing C code,
2. Expression and list commands understand all C++ brackets,
3. Tab at left margin indents for C++ code,
4. Both C++ and C style block comments are recognized,
5. Paragraphs are separated by blank lines only,
6. Hungry delete key and auto newline features are optional.

IMPORTANT NOTE: You may notice that some characters (by default, only
single quote) will get escaped with a backslash when typed in a
comment region.  This is a necessary workaround of a bug present in
GNU Emacs 18 and derivatives.  Enter `\\[describe-variable] c++-untame-characters RET'
for more information.  If you are running a patched Emacs, no
characters will be escaped in comment regions, and many functions will
run much faster.

Key bindings:
\\{c++-mode-map}

These variables control indentation style.  Those with names like
c-<thing> are inherited from c-mode.  Those with names like
c++-<thing> are unique for this mode, or have extended functionality
from their c-mode cousins.

 c-argdecl-indent
    Indentation level of declarations of C function arguments.
 c-brace-imaginary-offset
    An open brace following other text is treated as if it were
    this far to the right of the start of its line.
 c-brace-offset
    Extra indentation for line if it starts with an open brace.
 c-continued-brace-offset
    Extra indentation given to a brace that starts a substatement.
    This is in addition to `c-continued-statement-offset'.
 c-continued-statement-offset
    Extra indentation given to a substatement, such as the
    then-clause of an if or body of a while.
 c-indent-level
    Indentation of C statements within surrounding block.
    The surrounding block's indentation is the indentation
    of the line on which the open-brace appears.
 c-label-offset
    Extra indentation for line that is a label, or case or ``default:''

 c++-C-block-comments-indent-p
    Style of C block comments to support.
 c++-access-specifier-offset
    Extra indentation given to public, protected, and private keyword lines.
 c++-always-arglist-indent-p
    Control indentation of continued arglists.  When non-nil, arglists
    continued on subsequent lines will always indent
    `c++-empty-arglist-indent' spaces, otherwise, they will indent to
    just under previous line's argument indentation.
 c++-auto-hungry-initial-state
    Initial state of auto/hungry feature when a C++ buffer is first visited.
 c++-auto-hungry-toggle
    Enable/disable toggling of auto/hungry features.
 c++-backscan-limit
    Limit in characters for looking back while skipping syntactic
    whitespace.  This variable is only used in an un-patched Emacs to
    help improve performance at the expense of some accuracy.  Patched
    Emacses are both fast and accurate.
 c++-block-close-brace-offset
    Extra indentation give to braces which close a block.
 c++-cleanup-list
    A list of construct ``clean ups'' which c++-mode will perform when
    auto-newline feature is on.  Current legal values are:
    `brace-else-brace', `empty-defun-braces', `defun-close-semi'.
 c++-comment-only-line-offset
    Extra indentation for a line containing only a C or C++ style
    comment.  Can be an integer or list, specifying the various styles
    of comment-only line special indentations.
 c++-continued-member-init-offset
    Extra indentation for continuation lines of member initializations; nil
    means to align with previous initializations rather than with the colon.
 c++-default-macroize-column
    Column to insert backslashes when macroizing a region.
 c++-delete-function
    Function called by `c++-electric-delete' when deleting a single char.
 c++-electric-pound-behavior
    List of behaviors for electric pound insertion.
 c++-empty-arglist-indent
    Extra indentation to apply to a line following an empty argument
    list.  nil means to line it up with the left paren.
 c++-friend-offset
    Offset of C++ friend class declarations relative to member declarations.
 c++-hanging-braces
    Controls open brace hanging behavior when using auto-newline feature.
    nil says no braces hang, t says all open braces hang.  non-nil-or-t
    means top-level open braces don't hang, all others do.
 c++-hanging-member-init-colon
    Defines how colons which introduce member initialization lists are
    formatted.  t means no newlines are inserted either before or after
    the colon.  nil means newlines are inserted both before and after
    the colon.  `before' inserts newlines only before the colon, and
    `after' inserts newlines only after colon.
 c++-member-init-indent
    Indentation level of member initializations in function declarations,
    if they are on a separate line beginning with a colon.
 c++-paren-as-block-close-p
    If non-nil, treat a parenthesis which is the first non-whitespace
    on a line as a paren which closes a block (i.e. treat it similar
    to right curly brace).
 c++-relative-offset-p
    Control the calculation for indentation.  When non-nil (the
    default), indentation is calculated relative to the first
    statement in the block.  When nil, the indentation is calculated
    without regard to how the first statement is indented.  Useful when
    using a `c++-special-indent-hook'.
 c++-special-indent-hook
    Hook for user defined special indentation adjustments.  You can use
    this hook, which gets called after a line is indented by the mode,
    to customize indentations of the line.
 c++-tab-always-indent
    Controls the operation of the TAB key.  t means always just indent
    the current line.  nil means indent the current line only if point
    is at the left margin or in the line's indentation; otherwise
    insert a tab.  If not-nil-or-t, then tab is inserted only within
    literals (comments and strings) and inside preprocessor
    directives, but the line is always reindented.  Default is value
    for `c-tab-always-indent'.
 c++-untame-characters
    When non-nil, inserts backslash escapes before certain untamed
    characters in comment regions.  It is recommended that you keep the
    default setting to workaround a nasty Emacs bug, unless you are
    running a patched Emacs.

Auto-newlining is no longer an all or nothing proposition.  In my
opinion, I don't believe it is possible to implement a perfect
auto-newline algorithm.  Sometimes you want it and sometimes you don't.
So now auto-newline (and its companion feature, hungry-delete-key) can
be toggled on and off on the fly.  Hungry-delete-key is the optional
behavior of the delete key so that, when enabled, hitting the delete
key once consumes all preceding whitespace, unless point is within a
literal (defined as a C or C++ comment, or string).  Inside literals,
and with hungry-delete-key disabled, the delete key just calls the
function in variable `c++-delete-function'.

Selection and toggling of these features is controlled by the
variables `c++-auto-hungry-initial-state' and `c++-auto-hungry-toggle'.
Legal values for both variables are:

  `none' (or nil)      -- no auto-newline or hungry-delete-key.
  `auto-only'          -- function affects only auto-newline feature.
  `hungry-only'        -- function affects only hungry-delete-key feature.
  `auto-hungry' (or t) -- function affects both features.

Thus if `c++-auto-hungry-initial-state' is `hungry-only', then only
hungry-delete-key feature is turned on when the buffer is first
visited.  If `c++-auto-hungry-toggle' is `auto-hungry', and both
auto-newline and hungry-delete-key features are on, then hitting
`\\[c++-toggle-auto-hungry-state]' will toggle both features.  Hitting
`\\[c++-toggle-hungry-state]' will always toggle hungry-delete-key
feature and hitting `\\[c++-toggle-auto-state]' will always toggle
auto-newline feature, regardless of the value of
`c++-auto-hungry-toggle'.

Settings for K&R, BSD, and Stroustrup indentation styles are
  c-indent-level                5    8    4
  c-continued-statement-offset  5    8    4
  c-continued-brace-offset                0
  c-brace-offset               -5   -8    0
  c-brace-imaginary-offset                0
  c-argdecl-indent              0    8    4
  c-label-offset               -5   -8   -4
  c++-access-specifier-offset  -5   -8   -4
  c++-empty-arglist-indent                4
  c++-friend-offset                       0

Turning on C++ mode calls the value of the variable `c++-mode-hook' with
no args, if that value is non-nil." t nil)

(autoload 'c++-c-mode "c++-mode" "\
Major mode for editing K&R and ANSI C code.  2.353
This mode is based on c++-mode.  Documentation for this mode is
available by doing a `\\[describe-function] c++-mode'." t nil)

;;;***

;;;### (autoloads (set-c-style) "c-style" "modes/c-style.el" (11555 56776))
;;; Generated autoloads from modes/c-style.el

(autoload 'set-c-style "c-style" "\
Set up the c-mode style variables from STYLE if it is given, or
default-c-style otherwise.  It makes the c indentation style variables
buffer local." t nil)

;;;***

;;;### (autoloads (common-lisp-indent-function) "cl-indent" "modes/cl-indent.el" (11555 56778))
;;; Generated autoloads from modes/cl-indent.el

(autoload 'common-lisp-indent-function "cl-indent" nil nil nil)

;;;***

;;;### (autoloads (fortran-mode) "fortran" "modes/fortran.el" (11458 65298))
;;; Generated autoloads from modes/fortran.el

(defvar fortran-tab-mode-default nil "\
*Default tabbing/carriage control style for empty files in Fortran mode.
A value of t specifies tab-digit style of continuation control.
A value of nil specifies that continuation lines are marked
with a character in column 6.")

(autoload 'fortran-mode "fortran" "\
Major mode for editing Fortran code.
\\[fortran-indent-line] indents the current Fortran line correctly. 
DO statements must not share a common CONTINUE.

Type ;? or ;\\[help-command] to display a list of built-in abbrevs for Fortran keywords.

Key definitions:
\\{fortran-mode-map}

Variables controlling indentation style and extra features:

 comment-start
    Normally nil in Fortran mode.  If you want to use comments
    starting with `!', set this to the string \"!\".
 fortran-do-indent
    Extra indentation within do blocks.  (default 3)
 fortran-if-indent
    Extra indentation within if blocks.  (default 3)
 fortran-structure-indent
    Extra indentation within structure, union and map blocks.  (default 3)
 fortran-continuation-indent
    Extra indentation applied to continuation statements.  (default 5)
 fortran-comment-line-extra-indent
    Amount of extra indentation for text within full-line comments. (default 0)
 fortran-comment-indent-style
    nil    means don't change indentation of text in full-line comments,
    fixed  means indent that text at `fortran-comment-line-extra-indent' beyond
           the value of `fortran-minimum-statement-indent-fixed' (for fixed
           format continuation style) or `fortran-minimum-statement-indent-tab'
           (for TAB format continuation style).
    relative  means indent at `fortran-comment-line-extra-indent' beyond the
 	      indentation for a line of code.
    (default 'fixed)
 fortran-comment-indent-char
    Single-character string to be inserted instead of space for
    full-line comment indentation.  (default \" \")
 fortran-minimum-statement-indent-fixed
    Minimum indentation for Fortran statements in fixed format mode. (def.6)
 fortran-minimum-statement-indent-tab
    Minimum indentation for Fortran statements in TAB format mode. (default 9)
 fortran-line-number-indent
    Maximum indentation for line numbers.  A line number will get
    less than this much indentation if necessary to avoid reaching
    column 5.  (default 1)
 fortran-check-all-num-for-matching-do
    Non-nil causes all numbered lines to be treated as possible \"continue\"
    statements.  (default nil)
 fortran-blink-matching-if 
    From a Fortran ENDIF statement, blink the matching IF statement.
    (default nil)
 fortran-continuation-string
    Single-character string to be inserted in column 5 of a continuation
    line.  (default \"$\")
 fortran-comment-region
    String inserted by \\[fortran-comment-region] at start of each line in 
    region.  (default \"c$$$\")
 fortran-electric-line-number
    Non-nil causes line number digits to be moved to the correct column 
    as typed.  (default t)
 fortran-break-before-delimiters
    Non-nil causes `fortran-do-auto-fill' breaks lines before delimiters.
    (default t)
 fortran-startup-message
    Set to nil to inhibit message first time Fortran mode is used.

Turning on Fortran mode calls the value of the variable `fortran-mode-hook'
with no args, if that value is non-nil." t nil)

;;;***

;;;### (autoloads (html-mode) "html-mode" "modes/html-mode.el" (11563 43299))
;;; Generated autoloads from modes/html-mode.el

(autoload 'html-mode "html-mode" "\
Major mode for editing HTML hypertext documents.  Special commands:\\{html-mode-map}
Turning on html-mode calls the value of the variable html-mode-hook,
if that value is non-nil.

More extensive documentation is available in the file 'html-mode.el'.
The latest (possibly unstable) version of this file will always be available
on anonymous FTP server ftp.ncsa.uiuc.edu in /Mosaic/elisp." t nil)

;;;***

;;;### (autoloads (define-mail-alias build-mail-aliases mail-aliases-setup) "mail-abbrevs" "modes/mail-abbrevs.el" (11555 56781))
;;; Generated autoloads from modes/mail-abbrevs.el

(defvar mail-abbrev-mailrc-file nil "\
Name of file with mail aliases.   If nil, ~/.mailrc is used.")

(defvar mail-aliases nil "\
Word-abbrev table of mail address aliases.
If this is nil, it means the aliases have not yet been initialized and
should be read from the .mailrc file.  (This is distinct from there being
no aliases, which is represented by this being a table with no entries.)")

(autoload 'mail-aliases-setup "mail-abbrevs" nil nil nil)

(autoload 'build-mail-aliases "mail-abbrevs" "\
Read mail aliases from .mailrc and set mail-aliases." nil nil)

(autoload 'define-mail-alias "mail-abbrevs" "\
Define NAME as a mail-alias that translates to DEFINITION.
If DEFINITION contains multiple addresses, separate them with commas." t nil)

;;;***

;;;### (autoloads (makefile-mode) "makefile" "modes/makefile.el" (11570 13231))
;;; Generated autoloads from modes/makefile.el

(autoload 'makefile-mode "makefile" "\
Major mode for editing Makefiles.
Calling this function invokes the function(s) \"makefile-mode-hook\" before
doing anything else.

\\{makefile-mode-map}

In the browser, use the following keys:

\\{makefile-browser-map}

makefile-mode can be configured by modifying the following
variables:

makefile-mode-name:
    The \"pretty name\" of makefile-mode, as it
    appears in the modeline.

makefile-browser-buffer-name:
    Name of the macro- and target browser buffer.

makefile-target-colon:
    The string that gets appended to all target names
    inserted by makefile-insert-target.
    \":\" or \"::\" are quite common values.

makefile-macro-assign:
   The string that gets appended to all macro names
   inserted by makefile-insert-macro.
   The normal value should be \" = \", since this is what
   standard make expects. However, newer makes such as dmake
   allow a larger variety of different macro assignments, so you
   might prefer to use \" += \" or \" := \" .

makefile-tab-after-target-colon:
   If you want a TAB (instead of a space) to be appended after the
   target colon, then set this to a non-nil value.

makefile-browser-leftmost-column:
   Number of blanks to the left of the browser selection mark.

makefile-browser-cursor-column:
   Column in which the cursor is positioned when it moves
   up or down in the browser.

makefile-browser-selected-mark:
   String used to mark selected entries in the browser.

makefile-browser-unselected-mark:
   String used to mark unselected entries in the browser.

makefile-browser-auto-advance-after-selection-p:
   If this variable is set to a non-nil value the cursor
   will automagically advance to the next line after an item
   has been selected in the browser.

makefile-pickup-everything-picks-up-filenames-p:
   If this variable is set to a non-nil value then
   makefile-pickup-everything also picks up filenames as targets
   (i.e. it calls makefile-find-filenames-as-targets), otherwise
   filenames are omitted.

makefile-cleanup-continuations-p:
   If this variable is set to a non-nil value then makefile-mode
   will assure that no line in the file ends with a backslash
   (the continuation character) followed by any whitespace.
   This is done by silently removing the trailing whitespace, leaving
   the backslash itself intact.
   IMPORTANT: Please note that enabling this option causes makefile-mode
   to MODIFY A FILE WITHOUT YOUR CONFIRMATION when 'it seems necessary'.

makefile-browser-hook:
   A function or list of functions to be called just before the
   browser is entered. This is executed in the makefile buffer.

makefile-special-targets-list:
   List of special targets. You will be offered to complete
   on one of those in the minibuffer whenever you enter a \".\"
   at the beginning of a line in makefile-mode." t nil)

;;;***

;;;### (autoloads (modula-2-mode) "modula2" "modes/modula2.el" (11555 56784))
;;; Generated autoloads from modes/modula2.el

(autoload 'modula-2-mode "modula2" "\
This is a mode intended to support program development in Modula-2.
All control constructs of Modula-2 can be reached by typing
Control-C followed by the first character of the construct.
\\{m2-mode-map}
  Control-c b begin         Control-c c case
  Control-c d definition    Control-c e else
  Control-c f for           Control-c h header
  Control-c i if            Control-c m module
  Control-c l loop          Control-c o or
  Control-c p procedure     Control-c Control-w with
  Control-c r record        Control-c s stdio
  Control-c t type          Control-c u until
  Control-c v var           Control-c w while
  Control-c x export        Control-c y import
  Control-c { begin-comment Control-c } end-comment
  Control-c Control-z suspend-emacs     Control-c Control-t toggle
  Control-c Control-c compile           Control-x ` next-error
  Control-c Control-l link

   m2-indent controls the number of spaces for each indentation.
   m2-compile-command holds the command to compile a Modula-2 program.
   m2-link-command holds the command to link a Modula-2 program." t nil)

;;;***

;;;### (autoloads (nroff-mode) "nroff-mode" "modes/nroff-mode.el" (11352 15852))
;;; Generated autoloads from modes/nroff-mode.el

(autoload 'nroff-mode "nroff-mode" "\
Major mode for editing text intended for nroff to format.
\\{nroff-mode-map}
Turning on Nroff mode runs `text-mode-hook', then `nroff-mode-hook'.
Also, try `nroff-electric-mode', for automatically inserting
closing requests for requests that are used in matched pairs." t nil)

;;;***

;;;### (autoloads (outline-mode) "outline" "modes/outline.el" (11555 56785))
;;; Generated autoloads from modes/outline.el

(defvar outline-regexp (purecopy "[*\^L]+") "\
*Regular expression to match the beginning of a heading.
Any line whose beginning matches this regexp is considered to start a heading.
The recommended way to set this is with a Local Variables: list
in the file it applies to.  See also outline-heading-end-regexp.")

(defvar outline-heading-end-regexp (purecopy "[\n
]") "\
*Regular expression to match the end of a heading line.
You can assume that point is at the beginning of a heading
when this regexp is searched for.  The heading ends at the end of the match.
The recommended way to set this is with a Local Variables: list
in the file it applies to.")

(autoload 'outline-mode "outline" "\
Set major mode for editing outlines with selective display.
Headings are lines which start with asterisks: one for major headings,
two for subheadings, etc.  Lines not starting with asterisks are body lines. 

Body text or subheadings under a heading can be made temporarily
invisible, or visible again.  Invisible lines are attached to the end 
of the heading, so they move with it, if the line is killed and yanked
back.  A heading with text hidden under it is marked with an ellipsis (...).

Commands:
C-c C-n   outline-next-visible-heading      move by visible headings
C-c C-p   outline-previous-visible-heading
C-c C-f   outline-forward-same-level        similar but skip subheadings
C-c C-b   outline-backward-same-level
C-c C-u   outline-up-heading		    move from subheading to heading

Meta-x hide-body	make all text invisible (not headings).
Meta-x show-all		make everything in buffer visible.

The remaining commands are used when point is on a heading line.
They apply to some of the body or subheadings of that heading.
C-c C-h   hide-subtree	make body and subheadings invisible.
C-c C-s   show-subtree	make body and subheadings visible.
C-c C-i   show-children	make direct subheadings visible.
		 No effect on body, or subheadings 2 or more levels down.
		 With arg N, affects subheadings N levels down.
M-x hide-entry	   make immediately following body invisible.
M-x show-entry	   make it visible.
M-x hide-leaves	   make body under heading and under its subheadings invisible.
		     The subheadings remain visible.
M-x show-branches  make all subheadings at all levels visible.

The variable outline-regexp can be changed to control what is a heading.
A line is a heading if outline-regexp matches something at the
beginning of the line.  The longer the match, the deeper the level.

Turning on outline mode calls the value of text-mode-hook and then of
outline-mode-hook, if they are non-nil." t nil)

;;;***

;;;### (autoloads (pascal-mode) "pascal" "modes/pascal.el" (11493 30980))
;;; Generated autoloads from modes/pascal.el

(autoload 'pascal-mode "pascal" "\
Major mode for editing Pascal code.
Tab indents for Pascal code.
Delete converts tabs to spaces as it moves back.
\\{pascal-mode-map}
Variables controlling indentation style:
 pascal-tab-always-indent (default t)
    Non-nil means TAB in Pascal mode should always reindent the current line,
    regardless of where in the line point is when the TAB command is used.
 pascal-auto-newline (default nil)
    Non-nil means automatically newline after semicolons and the punctation
    mark after an end.
 pascal-auto-endcomments (default t)
    Non-nil means automatically set name of function or `case' in braces after
    after the `end' if this end ends a function or a case block.
 pascal-indent-level (default 3)
    Indentation of Pascal statements within surrounding block.
 pascal-continued-expr (default 1)
    Indentation of a line that is a continued expression.
 pascal-typedecl-indent (default 10)
    Indentation to the `=' in type declarations. (Or constant declarations.)
 pascal-vardecl-indent (default 20)
    Indentation to the `:' in var declarations.
 pascal-label-offset (default -1)
    Extra indentation for line that is a label, case statement or part of
    a record block.
 pascal-case-offset (default 2)
    Extra indent to the `:' in case statements.

The only auto indention this mode doesn't fully support is if there is a
case within a type declaration.  However, this is seldom used.

When typing text, you should not worry about to get right indentions, they
will be set when you hit return. The mode will also automatically delete the
whitespaces between `*' and `)' when ending a starcomment.

Turning on Pascal mode calls the value of the variable pascal-mode-hook with
no args, if that value is non-nil." t nil)

;;;***

;;;### (autoloads (perl-mode) "perl-mode" "modes/perl-mode.el" (11565 27740))
;;; Generated autoloads from modes/perl-mode.el

(autoload 'perl-mode "perl-mode" "\
Major mode for editing Perl code.
Expression and list commands understand all Perl brackets.
Tab indents for Perl code.
Comments are delimited with # ... \\n.
Paragraphs are separated by blank lines only.
Delete converts tabs to spaces as it moves back.
\\{perl-mode-map}
Variables controlling indentation style:
 perl-tab-always-indent
    Non-nil means TAB in Perl mode should always indent the current line,
    regardless of where in the line point is when the TAB command is used.
 perl-tab-to-comment
    Non-nil means that for lines which don't need indenting, TAB will
    either delete an empty comment, indent an existing comment, move 
    to end-of-line, or if at end-of-line already, create a new comment.
 perl-nochange
    Lines starting with this regular expression will not be auto-indented.
 perl-indent-level
    Indentation of Perl statements within surrounding block.
    The surrounding block's indentation is the indentation
    of the line on which the open-brace appears.
 perl-continued-statement-offset
    Extra indentation given to a substatement, such as the
    then-clause of an if or body of a while.
 perl-continued-brace-offset
    Extra indentation given to a brace that starts a substatement.
    This is in addition to perl-continued-statement-offset.
 perl-brace-offset
    Extra indentation for line if it starts with an open brace.
 perl-brace-imaginary-offset
    An open brace following other text is treated as if it were
    this far to the right of the start of its line.
 perl-label-offset
    Extra indentation for line that is a label.

Various indentation styles:       K&R  BSD  BLK  GNU  LW
  perl-indent-level                5    8    0    2    4
  perl-continued-statement-offset  5    8    4    2    4
  perl-continued-brace-offset      0    0    0    0   -4
  perl-brace-offset               -5   -8    0    0    0
  perl-brace-imaginary-offset      0    0    4    0    0
  perl-label-offset               -5   -8   -2   -2   -2

Turning on Perl mode calls the value of the variable perl-mode-hook with no 
args, if that value is non-nil." t nil)

;;;***

;;;### (autoloads (edit-picture) "picture" "modes/picture.el" (11555 56787))
;;; Generated autoloads from modes/picture.el

(autoload 'edit-picture "picture" "\
Switch to Picture mode, in which a quarter-plane screen model is used.
Printing characters replace instead of inserting themselves with motion
afterwards settable by these commands:
  C-c <	  Move left after insertion.
  C-c >	  Move right after insertion.
  C-c ^	  Move up after insertion.
  C-c .	  Move down after insertion.
  C-c `	  Move northwest (nw) after insertion.
  C-c '	  Move northeast (ne) after insertion.
  C-c /	  Move southwest (sw) after insertion.
  C-c \\   Move southeast (se) after insertion.
The current direction is displayed in the mode line.  The initial
direction is right.  Whitespace is inserted and tabs are changed to
spaces when required by movement.  You can move around in the buffer
with these commands:
  C-p	  Move vertically to SAME column in previous line.
  C-n	  Move vertically to SAME column in next line.
  C-e	  Move to column following last non-whitespace character.
  C-f	  Move right inserting spaces if required.
  C-b	  Move left changing tabs to spaces if required.
  C-c C-f Move in direction of current picture motion.
  C-c C-b Move in opposite direction of current picture motion.
  Return  Move to beginning of next line.
You can edit tabular text with these commands:
  M-Tab	  Move to column beneath (or at) next interesting character.
	    `Indents' relative to a previous line.
  Tab	  Move to next stop in tab stop list.
  C-c Tab Set tab stops according to context of this line.
	    With ARG resets tab stops to default (global) value.
	    See also documentation of variable	picture-tab-chars
	    which defines \"interesting character\".  You can manually
	    change the tab stop list with command \\[edit-tab-stops].
You can manipulate text with these commands:
  C-d	  Clear (replace) ARG columns after point without moving.
  C-c C-d Delete char at point - the command normally assigned to C-d.
  Delete  Clear (replace) ARG columns before point, moving back over them.
  C-k	  Clear ARG lines, advancing over them.	 The cleared
	    text is saved in the kill ring.
  C-o	  Open blank line(s) beneath current line.
You can manipulate rectangles with these commands:
  C-c C-k Clear (or kill) a rectangle and save it.
  C-c C-w Like C-c C-k except rectangle is saved in named register.
  C-c C-y Overlay (or insert) currently saved rectangle at point.
  C-c C-x Like C-c C-y except rectangle is taken from named register.
  \\[copy-rectangle-to-register]   Copies a rectangle to a register.
  \\[advertised-undo]   Can undo effects of rectangle overlay commands
	    commands if invoked soon enough.
You can return to the previous mode with:
  C-c C-c Which also strips trailing whitespace from every line.
	    Stripping is suppressed by supplying an argument.

Entry to this mode calls the value of  edit-picture-hook  if non-nil.

Note that Picture mode commands will work outside of Picture mode, but
they are not defaultly assigned to keys." t nil)

(fset 'picture-mode 'edit-picture)

;;;***

;;;### (autoloads (postscript-mode) "postscript" "modes/postscript.el" (11555 56788))
;;; Generated autoloads from modes/postscript.el

(autoload 'postscript-mode "postscript" "\
Major mode for editing PostScript files.

\\[ps-execute-buffer] will send the contents of the buffer to the NeWS
server using psh(1).  \\[ps-execute-region] sends the current region.
\\[ps-shell] starts an interactive psh(1) window which will be used for
subsequent \\[ps-execute-buffer] or \\[ps-execute-region] commands.

In this mode, TAB and \\[indent-region] attempt to indent code
based on the position of {}, [], and begin/end pairs.  The variable
ps-indent-level controls the amount of indentation used inside
arrays and begin/end pairs.  

\\{ps-mode-map}

\\[postscript-mode] calls the value of the variable postscript-mode-hook 
with no args, if that value is non-nil." t nil)

;;;***

;;;### (autoloads (run-prolog inferior-prolog-mode prolog-mode) "prolog" "modes/prolog.el" (11555 56790))
;;; Generated autoloads from modes/prolog.el

(autoload 'prolog-mode "prolog" "\
Major mode for editing Prolog code for Prologs.
Blank lines and `%%...' separate paragraphs.  `%'s start comments.
Commands:
\\{prolog-mode-map}
Entry to this mode calls the value of prolog-mode-hook
if that value is non-nil." t nil)

(autoload 'inferior-prolog-mode "prolog" "\
Major mode for interacting with an inferior Prolog process.

The following commands are available:
\\{inferior-prolog-mode-map}

Entry to this mode calls the value of prolog-mode-hook with no arguments,
if that value is non-nil.  Likewise with the value of comint-mode-hook.
prolog-mode-hook is called after comint-mode-hook.

You can send text to the inferior Prolog from other buffers
using the commands send-region, send-string and \\[prolog-consult-region].

Commands:
Tab indents for Prolog; with argument, shifts rest
 of expression rigidly with the current line.
Paragraphs are separated only by blank lines and '%%'. '%'s start comments.

Return at end of buffer sends line as input.
Return not at end copies rest of line to end and sends it.
\\[comint-kill-input] and \\[backward-kill-word] are kill commands, imitating normal Unix input editing.
\\[comint-interrupt-subjob] interrupts the shell or its current subjob if any.
\\[comint-stop-subjob] stops. \\[comint-quit-subjob] sends quit signal." t nil)

(autoload 'run-prolog "prolog" "\
Run an inferior Prolog process, input and output via buffer *prolog*." t nil)

;;;***

;;;### (autoloads (scheme-mode) "scheme" "modes/scheme.el" (11555 56791))
;;; Generated autoloads from modes/scheme.el

(autoload 'scheme-mode "scheme" "\
Major mode for editing Scheme code.
Editing commands are similar to those of lisp-mode.

In addition, if an inferior Scheme process is running, some additional
commands will be defined, for evaluating expressions and controlling
the interpreter, and the state of the process will be displayed in the
modeline of all Scheme buffers.  The names of commands that interact
with the Scheme process start with \"xscheme-\".  For more information
see the documentation for xscheme-interaction-mode.

Commands:
Delete converts tabs to spaces as it moves back.
Blank lines separate paragraphs.  Semicolons start comments.
\\{scheme-mode-map}
Entry to this mode calls the value of scheme-mode-hook
if that value is non-nil." t nil)

;;;***

;;;### (autoloads (scribe-mode) "scribe" "modes/scribe.el" (11555 56793))
;;; Generated autoloads from modes/scribe.el

(autoload 'scribe-mode "scribe" "\
Major mode for editing files of Scribe (a text formatter) source.
Scribe-mode is similar text-mode, with a few extra commands added.
\\{scribe-mode-map}

Interesting variables:

scribe-fancy-paragraphs
  Non-nil makes Scribe mode use a different style of paragraph separation.

scribe-electric-quote
  Non-nil makes insert of double quote use `` or '' depending on context.

scribe-electric-parenthesis
  Non-nil makes an open-parenthesis char (one of `([<{')
  automatically insert its close if typed after an @Command form." t nil)

;;;***

;;;### (autoloads (mail-other-window mail mail-mode) "sendmail" "modes/sendmail.el" (11563 43311))
;;; Generated autoloads from modes/sendmail.el

(defvar mail-self-blind nil "\
Non-nil means insert BCC to self in messages to be sent.
This is done when the message is initialized,
so you can remove or alter the BCC field to override the default.")

(defvar mail-interactive nil "\
Non-nil means when sending a message wait for and display errors.
nil means let mailer mail back a message to report errors.")

(defvar rmail-ignored-headers (purecopy (concat "^\\(" (mapconcat 'identity '("Sender:" "References:" "Return-Path:" "Received:" "[^: 	\n]*Message-ID:" "Errors-To:" "Path:" "Expires:" "Xref:" "Lines:" "Approved:" "Distribution:" "Content-Length:" "Mime-Version:" "Content-Type:" "Content-Transfer-Encoding:" "X400-Received:" "X400-Originator:" "X400-Mts-Identifier:" "X400-Content-Type:" "Content-Identifier:" "Status:" "Summary-Line:" "X-Attribution:" "Via:" "Sent-Via:" "Mail-From:" "Origin:" "Comments:" "Originator:" "NF-ID:" "NF-From:" "Posting-Version:" "Posted:" "Posted-Date:" "Date-Received:" "Relay-Version:" "Article-I\\.D\\.:" "NNTP-Version:" "NNTP-Posting-Host:" "X-Mailer:" "X-Newsreader:" "News-Software:" "X-Received:" "X-References:" "Remailed-") "\\|") "\\)")) "\
*Gubbish header fields one would rather not see.")

(defvar mail-yank-ignored-headers (purecopy (concat rmail-ignored-headers "\\|" "^\\(" (mapconcat 'identity '("Resent-To:" "Resent-By:" "Resent-CC:" "To:" "Subject:" "In-Reply-To:") "\\|") "\\)")) "\
Delete these headers from old message when it's inserted in a reply.")

(defvar send-mail-function 'sendmail-send-it "\
Function to call to send the current buffer as mail.
The headers are be delimited by a line which is `mail-header-separator'.")

(defvar mail-header-separator (purecopy "--text follows this line--") "\
*Line used to separate headers from text in messages being composed.")

(defvar mail-archive-file-name nil "\
*Name of file to write all outgoing messages in, or nil for none.
Do not use an rmail file here!  Instead, use its inbox file.")

(defvar mail-signature nil "\
*Text inserted at end of mail buffer when a message is initialized.
If t, it means to insert the contents of the file `mail-signature-file'.")

(autoload 'mail-mode "sendmail" "\
Major mode for editing mail to be sent.
Like Text Mode but with these additional commands:
C-c C-s  mail-send (send the message)    C-c C-c  mail-send-and-exit
C-c C-f  move to a header field (and create it if there isn't):
	 C-c C-f C-t  move to To:	C-c C-f C-s  move to Subj:
	 C-c C-f C-b  move to BCC:	C-c C-f C-c  move to CC:
C-c C-t  move to message text.
C-c C-y  mail-yank-original (insert current message, in Rmail).
C-c C-w  mail-signature (insert signature file).
C-c C-q  mail-fill-yanked-message (fill what was yanked).
C-c C-v  mail-sent-via (add a sent-via field for each To or CC)

Button3  Popup menu with the above commands." t nil)

(autoload 'mail "sendmail" "\
Edit a message to be sent.  Prefix arg means resume editing (don't erase).
When this function returns, the buffer `*mail*' is selected.
The value is t if the message was newly initialized; otherwise, nil.

\\<mail-mode-map>
While editing message, type \\[mail-send-and-exit] to send the message and exit.

Various special commands starting with C-c are available in sendmail mode
to move to message header fields:
\\{mail-mode-map}

The variable `mail-signature' controls whether the signature file
`mail-signature-file' is inserted immediately.

If `mail-insert-signature' is non-nil, the signature file, denoted by
the variable `mail-signature-file', is automatically inserted at the
end of the message before sending.  (Otherwise use C-c C-w).

If `mail-self-blind' is non-nil, a BCC to yourself is inserted
when the message is initialized.

If `mail-default-reply-to' is non-nil, it should be an address (a string);
a Reply-to: field with that address is inserted.

If `mail-archive-file-name' is non-nil, an FCC field with that file name
is inserted.

If `mail-setup-hook' is bound, its value is called with no arguments
after the message is initialized.  It can add more default fields.

When calling from a program, the second through fifth arguments
 TO, SUBJECT, IN-REPLY-TO and CC specify if non-nil
 the initial contents of those header fields.
 These arguments should not have final newlines.
The sixth argument REPLYBUFFER is a buffer whose contents
 should be yanked if the user types C-c C-y.
The seventh argument ACTIONS is a list of actions to take
 if/when the message is sent.  Each action looks like (FUNCTION . ARGS);
 when the message is sent, we apply FUNCTION to ARGS.
 This is how Rmail arranges to mark messages `answered'." t nil)

(autoload 'mail-other-window "sendmail" "\
Like `mail' command, but display mail buffer in another window." t nil)

;;;***

;;;### (autoloads (sgml-mode) "sgml-mode" "modes/sgml-mode.el" (11551 28145))
;;; Generated autoloads from modes/sgml-mode.el

(autoload 'sgml-mode "sgml-mode" "\
Major mode for editing SGML.
Makes > display the matching <.  Makes / display matching /.
Use \\[sgml-validate] to validate your document with an SGML parser." t nil)

;;;***

;;;### (autoloads (latex-mode plain-tex-mode tex-mode) "tex-mode" "modes/tex-mode.el" (11555 56795))
;;; Generated autoloads from modes/tex-mode.el

(autoload 'tex-mode "tex-mode" "\
Major mode for editing files of input for TeX, LaTeX, or SliTeX.
Tries to determine (by looking at the beginning of the file) whether
this file is for plain TeX, LaTeX, or SliTeX and calls plain-tex-mode,
latex-mode, or slitex-mode, respectively.  If it cannot be determined,
such as if there are no commands in the file, the value of tex-default-mode
is used." t nil)

(fset 'TeX-mode 'tex-mode)

(fset 'LaTeX-mode 'latex-mode)

(autoload 'plain-tex-mode "tex-mode" "\
Major mode for editing files of input for plain TeX.
Makes $ and } display the characters they match.
Makes \" insert `` when it seems to be the beginning of a quotation,
and '' when it appears to be the end; it inserts \" only after a \\.

Use \\[tex-region] to run TeX on the current region, plus a \"header\"
copied from the top of the file (containing macro definitions, etc.),
running TeX under a special subshell.  \\[tex-buffer] does the whole buffer.
\\[tex-file] saves the buffer and then processes the file.
\\[tex-print] prints the .dvi file made by any of these.
\\[tex-view] previews the .dvi file made by any of these.
\\[tex-bibtex-file] runs bibtex on the file of the current buffer.

Use \\[validate-tex-buffer] to check buffer for paragraphs containing
mismatched $'s or braces.

Special commands:
\\{tex-mode-map}

Mode variables:
tex-run-command
	Command string used by \\[tex-region] or \\[tex-buffer].
tex-directory
	Directory in which to create temporary files for TeX jobs
	run by \\[tex-region] or \\[tex-buffer].
tex-dvi-print-command
	Command string used by \\[tex-print] to print a .dvi file.
tex-alt-dvi-print-command
	Alternative command string used by \\[tex-print] (when given a prefix
	argument) to print a .dvi file.
tex-dvi-view-command
	Command string used by \\[tex-view] to preview a .dvi file.
tex-show-queue-command
	Command string used by \\[tex-show-print-queue] to show the print
	queue that \\[tex-print] put your job on.

Entering Plain-tex mode calls the value of text-mode-hook, then the value of
tex-mode-hook, and then the value of plain-tex-mode-hook.  When the special
subshell is initiated, the value of tex-shell-hook is called." t nil)

(fset 'plain-TeX-mode 'plain-tex-mode)

(autoload 'latex-mode "tex-mode" "\
Major mode for editing files of input for LaTeX.
Makes $ and } display the characters they match.
Makes \" insert `` when it seems to be the beginning of a quotation,
and '' when it appears to be the end; it inserts \" only after a \\.

Use \\[tex-region] to run LaTeX on the current region, plus the preamble
copied from the top of the file (containing \\documentstyle, etc.),
running LaTeX under a special subshell.  \\[tex-buffer] does the whole buffer.
\\[tex-file] saves the buffer and then processes the file.
\\[tex-print] prints the .dvi file made by any of these.
\\[tex-view] previews the .dvi file made by any of these.
\\[tex-bibtex-file] runs bibtex on the file of the current buffer.

Use \\[validate-tex-buffer] to check buffer for paragraphs containing
mismatched $'s or braces.

Special commands:
\\{tex-mode-map}

Mode variables:
latex-run-command
	Command string used by \\[tex-region] or \\[tex-buffer].
tex-directory
	Directory in which to create temporary files for LaTeX jobs
	run by \\[tex-region] or \\[tex-buffer].
tex-dvi-print-command
	Command string used by \\[tex-print] to print a .dvi file.
tex-alt-dvi-print-command
	Alternative command string used by \\[tex-print] (when given a prefix
	argument) to print a .dvi file.
tex-dvi-view-command
	Command string used by \\[tex-view] to preview a .dvi file.
tex-show-queue-command
	Command string used by \\[tex-show-print-queue] to show the print
	queue that \\[tex-print] put your job on.

Entering Latex mode calls the value of text-mode-hook, then the value of
tex-mode-hook, and then the value of latex-mode-hook.  When the special
subshell is initiated, the value of tex-shell-hook is called." t nil)

;;;***

;;;### (autoloads (texinfo-mode) "texinfo" "modes/texinfo.el" (11555 58371))
;;; Generated autoloads from modes/texinfo.el

(autoload 'texinfo-mode "texinfo" "\
Major mode for editing Texinfo files.

  It has these extra commands:
\\{texinfo-mode-map}

  These are files that are used as input for TeX to make printed manuals
and also to be turned into Info files by \\[texinfo-format-buffer] or
`makeinfo'.  These files must be written in a very restricted and
modified version of TeX input format.

  Editing commands are like text-mode except that the syntax table is
set up so expression commands skip Texinfo bracket groups.  To see
what the Info version of a region of the Texinfo file will look like,
use \\[texinfo-format-region].  This command runs Info on the current region
of the Texinfo file and formats it properly.

  You can show the structure of a Texinfo file with \\[texinfo-show-structure].
This command shows the structure of a Texinfo file by listing the
lines with the @-sign commands for @chapter, @section, and the like.
These lines are displayed in another window called the *Occur* window.
In that window, you can position the cursor over one of the lines and
use \\[occur-mode-goto-occurrence], to jump to the corresponding spot
in the Texinfo file.

  In addition, Texinfo mode provides commands that insert various
frequently used @-sign commands into the buffer.  You can use these
commands to save keystrokes.  And you can insert balanced braces with
\\[texinfo-insert-braces] and later use the command \\[up-list] to
move forward past the closing brace.

Also, Texinfo mode provides functions for automatically creating or
updating menus and node pointers.  These functions

  * insert the `Next', `Previous' and `Up' pointers of a node,
  * insert or update the menu for a section, and
  * create a master menu for a Texinfo source file.

Here are the functions:

    texinfo-update-node                \\[texinfo-update-node]
    texinfo-every-node-update          \\[texinfo-every-node-update]
    texinfo-sequential-node-update 

    texinfo-make-menu                  \\[texinfo-make-menu]
    texinfo-all-menus-update           \\[texinfo-all-menus-update]
    texinfo-master-menu

    texinfo-indent-menu-description (column &optional region-p)

The `texinfo-column-for-description' variable specifies the column to
which menu descriptions are indented. 

Passed an argument (a prefix argument, if interactive), the
`texinfo-update-node' and `texinfo-make-menu' functions do their jobs
in the region.

To use the updating commands, you must structure your Texinfo file
hierarchically, such that each `@node' line, with the exception of the
Top node, is accompanied by some kind of section line, such as an
`@chapter' or `@section' line.

If the file has a `top' node, it must be called `top' or `Top' and
be the first node in the file.

Entering Texinfo mode calls the value of text-mode-hook, and then the
value of texinfo-mode-hook." t nil)

;;;***

;;;### (autoloads (view-mode view-buffer view-file) "view-less" "modes/view-less.el" (11555 56797))
;;; Generated autoloads from modes/view-less.el

(autoload 'view-file "view-less" "\
Find FILE, enter view mode.  With prefix arg use other window." t nil)

(autoload 'view-buffer "view-less" "\
Switch to BUF, enter view mode.  With prefix arg use other window." t nil)

(autoload 'view-mode "view-less" "\
Mode for viewing text, with bindings like `less'.
Commands are:
\\<view-mode-map>
0..9	prefix args
-	prefix minus
\\[scroll-up]	page forward
\\[scroll-down]	page back
\\[view-scroll-lines-up]	scroll prefix-arg lines forward, default 1.
\\[view-scroll-lines-down]	scroll prefix-arg lines backward, default 1.
\\[view-scroll-some-lines-down]	scroll prefix-arg lines backward, default 10.
\\[view-scroll-some-lines-up]	scroll prefix-arg lines forward, default 10.
\\[what-line]	print line number
\\[view-mode-describe]	print this help message
\\[view-search-forward]	regexp search, uses previous string if you just hit RET
\\[view-search-backward]	as above but searches backward
\\[view-repeat-search]	repeat last search
\\[view-goto-line]	goto line prefix-arg, default 1
\\[view-Goto-line]	goto line prefix-arg, default last line
\\[view-goto-percent]	goto a position by percentage
\\[toggle-truncate-lines]	toggle truncate-lines
\\[view-file]	view another file
\\[view-buffer]	view another buffer
\\[view-cleanup-backspaces]	cleanup backspace constructions
\\[shell-command]	execute a shell command
\\[shell-command-on-region]	execute a shell command with the region as input
\\[view-quit]	exit view-mode, and bury the current buffer.

If invoked with the optional (prefix) arg non-nil, view-mode cleans up
backspace constructions.

More precisely:
\\{view-mode-map}" t nil)

;;;***

;;;### (autoloads (change-log-mode add-change-log-entry-other-window add-change-log-entry find-change-log prompt-for-change-log-name) "add-log" "packages/add-log.el" (11555 57046))
;;; Generated autoloads from packages/add-log.el

(defvar change-log-default-name nil "\
*Name of a change log file for \\[add-change-log-entry].")

(defvar add-log-current-defun-function nil "\
*If non-nil, function to guess name of current function from surrounding text.
\\[add-change-log-entry] calls this function (if nil, `add-log-current-defun'
instead) with no arguments.  It returns a string or nil if it cannot guess.")

(defvar add-log-full-name nil "\
*Full name of user, for inclusion in ChangeLog daily headers.
This defaults to the value returned by the `user-full-name' function.")

(defvar add-log-mailing-address nil "\
*Electronic mail address of user, for inclusion in ChangeLog daily headers.
This defaults to the value returned by `user-login-name', followed by
an `@' character, followed by the value returned by `system-name'.")

(autoload 'prompt-for-change-log-name "add-log" "\
Prompt for a change log name." nil nil)

(autoload 'find-change-log "add-log" "\
Find a change log file for \\[add-change-log-entry] and return the name.
Optional arg FILE-NAME is a name to try first.
If FILE-NAME is nil, use the value of `change-log-default-name' if non-nil.
Failing that, use \"ChangeLog\" in the current directory.
If the file does not exist in the named directory, successive parent
directories are tried.

Once a file is found, `change-log-default-name' is set locally in the
current buffer to the complete file name." nil nil)

(autoload 'add-change-log-entry "add-log" "\
Find change log file and add an entry for today.
Optional arg (interactive prefix) non-nil means prompt for user name and site.
Second arg is file name of change log.  If nil, uses `change-log-default-name'.
Third arg OTHER-WINDOW non-nil means visit in other window.
Fourth arg NEW-ENTRY non-nil means always create a new entry at the front;
never append to an existing entry." t nil)

(autoload 'add-change-log-entry-other-window "add-log" "\
Find change log file in other window and add an entry for today.
Optional arg (interactive prefix) non-nil means prompt for user name and site.
Second arg is file name of change log.  If nil, uses `change-log-default-name'." t nil)
(define-key ctl-x-4-map "a" 'add-change-log-entry-other-window)

(autoload 'change-log-mode "add-log" "\
Major mode for editing change logs; like Indented Text Mode.
Prevents numeric backups and sets `left-margin' to 8 and `fill-column' to 74.
New log entries are usually made with \\[add-change-log-entry] or \\[add-change-log-entry-other-window].
Each entry behaves as a paragraph, and the entries for one day as a page.
Runs `change-log-mode-hook'." t nil)

;;;***

;;;### (autoloads (super-apropos apropos) "apropos" "packages/apropos.el" (11555 56805))
;;; Generated autoloads from packages/apropos.el

(autoload 'apropos "apropos" "\
Show all symbols whose names contain matches for REGEXP.
If optional argument DO-ALL is non-nil, does more (time-consuming) work such as
showing key bindings.  Optional argument PRED is called with each symbol, and
if it returns nil, the symbol is not shown.  Returns list of symbols and
documentation found." t nil)

(autoload 'super-apropos "apropos" "\
Show symbols whose names/documentation contain matches for REGEXP.
If optional argument DO-ALL is non-nil, does more (time-consuming) work such as
showing key bindings and documentation that is not stored in the documentation
file.  Returns list of symbols and documentation found." t nil)

;;;***

;;;### (autoloads (list-bookmarks bookmark-load bookmark-save bookmark-write bookmark-delete bookmark-insert bookmark-rename bookmark-locate bookmark-relocate bookmark-jump bookmark-set) "bookmark" "packages/bookmark.el" (11557 4859))
;;; Generated autoloads from packages/bookmark.el

(if (symbolp (key-binding "r")) nil (progn (define-key ctl-x-map "rb" 'bookmark-jump) (define-key ctl-x-map "rm" 'bookmark-set) (define-key ctl-x-map "rl" 'list-bookmarks)))

(defvar bookmark-map nil "\
Keymap containing bindings to bookmark functions.
It is not bound to any key by default: to bind it
so that you have a bookmark prefix, just use `global-set-key' and bind a
key of your choice to `bookmark-map'.  All interactive bookmark
functions have a binding in this keymap.")

(define-prefix-command 'bookmark-map)

(define-key bookmark-map "x" 'bookmark-set)

(define-key bookmark-map "m" 'bookmark-set)

(define-key bookmark-map "j" 'bookmark-jump)

(define-key bookmark-map "g" 'bookmark-jump)

(define-key bookmark-map "i" 'bookmark-insert)

(define-key bookmark-map "e" 'edit-bookmarks)

(define-key bookmark-map "f" 'bookmark-locate)

(define-key bookmark-map "r" 'bookmark-rename)

(define-key bookmark-map "d" 'bookmark-delete)

(define-key bookmark-map "l" 'bookmark-load)

(define-key bookmark-map "w" 'bookmark-write)

(define-key bookmark-map "s" 'bookmark-save)

(autoload 'bookmark-set "bookmark" "\
Set a bookmark named NAME inside a file.  
With prefix arg, will not overwrite a bookmark that has the same name
as NAME if such a bookmark already exists, but instead will \"push\"
the new bookmark onto the bookmark alist.  Thus the most recently set
bookmark with name NAME would be the one in effect at any given time,
but the others are still there, should you decide to delete the most
recent one.

To yank words from the text of the buffer and use them as part of the
bookmark name, type C-w while setting a bookmark.  Successive C-w's
yank successive words.

Typing C-v inserts the name of the current file being visited. Typing
C-u inserts the name of the last bookmark used in the buffer (as an
aid in using a single bookmark name to track your progress through a
large file).  If no bookmark was used, then C-u behaves like C-v and
inserts the name of the file being visited.

Use \\[bookmark-delete] to remove bookmarks (you give it a name,
and it removes only the first instance of a bookmark with that name from
the list of bookmarks.)" t nil)

(autoload 'bookmark-jump "bookmark" "\
Jump to bookmark BOOKMARK (a point in some file).  
You may have a problem using this function if the value of variable
`bookmark-alist' is nil.  If that happens, you need to load in some
bookmarks.  See help on function `bookmark-load' for more about
this.

If the file pointed to by BOOKMARK no longer exists, you will be asked
if you wish to give the bookmark a new location, and bookmark-jump
will then jump to the new location, as well as recording it in place
of the old one in the permanent bookmark record." t nil)

(autoload 'bookmark-relocate "bookmark" "\
Relocate BOOKMARK -- prompts for a filename, and makes an already
existing bookmark point to that file, instead of the one it used to
point at.  Useful when a file has been renamed after a bookmark was
set in it." t nil)

(autoload 'bookmark-locate "bookmark" "\
Insert the name of the file associated with BOOKMARK.
Optional second arg NO-INSERTION means merely return the filename as a
string." t nil)

(autoload 'bookmark-rename "bookmark" "\
Change the name of OLD-BOOKMARK to NEWNAME.  
If called from keyboard, prompts for OLD-BOOKMARK and NEWNAME.
If called from menubar, OLD-BOOKMARK is selected from a menu, and
prompts for NEWNAME. 
If called from Lisp, prompts for NEWNAME if only OLD-BOOKMARK was
passed as an argument.  If called with two strings, then no prompting
is done.  You must pass at least OLD-BOOKMARK when calling from Lisp.

While you are entering the new name, consecutive C-w's insert
consectutive words from the text of the buffer into the new bookmark
name, and C-v inserts the name of the file." t nil)

(autoload 'bookmark-insert "bookmark" "\
Insert the text of the file pointed to by bookmark BOOKMARK.  
You may have a problem using this function if the value of variable
`bookmark-alist' is nil.  If that happens, you need to load in some
bookmarks.  See help on function `bookmark-load' for more about
this." t nil)

(autoload 'bookmark-delete "bookmark" "\
Delete the bookmark named NAME from the bookmark list.  
Removes only the first instance of a bookmark with that name.  If
there are one or more other bookmarks with the same name, they will
not be deleted.  Defaults to the \"current\" bookmark (that is, the
one most recently used in this file, if any)." t nil)

(autoload 'bookmark-write "bookmark" "\
Write bookmarks to a file (for which the user will be prompted
interactively).  Don't use this in Lisp programs; use bookmark-save
instead." t nil)

(autoload 'bookmark-save "bookmark" "\
Save currently defined bookmarks.
Saves by default in the file defined by the variable
`bookmark-file'.  With a prefix arg, save it in file FILE.

If you are calling this from Lisp, the two arguments are PREFIX-ARG
and FILE, and if you just want it to write to the default file, then
pass no arguments.  Or pass in nil and FILE, and it will save in FILE
instead.  If you pass in one argument, and it is non-nil, then the
user will be interactively queried for a file to save in.

When you want to load in the bookmarks from a file, use
`bookmark-load', \\[bookmark-load].  That function will prompt you
for a file, defaulting to the file defined by variable
`bookmark-file'." t nil)

(autoload 'bookmark-load "bookmark" "\
Load bookmarks from FILE (which must be in bookmark format).
Appends loaded bookmarks to the front of the list of bookmarks.  If
optional second argument REVERT is non-nil, existing bookmarks are
destroyed.  Optional third arg NO-MSG means don't display any messages
while loading.

If you load a file that doesn't contain a proper bookmark alist, you
will corrupt Emacs's bookmark list.  Generally, you should only load
in files that were created with the bookmark functions in the first
place.  Your own personal bookmark file, `~/.emacs-bkmrks', is
maintained automatically by Emacs; you shouldn't need to load it
explicitly." t nil)

(defalias 'edit-bookmarks 'list-bookmarks)

(autoload 'list-bookmarks "bookmark" "\
Display a list of existing bookmarks.
The list is displayed in a buffer named `*Bookmark List*'.
The leftmost column displays a D if the bookmark is flagged for
deletion, or > if it is flagged for displaying." t nil)

;;;***

;;;### (autoloads (command-history-mode list-command-history repeat-matching-complex-command) "chistory" "packages/chistory.el" (11387 38384))
;;; Generated autoloads from packages/chistory.el

(autoload 'repeat-matching-complex-command "chistory" "\
Edit and re-evaluate complex command with name matching PATTERN.
Matching occurrences are displayed, most recent first, until you
select a form for evaluation.  If PATTERN is empty (or nil), every form
in the command history is offered.  The form is placed in the minibuffer
for editing and the result is evaluated." t nil)

(autoload 'list-command-history "chistory" "\
List history of commands typed to minibuffer.
The number of commands listed is controlled by `list-command-history-max'.
Calls value of `list-command-history-filter' (if non-nil) on each history
element to judge if that element should be excluded from the list.

The buffer is left in Command History mode." t nil)

(autoload 'command-history-mode "chistory" "\
Major mode for examining commands from `command-history'.
The number of commands listed is controlled by `list-command-history-max'.
The command history is filtered by `list-command-history-filter' if non-nil.
Use \\<command-history-map>\\[command-history-repeat] to repeat the command on the current line.

Otherwise much like Emacs-Lisp Mode except that there is no self-insertion
and digits provide prefix arguments.  Tab does not indent.
\\{command-history-map}
Calls the value of `command-history-hook' if that is non-nil.
The Command History listing is recomputed each time this mode is invoked." t nil)

;;;***

;;;### (autoloads (compare-windows) "compare-w" "packages/compare-w.el" (11555 56807))
;;; Generated autoloads from packages/compare-w.el

(autoload 'compare-windows "compare-w" "\
Compare text in current window with text in next window.
Compares the text starting at point in each window,
moving over text in each one as far as they match.

A prefix arg means ignore changes in whitespace.
The variable `compare-windows-whitespace' controls how whitespace is skipped.

If `compare-ignore-case' is non-nil, changes in case are also ignored." t nil)

;;;***

;;;### (autoloads (previous-error next-error compilation-minor-mode grep compile) "compile" "packages/compile.el" (11567 52565))
;;; Generated autoloads from packages/compile.el

(defvar compilation-mode-hook nil "\
*List of hook functions run by `compilation-mode' (see `run-hooks').")

(defconst compilation-window-height nil "\
*Number of lines in a compilation window.  If nil, use Emacs default.")

(defvar compilation-buffer-name-function nil "\
Function to compute the name of a compilation buffer.
The function receives one argument, the name of the major mode of the
compilation buffer.  It should return a string.
nil means compute the name with `(concat \"*\" (downcase major-mode) \"*\")'.")

(defvar compilation-finish-function nil "\
*Function to call when a compilation process finishes.
It is called with two arguments: the compilation buffer, and a string
describing how the process finished.")

(defvar compilation-search-path '(nil) "\
*List of directories to search for source files named in error messages.
Elements should be directory names, not file names of directories.
nil as an element means to try the default directory.")

(autoload 'compile "compile" "\
Compile the program including the current buffer.  Default: run `make'.
Runs COMMAND, a shell command, in a separate process asynchronously
with output going to the buffer `*compilation*'.

You can then use the command \\[next-error] to find the next error message
and move to the source code that caused it.

To run more than one compilation at once, start one and rename the
`*compilation*' buffer to some other name with \\[rename-buffer].
Then start the next one.

The name used for the buffer is actually whatever is returned by
the function in `compilation-buffer-name-function', so you can set that
to a function that generates a unique name." t nil)

(autoload 'grep "compile" "\
Run grep, with user-specified args, and collect output in a buffer.
While grep runs asynchronously, you can use the \\[next-error] command
to find the text that grep hits refer to.

This command uses a special history list for its arguments, so you can
easily repeat a grep command." t nil)

(autoload 'compilation-minor-mode "compile" "\
Toggle compilation minor mode.
With arg, turn compilation mode on if and only if arg is positive.
See `compilation-mode'." t nil)

(autoload 'next-error "compile" "\
Visit next compilation error message and corresponding source code.
This operates on the output from the \\[compile] command.
If all preparsed error messages have been processed,
the error message buffer is checked for new ones.

A prefix arg specifies how many error messages to move;
negative means move back to previous error messages.
Just C-u as a prefix means reparse the error message buffer
and start at the first error.

\\[next-error] normally applies to the most recent compilation started,
but as long as you are in the middle of parsing errors from one compilation
output buffer, you stay with that compilation output buffer.

Use \\[next-error] in a compilation output buffer to switch to
processing errors from that compilation.

See variables `compilation-parse-errors-function' and
`compilation-error-regexp-alist' for customization ideas." t nil)

(autoload 'previous-error "compile" "\
\\[next-error] backwards." t nil)

(define-key ctl-x-map "`" 'next-error)

;;;***

;;;### (autoloads (dabbrev-expand) "dabbrev" "packages/dabbrev.el" (11352 15919))
;;; Generated autoloads from packages/dabbrev.el

(autoload 'dabbrev-expand "dabbrev" "\
Expand previous word \"dynamically\".
Expands to the most recent, preceding word for which this is a prefix.
If no suitable preceding word is found, words following point are considered.

If `case-fold-search' and `case-replace' are non-nil (usually true)
then the substituted word may be case-adjusted to match the abbreviation
that you had typed.  This takes place if the substituted word, as found,
is all lower case, or if it is at the beginning of a sentence and only
its first letter was upper case.

A positive prefix arg N says to take the Nth backward DISTINCT
possibility.  A negative argument says search forward.  The variable
`dabbrev-backward-only' may be used to limit the direction of search to
backward if set non-nil.

If the cursor has not moved from the end of the previous expansion and
no argument is given, replace the previously-made expansion
with the next possible expansion not yet tried." t nil)

;;;***

;;;### (autoloads (diff-backup diff) "diff" "packages/diff.el" (11562 15240))
;;; Generated autoloads from packages/diff.el

(defvar diff-switches (purecopy "-c") "\
*A string or list of strings specifying switches to be be passed to diff.")

(autoload 'diff "diff" "\
Find and display the differences between OLD and NEW files.
Interactively the current buffer's file name is the default for NEW
and a backup file for NEW is the default for OLD.
With prefix arg, prompt for diff switches." t nil)

(autoload 'diff-backup "diff" "\
Diff this file with its backup file or vice versa.
Uses the latest backup, if there are several numerical backups.
If this file is a backup, diff it with its original.
The backup file is the first file given to `diff'." t nil)

;;;***

;;;### (autoloads (emerge-files-with-ancestor-remote emerge-files-remote emerge-files-with-ancestor-command emerge-files-command emerge-buffers-with-ancestor emerge-buffers emerge-files-with-ancestor emerge-files) "emerge" "packages/emerge.el" (11472 35765))
;;; Generated autoloads from packages/emerge.el

(autoload 'emerge-files "emerge" "\
Run Emerge on two files." t nil)

(autoload 'emerge-files-with-ancestor "emerge" "\
Run Emerge on two files, giving another file as the ancestor." t nil)

(autoload 'emerge-buffers "emerge" "\
Run Emerge on two buffers." t nil)

(autoload 'emerge-buffers-with-ancestor "emerge" "\
Run Emerge on two buffers, giving another buffer as the ancestor." t nil)

(autoload 'emerge-files-command "emerge" nil nil nil)

(autoload 'emerge-files-with-ancestor-command "emerge" nil nil nil)

(autoload 'emerge-files-remote "emerge" nil nil nil)

(autoload 'emerge-files-with-ancestor-remote "emerge" nil nil nil)

;;;***

;;;### (autoloads (tags-apropos list-tags tags-query-replace tags-search tags-loop-continue next-file find-tag-other-window find-tag visit-tags-table) "etags" "packages/etags.el" (11565 27773))
;;; Generated autoloads from packages/etags.el

(defvar tags-build-completion-table 'ask "\
*If this variable is nil, then tags completion is disabled.
If this variable is t, then things which prompt for tags will do so with 
 completion across all known tags.
If this variable is the symbol `ask', then you will be asked whether each
 tags table should be added to the completion list as it is read in.
 (With the exception that for very small tags tables, you will not be asked,
 since they can be parsed quickly.)")

(defvar tag-table-alist nil "\
*A list which determines which tags files should be active for a 
given buffer.  This is not really an association list, in that all 
elements are checked.  The CAR of each element of this list is a 
pattern against which the buffer's file name is compared; if it 
matches, then the CDR of the list should be the name of the tags
table to use.  If more than one element of this list matches the
buffer's file name, then all of the associated tags tables will be
used.  Earlier ones will be searched first.

If the CAR of elements of this list are strings, then they are treated
as regular-expressions against which the file is compared (like the
auto-mode-alist).  If they are not strings, then they are evaluated.
If they evaluate to non-nil, then the current buffer is considered to
match.

If the CDR of the elements of this list are strings, then they are
assumed to name a TAGS file.  If they name a directory, then the string
\"TAGS\" is appended to them to get the file name.  If they are not 
strings, then they are evaluated, and must return an appropriate string.

For example:
  (setq tag-table-alist
	'((\"/usr/src/public/perl/\" . \"/usr/src/public/perl/perl-3.0/\")
	 (\"\\\\.el$\" . \"/usr/local/emacs/src/\")
	 (\"/jbw/gnu/\" . \"/usr15/degree/stud/jbw/gnu/\")
	 (\"\" . \"/usr/local/emacs/src/\")
	 ))

This means that anything in the /usr/src/public/perl/ directory should use
the TAGS file /usr/src/public/perl/perl-3.0/TAGS; and file ending in .el should
use the TAGS file /usr/local/emacs/src/TAGS; and anything in or below the
directory /jbw/gnu/ should use the TAGS file /usr15/degree/stud/jbw/gnu/TAGS.
A file called something like \"/usr/jbw/foo.el\" would use both the TAGS files
/usr/local/emacs/src/TAGS and /usr15/degree/stud/jbw/gnu/TAGS (in that order)
because it matches both patterns.

If the buffer-local variable `buffer-tag-table' is set, then it names a tags
table that is searched before all others when find-tag is executed from this
buffer.

If there is a file called \"TAGS\" in the same directory as the file in 
question, then that tags file will always be used as well (after the
`buffer-tag-table' but before the tables specified by this list.)

If the variable tags-file-name is set, then the tags file it names will apply
to all buffers (for backwards compatibility.)  It is searched first.
")

(autoload 'visit-tags-table "etags" "\
Tell tags commands to use tags table file FILE first.
FILE should be the name of a file created with the `etags' program.
A directory name is ok too; it means file TAGS in that directory." t nil)

(autoload 'find-tag "etags" "\
*Find tag whose name contains TAGNAME.
 Selects the buffer that the tag is contained in
and puts point at its definition.
 If TAGNAME is a null string, the expression in the buffer
around or before point is used as the tag name.
 If called interactively with a numeric argument, searches for the next tag
in the tag table that matches the tagname used in the previous find-tag.
 If second arg OTHER-WINDOW is non-nil, uses another window to display
the tag.

This version of this function supports multiple active tags tables,
and completion.

Variables of note:

  tag-table-alist		controls which tables apply to which buffers
  tags-file-name		a default tags table
  tags-build-completion-table   controls completion behavior
  buffer-tag-table		another way of specifying a buffer-local table
  make-tags-files-invisible	whether tags tables should be very hidden
  tag-mark-stack-max		how many tags-based hops to remember" t nil)

(autoload 'find-tag-other-window "etags" "\
*Find tag whose name contains TAGNAME.
 Selects the buffer that the tag is contained in in another window
and puts point at its definition.
 If TAGNAME is a null string, the expression in the buffer
around or before point is used as the tag name.
 If second arg NEXT is non-nil (interactively, with prefix arg),
searches for the next tag in the tag table
that matches the tagname used in the previous find-tag.

This version of this function supports multiple active tags tables,
and completion.

Variables of note:

  tag-table-alist		controls which tables apply to which buffers
  tags-file-name		a default tags table
  tags-build-completion-table   controls completion behavior
  buffer-tag-table		another way of specifying a buffer-local table
  make-tags-files-invisible	whether tags tables should be very hidden
  tag-mark-stack-max		how many tags-based hops to remember" t nil)

(autoload 'next-file "etags" "\
Select next file among files in current tag table(s).
Non-nil argument (prefix arg, if interactive) initializes to the beginning 
of the list of files in the (first) tag table." t nil)

(autoload 'tags-loop-continue "etags" "\
Continue last \\[tags-search] or \\[tags-query-replace] command.
Used noninteractively with non-nil argument
to begin such a command.  See variable tags-loop-form." t nil)

(autoload 'tags-search "etags" "\
Search through all files listed in tag table for match for REGEXP.
Stops when a match is found.
To continue searching for next match, use command \\[tags-loop-continue].

See documentation of variable tag-table-alist." t nil)

(autoload 'tags-query-replace "etags" "\
Query-replace-regexp FROM with TO through all files listed in tag table.
Third arg DELIMITED (prefix arg) means replace only word-delimited matches.
If you exit (C-G or ESC), you can resume the query-replace
with the command \\[tags-loop-continue].

See documentation of variable tag-table-alist." t nil)

(autoload 'list-tags "etags" "\
Display list of tags in file FILE.
FILE should not contain a directory spec
unless it has one in the tag table." t nil)

(autoload 'tags-apropos "etags" "\
Display list of all tags in tag table REGEXP matches." t nil)

;;;***

;;;### (autoloads (feedmail-send-it) "feedmail" "packages/feedmail.el" (11557 4864))
;;; Generated autoloads from packages/feedmail.el

(autoload 'feedmail-send-it "feedmail" nil nil nil)

;;;***

;;;### (autoloads (font-lock-fontify-buffer turn-on-font-lock font-lock-mode) "font-lock" "packages/font-lock.el" (11560 51229))
;;; Generated autoloads from packages/font-lock.el

(make-variable-buffer-local 'font-lock-keywords)

(defvar font-lock-keywords nil "\
*The keywords to highlight.
If this is a list, then elements may be of the forms:

  \"string\"			  ; a regexp to highlight in the 
				  ;  `font-lock-keyword-face'.
  (\"string\" . integer)  	  ; match N of the regexp will be highlighted
  (\"string\" . face-name)	  ; use the named face
  (\"string\" integer face-name)    ; both of the above
  (\"string\" integer face-name t)  ; this allows highlighting to overlap
				  ;  with already-highlighted regions.

These regular expressions should not match text which spans lines.  Multi-line
patterns will be correctly fontified when \\[font-lock-fontify-buffer] is used,
but will not be matched by the auto-fontification that font-lock-mode does,
since it looks at only one line at a time.

Be careful composing regexps for this list; the wrong pattern can dramatically
slow things down!")

(autoload 'font-lock-mode "font-lock" "\
Toggle Font Lock Mode.
With arg, turn font-lock mode on if and only if arg is positive.
In the font-lock minor mode, text is fontified as you type it:

 - comments are displayed in font-lock-comment-face;
 - strings are displayed in font-lock-string-face;
 - documentation strings are displayed in font-lock-doc-string-face;
 - function and variable names in their defining forms are displayed
   in font-lock-function-name-face;
 - and certain other expressions are displayed in other faces
   according to the value of the variable `font-lock-keywords'.

When font-lock mode is turned on/off, the buffer is fontified/defontified.
To fontify a buffer without having newly typed text become fontified, you
can use \\[font-lock-fontify-buffer].

See the variable `font-lock-keywords' for customization." t nil)

(autoload 'turn-on-font-lock "font-lock" "\
Unconditionally turn on Font Lock mode." nil nil)

(autoload 'font-lock-fontify-buffer "font-lock" "\
Fontify the current buffer the way `font-lock-mode' would:

 - comments are displayed in font-lock-comment-face;
 - strings are displayed in font-lock-string-face;
 - documentation strings are displayed in font-lock-doc-string-face;
 - function and variable names in their defining forms are displayed
   in font-lock-function-name-face;
 - and certain other expressions are displayed in other faces
   according to the value of the variable `font-lock-keywords'.

This can take a while for large buffers." t nil)

;;;***

;;;### (autoloads (gopher-atpoint gopher) "gopher" "packages/gopher.el" (11555 56817))
;;; Generated autoloads from packages/gopher.el

(autoload 'gopher "gopher" "\
Start a gopher session.  With C-u, prompt for a gopher server." t nil)

(autoload 'gopher-atpoint "gopher" "\
Try to interpret the text around point as a gopher bookmark, and dispatch
to that object." t nil)

;;;***

;;;### (autoloads (hexl-find-file hexl-mode) "hexl" "packages/hexl.el" (11493 31178))
;;; Generated autoloads from packages/hexl.el

(autoload 'hexl-mode "hexl" "\
\\<hexl-mode-map>
A major mode for editing binary files in hex dump format.

This function automatically converts a buffer into the hexl format
using the function `hexlify-buffer'.

Each line in the buffer has an \"address\" (displayed in hexadecimal)
representing the offset into the file that the characters on this line
are at and 16 characters from the file (displayed as hexadecimal
values grouped every 16 bits) and as their ASCII values.

If any of the characters (displayed as ASCII characters) are
unprintable (control or meta characters) they will be replaced as
periods.

If `hexl-mode' is invoked with an argument the buffer is assumed to be
in hexl format.

A sample format:

  HEX ADDR: 0001 0203 0405 0607 0809 0a0b 0c0d 0e0f     ASCII-TEXT
  --------  ---- ---- ---- ---- ---- ---- ---- ----  ----------------
  00000000: 5468 6973 2069 7320 6865 786c 2d6d 6f64  This is hexl-mod
  00000010: 652e 2020 4561 6368 206c 696e 6520 7265  e.  Each line re
  00000020: 7072 6573 656e 7473 2031 3620 6279 7465  presents 16 byte
  00000030: 7320 6173 2068 6578 6164 6563 696d 616c  s as hexadecimal
  00000040: 2041 5343 4949 0a61 6e64 2070 7269 6e74   ASCII.and print
  00000050: 6162 6c65 2041 5343 4949 2063 6861 7261  able ASCII chara
  00000060: 6374 6572 732e 2020 416e 7920 636f 6e74  cters.  Any cont
  00000070: 726f 6c20 6f72 206e 6f6e 2d41 5343 4949  rol or non-ASCII
  00000080: 2063 6861 7261 6374 6572 730a 6172 6520   characters.are 
  00000090: 6469 7370 6c61 7965 6420 6173 2070 6572  displayed as per
  000000a0: 696f 6473 2069 6e20 7468 6520 7072 696e  iods in the prin
  000000b0: 7461 626c 6520 6368 6172 6163 7465 7220  table character 
  000000c0: 7265 6769 6f6e 2e0a                      region..

Movement is as simple as movement in a normal emacs text buffer.  Most
cursor movement bindings are the same (ie. Use \\[hexl-backward-char], \\[hexl-forward-char], \\[hexl-next-line], and \\[hexl-previous-line]
to move the cursor left, right, down, and up).

Advanced cursor movement commands (ala \\[hexl-beginning-of-line], \\[hexl-end-of-line], \\[hexl-beginning-of-buffer], and \\[hexl-end-of-buffer]) are
also supported.

There are several ways to change text in hexl mode:

ASCII characters (character between space (0x20) and tilde (0x7E)) are
bound to self-insert so you can simply type the character and it will
insert itself (actually overstrike) into the buffer.

\\[hexl-quoted-insert] followed by another keystroke allows you to insert the key even if
it isn't bound to self-insert.  An octal number can be supplied in place
of another key to insert the octal number's ASCII representation.

\\[hexl-insert-hex-char] will insert a given hexadecimal value (if it is between 0 and 0xFF)
into the buffer at the current point.

\\[hexl-insert-octal-char] will insert a given octal value (if it is between 0 and 0377)
into the buffer at the current point.

\\[hexl-insert-decimal-char] will insert a given decimal value (if it is between 0 and 255)
into the buffer at the current point.

\\[hexl-mode-exit] will exit hexl-mode.

Note: saving the file with any of the usual Emacs commands
will actually convert it back to binary format while saving.

You can use \\[hexl-find-file] to visit a file in hexl-mode.

\\[describe-bindings] for advanced commands." t nil)

(autoload 'hexl-find-file "hexl" "\
Edit file FILENAME in hexl-mode.
Switch to a buffer visiting file FILENAME, creating one in none exists." t nil)

;;;***

;;;### (autoloads (Info-emacs-key Info-goto-emacs-key-command-node Info-goto-emacs-command-node Info-emacs-command info) "info" "packages/info.el" (11553 17917))
;;; Generated autoloads from packages/info.el

(autoload 'info "info" "\
Enter Info, the documentation browser.
Optional argument FILE specifies the file to examine;
the default is the top-level directory of Info.

In interactive use, a prefix argument directs this command
to read a file name from the minibuffer." t nil)

(autoload 'Info-emacs-command "info" "\
Look up an Emacs command in the Emacs manual in the Info system.
This command is designed to be used whether you are already in Info or not." t nil)

(autoload 'Info-goto-emacs-command-node "info" "\
Look up an Emacs command in the Emacs manual in the Info system.
This command is designed to be used whether you are already in Info or not." t nil)

(autoload 'Info-goto-emacs-key-command-node "info" "\
Look up an Emacs key sequence in the Emacs manual in the Info system.
This command is designed to be used whether you are already in Info or not." t nil)

(autoload 'Info-emacs-key "info" "\
Look up an Emacs key sequence in the Emacs manual in the Info system.
This command is designed to be used whether you are already in Info or not." t nil)

;;;***

;;;### (autoloads (ispell-message ispell-complete-word ispell-buffer ispell-region ispell-change-dictionary ispell-word) "ispell" "packages/ispell.el" (11555 57163))
;;; Generated autoloads from packages/ispell.el

(autoload 'ispell-word "ispell" "\
Check spelling of word under or before the cursor.
If word not found in dictionary, display possible corrections in a window
and let user select.
  If optional argument FOLLOWING is non-nil or if ispell-following-word
is non-nil when called interactively, then the following word
\(rather than preceding) will be checked when the cursor is not over a word.
  When the optional argument QUIETLY is non-nil or ispell-quietly is non-nil
when called interactively, non-corrective messages are suppressed.

  Word syntax described by ispell-dictionary-alist (which see).

This will check or reload the dictionary.  Use \\[ispell-change-dictionary]
or \\[ispell-region] to update the ispell process." t nil)

(autoload 'ispell-change-dictionary "ispell" "\
Change ispell-dictionary (q.v.) and kill old ispell process.
A new one will be started as soon as necessary.

By just answering RET you can find out what the current dictionary is." t nil)

(autoload 'ispell-region "ispell" "\
Interactively check a region for spelling errors." t nil)

(autoload 'ispell-buffer "ispell" "\
Check the current buffer for spelling errors interactively." t nil)

(autoload 'ispell-complete-word "ispell" "\
Look up word before or under point in dictionary (see lookup-words command)
and try to complete it.  Standard ispell choices are then available." t nil)

(autoload 'ispell-message "ispell" "\
Check the spelling of a mail message or news post.
Don't check spelling of message headers except the Subject field.
Don't check included messages.

To abort spell checking of a message region and send message anyway,
use the 'x' or 'q' command.  The 'X' command aborts the message send so that
you can edit the buffer.

To spell-check whenever a message is sent, include the appropriate lines
in your .emacs file:
   (setq news-inews-hook 'ispell-message)
   (setq mail-send-hook  'ispell-message)
   (setq mh-before-send-letter-hook 'ispell-message)" t nil)

;;;***

;;;### (autoloads (print-region lpr-region print-buffer lpr-buffer) "lpr" "packages/lpr.el" (11555 56821))
;;; Generated autoloads from packages/lpr.el

(defvar lpr-switches nil "\
*List of strings to pass as extra switch args to lpr when it is invoked.")

(defvar lpr-command (if (memq system-type '(usg-unix-v dgux-unix hpux silicon-graphics-unix)) "lp" "lpr") "\
*Shell command for printing a file")

(autoload 'lpr-buffer "lpr" "\
Print buffer contents as with Unix command `lpr'.
`lpr-switches' is a list of extra switches (strings) to pass to lpr." t nil)

(autoload 'print-buffer "lpr" "\
Print buffer contents as with Unix command `lpr -p'.
`lpr-switches' is a list of extra switches (strings) to pass to lpr." t nil)

(autoload 'lpr-region "lpr" "\
Print region contents as with Unix command `lpr'.
`lpr-switches' is a list of extra switches (strings) to pass to lpr." t nil)

(autoload 'print-region "lpr" "\
Print region contents as with Unix command `lpr -p'.
`lpr-switches' is a list of extra switches (strings) to pass to lpr." t nil)

;;;***

;;;### (autoloads (make-command-summary) "makesum" "packages/makesum.el" (11352 16051))
;;; Generated autoloads from packages/makesum.el

(autoload 'make-command-summary "makesum" "\
Make a summary of current key bindings in the buffer *Summary*.
Previous contents of that buffer are killed first." t nil)

;;;***

;;;### (autoloads (manual-entry) "man" "packages/man.el" (11557 4867))
;;; Generated autoloads from packages/man.el

(autoload 'manual-entry "man" "\
Display the Unix manual entry (or entries) for TOPIC.
If prefix arg is given, modify the search according to the value:
  2 = complement default exact matching of the TOPIC name;
      exact matching default is specified by `Manual-match-topic-exactly'
  3 = force a search of the unformatted man directories
  4 = both 2 and 3
The manual entries are searched according to the variable
Manual-directory-list, which should be a list of directories.  If
Manual-directory-list is nil, \\[Manual-directory-list-init] is
invoked to create this list from the MANPATH environment variable.
See the variable Manual-topic-buffer which controls how the buffer
is named.  See also the variables Manual-match-topic-exactly,
Manual-query-multiple-pages, and Manual-buffer-view-mode." t nil)

;;;***

;;;### (autoloads (mh-smail mh-rmail) "mh-e" "packages/mh-e.el" (11472 37891))
;;; Generated autoloads from packages/mh-e.el

(autoload 'mh-rmail "mh-e" "\
Inc(orporate) new mail (no arg) or scan a MH mail box (arg given).
This front end uses the MH mail system, which uses different conventions
from the usual mail system." t nil)

(autoload 'mh-smail "mh-e" "\
Compose and send mail with the MH mail system." t nil)

;;;***

;;;### (autoloads (pending-delete pending-delete-off pending-delete-on) "pending-del" "packages/pending-del.el" (11555 56822))
;;; Generated autoloads from packages/pending-del.el

(autoload 'pending-delete-on "pending-del" "\
Turn on pending delete.
When it is ON typed text replaces the selection if the selection is active.
When it is OFF typed text is just inserted at point." t nil)

(autoload 'pending-delete-off "pending-del" "\
Turn on pending delete.
When it is ON typed text replaces the selection if the selection is active.
When it is OFF typed text is just inserted at point." t nil)

(autoload 'pending-delete "pending-del" "\
Toggle the state of pending-delete mode.
When it is ON typed text replaces the selection if the selection is active.
When it is OFF typed text is just inserted at point." t nil)

;;;***

;;;### (autoloads (server-start) "server" "packages/server.el" (11555 56823))
;;; Generated autoloads from packages/server.el

(autoload 'server-start "server" "\
Allow this Emacs process to be a server for client processes.
This starts a server communications subprocess through which
client \"editors\" can send your editing commands to this Emacs job.
To use the server, set up the program `etc/emacsclient' in the
Emacs distribution as your standard \"editor\".

Prefix arg means just kill any existing server communications subprocess." t nil)

;;;***

;;;### (autoloads (install-shell-fonts) "shell-font" "packages/shell-font.el" (11566 35391))
;;; Generated autoloads from packages/shell-font.el

(autoload 'install-shell-fonts "shell-font" "\
Decorate the current interaction buffer with fonts.
This uses the faces called `shell-prompt', `shell-input' and `shell-output';
you can alter the graphical attributes of those with the normal
face-manipulation functions." nil nil)

;;;***

;;;### (autoloads (tar-mode) "tar-mode" "packages/tar-mode.el" (11555 56825))
;;; Generated autoloads from packages/tar-mode.el

(autoload 'tar-mode "tar-mode" "\
Major mode for viewing a tar file as a dired-like listing of its contents.
You can move around using the usual cursor motion commands. 
Letters no longer insert themselves.
Type 'e' to pull a file out of the tar file and into its own buffer.
Type 'c' to copy an entry from the tar file into another file on disk.

If you edit a sub-file of this archive (as with the 'e' command) and 
save it with Control-X Control-S, the contents of that buffer will be 
saved back into the tar-file buffer; in this way you can edit a file 
inside of a tar archive without extracting it and re-archiving it.

See also: variables tar-update-datestamp and tar-anal-blocksize.
\\{tar-mode-map}" nil nil)

;;;***

;;;### (autoloads (terminal-emulator) "terminal" "packages/terminal.el" (11555 56828))
;;; Generated autoloads from packages/terminal.el

(autoload 'terminal-emulator "terminal" "\
Under a display-terminal emulator in BUFFER, run PROGRAM on arguments ARGS.
ARGS is a list of argument-strings.  Remaining arguments are WIDTH and HEIGHT.
BUFFER's contents are made an image of the display generated by that program,
and any input typed when BUFFER is the current Emacs buffer is sent to that
program an keyboard input.

Interactively, BUFFER defaults to \"*terminal*\" and PROGRAM and ARGS
are parsed from an input-string using your usual shell.
WIDTH and HEIGHT are determined from the size of the current window
-- WIDTH will be one less than the window's width, HEIGHT will be its height.

To switch buffers and leave the emulator, or to give commands
to the emulator itself (as opposed to the program running under it),
type Control-^.  The following character is an emulator command.
Type Control-^ twice to send it to the subprogram.
This escape character may be changed using the variable `terminal-escape-char'.

`Meta' characters may not currently be sent through the terminal emulator.

Here is a list of some of the variables which control the behaviour
of the emulator -- see their documentation for more information:
terminal-escape-char, terminal-scrolling, terminal-more-processing,
terminal-redisplay-interval.

This function calls the value of terminal-mode-hook if that exists
and is non-nil after the terminal buffer has been set up and the
subprocess started.

Presently with `termcap' only; if somebody sends us code to make this
work with `terminfo' we will try to use it." t nil)

;;;***

;;;### (autoloads (batch-texinfo-format texinfo-format-region texinfo-format-buffer) "texinfmt" "packages/texinfmt.el" (11557 4870))
;;; Generated autoloads from packages/texinfmt.el

(autoload 'texinfo-format-buffer "texinfmt" "\
Process the current buffer as texinfo code, into an Info file.
The Info file output is generated in a buffer visiting the Info file
names specified in the @setfilename command.

Non-nil argument (prefix, if interactive) means don't make tag table
and don't split the file if large.  You can use Info-tagify and
Info-split to do these manually." t nil)

(autoload 'texinfo-format-region "texinfmt" "\
Convert the current region of the Texinfo file to Info format.
This lets you see what that part of the file will look like in Info.
The command is bound to \\[texinfo-format-region].  The text that is
converted to Info is stored in a temporary buffer." t nil)

(autoload 'batch-texinfo-format "texinfmt" "\
Runs  texinfo-format-buffer  on the files remaining on the command line.
Must be used only with -batch, and kills emacs on completion.
Each file will be processed even if an error occurred previously.
For example, invoke
  \"emacs -batch -funcall batch-texinfo-format $docs/ ~/*.texinfo\"." nil nil)

;;;***

;;;### (autoloads (time-stamp) "time-stamp" "packages/time-stamp.el" (11369 13515))
;;; Generated autoloads from packages/time-stamp.el

(autoload 'time-stamp "time-stamp" "\
Update the time stamp string in the buffer.
Only does its thing if the variable  time-stamp-active  is non-nil.
Typically used on  write-file-hooks  for automatic time-stamping.
The format of the time stamp is determined by the variable
time-stamp-format.  The first  time-stamp-line-limit  lines of the
buffer (normally 8) are searched for the time stamp template,
and if it is found, a new time stamp is written into it." t nil)

;;;***

;;;### (autoloads (display-time) "time" "packages/time.el" (11558 42401))
;;; Generated autoloads from packages/time.el

(defvar display-time-day-and-date nil "\
*Non-nil means \\[display-time] should display day and date as well as time.")

(autoload 'display-time "time" "\
Display current time, load level, and mail flag in mode line of each buffer.
Updates automatically every minute.
If `display-time-day-and-date' is non-nil, the current day and date
are displayed as well.
After each update, `display-time-hook' is run with `run-hooks'.
If `display-time-echo-area' is non-nil, the time is displayed in the
echo area instead of in the mode-line." t nil)

;;;***

;;;### (autoloads (ununderline-and-unoverstrike-region overstrike-region unoverstrike-region ununderline-region underline-region) "underline" "packages/underline.el" (11387 38418))
;;; Generated autoloads from packages/underline.el

(autoload 'underline-region "underline" "\
Underline all nonblank characters in the region.
Works by overstriking underscores.
Called from program, takes two arguments START and END
which specify the range to operate on." t nil)

(autoload 'ununderline-region "underline" "\
Remove all underlining (overstruck underscores) in the region.
Called from program, takes two arguments START and END
which specify the range to operate on." t nil)

(autoload 'unoverstrike-region "underline" "\
Remove all overstriking (character-backspace-character) in the region.
Called from program, takes two arguments START and END which specify the
range to operate on." t nil)

(autoload 'overstrike-region "underline" "\
Overstrike (character-backspace-character) all nonblank characters in
the region. Called from program, takes two arguments START and END which
specify the range to operate on." t nil)

(autoload 'ununderline-and-unoverstrike-region "underline" "\
Remove underlining and overstriking in the region.  Called from a program,
takes two arguments START and END which specify the range to operate on." t nil)

;;;***

;;;### (autoloads (ask-to-update-copyright update-copyright) "upd-copyr" "packages/upd-copyr.el" (11558 43041))
;;; Generated autoloads from packages/upd-copyr.el

(defvar replace-copying-with nil "\
*If non-nil, replace copying notices with this file.")

(autoload 'update-copyright "upd-copyr" "\
Update the copyright notice at the beginning of the buffer
to indicate the current year.  If optional arg REPLACE is given
\(interactively, with prefix arg) replace the years in the notice
rather than adding the current year after them.
If `replace-copying-with' is set, the copying permissions following the
copyright are replaced as well.

If optional third argument ASK is non-nil, the user is prompted for whether
or not to update the copyright.  If optional fourth argument ASK-YEAR is
non-nil, the user is prompted for whether or not to replace the year rather
than adding to it." t nil)

(autoload 'ask-to-update-copyright "upd-copyr" "\
If the current buffer contains a copyright notice that is out of date,
ask the user if it should be updated with `update-copyright' (which see).
Put this on write-file-hooks." nil nil)

;;;***

;;;### (autoloads (vc-update-change-log vc-cancel-version vc-revert-buffer vc-print-log vc-retrieve-snapshot vc-create-snapshot vc-directory vc-insert-headers vc-version-other-window vc-diff vc-register vc-next-action) "vc" "packages/vc.el" (11562 15207))
;;; Generated autoloads from packages/vc.el

(defvar vc-checkin-hook nil "\
*List of functions called after a checkin is done.  See `run-hooks'.")

(autoload 'vc-next-action "vc" "\
Do the next logical checkin or checkout operation on the current file.
   If the file is not already registered, this registers it for version
control and then retrieves a writable, locked copy for editing.
   If the file is registered and not locked by anyone, this checks out
a writable and locked file ready for editing.
   If the file is checked out and locked by the calling user, this
first checks to see if the file has changed since checkout.  If not,
it performs a revert.
   If the file has been changed, this pops up a buffer for entry
of a log message; when the message has been entered, it checks in the
resulting changes along with the log message as change commentary.  If
the variable `vc-keep-workfiles' is non-nil (which is its default), a
read-only copy of the changed file is left in place afterwards.
   If the file is registered and locked by someone else, you are given
the option to steal the lock.
   If you call this from within a VC dired buffer with no files marked,
it will operate on the file in the current line.
   If you call this from within a VC dired buffer, and one or more
files are marked, it will accept a log message and then operate on
each one.  The log message will be used as a comment for any register
or checkin operations, but ignored when doing checkouts.  Attempted
lock steals will raise an error.

   For checkin, a prefix argument lets you specify the version number to use." t nil)

(autoload 'vc-register "vc" "\
Register the current file into your version-control system." t nil)

(autoload 'vc-diff "vc" "\
Display diffs between file versions.
Normally this compares the current file and buffer with the most recent 
checked in version of that file.  This uses no arguments.
With a prefix argument, it reads the file name to use
and two version designators specifying which versions to compare." t nil)

(autoload 'vc-version-other-window "vc" "\
Visit version REV of the current buffer in another window.
If the current buffer is named `F', the version is named `F.~REV~'.
If `F.~REV~' already exists, it is used instead of being re-created." t nil)

(autoload 'vc-insert-headers "vc" "\
Insert headers in a file for use with your version-control system.
Headers desired are inserted at the start of the buffer, and are pulled from
the variable `vc-header-alist'." t nil)

(autoload 'vc-directory "vc" "\
Show version-control status of all files under the current directory." t nil)

(autoload 'vc-create-snapshot "vc" "\
Make a snapshot called NAME.
The snapshot is made from all registered files at or below the current
directory.  For each file, the version level of its latest
version becomes part of the named configuration." t nil)

(autoload 'vc-retrieve-snapshot "vc" "\
Retrieve the snapshot called NAME.
This function fails if any files are locked at or below the current directory
Otherwise, all registered files are checked out (unlocked) at their version
levels in the snapshot." t nil)

(autoload 'vc-print-log "vc" "\
List the change log of the current buffer in a window." t nil)

(autoload 'vc-revert-buffer "vc" "\
Revert the current buffer's file back to the latest checked-in version.
This asks for confirmation if the buffer contents are not identical
to that version." t nil)

(autoload 'vc-cancel-version "vc" "\
Get rid of most recently checked in version of this file.
A prefix argument means do not revert the buffer afterwards." t nil)

(autoload 'vc-update-change-log "vc" "\
Find change log file and add entries from recent RCS logs.
The mark is left at the end of the text prepended to the change log.
With prefix arg of C-u, only find log entries for the current buffer's file.
With any numeric prefix arg, find log entries for all files currently visited.
Otherwise, find log entries for all registered files in the default directory.
From a program, any arguments are passed to the `rcs2log' script." t nil)

;;;***

;;;### (autoloads (webster-spell webster-endings webster) "webster" "packages/webster.el" (11555 56837))
;;; Generated autoloads from packages/webster.el

(autoload 'webster "webster" "\
Look up a word in the Webster's dictionary.
Open a network login connection to a webster host if necessary.
Communication with host is recorded in a buffer *webster*." t nil)

(autoload 'webster-endings "webster" "\
Look up endings for a word in the Webster's dictionary.
Open a network login connection to a webster host if necessary.
Communication with host is recorded in a buffer *webster*." t nil)

(autoload 'webster-spell "webster" "\
Look spelling for a word in the Webster's dictionary.
Open a network login connection to a webster host if necessary.
Communication with host is recorded in a buffer *webster*." t nil)

;;;***

;;;### (autoloads (run-scheme) "xscheme" "packages/xscheme.el" (11555 56838))
;;; Generated autoloads from packages/xscheme.el

(autoload 'run-scheme "xscheme" "\
Run an inferior Scheme process.
Output goes to the buffer `*scheme*'.
With argument, asks for a command line." t nil)

;;;***

;;;### (autoloads (cvs-update-other-window cvs-update) "pcl-cvs" "pcl-cvs/pcl-cvs.el" (11555 57213))
;;; Generated autoloads from pcl-cvs/pcl-cvs.el

(autoload 'cvs-update "pcl-cvs" "\
Run a 'cvs update' in the current working directory. Feed the
output to a *cvs* buffer and run cvs-mode on it.
If optional prefix argument LOCAL is non-nil, 'cvs update -l' is run." t nil)

(autoload 'cvs-update-other-window "pcl-cvs" "\
Run a 'cvs update' in the current working directory. Feed the
output to a *cvs* buffer, display it in the other window, and run
cvs-mode on it.

If optional prefix argument LOCAL is non-nil, 'cvs update -l' is run." t nil)

;;;***

;;;### (autoloads (cancel-debug-on-entry debug-on-entry debug) "debug" "prim/debug.el" (11570 13251))
;;; Generated autoloads from prim/debug.el

(autoload 'debug "debug" "\
Enter debugger.  Returns if user says \"continue\".
Arguments are mainly for use when this is called
 from the internals of the evaluator.
You may call with no args, or you may
 pass nil as the first arg and any other args you like.
 In that case, the list of args after the first will 
 be printed into the backtrace buffer." nil nil)

(autoload 'debug-on-entry "debug" "\
Request FUNCTION to invoke debugger each time it is called.
If the user continues, FUNCTION's execution proceeds.
Works by modifying the definition of FUNCTION,
which must be written in Lisp, not predefined.
Use \\[cancel-debug-on-entry] to cancel the effect of this command.
Redefining FUNCTION also does that." t nil)

(autoload 'cancel-debug-on-entry "debug" "\
Undo effect of \\[debug-on-entry] on FUNCTION.
If argument is nil or an empty string, cancel for all functions." t nil)

;;;***

;;;***

;;;### (autoloads (setenv) "env" "prim/env.el" (11519 5884))
;;; Generated autoloads from prim/env.el

(autoload 'setenv "env" "\
Set the value of the environment variable named VARIABLE to VALUE.
VARIABLE should be a string.  VALUE is optional; if not provided or is
`nil', the environment variable VARIABLE will be removed.  
This function works by modifying `process-environment'." t nil)

;;;***

;;;### (autoloads (apply-macro-to-region-lines kbd-macro-query insert-kbd-macro name-last-kbd-macro) "macros" "prim/macros.el" (11472 36597))
;;; Generated autoloads from prim/macros.el

(autoload 'name-last-kbd-macro "macros" "\
Assign a name to the last keyboard macro defined.
Argument SYMBOL is the name to define.
The symbol's function definition becomes the keyboard macro string.
Such a \"function\" cannot be called from Lisp, but it is a valid
editor command." t nil)

(autoload 'insert-kbd-macro "macros" "\
Insert in buffer the definition of kbd macro NAME, as Lisp code.
Optional second argument KEYS means also record the keys it is on
\(this is the prefix argument, when calling interactively.)

This Lisp code will, when executed, define the kbd macro with the
same definition it has now.  If you say to record the keys,
the Lisp code will also rebind those keys to the macro.
Only global key bindings are recorded since executing this Lisp code
always makes global bindings.

To save a kbd macro, visit a file of Lisp code such as your `~/.emacs',
use this command, and then save the file." t nil)

(autoload 'kbd-macro-query "macros" "\
Query user during kbd macro execution.
With prefix argument, enters recursive edit,
 reading keyboard commands even within a kbd macro.
 You can give different commands each time the macro executes.
Without prefix argument, asks whether to continue running the macro.
Your options are: \\<query-replace-map>
\\[act]	Finish this iteration normally and continue with the next.
\\[skip]	Skip the rest of this iteration, and start the next.
\\[exit]	Stop the macro entirely right now.
\\[recenter]	Redisplay the screen, then ask again.
\\[edit]	Enter recursive edit; ask again when you exit from that." t nil)

(autoload 'apply-macro-to-region-lines "macros" "\
For each complete line between point and mark, move to the beginning
of the line, and run the last keyboard macro.

When called from lisp, this function takes two arguments TOP and
BOTTOM, describing the current region.  TOP must be before BOTTOM.
The optional third argument MACRO specifies a keyboard macro to
execute.

This is useful for quoting or unquoting included text, adding and
removing comments, or producing tables where the entries are regular.

For example, in Usenet articles, sections of text quoted from another
author are indented, or have each line start with `>'.  To quote a
section of text, define a keyboard macro which inserts `>', put point
and mark at opposite ends of the quoted section, and use
`\\[apply-macro-to-region-lines]' to mark the entire section.

Suppose you wanted to build a keyword table in C where each entry
looked like this:

    { \"foo\", foo_data, foo_function }, 
    { \"bar\", bar_data, bar_function },
    { \"baz\", baz_data, baz_function },

You could enter the names in this format:

    foo
    bar
    baz

and write a macro to massage a word into a table entry:

    \\C-x (
       \\M-d { \"\\C-y\", \\C-y_data, \\C-y_function },
    \\C-x )

and then select the region of un-tablified names and use
`\\[apply-macro-to-region-lines]' to build the table from the names.
" t nil)

;;;***

;;;### (autoloads (disable-command enable-command disabled-command-hook) "novice" "prim/novice.el" (11387 46608))
;;; Generated autoloads from prim/novice.el

(autoload 'disabled-command-hook "novice" nil nil nil)

(autoload 'enable-command "novice" "\
Allow COMMAND to be executed without special confirmation from now on.
The user's .emacs file is altered so that this will apply
to future sessions." t nil)

(autoload 'disable-command "novice" "\
Require special confirmation to execute COMMAND from now on.
The user's .emacs file is altered so that this will apply
to future sessions." t nil)

;;;***

;;;### (autoloads (edit-options list-options) "options" "prim/options.el" (11472 36607))
;;; Generated autoloads from prim/options.el

(autoload 'list-options "options" "\
Display a list of Emacs user options, with values and documentation." t nil)

(autoload 'edit-options "options" "\
Edit a list of Emacs user option values.
Selects a buffer containing such a list,
in which there are commands to set the option values.
Type \\[describe-mode] in that buffer for a list of commands." t nil)

;;;***

;;;### (autoloads (clear-rectangle string-rectangle open-rectangle insert-rectangle yank-rectangle kill-rectangle extract-rectangle delete-extract-rectangle delete-rectangle) "rect" "prim/rect.el" (11387 46849))
;;; Generated autoloads from prim/rect.el

(autoload 'delete-rectangle "rect" "\
Delete (don't save) text in rectangle with point and mark as corners.
The same range of columns is deleted in each line
starting with the line where the region begins
and ending with the line where the region ends." t nil)

(autoload 'delete-extract-rectangle "rect" "\
Delete contents of rectangle and return it as a list of strings.
Arguments START and END are the corners of the rectangle.
The value is list of strings, one for each line of the rectangle." nil nil)

(autoload 'extract-rectangle "rect" "\
Return contents of rectangle with corners at START and END.
Value is list of strings, one for each line of the rectangle." nil nil)

(autoload 'kill-rectangle "rect" "\
Delete rectangle with corners at point and mark; save as last killed one.
Calling from program, supply two args START and END, buffer positions.
But in programs you might prefer to use `delete-extract-rectangle'." t nil)

(autoload 'yank-rectangle "rect" "\
Yank the last killed rectangle with upper left corner at point." t nil)

(autoload 'insert-rectangle "rect" "\
Insert text of RECTANGLE with upper left corner at point.
RECTANGLE's first line is inserted at point,
its second line is inserted at a point vertically under point, etc.
RECTANGLE should be a list of strings.
After this command, the mark is at the upper left corner
and point is at the lower right corner." nil nil)

(autoload 'open-rectangle "rect" "\
Blank out rectangle with corners at point and mark, shifting text right.
The text previously in the region is not overwritten by the blanks,
but instead winds up to the right of the rectangle." t nil)

(autoload 'string-rectangle "rect" "\
Insert STRING on each line of the region-rectangle, shifting text right.
The left edge of the rectangle specifies the column for insertion.
This command does not delete or overwrite any existing text.

Called from a program, takes three args; START, END and STRING." t nil)

(autoload 'clear-rectangle "rect" "\
Blank out rectangle with corners at point and mark.
The text previously in the region is overwritten by the blanks.
When called from a program, requires two args which specify the corners." t nil)

;;;***

;;;### (autoloads (reposition-window) "reposition" "prim/reposition.el" (11557 4883))
;;; Generated autoloads from prim/reposition.el

(autoload 'reposition-window "reposition" "\
Make the current definition and/or comment visible.
Further invocations move it to the top of the window or toggle the
visibility of comments that precede it.
  Point is left unchanged unless prefix ARG is supplied.
  If the definition is fully onscreen, it is moved to the top of the
window.  If it is partly offscreen, the window is scrolled to get the
definition (or as much as will fit) onscreen, unless point is in a comment
which is also partly offscreen, in which case the scrolling attempts to get
as much of the comment onscreen as possible.
  Initially `reposition-window' attempts to make both the definition and
preceding comments visible.  Further invocations toggle the visibility of
the comment lines.
  If ARG is non-nil, point may move in order to make the whole defun
visible (if only part could otherwise be made so), to make the defun line
visible (if point is in code and it could not be made so, or if only
comments, including the first comment line, are visible), or to make the
first comment line visible (if point is in a comment)." t nil)

;;;***

;;;### (autoloads (reverse-region sort-columns sort-regexp-fields sort-fields sort-float-fields sort-numeric-fields sort-pages sort-paragraphs sort-lines) "sort" "prim/sort.el" (11472 36618))
;;; Generated autoloads from prim/sort.el

(autoload 'sort-lines "sort" "\
Sort lines in region alphabetically; argument means descending order.
Called from a program, there are three arguments:
REVERSE (non-nil means reverse order), BEG and END (region to sort)." t nil)

(autoload 'sort-paragraphs "sort" "\
Sort paragraphs in region alphabetically; argument means descending order.
Called from a program, there are three arguments:
REVERSE (non-nil means reverse order), BEG and END (region to sort)." t nil)

(autoload 'sort-pages "sort" "\
Sort pages in region alphabetically; argument means descending order.
Called from a program, there are three arguments:
REVERSE (non-nil means reverse order), BEG and END (region to sort)." t nil)

(autoload 'sort-numeric-fields "sort" "\
Sort lines in region numerically by the ARGth field of each line.
Fields are separated by whitespace and numbered from 1 up.
Specified field must contain a number in each line of the region.
With a negative arg, sorts by the ARGth field counted from the right.
Called from a program, there are three arguments:
FIELD, BEG and END.  BEG and END specify region to sort.
If you want to sort floating-point numbers, try `sort-float-fields'." t nil)

(autoload 'sort-float-fields "sort" "\
Sort lines in region numerically by the ARGth field of each line.
Fields are separated by whitespace and numbered from 1 up.  Specified field
must contain a floating point number in each line of the region.  With a
negative arg, sorts by the ARGth field counted from the right.  Called from a
program, there are three arguments: FIELD, BEG and END.  BEG and END specify
region to sort." t nil)

(autoload 'sort-fields "sort" "\
Sort lines in region lexicographically by the ARGth field of each line.
Fields are separated by whitespace and numbered from 1 up.
With a negative arg, sorts by the ARGth field counted from the right.
Called from a program, there are three arguments:
FIELD, BEG and END.  BEG and END specify region to sort." t nil)

(autoload 'sort-regexp-fields "sort" "\
Sort the region lexicographically as specified by RECORD-REGEXP and KEY.
RECORD-REGEXP specifies the textual units which should be sorted.
  For example, to sort lines RECORD-REGEXP would be \"^.*$\"
KEY specifies the part of each record (ie each match for RECORD-REGEXP)
  is to be used for sorting.
  If it is \"\\digit\" then the digit'th \"\\(...\\)\" match field from
  RECORD-REGEXP is used.
  If it is \"\\&\" then the whole record is used.
  Otherwise, it is a regular-expression for which to search within the record.
If a match for KEY is not found within a record then that record is ignored.

With a negative prefix arg sorts in reverse order.

For example: to sort lines in the region by the first word on each line
 starting with the letter \"f\",
 RECORD-REGEXP would be \"^.*$\" and KEY would be \"\\=\\<f\\w*\\>\"" t nil)

(autoload 'sort-columns "sort" "\
Sort lines in region alphabetically by a certain range of columns.
For the purpose of this command, the region includes
the entire line that point is in and the entire line the mark is in.
The column positions of point and mark bound the range of columns to sort on.
A prefix argument means sort into reverse order.

Note that `sort-columns' rejects text that contains tabs,
because tabs could be split across the specified columns
and it doesn't know how to handle that.  Also, when possible,
it uses the `sort' utility program, which doesn't understand tabs.
Use \\[untabify] to convert tabs to spaces before sorting." t nil)

(autoload 'reverse-region "sort" "\
Reverse the order of lines in a region.
From a program takes two point or marker arguments, BEG and END." t nil)

;;;***

;;;### (autoloads (load-default-sounds load-sound-file) "sound" "prim/sound.el" (11555 56848))
;;; Generated autoloads from prim/sound.el

(autoload 'load-sound-file "sound" "\
Read in an audio-file and add it to the sound-alist.

You can only play sound files if you are running on display 0 of the console
of a Sun SparcStation, SGI machine, or HP9000s700.  The sound file must be in
the Sun/NeXT U-LAW format." t nil)

(autoload 'load-default-sounds "sound" "\
Load and install some sound files as beep-types.
This only works if you're on display 0 of a Sun SparcStation, SGI machine,
or HP9000s700." t nil)

;;;***

;;;### (autoloads (tabify untabify) "tabify" "prim/tabify.el" (11369 25282))
;;; Generated autoloads from prim/tabify.el

(autoload 'untabify "tabify" "\
Convert all tabs in region to multiple spaces, preserving columns.
Called non-interactively, the region is specified by arguments
START and END, rather than by the position of point and mark.
The variable `tab-width' controls the spacing of tab stops." t nil)

(autoload 'tabify "tabify" "\
Convert multiple spaces in region to tabs when possible.
A group of spaces is partially replaced by tabs
when this can be done without changing the column they end at.
Called non-interactively, the region is specified by arguments
START and END, rather than by the position of point and mark.
The variable `tab-width' controls the spacing of tab stops." t nil)

;;;***

;;;### (autoloads (previous-single-property-change previous-property-change next-single-property-change next-property-change text-property-not-all text-property-any text-properties-at extent-properties-at get-text-property) "text-props" "utils/text-props.el" (11560 51526))
;;; Generated autoloads from utils/text-props.el

(autoload 'get-text-property "text-props" "\
Returns the value of the PROP property at the given position." nil nil)

(autoload 'extent-properties-at "text-props" "\
Returns the properties of the character at the given position,
by merging the properties of overlapping extents.  The returned value
is a property list, some of which may be shared with other structures.
You must not modify it.

This returns all properties on all extents." nil nil)

(autoload 'text-properties-at "text-props" "\
Returns the properties of the character at the given position,
by merging the properties of overlapping extents.  The returned value
is a property list, some of which may be shared with other structures.
You must not modify it.

This returns only those properties added with `put-text-property'.
See also `extent-properties-at'." nil nil)

(autoload 'text-property-any "text-props" "\
Check text from START to END to see if PROP is ever `eq' to VALUE.
If so, return the position of the first character whose PROP is `eq'
to VALUE.  Otherwise return nil." nil nil)

(autoload 'text-property-not-all "text-props" "\
Check text from START to END to see if PROP is ever not `eq' to VALUE.
If so, return the position of the first character whose PROP is not
`eq' to VALUE.  Otherwise, return nil." nil nil)

(autoload 'next-property-change "text-props" "\
Return the position of next property change.
Scans forward from POS until it finds a change in some text property,
then returns the position of the change.  In other words, it returns the
position of the first character beyond POS whose properties are not
identical to those of the character just after POS.
LIMIT bounds the search (defaults to point-max.)
Returns nil if the properties remain unchanged all the way to the end." nil nil)

(autoload 'next-single-property-change "text-props" "\
Return the position of next property change for a specific property.
Scans forward from POS until it finds a change in PROPERTY,
then returns the position of the change.  In other words, it returns the
position of the first character beyond POS whose PROP property differs from
that of the character just after POS.
LIMIT bounds the search (defaults to point-max.)
Returns nil if the property is the same all the way to the end." nil nil)

(autoload 'previous-property-change "text-props" "\
Return the position of previous property change.
Scans backward from POS until it finds a change in some text property,
then returns the position of the change.  In other words, it returns the
position of the first character before POS whose properties are not
identical to those of the character just after POS.
LIMIT bounds the search (defaults to point-min.)
Returns nil if the properties remain unchanged all the way to the beginning." nil nil)

(autoload 'previous-single-property-change "text-props" "\
Return the position of previous property change for a specific property.
Scans backward from POS until it finds a change in PROPERTY,
then returns the position of the change.  In other words, it returns the
position of the first character before POS whose PROP property differs from
that of the character just after POS.
LIMIT bounds the search (defaults to point-min.)
Returns nil if the property is the same all the way to the beginning." nil nil)

;;;***

;;;### (autoloads (ask-user-about-supersession-threat ask-user-about-lock) "userlock" "prim/userlock.el" (11387 47384))
;;; Generated autoloads from prim/userlock.el

(autoload 'ask-user-about-lock "userlock" "\
Ask user what to do when he wants to edit FILE but it is locked by USER.
This function has a choice of three things to do:
  do (signal 'buffer-file-locked (list FILE USER))
    to refrain from editing the file
  return t (grab the lock on the file)
  return nil (edit the file even though it is locked).
You can rewrite it to use any criterion you like to choose which one to do." nil nil)

(autoload 'ask-user-about-supersession-threat "userlock" "\
Ask a user who is about to modify an obsolete buffer what to do.
This function has two choices: it can return, in which case the modification
of the buffer will proceed, or it can (signal 'file-supersession (file)),
in which case the proposed buffer modification will not be made.

You can rewrite this to use any criterion you like to choose which one to do.
The buffer in question is current when this function is called." nil nil)

;;;***

;;;### (autoloads (rmail-input rmail-mode rmail) "rmail" "rmail/rmail.el" (11565 27829))
;;; Generated autoloads from rmail/rmail.el

(defvar rmail-dont-reply-to-names nil "\
*A regexp specifying names to prune of reply to messages.
A value of nil means exclude your own name only.")

(defvar rmail-default-dont-reply-to-names "info-" "\
A regular expression specifying part of the value of the default value of
the variable `rmail-dont-reply-to-names', for when the user does not set
`rmail-dont-reply-to-names' explicitly.  (The other part of the default
value is the user's name.)
It is useful to set this variable in the site customization file.")

(defvar rmail-delete-after-output nil "\
*Non-nil means automatically delete a message that is copied to a file.")

(defvar rmail-primary-inbox-list nil "\
*List of files which are inboxes for user's primary mail file `~/RMAIL'.
`nil' means the default, which is (\"/usr/spool/mail/$USER\")
\(the name varies depending on the operating system,
and the value of the environment variable MAIL overrides it).")

(defvar rmail-mail-new-frame nil "\
*Non-nil means Rmail makes a new frame for composing outgoing mail.")

(defvar rmail-retry-setup-hook nil "\
Hook that `rmail-retry-failure' uses in place of `mail-setup-hook'.")

(autoload 'rmail "rmail" "\
Read and edit incoming mail.
Moves messages into file named by `rmail-file-name' (a babyl format file)
 and edits that file in RMAIL Mode.
Type \\[describe-mode] once editing that file, for a list of RMAIL commands.

May be called with filename as argument; then performs rmail editing on
that file, but does not copy any new mail into the file." t nil)

(autoload 'rmail-mode "rmail" "\
Rmail Mode is used by \\<rmail-mode-map>\\[rmail] for editing Rmail files.
All normal editing commands are turned off.
Instead, these commands are available:

\\[rmail-beginning-of-message]	Move point to front of this message (same as \\[beginning-of-buffer]).
\\[scroll-up]	Scroll to next screen of this message.
\\[scroll-down]	Scroll to previous screen of this message.
\\[rmail-next-undeleted-message]	Move to Next non-deleted message.
\\[rmail-previous-undeleted-message]	Move to Previous non-deleted message.
\\[rmail-next-message]	Move to Next message whether deleted or not.
\\[rmail-previous-message]	Move to Previous message whether deleted or not.
\\[rmail-first-message]	Move to the first message in Rmail file.
\\[rmail-last-message]	Move to the last message in Rmail file.
\\[rmail-show-message]	Jump to message specified by numeric position in file.
\\[rmail-search]	Search for string and show message it is found in.
\\[rmail-delete-forward]	Delete this message, move to next nondeleted.
\\[rmail-delete-backward]	Delete this message, move to previous nondeleted.
\\[rmail-undelete-previous-message]	Undelete message.  Tries current message, then earlier messages
	till a deleted message is found.
\\[rmail-edit-current-message]	Edit the current message.  \\[rmail-cease-edit] to return to Rmail.
\\[rmail-expunge]	Expunge deleted messages.
\\[rmail-expunge-and-save]	Expunge and save the file.
\\[rmail-quit]       Quit Rmail: expunge, save, then switch to another buffer.
\\[save-buffer] Save without expunging.
\\[rmail-get-new-mail]	Move new mail from system spool directory into this file.
\\[rmail-mail]	Mail a message (same as \\[mail-other-window]).
\\[rmail-continue]	Continue composing outgoing message started before.
\\[rmail-reply]	Reply to this message.  Like \\[rmail-mail] but initializes some fields.
\\[rmail-retry-failure]	Send this message again.  Used on a mailer failure message.
\\[rmail-forward]	Forward this message to another user.
\\[rmail-output-to-rmail-file]       Output this message to an Rmail file (append it).
\\[rmail-output]	Output this message to a Unix-format mail file (append it).
\\[rmail-input]	Input Rmail file.  Run Rmail on that file.
\\[rmail-add-label]	Add label to message.  It will be displayed in the mode line.
\\[rmail-kill-label]	Kill label.  Remove a label from current message.
\\[rmail-next-labeled-message]   Move to Next message with specified label
          (label defaults to last one specified).
          Standard labels: filed, unseen, answered, forwarded, deleted.
          Any other label is present only if you add it with \\[rmail-add-label].
\\[rmail-previous-labeled-message]   Move to Previous message with specified label
\\[rmail-summary]	Show headers buffer, with a one line summary of each message.
\\[rmail-summary-by-labels]	Summarize only messages with particular label(s).
\\[rmail-summary-by-recipients]   Summarize only messages with particular recipient(s).
\\[rmail-summary-by-regexp]   Summarize only messages with particular regexp(s).
\\[rmail-summary-by-topic]   Summarize only messages with subject line regexp(s).
\\[rmail-toggle-header]	Toggle display of complete header." t nil)

(autoload 'rmail-input "rmail" "\
Run Rmail on file FILENAME." t nil)

;;;***

;;;### (autoloads (rmail-file-p) "rmailout" "rmail/rmailout.el" (11555 61924))
;;; Generated autoloads from rmail/rmailout.el

(autoload 'rmail-file-p "rmailout" nil nil nil)

;;;***



;;;### (autoloads (unrmail batch-unrmail) "unrmail" "rmail/unrmail.el" (11551 28253))
;;; Generated autoloads from rmail/unrmail.el

(autoload 'batch-unrmail "unrmail" "\
Convert Rmail files to mailbox files.
Specify the input Rmail file names as command line arguments.
For each Rmail file, the corresponding output file name
is made by adding `.mail' at the end.
For example, invoke `emacs -batch -f batch-unrmail RMAIL'." nil nil)

(autoload 'unrmail "unrmail" "\
Convert Rmail file FILE to mailbox-format file TO-FILE." t nil)

;;;***

;;;### (autoloads (ad-start-advice defadvice ad-add-advice) "advice" "utils/advice.el" (11393 25327))
;;; Generated autoloads from utils/advice.el

(defvar ad-start-advice-on-load nil "\
*Non-NIL will start advice magic when this file gets loaded.
Also see function `ad-start-advice'.")

(defvar ad-activate-on-definition nil "\
*Non-NIL means automatic advice activation at function definition.
Set this variable to t if you want to enable forward advice (which is
automatic advice activation of a previously undefined function at the
point the function gets defined/loaded/autoloaded). The value of this
variable takes effect only during the execution of `ad-start-advice'. 
If non-NIL it will enable definition hooks regardless of the value
of `ad-enable-definition-hooks'.")

(defvar ad-redefinition-action 'warn "\
*Defines what to do with redefinitions during de/activation.
Redefinition occurs if a previously activated function that already has an
original definition associated with it gets redefined and then de/activated.
In such a case we can either accept the current definition as the new
original definition, discard the current definition and replace it with the
old original, or keep it and raise an error. The values `accept', `discard',
`error' or `warn' govern what will be done. `warn' is just like `accept' but
it additionally prints a warning message. All other values will be
interpreted as `error'.")

(defvar ad-definition-hooks nil "\
*List of hooks to be run after a function definition.
The variable `ad-defined-function' will be bound to the name of
the currently defined function when the hook function is run.")

(defvar ad-enable-definition-hooks nil "\
*Non-NIL will enable hooks to be run on function definition.
Setting this variable is a noop unless the value of
`ad-activate-on-definition' (which see) is NIL.")

(defvar ad-use-jwz-byte-compiler (fboundp 'eval-when-compile) "\
*Non-NIL means Jamie Zawinski's v19 byte-compiler will be used.
If you use a v18 Emacs and don't use jwz's optimizing byte-compiler (the
normal case) then this variable should be NIL, because otherwise
enabling definition hooks (e.g., for forward advice) will redefine the 
`byte-code' subr which will lead to some performance degradation for
byte-compiled code.")

(autoload 'ad-add-advice "advice" "\
Adds a piece of ADVICE to FUNCTION's list of advices in CLASS.
If FUNCTION already has one or more pieces of advice of the specified
CLASS then POSITION determines where the new piece will go. The value
of POSITION can either be `first', `last' or a number where 0 corresponds
to `first'. Numbers outside the range will be mapped to the closest
extreme position. If there was already a piece of ADVICE with the same
name, then the position argument will be ignored and the old advice
will be overwritten with the new one.
    If the FUNCTION was not advised already, then its advice info will be 
initialized. Redefining a piece of advice whose name is part of the cache-id
will clear the cache." nil nil)

(autoload 'defadvice "advice" "\
Defines a piece of advice for FUNCTION (a symbol).

  (defadvice <function> (<class> <name> [<position>] [<arglist>] {<flags>}*)
    [ [<documentation-string>] [<interactive-form>] ]
    {<body-form>}* )

<function> ::= name of the function to be advised
<class> ::= before | around | after | activation | deactivation
<name> ::= non-NIL symbol that names this piece of advice
<position> ::= first | last | <number> (optional, defaults to `first',
    see also `ad-add-advice')
<arglist> ::= an optional argument list to be used for the advised function
    instead of the argument list of the original. The first one found in
    before/around/after advices will be used.
<flags> ::= protect | disable | activate | compile | preactivate
    All flags can be specified with unambiguous initial substrings.
<documentation-string> ::= optional documentation for this piece of advice
<interactive-form> ::= optional interactive form to be used for the advised
    function. The first one found in before/around/after advices will be used.
<body-form> ::= any s-expression

Semantics of the various flags:
`protect': The piece of advice will be protected against non-local exits in
any code that precedes it. If any around advice of a function is protected
then automatically all around advices will be protected (the complete onion).

`activate': All advice of FUNCTION will be activated immediately if
FUNCTION has been properly defined prior to the defadvice.

`compile': In conjunction with `activate' specifies that the resulting
advised function should be compiled.

`disable': The defined advice will be disabled, hence it will not be used 
during activation until somebody enables it.

`preactivate': Preactivates the advised FUNCTION at macro expansion/compile
time. This generates a compiled advised definition according to the current
advice state that will be used during activation if appropriate. Only use
this if the defadvice gets actually compiled (with a v18 byte-compiler put
the defadvice into the body of a defun).

Look at the file advice.el for comprehensive documentation." nil 'macro)

(autoload 'ad-start-advice "advice" "\
Redefines some primitives to start the advice magic.
If `ad-activate-on-definition' is t then advice information will
automatically get activated whenever an advised function gets defined or
redefined.  This will enable goodies such as forward advice and
automatically enable function definition hooks. If its value is nil but
the value of `ad-enable-definition-hooks' is t then definition hooks
will be enabled without having automatic advice activation, otherwise
function definition hooks will be disabled too. If definition hooks are
enabled then functions stored in `ad-definition-hooks' are run whenever
a function gets defined or redefined." t nil)

;;;***

;;;### (autoloads (batch-update-autoloads update-directory-autoloads update-autoloads-here update-file-autoloads) "autoload" "utils/autoload.el" (11560 52293))
;;; Generated autoloads from utils/autoload.el

(autoload 'update-file-autoloads "autoload" "\
Update the autoloads for FILE in `generated-autoload-file'
\(which FILE might bind in its local variables)." t nil)

(autoload 'update-autoloads-here "autoload" "\
Update sections of the current buffer generated by \\[update-file-autoloads]." t nil)

(autoload 'update-directory-autoloads "autoload" "\
Run \\[update-file-autoloads] on each .el file in DIR." t nil)

(autoload 'batch-update-autoloads "autoload" "\
Update the autoloads for the files or directories on the command line.
Runs \\[update-file-autoloads] on files and \\[update-directory-autoloads]
on directories.  Must be used only with -batch, and kills Emacs on completion.
Each file will be processed even if an error occurred previously.
For example, invoke \"emacs -batch -f batch-update-autoloads *.el\"" nil nil)

;;;***

;;;### (autoloads (\`) "backquote" "utils/backquote.el" (11555 57320))
;;; Generated autoloads from utils/backquote.el

(autoload '\` "backquote" "\
\(` FORM)  is a macro that expands to code to construct FORM.
Note that this is very slow in interpreted code, but fast if you compile.
FORM is one or more nested lists, which are `almost quoted':
They are copied recursively, with non-lists used unchanged in the copy.
 (` a b) == (list 'a 'b)  constructs a new list with two elements, `a' and `b'.
 (` a (b c)) == (list 'a (list 'b 'c))  constructs two nested new lists.

However, certain special lists are not copied.  They specify substitution.
Lists that look like (, EXP) are evaluated and the result is substituted.
 (` a (, (+ x 5))) == (list 'a (+ x 5))

Elements of the form (,@ EXP) are evaluated and then all the elements
of the result are substituted.  This result must be a list; it may
be `nil'.

As an example, a simple macro `push' could be written:
   (defmacro push (v l)
        (` (setq (, l) (cons (,@ (list v l))))))
or as
   (defmacro push (v l)
        (` (setq (, l) (cons (, v) (, l)))))

LIMITATIONS: \"dotted lists\" are not allowed in FORM.
The ultimate cdr of each list scanned by ` must be `nil'.
\(This does not apply to constants inside expressions to be substituted.)

Substitution elements are not allowed as the cdr
of a cons cell.  For example, (` (A . (, B))) does not work.
Instead, write (` (A (,@ B))).

You cannot construct vectors, only lists.  Vectors are treated as
constants.

BEWARE BEWARE BEWARE
Inclusion of (,ATOM) rather than (, ATOM)
or of (,@ATOM) rather than (,@ ATOM)
will result in errors that will show up very late." nil 'macro)

;;;***

;;;### (autoloads (forms-find-file-other-window forms-find-file forms-mode) "forms" "utils/forms.el" (11551 56255))
;;; Generated autoloads from utils/forms.el

(autoload 'forms-mode "forms" "\
Major mode to visit files in a field-structured manner using a form.

Commands:                        Equivalent keys in read-only mode:

 TAB          forms-next-field           TAB
 C-c TAB      forms-next-field
 C-c <        forms-first-record         <
 C-c >        forms-last-record          >
 C-c ?        describe-mode              ?
 C-c C-k      forms-delete-record
 C-c C-q      forms-toggle-read-only     q
 C-c C-o      forms-insert-record
 C-c C-l      forms-jump-record          l
 C-c C-n      forms-next-record          n
 C-c C-p      forms-prev-record          p
 C-c C-s      forms-search               s
 C-c C-x      forms-exit                 x" t nil)

(autoload 'forms-find-file "forms" "\
Visit a file in Forms mode." t nil)

(autoload 'forms-find-file-other-window "forms" "\
Visit a file in Forms mode in other window." t nil)

;;;***

;;;### (autoloads (highlight-headers) "highlight-headers" "utils/highlight-headers.el" (11555 56853))
;;; Generated autoloads from utils/highlight-headers.el

(autoload 'highlight-headers "highlight-headers" "\
Highlight message headers between start and end.
Faces used:
  message-headers			the part before the colon
  message-header-contents		the part after the colon
  message-highlighted-header-contents	contents of \"special\" headers
  message-cited-text			quoted text from other messages

Variables used:

  highlight-headers-regexp			what makes a \"special\" header
  highlight-headers-citation-regexp		matches lines of quoted text
  highlight-headers-citation-header-regexp	matches headers for quoted text

If HACK-SIG is true,then we search backward from END for something that
looks like the beginning of a signature block, and don't consider that a
part of the message (this is because signatures are often incorrectly
interpreted as cited text.)" nil nil)

;;;***

;;;### (autoloads (what-domain mail-extract-address-components) "mail-extr" "utils/mail-extr.el" (11555 56855))
;;; Generated autoloads from utils/mail-extr.el

(autoload 'mail-extract-address-components "mail-extr" "\
Given an RFC-822 ADDRESS, extract full name and canonical address.
Returns a list of the form (FULL-NAME CANONICAL-ADDRESS).
If no name can be extracted, FULL-NAME will be nil.
ADDRESS may be a string or a buffer.  If it is a buffer, the visible 
 (narrowed) portion of the buffer will be interpreted as the address.
 (This feature exists so that the clever caller might be able to avoid
 consing a string.)
If ADDRESS contains more than one RFC-822 address, only the first is
 returned.  Some day this function may be extended to extract multiple
 addresses, or perhaps return the position at which parsing stopped." nil nil)

(autoload 'what-domain "mail-extr" "\
Prompts for a mail domain, and prints the country it corresponds to
in the minibuffer." t nil)

;;;***

;;;### (autoloads nil "mail-utils" "utils/mail-utils.el" (11555 56858))
;;; Generated autoloads from utils/mail-utils.el

(defvar mail-use-rfc822 nil "\
*If non-nil, use a full, hairy RFC822 parser on mail addresses.
Otherwise, (the default) use a smaller, somewhat faster and
often-correct parser.")

;;;***

;;;### (autoloads (map-y-or-n-p) "map-ynp" "utils/map-ynp.el" (11352 16196))
;;; Generated autoloads from utils/map-ynp.el

(autoload 'map-y-or-n-p "map-ynp" "\
Ask a series of boolean questions.
Takes args PROMPTER ACTOR LIST, and optional arg HELP.

LIST is a list of objects, or a function of no arguments to return the next
object or nil.

If PROMPTER is a string, the prompt is (format PROMPTER OBJECT).  If not
a string, PROMPTER is a function of one arg (an object from LIST), which
returns a string to be used as the prompt for that object.  If the return
value is not a string, it is eval'd to get the answer; it may be nil to
ignore the object, t to act on the object without asking the user, or a
form to do a more complex prompt.


ACTOR is a function of one arg (an object from LIST),
which gets called with each object that the user answers `yes' for.

If HELP is given, it is a list (OBJECT OBJECTS ACTION),
where OBJECT is a string giving the singular noun for an elt of LIST;
OBJECTS is the plural noun for elts of LIST, and ACTION is a transitive
verb describing ACTOR.  The default is (\"object\" \"objects\" \"act on\").

At the prompts, the user may enter y, Y, or SPC to act on that object;
n, N, or DEL to skip that object; ! to act on all following objects;
ESC or q to exit (skip all following objects); . (period) to act on the
current object and then exit; or \\[help-command] to get help.

Returns the number of actions taken." nil nil)

;;;***

;;;### (autoloads (make-ring ring-p) "ring" "utils/ring.el" (11387 47427))
;;; Generated autoloads from utils/ring.el

(autoload 'ring-p "ring" "\
Returns t if X is a ring; nil otherwise." nil nil)

(autoload 'make-ring "ring" "\
Make a ring that can contain SIZE elements." nil nil)

;;;***

;;;### (autoloads (trace-function-background trace-function) "trace" "utils/trace.el" (11352 16204))
;;; Generated autoloads from utils/trace.el

(defvar trace-buffer "*trace-output*" "\
*Trace output will by default go to that buffer.")

(autoload 'trace-function "trace" "\
Traces FUNCTION with trace output going to BUFFER.
For every call of FUNCTION Lisp-style trace messages that display argument
and return values will be inserted into BUFFER. This function generates the
trace advice for FUNCTION and activates it together with any other advice
there might be!! The trace BUFFER will popup whenever FUNCTION is called.
Do not use this to trace functions that switch buffers or do any other
display oriented stuff, use `trace-function-background' instead." t nil)

(autoload 'trace-function-background "trace" "\
Traces FUNCTION with trace output going quietly to BUFFER.
For every call of FUNCTION Lisp-style trace messages that display argument
and return values will be inserted into BUFFER. This function generates the
trace advice for FUNCTION and activates it together with any other advice
there might be!! Trace output will quietly go to BUFFER without changing
the window or buffer configuration at all." t nil)

;;;***

;;;### (autoloads (y-or-n-p-with-timeout yes-or-no-p-with-timeout with-timeout) "with-timeout" "utils/with-timeout.el" (11555 56859))
;;; Generated autoloads from utils/with-timeout.el

(autoload 'with-timeout "with-timeout" "\
Usage: (with-timeout (seconds &rest timeout-forms) &rest body)
This is just like progn, but if the given number of seconds expires before
the body returns, then timeout-forms are evaluated and returned instead.
The body won't be interrupted in the middle of a computation: the check for 
the timer expiration only occurs when body does a redisplay, or prompts the
user for input, or calls accept-process-output." nil 'macro)

(autoload 'yes-or-no-p-with-timeout "with-timeout" "\
Just like yes-or-no-p, but will time out after TIMEOUT seconds
if the user has not yes answered, returning DEFAULT-VALUE." nil nil)

(autoload 'y-or-n-p-with-timeout "with-timeout" "\
Just like y-or-n-p, but will time out after TIMEOUT seconds
if the user has not yes answered, returning DEFAULT-VALUE." nil nil)

;;;***

;;;### (autoloads nil "w3" "w3/w3.el" (11567 50497))
;;; Generated autoloads from w3/w3.el
(autoload 'w3-open-local "w3" "Open local file for WWW browsing" t)
(autoload 'w3-fetch "w3" "Open remote file for WWW browsing" t)
(autoload 'w3-use-hotlist "w3" "Use shortcuts to WWW Docs" t)
(autoload 'w3-preview-this-buffer "w3" "Parse this buffer as HTML" t)
(autoload 'w3-batch-fetch "w3" "Batch fetch urls")
(autoload 'w3-retrieve "w3" "Fetch urls")

;;;***

;;; Don't make backup versions of this file - most of it is generated
;;; automatically by autoload.el, and what isn't changes rarely.
;;; Local Variables:
;;; version-control: never
;;; no-byte-compile: t
;;; no-update-autoloads: t
;;; End:
;;; loaddefs.el ends here
