#! /bin/zsh -f

# Written by SL Baur  <steve@xemacs.org>
# December, 1998
# This file is an unofficial part of XEmacs and is used by the maintainers
#  for creating distributions

setopt extendedglob
set -e

if [ $# != 2 ]; then
	echo "Usage: $0: previous next"
	exit 1
fi

export previous=$1

export STAGING=$(pwd)
# export CVSROOT=/usr/local/xemacs # Change to /usr/CVSroot
export CVSROOT=/usr/CVSroot
export MAJOR=$(echo $2 | cut -d'.' -f1)
export MINOR=$(echo $2 | cut -d'.' -f2)
export BUILD=$(echo $2 | cut -d'.' -f3)
export BUILDDIR=xemacs-${MAJOR}.${MINOR}

# Get a fresh copy of the sources, force reload from CVS
./CleanDist.zsh ${MAJOR} ${MINOR} t

# Bump the version number
./IncVers.zsh ${MAJOR} ${MINOR} ${BUILD}

# Link extra packages if needed
./LinkPackages.zsh ${BUILDDIR}

# Build XEmacs and configure it first
./MakeXEmacs.zsh ${BUILDDIR} t nil

if [ ! -x ${BUILDDIR}/src/xemacs ]; then
	echo "Error: XEmacs binary failed to build"
	exit 1
fi

# Update package binaries
./UpdatePackages.zsh ${BUILDDIR}/src/xemacs

# Redump XEmacs and build the rest of the .elcs and texinfo
rm -f ${BUILDDIR}/src/xemacs
./MakeXEmacs.zsh ${BUILDDIR} nil t

Mail -s "Distribution Build Report for XEmacs-${MAJOR}.${MINOR}.${BUILD}" xemacs-beta@xemacs.org <<EOF
Greetings XEmacs beta testers.  I am in the process of building the next
distribution of XEmacs ${MAJOR}.${MINOR}.  I have tested the attached
configuration.

Sincerely,
The XEmacs Build 'Bot

-- 
$(< ${BUILDDIR}/Installation)
EOF

# Add a message to the ChangeLog files regarding the release
./UpdateLogs.zsh ${MAJOR} ${MINOR} ${BUILD} t

if [ -f ${BUILDDIR}/Makefile ]; then
	(cd ${BUILDDIR}; make distclean)
fi

# Tag the release
./CVSGraffito.zsh ${MAJOR} ${MINOR} ${BUILD}

# Prepare .tar.gzs for upload
./MakeTarballs.zsh r$(echo $previous | sed -e 's/\./-/g') \
		   r${MAJOR}-${MINOR}-${BUILD} ${MAJOR} ${MINOR} ${BUILD}

# PGP sign everything
#./PGPSign.zsh ${MAJOR} ${MINOR} ${BUILD}

# Rebuild so we have something to build packages with later
./LinkPackages.zsh ${BUILDDIR}
./MakeXEmacs.zsh ${BUILDDIR} t t
