#ifndef _spline_ed.h
#define _spline_ed.h

#include <gl/gl.h>
#include <stdio.h>
#include "debug.h"

void	plot_t_spline(long gid,float coeff[4][3],float t);
float	solve_3order(float,float,float,float);
float	solve_2order(float,float,float);
void 	plot_point(long ,long, float ,float );
void 	plot_dbg_spline(long ,float a[4][3] );


// Window Viewport Size, used for ORTHO and misc scaling caclulations
#define XMIN (-100)	// always keep here for border
#define XMAX  900
#define	YMIN  (-50)
#define YMAX  500
#define ZMIN (-100)
#define ZMAX  100


class spline_cntrl_points {
    
  public:
    int num_pts;
    spline_cntrl_points(int);
    ~spline_cntrl_points();
    float *pnts;
    float xpos(int i) { return(pnts[i*3]); }
    float ypos(int i) { return(pnts[i*3+1]); }  
    float zpos(int i) { return(pnts[i*3+2]); }
    void eq(int i,float x,float y) {pnts[i*3]=x; pnts[i*3+1]=y; }
    
    void reset();		// reset point values to initial condition
    void plot(void); 
    int	find_point(); 
    void print(void);		// print the points
};


class spline_editor {
  private: 
    int		id;
    char 	title[50];	// should strcpy over but...
        
  public:
    long 	gid,st_frame,end_frame,curr_frame;
    spline_cntrl_points *cntrl_pts;

    spline_editor(int id,int no_cntrls,long start,long end);
    ~spline_editor(void) {delete cntrl_pts;};
    long winid(void) { return(gid); } ; 	// return window id #
    long get_id()    { return(id); }; 	// spline id #
    long open(void);			// returns win_id for callbacks
    long open(long,long,long,long);	
    void callback(long,short);	// handles winman callbacks for mice
    void set_title(char *a) {
	sprintf(title,"%s",a);
	if (gid !=0) {
	    winset(gid); wintitle(title);
	}
    } ; // bad style ALERT !!!, should copy over the memory area! 

    char *get_title() { return(title); }; 
    int append(spline_editor *);
    int prepend(spline_editor *);
    int merge(spline_editor *);
    int	replace(spline_editor *);
    void redraw(void);
    void print(void) {
	status(title,(int)st_frame,(int)end_frame);
	cntrl_pts->print();
    };
    float value(long frame);	// return value at frame #
    
};


typedef	spline_editor *  spline_pntr;


class	winman {
  public:
    winman(int);
    void inform(spline_editor *a,long b) {
	inform(a,b,"Untitled"); };

    int inform(spline_editor *,long,char *);
    spline_editor *lookup(long);
    int	num_win() { return(nbr_win);};
    char *get_title(int);

    float	win_xstart,win_xstop;	// current "scroll" position
    float	script_max_xpos; 
    float	curr_xpos;
  
  private:
    
    int		maxwin;
    int		nbr_win;
 

    char	**titles;
    long	*gid_tab;
    spline_pntr *obj_tab;
    
};


#endif

