// Program to exercise the new spline editor classes


#include <gl/gl.h>
#include <gl/device.h>
#include <stdio.h>
#include <unistd.h>

#include "colors.h"
#include "debug.h"
#include "actor.h"
#include "winman.h"

extern "C" {
#include <forms.h>
#include "spline_forms.h"
#include "IPC.h"
}


void	event_handler();
int 	create_muscle_scene(char *name);

Winman	mngr;
int	skt;	/* Socket to Connect with Face DIsplayer over */
main()
{


    Actor 	*zenbun[10];
    int		b0,b1;
    char	title[15];
    foreground();
    status("This program simply test the Actor/scene/script classes");

    // Setup the FORMS2.0 Environment
    create_the_forms();

    fl_qdevice(LEFTMOUSE);
    fl_qdevice(MIDDLEMOUSE);
    fl_qdevice(RIGHTMOUSE);
    fl_qdevice(REDRAW);
    fl_qdevice(INPUTCHANGE);

    fl_clear_browser(curr_board_lbl);
    fl_add_browser_line(curr_board_lbl,"NoCurrentBoard");
    fl_show_form(spline_cntrl,FL_PLACE_MOUSE,TRUE,"Script Cntrl");
    
    defbasis(CARD_BASIS,cspline_matrix);
    curvebasis(CARD_BASIS);
    curveprecision(2);
    

    b0 = create_muscle_scene("Scratch");
     
    mngr.print_boards();
    mngr.print_actors(b0);	// print all scenes from Board ID 1
 
#ifndef STANDALONE
    /* Connect to the Face display program is not STANDALONE MoDE */
    skt=setup_client_IPC();
#endif
  
    event_handler();
  

}




/*** create_muscle_scene -- create a standard scene with all the controls ***/
int create_muscle_scene(char *name)
{
    
    static int	ID=1;
    int		num_actors;
    int		brd,i;
    Actor	*t;
    
    
    ID++;
    num_actors=17;
    
    brd = mngr.create_board(name,ID,num_actors);
    
    // Actor(#pnts, Title, ID#)
    
    t = new Actor(10,"Zygos",1);
    mngr.register_actor(brd,t->title,t->id,t);
    
    t = new Actor(10,"Anguli_Depressor",2);
    mngr.register_actor(brd,t->title,t->id,t);
    
    t = new Actor(10,"Inner_Frontalis",3);
    mngr.register_actor(brd,t->title,t->id,t);
    
    t = new Actor(10,"Outer_Fronatlis",4);
    mngr.register_actor(brd,t->title,t->id,t);
    
    t = new Actor(10,"Labi",5);
    mngr.register_actor(brd,t->title,t->id,t);
    
    t = new Actor(10,"Corrugator",6);
    mngr.register_actor(brd,t->title,t->id,t);
    
    t = new Actor(10,"Nasi(L)",71);
    mngr.register_actor(brd,t->title,t->id,t);
    
    t = new Actor(10,"Lat_Corrugator",8);
    mngr.register_actor(brd,t->title,t->id,t);
    
    t = new Actor(10,"Major_Frontalis",9);
    mngr.register_actor(brd,t->title,t->id,t);
    
    t = new Actor(10,"Jaw_Rotation",10);
    mngr.register_actor(brd,t->title,t->id,t);
    
    t = new Actor(10,"Lip_Z",11);
    mngr.register_actor(brd,t->title,t->id,t);
    
    t = new Actor(10,"Lip_Y",12);
    mngr.register_actor(brd,t->title,t->id,t);
    
    t = new Actor(10,"Mouth",13);
    mngr.register_actor(brd,t->title,t->id,t);
    
    t = new Actor(4,"Eye_X",14);
    t->eq(0,(float)t->xpos(0),250);	/* We should specify by 0.1 scale! */
    t->eq(1,(float)t->xpos(0)+20.0,250);
    t->eq(2,(float)t->xpos(3)-20.0,250);	
    t->eq(3,(float)t->xpos(3),250);	/* We should specify by 0.1 scale! */
    mngr.register_actor(brd,t->title,t->id,t);
    
   
    
    t = new Actor(4,"Eye_Y",15);
    t->eq(0,(float)t->xpos(0),250);	/* We should specify by 0.1 scale! */
    t->eq(1,(float)t->xpos(0)+20.0,250);
    t->eq(2,(float)t->xpos(3)-20.0,250);	
    t->eq(3,(float)t->xpos(3),250);	/* We should specify by 0.1 scale! */
    
    mngr.register_actor(brd,t->title,t->id,t);
    
    t = new Actor(4,"Side_Head",16);
    t->eq(0,(float)t->xpos(0),250);	/* We should specify by 0.1 scale! */
    t->eq(1,(float)t->xpos(0)+20.0,250);
    t->eq(2,(float)t->xpos(3)-20.0,250);	
    t->eq(3,(float)t->xpos(3),250);	/* We should specify by 0.1 scale! */
    mngr.register_actor(brd,t->title,t->id,t);
    
    t = new Actor(4,"Nod-Head",17);
    t->eq(0,(float)t->xpos(0),250);	/* We should specify by 0.1 scale! */
    t->eq(1,(float)t->xpos(0)+20.0,250);
    t->eq(2,(float)t->xpos(3)-20.0,250);	
    t->eq(3,(float)t->xpos(3),250);	/* We should specify by 0.1 scale! */
 
    mngr.register_actor(brd,t->title,t->id,t);
    
   
    return(brd);
}



/*** event_handler ****/
void event_handler()
{

    FL_OBJECT *obj;
    long dev;
    static short val,curr_win;
    
    status("Looping in Event Handler...");
    while(1) {
	obj = fl_do_forms();
	if (obj == FL_EVENT) {
	 
	    dev = fl_qread(&val);
	    
	    switch ( (int)dev) {
	      case INPUTCHANGE:
		curr_win = val;			// 0 if exits a window 
		break;
		
	      case REDRAW: // all events that aren't in current window
		winset(val);
		curr_win= val;
		mngr.forward_gl_event(dev,val,curr_win);
		break;
		
	      case NULLDEV:
		fl_qreset();
		break;
	
	      default:
		winset(curr_win);
		mngr.forward_gl_event(dev,val,curr_win);

	    }
	}	// if (FL_EVENT)
    }  // while(1)
    
}
































































































