
#import <dpsclient/dpsNeXT.h>
#import "MyN3DCamera.h"
#import "TestShape.h"
#import <3Dkit/N3DRotator.h>
#import <appkit/OpenPanel.h>
#import <appkit/Slider.h>
#import <appkit/TextField.h>
#import <appkit/Form.h>
#import <appkit/Matrix.h>
#import <appkit/NXColorWell.h>
#import <appkit/Application.h>

#include <math.h>

void runOneStep();

@implementation MyN3DCamera

- openFile:sender
{
    const char *const *files;
    static const char *imageTypes[2] = {"rib",NULL};
    const char *directory;
    
    openPanel = [OpenPanel new];
    [openPanel allowMultipleFiles:NO];
    
    if ([openPanel runModalForTypes:imageTypes]) {
	files = [openPanel filenames];
	directory = [openPanel directory];
	if(files && *files) {
	    sprintf(filepath,"%s/%s",directory,files[0]);
	    [ourShape loadRIB:filepath];
	}
        [self display];
    }
    return self;
}

- appDidInit:sender
{
    RtPoint from;
    
    ourShape = [[TestShape alloc] init];
    
    filepath[0]=0;
         
    [worldShape linkDescendant:ourShape];
    
    myRotator = [[N3DRotator alloc] initWithCamera:self];
    
    shading = [[shadingMatrix selectedCell] tag];
    thehider = [[hiderMatrix selectedCell] tag];
    [ourShape setSurfaceType:(N3DSurfaceType)shading andDescendants:NO];
    [self setHider:(N3DHider)thehider];
    rotation = [[rotationMatrix selectedCell] tag];
    
    tesselation = 8;
    [tesselationSlider setIntValue:tesselation];
    [tesselationField setIntValue:tesselation];
    [ourShape setTesselation:tesselation];
    
    scale = 1.0;
    [scaleField setDoubleValue:scale];
    
    color = NXConvertRGBToColor(1.0, 1.0, 1.0);
    [colorWell setColor:color];
    [ourShape setColor:color];
    [self openFile:self];
    
    /* This will *usually* bring the object onscreen */
    from[0]=from[1]=0;
    from[2]=3.0;
    
    [self setEyeAt:from toward:N3DOrigin roll:0];
    [self display];
    shouldPreMultiply = 0;
    return self;
}

- rotationSelected:sender
{
    rotation = [[rotationMatrix selectedCell] tag];
    return self;
}

- shadingSelected:sender
{
    shading = [[shadingMatrix selectedCell] tag];
    [ourShape setSurfaceType:(N3DSurfaceType)shading andDescendants:NO];
    [self display];
    return self;
}

- setHiding:sender
{
    thehider = [[hiderMatrix selectedCell] tag];
    [self setHider:(N3DHider)thehider];
    [self display];
    return self;
}

- tesselationSelected:sender
{
    int value = [sender intValue];
    if(sender==tesselationSlider) [tesselationField setIntValue:value];
    else [tesselationSlider setIntValue:value];
    
    [ourShape setTesselation:value];
    
    [self display];
    return self;
}

- scaleBy:sender
{
    scale = [scaleField doubleValue];
    [ourShape scaleUniformly:scale];
    [sender selectTextAt:0]; /* re-hilite */
    
    [self display];
    return self;
}

- colorSelected:sender
{
    color = [sender color];
    [ourShape setColor:color];
    [self display];
    return self;
}

- backgroundColorSelected:sender
{
    [self setBackgroundColor:[sender color]];
    [self display];
    return self;
}

- mouseDown:(NXEvent *)firstEvent
{
    int looping;
    NXEvent *nextEvent;
    int oldMask;
    float dx,dy;
    NXPoint   lastPoint, thisPoint, aPoint, bPoint;
        	
    oldMask = [window addToEventMask:NX_LMOUSEDRAGGEDMASK];
    
    [self convertPoint:&firstEvent->location fromView:nil];
    
    lastPoint = thisPoint = firstEvent->location;
    
    looping = YES;

    while(looping)
    {
	nextEvent = [NXApp getNextEvent:(NX_LMOUSEDRAGGEDMASK
					|NX_LMOUSEUPMASK)];
										
	[self convertPoint:&nextEvent->location fromView:nil];
	thisPoint = nextEvent->location;
	
	switch (nextEvent->type)
	{
	case NX_LMOUSEDRAGGED:
	    /* becuase the rotation is confusing when the cursor
	     * is within the x/y spehere (radius of width/4), we
	     * do a kludge fix here
	     */
	     
	    dx=fabs(lastPoint.x-(bounds.size.width/2));
	    dy=fabs(lastPoint.y-(bounds.size.height/2));
	    if(sqrt(dx*dx+dy*dy)<=(bounds.size.width/4)) {
		aPoint.x = lastPoint.x;
		bPoint.x = thisPoint.x;
		aPoint.y = thisPoint.y;
		bPoint.y = lastPoint.y;
	    } else {
	        aPoint = lastPoint;
		bPoint = thisPoint;
	    }
	    [myRotator trackMouseFrom:&aPoint to:&bPoint
		rotationMatrix:theRotation andInverse:theInverse];
	    switch (rotation) {
	    case R_camera :
		if (shouldPreMultiply) 
		    N3DMultiplyMatrix([self preTransformMatrix], 
			theRotation, theTransform);
		else 
		    N3DMultiplyMatrix(theRotation, 
			[self preTransformMatrix], theTransform);
		[self setPreTransformMatrix:&theTransform];
		break;
	    case R_world:   
		[worldShape concatTransformMatrix:theRotation 
			premultiply:shouldPreMultiply];
		break;
	    }
	    [self display];
	    break;
	    
	case NX_LMOUSEUP:
	    looping = NO;
	    if(thisPoint.x==lastPoint.x && thisPoint.y==lastPoint.y) {
	        if(timer) DPSRemoveTimedEntry(timer); timer=NULL;
	    } else {
	        if(!timer) timer = DPSAddTimedEntry(.033, &runOneStep, self,
	        	NX_BASETHRESHOLD);
	    }
	    break;
	}
    } /* loop */
    
    [window setEventMask:oldMask];
    return self;
}

- step
{
    switch (rotation) {
    case R_camera :
	if (shouldPreMultiply) 
	    N3DMultiplyMatrix([self preTransformMatrix], 
	        theRotation, theTransform);
	else 
	    N3DMultiplyMatrix(theRotation,  [self preTransformMatrix],
		theTransform);
	[self setPreTransformMatrix:&theTransform];
	break;
    case R_world:   
	[worldShape concatTransformMatrix:theRotation 
	    premultiply:shouldPreMultiply];
	break;
    }
    [self display];
    return self;
}

void runOneStep(DPSTimedEntry timedEntry, double timeNow, void *data)
{
    [(id)data step];
}

@end
