/* Routin takes a list of 3 points in projective space and spits out a surface grid */
/* of poincare model points */

#include <stdio.h>
#include <math.h>
#include "mf.c"

#ifndef PI
#define PI 3.1415926
#endif
#define max(A,B) ( (A) > (B) ? (A) : (B) )
#define min(A,B) (-max(-A,-B))
#define Max(A,B,C) (max(A,max(B,C))) 
#define swap(A,B) dummy=(A); (A)=(B); (B)=dummy

static double size = 0.1;
static double combinval[3];

#define EPSILON 0.000001
#define BIG 1000000.0

typedef struct {
  double x,y,z;
  double w;     /* Homogeneous part */
 } Point;


double ArcLength(pnt1,pnt2)

double pnt1[3],pnt2[3];
{
  double r_squared;
 
  r_squared = pnt1[0]*pnt1[0] + pnt1[1]*pnt1[1] + pnt1[2]*pnt1[2];
  return(sqrt(r_squared) * acos(DotProduct(pnt1,pnt2)/r_squared));

}


poinc2proj(in,out)

double out[3],in[3];

{
  double factor,r_squared;

  r_squared = in[0]*in[0] + in[1]*in[1] + in[2]*in[2];
  factor = 2.0/(1.0 + r_squared);

  out[0] = in[0]*factor;
  out[1] = in[1]*factor;
  out[2] = in[2]*factor;

  return(1);
}

proj2poinc(in,out)

double in[3],out[3];

{
  double r,new_r;
  r = sqrt(in[0]*in[0] + in[1]*in[1] + in[2]*in[2]);
  if(r >= 1.0) {
    fprintf(stderr,"Ack! point outside unit sphere!\n");
    return(-1);
   }

  if(r > EPSILON)  new_r = (1.0 - sqrt(1.0 - r*r))/(r*r);
  else new_r = 0.5;

  out[0] = new_r*in[0];
  out[1] = new_r*in[1];
  out[2] = new_r*in[2];
        
  return(1);
}


DivideArc(pnt1,pnt2,num,arc)

double pnt1[3],pnt2[3],*arc;
int num;

/* Routine divides arc centered at origin into num line segments */
/* Result goes in arc, which is assumed to hold enough space */

{
  double angle,temp,theta;
  double coeff,A,B,x,y;   /* coefficients of linear system */
  double cs1,cs2,denom;
  int i;

  coeff = DotProduct(pnt1,pnt2)/DotProduct(pnt2,pnt2);
  temp = 1.0 - coeff*coeff;
  if(temp < EPSILON) {
     for(i=0;i<3*num;i+=3) {
        arc[i] = pnt1[0]; arc[i+1] = pnt1[1]; arc[i+2] = pnt1[2];
       }
     arc[3*num] = pnt2[0]; arc[3*num+1] = pnt2[1]; arc[3*num+2] = pnt2[2];
     return(1);
    }

  denom = 1.0/temp;

  theta = Angle(pnt1,pnt2);
  arc[0] = pnt1[0]; arc[1] = pnt1[1]; arc[2] = pnt1[2];
  angle = 0.0;
  for(i=1;i<num;++i) {
     angle += theta/(double) num;;
     cs1 = cos(angle); cs2 = cos(theta-angle);
     y = (cs2 - cs1*coeff)*denom;
     x = (cs1 - cs2*coeff)*denom;
     
     arc[3*i] = x*pnt1[0] + y*pnt2[0];
     arc[3*i+1] = x*pnt1[1] + y*pnt2[1];
     arc[3*i+2] = x*pnt1[2] + y*pnt2[2];
    }
  arc[3*num] = pnt2[0]; arc[3*num+1] = pnt2[1]; arc[3*num+2] = pnt2[2];
  return(1);   
}

ComputeCenter(pnt1,pnt2,center)

double pnt1[3],pnt2[3],*center;

{
  /* Use dbae's argument to compute hyperbolic center: */
  /* point satifies <X,pnt1> = 1, <X,pnt2> = 1, <X,pnt1 x pnt2> = 0  */

  double coeff[2][3],x,y;
  int rtrn;

  coeff[0][0] = DotProduct(pnt1,pnt1);
  coeff[0][1] = coeff[1][0] = DotProduct(pnt1,pnt2);
  coeff[1][1] = DotProduct(pnt2,pnt2);
  coeff[0][2] = coeff[1][2] = 1.0;

  rtrn = SolveTwoByTwo(coeff,&x,&y);
  if(rtrn < 0) return(-1);
  center[0] = x*pnt1[0] + y*pnt2[0];
  center[1] = x*pnt1[1] + y*pnt2[1];
  center[2] = x*pnt1[2] + y*pnt2[2];
  return(1);
}



ComputeArc(pnt1,pnt2,sz,arc)

double pnt1[3],pnt2[3],sz,*arc;

/* returns the number of segemnts in arc */

{
  int num,i;
  double rslt1[3],rslt2[3],center[3];
  double length;

  num = 0;   /* Number of arcs produced */
  if(ComputeCenter(pnt1,pnt2,center) < 0) { /* do straight line */
     if(proj2poinc(pnt1,rslt1) >= 0 && proj2poinc(pnt2,rslt2) >= 0) {
        num = 1;
        for(i=0;i<3;++i) {
           arc[i] = rslt1[i]; arc[3+i] = rslt2[i];
          }
       }
    }
  else {
     if(proj2poinc(pnt1,rslt1) >= 0 && proj2poinc(pnt2,rslt2) >= 0) {
        for(i=0;i<3;++i) { rslt1[i] -= center[i]; rslt2[i] -= center[i];}
        length = ArcLength(rslt1,rslt2);
        num = 2+ (int) (length/sz);
        DivideArc(rslt1,rslt2,num,arc); /* Divide into num arcs */
        for(i=0;i<3*num+3;i+=3) {
           arc[i] += center[0]; arc[i+1] += center[1]; arc[i+2] += center[2]; 
          }
       }
    }
  return(num);
}


int 
setsize(a)
  int a;
{ if ((a<0) || (a>5)) return(0);
  size=a; return(1);
}

static
projcenter(in1,in2,in3,center1)

double *in1,*in2,*in3,*center1;

{
  int i;
  double r,new_r;
  Point vec[3];
  Point out[3];
  Point center;
 
  double *in[3];
  
  
  in[0]=in1; in[1]=in2; in[2]=in3;
  /* Compute poincare out points */
   for(i=0;i<3;++i) {
      r = sqrt(in[i][0]*in[i][0] + in[i][1]*in[i][1] + in[i][2]*in[i][2]);
      if(r >= 1.0) {
         fprintf(stderr,"Ack! point outside unit sphere!\n");
         return(0);
        }
      if(r > EPSILON) {
        new_r = (1.0 - sqrt(1.0 - r*r))/(r*r);
        out[i].x = (in[i][0])*new_r; 
        out[i].y = in[i][1]*new_r; 
        out[i].z = in[i][2]*new_r;
       }
     else {
        out[i].x = in[i][0]*0.5; 
        out[i].y = in[i][1]*0.5; 
        out[i].z = in[i][2]*0.5;
       }
    }

  /* Compute minkowski equivalent of in points with norm i */

   for(i=0;i<3;++i) {
      r = sqrt(1.0 - in[i][0]*in[i][0] - in[i][1]*in[i][1] - in[i][2]*in[i][2]);
      vec[i].x = in[i][0]/r;
      vec[i].y = in[i][1]/r;
      vec[i].z = in[i][2]/r;
      vec[i].w = 1.0/r;
     }

  MinkowskiCrossProduct(vec,&center);

  /* Normalize center */
  if(center.w > EPSILON || center.w < -EPSILON) {
     center.x /= center.w;
     center.y /= center.w;
     center.z /= center.w;
    }
  else {  /* Put center far away in normal direction */
     Point A,B;  /* used as vectors */
     A.x = out[1].x-out[0].x; A.y = out[1].y-out[0].y; A.z = out[1].z-out[0].z;
     B.x = out[2].x-out[0].x; B.y = out[2].y-out[0].y; B.z = out[2].z-out[0].z;
     /* center = BIG * (A cross B) */
     center.x = BIG*(A.y*B.z - A.z*B.y);
     center.y = BIG*(A.z*B.x - A.x*B.z);
     center.z = BIG*(A.x*B.y - A.y*B.x);
    }
  center1[0]=center.x;
  center1[1]=center.y;
  center1[2]=center.z;

  return(1);
}

MinkowskiCrossProduct(vec,out)

Point *vec;   /* Array of 3 vectors */
Point *out;   /* result */

{  
  out->x =  vec[0].y*(vec[1].z*vec[2].w - vec[1].w*vec[2].z)
          - vec[0].z*(vec[1].y*vec[2].w - vec[1].w*vec[2].y)
          + vec[0].w*(vec[1].y*vec[2].z - vec[1].z*vec[2].y);

  out->y =  -vec[0].x*(vec[1].z*vec[2].w - vec[1].w*vec[2].z)
          + vec[0].z*(vec[1].x*vec[2].w - vec[1].w*vec[2].x)
          - vec[0].w*(vec[1].x*vec[2].z - vec[1].z*vec[2].x);

  out->z =  vec[0].x*(vec[1].y*vec[2].w - vec[1].w*vec[2].y)
          - vec[0].y*(vec[1].x*vec[2].w - vec[1].w*vec[2].x)
          + vec[0].w*(vec[1].x*vec[2].y - vec[1].y*vec[2].x);

  out->w =  -vec[0].x*(vec[1].y*vec[2].z - vec[1].z*vec[2].y)
          + vec[0].y*(vec[1].x*vec[2].z - vec[1].z*vec[2].x)
          - vec[0].z*(vec[1].x*vec[2].y - vec[1].y*vec[2].x);

  /* flip sign of w component */
  out->w = -out->w;
}


static int
normal(cent,pont,norm)
  double *cent,*pont,*norm;
{ 
  int r,i;
  for(i=0; i<3; i++) norm[i]=pont[i]-cent[i];
  r=norm[0]*norm[0]+norm[1]*norm[1]+norm[2]*norm[2];
  if (r>EPSILON)
  { 
    for(i=0; i<3; i++) norm[i]=norm[i]/r;
    return(1);
  }
  else return(0);
}

   
main(argc,argv)
  int argc; char *argv[];
{
  FILE *in,*out;
  double pnt1[3],pnt2[3],pnt3[3];
  double *list;
  int number,t,t1,t3;
 
  
  if (argc>2) 
  {
    if ((strcmp(argv[1],"-s")==0) || (strcmp(argv[1],"-size")==0))
    {
      if (sscanf(argv[2],"%lf",&size)!=1) 
      {fprintf(stderr," size was not specified! \n"); exit(1); }
      argv++; argv++; argc--; argc--; 
    }
  }
  if (argc<3) 
  {
    Usage();
    exit(0);
  }

  if(strcmp(argv[1],"-") == 0)  in = stdin;
  else in = fopen(argv[1],"r");
  if(in == NULL) 
  {
    fprintf(stderr,"Cannot open input file %s\n",argv[1]);
    exit(0);
  }

  if(strcmp(argv[2],"-") == 0)  out = stdout;
  else  out = fopen(argv[2],"w");
  if(out == NULL) 
  {
    fprintf(stderr,"Cannot open output file %s\n",argv[2]);
    exit(0);
  }
  fprintf(out,"NQUAD \n");
  while (fscanf(in,"%lf",&(pnt1[0]))==1)
  {
    if (fscanf(in,"%lf %lf %lf %lf %lf %lf %lf %lf",&(pnt1[1]),&(pnt1[2]),
      &(pnt2[0]),&(pnt2[1]),&(pnt2[2]),&(pnt3[0]),&(pnt3[1]),&(pnt3[2])) != 8) 
    {
      fprintf(stderr,"There are less than 3 points.. ");
      exit(1);
    }
  number=convert(pnt1,pnt2,pnt3,&list);
  for(t=0; t<number; t++)
   {
    for(t1=0; t1<18; t1+=6) 
      { for(t3=t1; t3<t1+6; t3++)
        fprintf(out,"%f ",list[t*18+t3]);
      fprintf(out,"\n");}
    for(t1=12; t1<18; t1++)
      fprintf(out,"%f ",list[t*18+t1]);
    fprintf(out,"\n");
  }
  free(list);
  }
}



int
convert(pnt1,pnt2,pnt3,list)
  double pnt1[3],pnt2[3],pnt3[3];
  double **list;
{
  int polycount,num,num1,num2,num3,mnum,*mpoints,i,j,k,l,tempmin,tempmax,
      argmin,argmax,t1;
  double center[3], *arc, norm[3], ppoint[3], *arc1, *arc2, *arc3,**marc,connect;
  double *ver,*line1,*line2,dummy;

  num = 2 + (int) (2.0*PI / size);
  arc1 = (double *) malloc(3 + 3*num*sizeof(double));
  arc2 = (double *) malloc(3 + 3*num*sizeof(double));
  arc3 = (double *) malloc(3 + 3*num*sizeof(double));

  projcenter(pnt1,pnt2,pnt3,center);

  polycount=0;

  /* numi represents the number of divisions opposite vertex i */
  num1 = ComputeArc(pnt3,pnt2,size,arc1);
  num2 = ComputeArc(pnt1,pnt3,size,arc2);
  num3 = ComputeArc(pnt2,pnt1,size,arc3);

  
  mnum = Max(num1,num2,num3);
  (*list) = (double *) malloc(40*(mnum+1)*(mnum+1)*sizeof(double));

  if (mnum==num1) { ver=pnt1; arc=arc1; }
    else if (mnum==num2) {ver=pnt2; arc=arc2; }
      else {ver=pnt3; arc=arc3;}
  mnum++;
  mpoints = (int *) malloc((2 + num)*sizeof(int));
  marc = (double **) malloc((2+mnum)*sizeof(double *));

  for(i=0; i<mnum; i++)
  {
    marc[i]=(double *) malloc(3 + 3*num*sizeof(double));
    poinc2proj(arc+i*3,ppoint);
    mpoints[i]=ComputeArc(ver,ppoint,size,marc[i])+1;
  }
    
  for(i=0; i<mnum-1; i++)
  { 
    tempmax=max(mpoints[i],mpoints[i+1]);
    tempmin=min(mpoints[i],mpoints[i+1]);
    argmin=((mpoints[i]==tempmin) ? i : i+1);
    argmax=((argmin==i) ? i+1 : i);
    connect=  ((double) (tempmax+tempmin-2))/((double)(tempmin-1)) ;
    k=0;


    for(j=1; j<=tempmin-1; j++)
    { 
      if (j>1) 
        {  
          for(t1=0; t1<3; t1++)
          { 
            (*list)[polycount*18+0+t1]= marc[argmin][j*3+t1]; 
            (*list)[polycount*18+1*6+t1]= marc[argmin][(j-1)*3+t1];
            (*list)[polycount*18+2*6+t1]= marc[argmax][k*3+t1];
            if (i==argmax)
              {swap((*list)[polycount*18+0+t1],(*list)[polycount*18+2*6+t1]);}
          }
         polycount++;
        }
      for(l=0; ((k+j<=(j*connect)) && (k< tempmax-1)); l++)      
        {  for(t1=0; t1<3; t1++)
           {  
             (*list)[polycount*18+0+t1]= marc[argmin][j*3+t1];
             (*list)[polycount*18+1*6+t1] = marc[argmax][(k)*3+t1];
             (*list)[polycount*18+2*6+t1]= marc[argmax][(k+1)*3+t1];

             if (i==argmax)
               {swap((*list)[polycount*18+0+t1],(*list)[polycount*18+2*6+t1]);}
           }
           polycount++; k++;
       }
    }         
  }
  for(i=0;i<polycount*3;i++)
  { normal(center,*list+i*6,norm);
    (*list)[i*6+3]=norm[0];
    (*list)[i*6+4]=norm[1];
    (*list)[i*6+5]=norm[2];
  }
  if ((18*polycount)>(40*(mnum+1)*(mnum+1))) fprintf(stderr,
" memory prob. please contact todd \n");
  free(arc1);
  free(arc2);
  free(arc3);
  for(i=0; i<mnum; i++) free(marc[i]);
  free(marc);
  free(mpoints);
  return(polycount);
}
  
 
Usage()
{
  fprintf(stderr," Usage: tri2poinc [-s size] infile outfile \n");
  fprintf(stderr,"        takes a list of triangles and produces a NQUAD file \n");
  fprintf(stderr,"          (quads with normals). \n");
  fprintf(stderr,"        if infile = '-' then stdin is used. \n");
  fprintf(stderr,"        if outfile = '-' then stdout is used. \n");
  fprintf(stderr,"        -s specifies size of arc (default is .1) \n\n");
}
