(* $Id: Beardon.m,v 1.3 90/07/11 13:08:01 mbp Exp Locker: mbp $
 *
 * Beardon.m: various functions for theorems in "The Geometry of
 *   Discrete Groups", by A. Beardon.
 *)

Needs["Hypercad`"]
Needs["Dirichlet`"]

gConnect[]

ITriangle[] :=
  Block[{i},
    Table[ gGetPoint[StringJoin["Pick vertex ",ToString[i]," of triangle"]],
           {i,1,3} ]
    ]

SetAttributes[IRightOneInfiniteTriangle, HoldAll]

IRightOneInfiniteTriangle[va_,vb_,vc_,sa_,sb_,sc_] :=
  Block[ {lb},
    gDraw[ vb = gGetInfinitePoint["Pick vertex at infinity"] ];
    gDraw[ vc = gGetPoint["Pick right-angle vertex"] ];
    gDraw[ sa = kSegment[ vb, vc ] ];
    gDraw[ lb = hPerp[kLine[ vb, vc ], vc] ];
    gDraw[ va = gGetPointOnLine["Pick vertex on perpendicular line", lb] ];
    gErase[ lb ];
    gDraw[ sb = kSegment[ vc, va ] ];
    gDraw[ sc = kSegment[ va, vb ] ];
  ]

IRightOneInfiniteTriangle[] :=
  Block[ {va,vb,vc,sa,sb,sc},
    IRightOneInfiniteTriangle[va,vb,vc,sa,sb,sc]]

SetAttributes[IOneInfiniteTriangle, HoldAll]

IOneInfiniteTriangle[va_,vb_,vc_,sa_,sb_,sc_] :=
  Block[ {},
    gDraw[vc = gGetInfinitePoint["Pick vertex at infinity"]];
    gDraw[va = gGetPoint["Pick first finite vertex"]];
    gDraw[sb = kSegment[vc, va]];
    gDraw[vb = gGetPoint["Pick second finite vertex"]];
    gDraw[sc = kSegment[va, vb]];
    gDraw[sa = kSegment[vb, vc]];
  ]

IOneInfiniteTriangle[] :=
  Block[ {va,vb,vc,sa,sb,sc},
    IRightOneInfiniteTriangle[va,vb,vc,sa,sb,sc]]

GetRightTriangle[va_,vb_,vc_,sa_,sb_,sc_] :=
  Block[ {lb},
    gDraw[va = gGetPoint["Pick vertex for first non-right angle in
right triangle"]];
    gDraw[vc = gGetPoint["Pick vertex for right angle in right triangle"]];
    gDraw[sb = kSegment[va, vc]];
    gDraw[lb = hPerp[kLine[va,vc], vc]];
    gDraw[vb = gGetPointOnLine["Pick vertex on perp line
for remaining non-right angle", lb]];
    gErase[lb];
    gDraw[sc = kSegment[va, vb]];
    gDraw[sa = kSegment[vb, vc]];
    Return[{{va,vb,vc}, {sa,sb,sc}}]
  ]

GetRightTriangle[] :=
  Block[ {va,vb,vc,sa,sb,sc},
    GetRightTriangle[va,vb,vc,sa,sb,sc]]

GetTriangle[va_,vb_,vc_,sa_,sb_,sc_] :=
  Block[ {},
    gDraw[va = gGetPoint["Pick first vertex of triangle"]];
    gDraw[vb = gGetPoint["Pick second vertex of triangle"]];
    gDraw[sc = kSegment[va, vb]];
    gDraw[vc = gGetPoint["Pick final vertex of triangle"]];
    gDraw[sa = kSegment[vb, vc]];
    gDraw[sb = kSegment[vc, va]];
    Return[ { {va,vb,vc}, {sa,sb,sc} } ]
    ]

GetTriangle[] :=
  Block[ {va,vb,vc,sa,sb,sc},
    GetTriangle[va,vb,vc,sa,sb,sc]]


GetIdealTriangle[va_,vb_,vc_,sa_,sb_,sc_] :=
  Block[ {},
    gDraw[va = gGetInfinitePoint["Pick first vertex of ideal triangle"]];
    gDraw[vb = gGetInfinitePoint["Pick second vertex of ideal triangle"]];
    gDraw[sc = kSegment[va, vb]];
    gDraw[vc = gGetInfinitePoint["Pick final vertex of ideal triangle"]];
    gDraw[sa = kSegment[vb, vc]];
    gDraw[sb = kSegment[vc, va]];
    Return[ { {va,vb,vc}, {sa,sb,sc} } ]
    ]

GetIdealTriangle[] :=
  Block[ {va,vb,vc,sa,sb,sc},
    GetIdealTriangle[va,vb,vc,sa,sb,sc]]


T772[triangle_List] :=
  Block[ {i, sides, lengths, ilpairs, ind, z, L, L1, p},
    sides = Table[ kSegment[triangle[[i]],triangle[[Mod[i,3]+1]]], {i,1,3} ];
    lengths = Map[ hLength, sides ];
    ilpairs = Table[ {lengths[[i]], i}, {i,1,3} ];
    ind = Map[ #[[2]]&, Sort[ ilpairs ] ];
    z[i_] := triangle[[ind[[i]]]];
    (* z[1] to z[2] is shortest
       z[2] to z[3] is next
       z[3] to z[1] is longest *)
    L = kLine[ z[2], z[3] ];
    L1 = hPerp[ L, z[1] ];
    p = hIntersection[ L1, L ];
    Map[ gDraw, sides ];
    Map[ gDraw, {p, kSegment[z[1], p]} ];
    Return[Null]
    ]

T791[] :=
  Block[ { va,vb,vc,sa,sb,sc,alpha,gamma,b },
    IRightOneInfiniteTriangle[va,vb,vc,sa,sb,sc];
    alpha = hAngle[ hLog[va, vb], hLog[va, vc] ];
    gamma = hAngle[ hLog[vc, va], hLog[vc, vb] ];
    b = hLength[ sb ];
    Print[""];
    Print["gamma = ", gamma, " (should be ", N[Pi/2], ")"];
    Print["alpha = ", alpha];
    Print["b = ", b];
    Print["Sinh[b] Tan[alpha] = ", Sinh[b] Tan[alpha], " (should be 1)"];
    Print["Cosh[b] Sin[alpha] = ", Cosh[b] Sin[alpha], " (should be 1)"];
    Print["Tanh[b] Sec[alpha] = ", Tanh[b] Sec[alpha], " (should be 1)"];
    Print[""];
    ]

T7101[] :=
  Block[ {va,vb,vc,sa,sb,sc,c,alpha,beta},
    IOneInfiniteTriangle[va,vb,vc,sa,sb,sc];
    c = hLength[sc];
    alpha = hAngle[ hLog[va, vb], hLog[va, vc] ];
    beta = hAngle[ hLog[vb, vc], hLog[vb, va] ];
    Print["7.10.1(i) = ",
      Cosh[c] - (1 + Cos[alpha] Cos[beta]) / (Sin[alpha] Sin[beta]),
      " (should be 0)"];
    Print["7.10.1(ii) = ",
      Sinh[c] - (Cos[alpha] + Cos[beta]) / (Sin[alpha] Sin[beta]),
      " (should be 0)"];
  ]     

T7111[{ {va_,vb_,vc_}, {sa_, sb_, sc_} }] :=
  Block[ {a,b,c},
    a = hLength[sa];
    b = hLength[sb];
    c = hLength[sc];
    Print["7.11.1 = ", Cosh[c] - Cosh[a] Cosh[b], " (should be 0)"]
  ]

T7111[] :=
  T7111[GetRightTriangle[]]

T7112[{ {va_,vb_,vc_}, {sa_, sb_, sc_} }] :=
  Block[ {a,b,c,beta},
    a = hLength[sa];
    b = hLength[sb];
    c = hLength[sc];
    beta = hAngle[ hLog[vb, vc], hLog[vb, va] ];
    Print["7.11.2(i) = ", Tanh[b] - Sinh[a] Tan[beta], " (should be 0)"];
    Print["7.11.2(ii) = ", Sinh[b] - Sinh[c] Sin[beta], " (should be 0)"];
    Print["7.11.2(iii) = ", Tanh[a] - Tanh[c] Cos[beta], " (should be 0)"];
  ]

T7112[] :=
  T7112[GetRightTriangle[]]

T7113[{ {va_,vb_,vc_}, {sa_, sb_, sc_} }] :=
  Block[ {a,b,c,beta},
    a = hLength[sa];
    b = hLength[sb];
    c = hLength[sc];
    alpha = hAngle[ hLog[va, vb], hLog[va, vc] ];
    beta = hAngle[ hLog[vb, vc], hLog[vb, va] ];
    Print["7.11.3(i) = ", Cosh[a] Sin[beta] - Cos[alpha], " (should be 0)"];
    Print["7.11.3(ii) = ", Cosh[c] - Cot[alpha] Cot[beta], " (should be 0)"];
  ]

T7113[] :=
  T7113[GetRightTriangle[]]

SineRule[{ {va_,vb_,vc_}, {sa_, sb_, sc_} }] :=
  Block[ {a,b,c,alpha,beta,gamma},
    a = hLength[sa];
    b = hLength[sb];
    c = hLength[sc];
    alpha = hAngle[ hLog[va, vb], hLog[va, vc] ];
    beta = hAngle[ hLog[vb, vc], hLog[vb, va] ];
    gamma = hAngle[ hLog[vc, va], hLog[vc, vb] ];
    Print["Sinh[a] / Sin[alpha] = ", Sinh[a] / Sin[alpha]];
    Print["Sinh[b] / Sin[beta] = ", Sinh[b] / Sin[beta]];
    Print["Sinh[c] / Sin[gamma] = ", Sinh[c] / Sin[gamma]];
    Print["  (these three should be equal)"]
    ]

SineRule[] :=
  SineRule[GetTriangle[]]

CosineRuleI[{ {va_,vb_,vc_}, {sa_, sb_, sc_} }] :=
  Block[ {a,b,c,alpha,beta,gamma},
    a = hLength[sa];
    b = hLength[sb];
    c = hLength[sc];
    gamma = hAngle[ hLog[vc, va], hLog[vc, vb] ];
    Print["Cosh[c] - ( Cosh[a] Cosh[b] - Sinh[a] Sinh[b] Cos[gamma] ) = ",
          Cosh[c] - (Cosh[a] Cosh[b] - Sinh[a] Sinh[b] Cos[gamma])];
    Print[" (should be 0)"]
    ]

CosineRuleI[] :=
  CosineRuleI[GetTriangle[]]

CosineRuleII[{ {va_,vb_,vc_}, {sa_, sb_, sc_} }] :=
  Block[ {a,b,c,alpha,beta,gamma},
    c = hLength[sc];
    alpha = hAngle[ hLog[va, vb], hLog[va, vc] ];
    beta = hAngle[ hLog[vb, vc], hLog[vb, va] ];
    gamma = hAngle[ hLog[vc, va], hLog[vc, vb] ];
    Print[ "Cosh[c] - (Cos[alpha] Cos[beta] + Cos[gamma])
 / (Sin[alpha] Sin[beta]) = ",
	  Cosh[c] - (Cos[alpha] Cos[beta] + Cos[gamma])
		      / (Sin[alpha] Sin[beta]) ];
    Print[" (should be 0)"]
    ]

CosineRuleII[] :=
  CosineRuleII[GetTriangle[]]

TriArea[{ {va_,vb_,vc_}, {sa_, sb_, sc_} }] :=
  Block[ {alpha,beta,gamma},
    alpha = hAngle[ hLog[va, vb], hLog[va, vc] ];
    beta = hAngle[ hLog[vb, vc], hLog[vb, va] ];
    gamma = hAngle[ hLog[vc, va], hLog[vc, vb] ];
    Return[ N[Pi] - alpha - beta - gamma ]
    ]

TriArea[] :=
  TriArea[GetTriangle[]]

ENorm[v_List] := Sqrt[ v . v ]

EUnitVector[ v_List ] := v / ENorm[v]

gGetInfinitePoint[prompt_String] :=
  kPoint[ EUnitVector[ hAffine[ gGetPoint[prompt] ] ] ]

gGetPointOnLine[prompt_String, l_kLine] :=
  Block[{p,lp},
    p = gGetPoint[prompt];
    lp = hPerp[l, p];
    Return[ hIntersection[l, lp] ]
    ]

Null
