(* $Id: Hypercad.m,v 1.11 90/07/11 13:08:14 mbp Exp Locker: mbp $
 *
 * Hypercad.m: main Hypercad file
 *)

(**************************************************************************
 *     Copyright (C) 1990 by Mark B. Phillips and Robert R. Miner	  *
 * 									  *
 * Permission to use, copy, modify, and distribute this software, its	  *
 * documentation, and any images it generates for any purpose and without *
 * fee is hereby granted, provided that					  *
 * 									  *
 * (1) the above copyright notice appear in all copies and that both that *
 *     copyright notice and this permission notice appear in supporting	  *
 *     documentation, and that the names of Mark B.  Phillips, Robert R.  *
 *     Miner, or the University of Maryland not be used in advertising or *
 *     publicity pertaining to distribution of the software without	  *
 *     specific, written prior permission.				  *
 *									  *
 * (2) Explicit written credit be given to the authors Mark B.  Phillips  *
 *     and Robert R. Miner in any publication which uses part or all of	  *
 *     any image produced by this software.				  *
 *									  *
 * This software is provided "as is" without express or implied warranty. *
 **************************************************************************)

BeginPackage["Hypercad`", "RH2`", "ExternalGraphics`", "GraphicsNames`"]

gGetPoint::usage = "gGetPoint[prompt] gets a kPoint from the user
via the mouse, while displaying prompt."

Begin["`Private`"]

(* ErrorFlag is the string returned by the graphics program to
   signal an error *)
ErrorFlag = "-1"

gSetErrorFlag[ErrorFlag]

ToCString[kPoint[x_,y_]] := StringJoin[gN[x], " ", gN[y]]
ToCString[p_pPoint] := ToCString[kPoint[p]]
ToCString[p_uPoint] := ToCString[kPoint[p]]

gDeclarePrimitive[ p_kPoint,  StringJoin["p ", ToCString[p] ] ]

gDeclarePrimitive[ p_pPoint,  StringJoin["p ", ToCString[p] ] ]

gDeclarePrimitive[ p_uPoint,  StringJoin["p ", ToCString[p] ] ]

gDeclarePrimitive[ s_kSegment,
  StringJoin[ "s ", ToCString[s[[1]]], " ", ToCString[s[[2]]] ] ]

gDeclarePrimitive[ s_pSegment,
  StringJoin[ "s ", ToCString[s[[1]]], " ", ToCString[s[[2]]] ] ]

gDeclarePrimitive[ s_uSegment,
  StringJoin[ "s ", ToCString[s[[1]]], " ", ToCString[s[[2]]] ] ]

gDeclarePrimitive[ l_kLine,
  Block[{s},
    s = kSegment[l];
    StringJoin[ "s ", ToCString[s[[1]]], " ", ToCString[s[[2]]] ]
    ]]

gSetEraseCommand["e"]

gSetClearCommand["c"]

gSetInputCommand["go"]

(* gGetPoint:
 *)
gGetPoint::exerror = "Error in external program"
gGetPoint[prompt_String] :=
  Block[{string,expr},
    string = MathPipe[StringJoin["gp \"", prompt, "\""]];
    If[ string==="-1", Message[gGetPoint::exerror] ];
    expr = ToExpression[string];
    If[ expr[[3]] =!= 1, Return[Null] ];
    Return[ kPoint[expr[[1]], expr[[2]]] ]
    ]

End[]

EndPackage[]

Print[""]
Print["Hypercad of July 10, 1990 (beta version)"]
Print["Copyright 1990 by Mark B. Phillips and Robert R. Miner"]
Print["University of Maryland Department of Mathematics"]
Print[""]

{gConnect, gDraw, gErase, gClear, gDisconnect}
