(* $Id: ExternalGraphics.m.tpl,v 1.9 90/07/11 13:08:51 mbp Exp Locker: mbp $
 *
 *TPL	DO NOT CHANGE ANY LINE IN THIS FILE THAT BEGINS WITH ' *TPL'
 *TPL	
 *TPL	This file is a template to be used in creating the actual .m
 *TPL	file.  The Makefile creates the .m file from this one by
 *TPL	replacing the following strings in this file with actual
 *TPL	values:
 *TPL		MATHPIPEPATH
 *
 * ExternalGraphics.m: meta-language for describing interface to
 *	external graphics program.
 *
 *TPLWARNING
 *)

(**************************************************************************
 *     Copyright (C) 1990 by Mark B. Phillips and Robert R. Miner	  *
 * 									  *
 * Permission to use, copy, modify, and distribute this software, its	  *
 * documentation, and any images it generates for any purpose and without *
 * fee is hereby granted, provided that					  *
 * 									  *
 * (1) the above copyright notice appear in all copies and that both that *
 *     copyright notice and this permission notice appear in supporting	  *
 *     documentation, and that the names of Mark B.  Phillips, Robert R.  *
 *     Miner, or the University of Maryland not be used in advertising or *
 *     publicity pertaining to distribution of the software without	  *
 *     specific, written prior permission.				  *
 *									  *
 * (2) Explicit written credit be given to the authors Mark B.  Phillips  *
 *     and Robert R. Miner in any publication which uses part or all of	  *
 *     any image produced by this software.				  *
 *									  *
 * This software is provided "as is" without express or implied warranty. *
 **************************************************************************)

BeginPackage["ExternalGraphics`", "GraphicsNames`", "MathPipe`"]

gSetErrorFlag::usage = "gSetErrorFlag[s] sets the error string to s.
This is the string which the graphics program returns to signal
an error."

gDeclarePrimitive::usage = "gDeclarePrimitive[form, command] declares
a new graphics primitive.  form is a pattern which gives the format of
the primitive, and command should be an expression for converting a
pattern which matches form to a draw command (a string) for the
external graphics program."

gN::usage = "gN[x] gives a string representation of the numeric value
of x in a form which can be interpreted by the external graphics
program.  gN can be used in constructing the 'command' argument to
gDeclarePrimitive.  gN[x] is like ToString[N[x]] except that it
always produces a string that can be interpreted by the C function
atof."

gSetEraseCommand::usage = "gSetEraseCommand[s] sets the erase prefix to
the string s."

gSetClearCommand::usage = "gSetClearCommand[s] sets the clear command
to the string s."

gSetInputCommand::usage = "gSetInputCommand[s] sets the input command
to the string s."

gConnect::usage = "gConnect[gPath->path] establishes a connection with
the external graphics program whose pathname is path.  gConnect[] uses
an internally stored pathname."

gPath::usage = "gPath is an option to gConnect that gives the pathname
of the external graphics program."

gDisconnect::usage = "gDisconnect[] terminates a connection with the
external graphics program."

gDraw::usage = "gDraw[x] draws the graphics primitive x.  x may be
either a graphics primitive or a variable whose value is a primitive;
if it is a variable, that variable's name is associated with the new
graphics object. gDraw[x = p] is also allowed; it is eqivalent to x =
p; gDraw[x].  gDraw can be called with multiple arguments;
gDraw[x1,x2,...]  is equivalent to gDraw[x1], gDraw[x2], ... ."

gErase::usage = "gErase[x] erases the graphics object referred to by
the expression x.  gErase can be called with multiple arguments;
gErase[x1,x2,...]  is equivalent to gErase[x1], gErase[x2], ... ."

gClear::usage = "gClear[] erases the entire graphics canvas."

gInput::usage = "gInput[prompt] displays the string prompt in the
graphics window, waits for the user to select an object in the
picture, and returns the name of that object.  The name is wrapped in
HoldForm to keep it from being evaluated."

(*----------------------------------------------------------------------*)

Begin["`Private`"]

(* gGeneral::exerror is the error message we will generate when
 * the graphics program signals an error. *)
gGeneral::exerror = "Error in external graphics program."

(* ErrorFlag is the flag returned by the graphics program to signal
 * an error.  It is set by a call to gSetErrorFlag. *)
ErrorFlag = Null

(* ErasePrefix is the prefix string used to construct an erase command
 * This is set by a call to gSetEraseCommand. *)
ErasePrefix = Null

(* ClearCommand is the string to send to the graphics program to erase
 * the entire canvas.  This is set by a call to gSetClearCommand. *)
ClearCommand = Null

gSetErrorFlag[s_String] :=
  ErrorFlag = s

gSetEraseCommand[s_String] :=
  ErasePrefix = s			      

gSetClearCommand[s_String] :=
  ClearCommand = s;

gSetInputCommand[s_String] :=
  InputCommand = s;

gConnected = False

Options[gConnect] ^= {gPath->"MATHPIPEPATH"}

gConnect[opts___] :=
  ( StartPipe[ RunningMathPipePath = (gPath /. {opts} /. Options[gConnect]) ];
    gConnected = True; Null ) /; Not[gConnected]

gConnect::already = "Already connected."

gConnect[] :=
  Message[gConnect::already] /; gConnected

gDisconnect::notnow = "Not currently connected."

gDisconnect[] :=
  ( MathPipe["q"]; EndPipe[RunningMathPipePath]; 
    RunningMathPipePath =. ; gConnected = False ; Null ) /; gConnected

gDisconnect[] :=
  Message[gDisconnect::notnow] /; Not[gConnected]

(* DrawCommand generates the command to draw a primitive.  It is defined via
 * calls to gDeclarePrimitive *)
SetAttributes[DrawCommand, HoldAll]
DrawCommand[_] :=
  Null

(* PrimitiveQ tests whether a form has been declared to be a primitve.  It
 * is defined via calls to gDeclarePrimitive *)
SetAttributes[PrimitiveQ, HoldAll]
PrimitiveQ[_] =
  False

(* gDeclarePrimitve:
 *)
SetAttributes[gDeclarePrimitive, HoldRest]
gDeclarePrimitive[form_, command_] := (
  DrawCommand[form] := command;
  PrimitiveQ[form] = True;
  Null )

(* gDraw:
 *)
SetAttributes[gDraw, {HoldAll}]
gDraw::badobj = "Unknown object type --- don't know how to draw it"
gDraw[HoldForm[x_]] :=
  gDraw[x]
gDraw[Literal[Set[lhs_, rhs_]]] :=
  (Set[lhs, rhs]; gDraw[lhs])
gDraw[x_?PrimitiveQ] :=
  (gDrawAndReturnName[x]; Null)
gDraw[x_, y__] :=
  (gDraw[x]; gDraw[y]; Null)
gDraw[x_] :=
  Block[{name},
    ( MathPipe["bb"];	(* Hypercad "begin batch" command *)
      name = Map[ gDrawAndReturnName, x ];
      MathPipe["eb"];	(* Hypercad "end batch" command *)
      SetGraphicsName[x, name];
      Return[Null]; )
  ] /; Head[Release[x]]===List
gDraw[x_] :=
  Block[{name},
    ( name = gDrawAndReturnName[x];
      If[name=!=ErrorFlag, SetGraphicsName[x, name]];
      Return[Null]; )
  ] /; PrimitiveQ[Release[x]]
gDraw[x_] :=
  Message[gDraw::badobj]
gDrawAndReturnName[Literal[Set[lhs_, rhs_]]] :=
  (Set[lhs, rhs]; gDrawAndReturnName[lhs])
gDrawAndReturnName[x_] :=
  Block[{name},
    ( name = MathPipe[DrawCommand[x]];
      If[name===ErrorFlag, (Message[gGeneral::exerror]; Return[Null])];
      Return[name]; )
  ]

(* gErase:
 *)
SetAttributes[gErase, {HoldAll}]
gErase::nosuchobj = "No such object --- can't erase it"
gErase[x_,y__] := (gErase[x]; gErase[y]; Null)
gErase[HoldForm[x_]] := gErase[x]
gErase[x_] :=
  Block[{},
    ( If[!GraphicsNamedQ[x],
         (Message[gErase::nosuchobj]; Return[Null])];
      If[!gDoErase[GraphicsName[x]],
	 (Message[gGeneral::exerror]; Return[Null])];
      UnsetGraphicsName[x];
      Return[Null]; )
  ]
gDoErase[name_List] := 
  Block[ {answer},
    MathPipe["bb"];	(* Hypercad "begin batch" command *)
    answer = Apply[ And, Map[ gDoEraseNoBatch, name ] ];
    MathPipe["eb"];	(* Hypercad "begin batch" command *)
    Return[answer]
    ]
gDoErase[name_] :=
  gDoEraseNoBatch[name]
gDoEraseNoBatch[name_List] := 
  Apply[ And, Map[ gDoEraseNoBatch, name ] ];
gDoEraseNoBatch[name_] :=
 (MathPipe[StringJoin[ErasePrefix, " ", name]]=!=ErrorFlag)


(* gClear:
 *)
gClear[] := (
  If[MathPipe[ClearCommand]===ErrorFlag, Message[gGeneral::exerror]];
  ClearGraphicsNames[];
  Null );

(* gInput:
 *)
gInput[prompt_String] :=
  Block[{gname},
    gname=MathPipe[StringJoin[InputCommand, " \"", prompt, "\"", " ps"]];
    If[ gname===ErrorFlag, Message[gGeneral::exerror]];
    If[ ValueQ[UserName[gname]], Return[UserName[gname]] ];
    Return[Null]
    ]

(* gN:
 *)
gN::notnumber = "argument `x` does not evaluate to a number."
gN[x_] :=
  Block[{val=N[x]},
    ( If[!NumberQ[val], Message[gN::notnumber, x]; Return[""]];
      Return[ToString[CForm[val]]] )
    ]

End[]

EndPackage[]

Null
