(* $Id: MathPipe.m.tpl,v 1.3 90/07/11 13:08:59 mbp Exp Locker: mbp $
 *
 *TPL	DO NOT CHANGE ANY LINE IN THIS FILE THAT BEGINS WITH ' *TPL'
 *TPL	
 *TPL	This file is a template to be used in creating the actual .m
 *TPL	file.  The makefile creates the .m file from this one by
 *TPL	replacing the following strings in this file with actual
 *TPL	values:
 *TPL		MATHPIPEPATH
 *
 * MathPipe.m: package for piping strings through stdio of a concurrently
 *   running external program on a (possibly) remote host.
 *
 *TPLWARNING
 *)

(**************************************************************************
 *     Copyright (C) 1990 by Mark B. Phillips and Robert R. Miner	  *
 * 									  *
 * Permission to use, copy, modify, and distribute this software, its	  *
 * documentation, and any images it generates for any purpose and without *
 * fee is hereby granted, provided that					  *
 * 									  *
 * (1) the above copyright notice appear in all copies and that both that *
 *     copyright notice and this permission notice appear in supporting	  *
 *     documentation, and that the names of Mark B.  Phillips, Robert R.  *
 *     Miner, or the University of Maryland not be used in advertising or *
 *     publicity pertaining to distribution of the software without	  *
 *     specific, written prior permission.				  *
 *									  *
 * (2) Explicit written credit be given to the authors Mark B.  Phillips  *
 *     and Robert R. Miner in any publication which uses part or all of	  *
 *     any image produced by this software.				  *
 *									  *
 * This software is provided "as is" without express or implied warranty. *
 **************************************************************************)

(* This package is to be used in conjunction with the C program
 * 'mathpipe', which relays data back and forth between Mathematica
 * and stdio of the external program.
 *
 * StartPipe and EndPipe each take an argument which is the pathname of
 * the 'mathpipe' program.  If called without this argument, (i.e.
 * StartPipe[] or EndPipe[]) they use the following default pathname: *)


MathPipe`Private`MathPipePath = "MATHPIPEPATH"

(* To change this default pathname just change its definition above *)

BeginPackage["MathPipe`"]

(*----------------------------------------------------------------------*)

StartPipe::usage = "StartPipe[mathpipepath] starts an external program,
possibly on a remote host, for use with MathPipe.  mathpipepath should
be the pathname of the program 'mathpipe', which serves as a data relay
between Mathematica and the remote program.  The name of the remote
program and the remote host on which it is to be run are determined by
the contents of a special flag file in the user's home directory;
('mathpipe' reads this file; see mathpipe.c for details).  StartPipe[]
does the same thing but uses an internally stored pathname for
mathpipepath."

StartPipeTest::usage = "StartPipeTest[] sets up a test mode in which
data is printed out instead of being sent to a program."

MathPipe::usage = "Pipe[string] sends string standard input of an
external program which has been started with StartPipe, waits for the
program to print a line on its standard output, and returns (as a
string) that line.  string should contain no newline chars.  The
terminating newline is removed from the output string before returning."

EndPipe::usage = "EndPipe[mathpipepath] terminates an external program
which was started with StartPipe[mathpipepath]. EndPipe[] terminates an
external program which was started with StartPipe[]."

(*----------------------------------------------------------------------*)

Begin["`Private`"]

StartPipe[mathpipepath_] := (StartProcess[mathpipepath]; Null)

StartPipe[] := StartPipe[MathPipePath]
  
StartPipeTest[] := (
  MathPipeValue = 0;
  System`MathPipe[c_] := (
    Print["MathPipe[",c,"]"];
    ++MathPipeValue;
    StringJoin["pstring", ToString[MathPipeValue]]
    );
  Null
  )

EndPipe[mathpipepath_] := (EndProcess[mathpipepath]; Null)

EndPipe[] := EndPipe[MathPipePath]

MathPipe[s_] := StripNewlines[System`MathPipe[s]]

(* StripNewlines is needed because for some silly reason, System`MathPipe
 * appends (always two?) newlines to the end of s. StripNewlines eliminates
 * any trailing newline chars from s *)

StripNewlines[s_String] :=
  Block[ {charlist=Characters[s],len},
    For[(len=Length[charlist]),
	(len>0) && (charlist[[len]]==="\n"),
	--len];
    Return[Apply[StringJoin, Take[charlist, len]]]
      ]
End[]

EndPackage[]

Null
