./"
./"  gdb.man: main man page for GDB procedures.  This page gives the
./"         call syntax for all GDB procedures.
./"
./"   $Id: gdb.man,v 1.2 90/07/11 13:10:29 mbp Exp Locker: mbp $
./"
./"		       This file is part of GDB
./"
./" ************************************************************************
./" *		Copyright (C) 1989 by Mark B. Phillips                     *
./" * 									   *
./" * Permission to use, copy, modify, and distribute this software and    *
./" * its documentation for any purpose and without fee is hereby granted, *
./" * provided that the above copyright notice appear in all copies and    *
./" * that both that copyright notice and this permission notice appear in *
./" * supporting documentation, and that the name of Mark B. Phillips or   *
./" * the University of Maryland not be used in advertising or publicity   *
./" * pertaining to distribution of the software without specific, written *
./" * prior permission.  This software is provided "as is" without express *
./" * or implied warranty.                                                 *
./" ************************************************************************
./" 
./"
.TH GDB 3X "August 22, 1988"
.SH NAME
gdb - GDB (Geometry DataBase) procedures
.SH SYNOPSIS
.B #include
"gdb.h"
.nf

cc myprogram.c -lgdb
.PP
.B gdb_add_entity(type, data, name, entity )
.B gdb_Entity_type type;
.B char *data, *name;
.B gdb_Entity  *entity;
.PP
.B char * gdb_generate_unique_name( prefix, name )
.B char *prefix, *name;
.PP
.B gdb_delete_entity( entity )
.B gdb_Entity   entity;
.PP
.B char *  gdb_entity_name(entity)
.B gdb_Entity   entity;
.PP
.B char * gdb_entity_data(entity)
.B gdb_Entity entity;
.PP
.B gdb_Entity_type gdb_entity_type(entity)
.B gdb_Entity entity;
.PP
.B gdb_retrieve_entity(tmask, search_type, search_spec, entity )
.B gdb_Entity_type tmask;
.B gdb_Search_type search_type;
.B char *search_spec;
.B gdb_Entity *entity;
.PP
.B gdb_create_block( name, block, leave_open )
.B char	*name;
.B gdb_Block *block;
.B int leave_open;
.PP
.B gdb_open_block( block )
.B gdb_Block block;
.PP
.B gdb_close_block()
.PP
.B gdb_delete_block( block )
.B gdb_Block block;
.PP
.B gdb_add_to_block( block, entity )
.B gdb_Block block;
.B gdb_Entity entity;
.PP
.B gdb_subtract_from_block( block, entity )
.B gdb_Entity entity;
.B gdb_Block block;
.PP
.B gdb_empty_block( block )
.B gdb_Block block;
.PP
.B gdb_block_entity_count( block )
.B gdb_Block block;
.PP
.B gdb_block_entity_list( block, harray )
.B gdb_Block block;
.B gdb_Entity harray[];
.PP
.B gdb_delete_block_entities( block )
.B gdb_Block block;
.PP
.B char * gdb_block_name( block )
.B gdb_Block block;
.PP
.B gdb_retrieve_block( search_type, search_spec, block )
.B gdb_Search_type search_type;
.B char *search_spec;
.B gdb_Block *block;
.PP
.B gdb_delete_all()
.PP
.B gdb_save( fname, success )
.B char *fname;
.B int *success;
.PP
.B gdb_load( fname, success )
.B char *fname;
.B int *success;
.SH DESCRIPTION
These are the GDB (Geometry DataBase) library procedures.  See gdbintro(3X)
for an introduction to GDB.
.PP
.I gdb_add_entity
adds an entity of type
.I type
to the database.
.I data
should point to the data to be stored for this entity.
.I name
should be a null-terminated string which will become this entity's name.
After a successful call to
.I gdb_add_entity,
.I *entity
is the handle of the newly added entity.  A NULL value of
.I *entity
indicates an error. It is the responsibility of the application to insure
that no two entities have the same name.
.I gdb_generate_unique_name
can be used to generate a name which is guaranteed to differ from the
names of all entities and blocks currently in the database. It will
write into
.I name
a string which consists of the string
.I prefix
followed by a number. It returns
.I name.
.I gdb_delete_entity
deletes the entity with the given handle from the database.  It
automatically removes this entity from any blocks which contain it.
.PP
.I gdb_entity_name,
.I gdb_entity_type,
and
.I gdb_entity_data
all return information about the handle
.I entity.
.I gdb_entity_name
returns a pointer to the entity's name,
.I gdb_entity_type
returns the entity's type flag,
and
.I gdb_entity_data
returns a pointer to the entity's data (which can be cast to the
appropriate type).
.PP
.I gdb_retrieve_entity
searches the database for an entity which matches certain attributes.
.I tmask
indicates which types of entities to look for; its value should be
a logical OR (|) of entity type flags.
.I search_type
indicates which type of search to perform; this must be one of the
values GDB_NAME, GDB_SEQUENTIAL, or GDB_DISTANCE.
.I search_spec
specifies what to search for.  If
.I search_type
is GDB_NAME, then
.I search_spec
should be a pointer to a null-terminated string which is interpreted as
the name of an entity to search for.  If
.I search_type
is GDB_SEQUENTIAL, then
.I search_spec
should be a pointer to a variable of type gdb_Sequence_spec, whose
value is either GDB_FIRST, in which case the first (in the order of
entry) entity in the database whose type matches
.I tmask
is sought, or GDB_NEXT, in which case the search begins immediately
after entity retrieved on the last call to
.I gdb_retrieve_entity.
In both of these cases
.I *search_spec
is set to GDB_NEXT upon return in order to facilitate sequential
traversal of the database. If
.I search_type
is GDB_DISTANCE, then
.I search_spec should be a pointer to an object of type
.I gdb_Distance_spec,
which is a structure defined as follows:
.nf
.sp
.in+2
typedef struct gdb_Distance_spec_s {
  char			 *seek_data;
  gdb_Entity_type	 seek_type;
  float                  tolerance;
  gdb_Sequence_spec      sequence_spec;
  gdb_Entity		 found_entity;
} gdb_Distance_spec;
.in-2
.sp
.fi
This type of search provides a way of searching for an entity whose
distance is within a specified tolerance of a given entity.
In the gdb_Distance_spec structure,
.I seek_data
should be a pointer to the data (not the handle!) of the given entity,
.I seek_type
should be this entity's type.
.I gdb_retrieve_entity
will search for an entity whose distance to the given entity
is less than or equal to
.I tolerance.
.I *sequence_spec
indicates where to begin the search; if it is GDB_FIRST, the search
starts at the beginning of the database.  If it is GDB_NEXT, the
search begins immediately after the entity retrieved by the last call
to
.I gdb_retrieve_entity.
.I *sequence_spec
is always set to GDB_NEXT before returning, and
.I *found_entity
is set to the handle of the found entity, if any, or to NULL, if none
is found.  On all calls to
.I gdb_retrieve_entity,
.I *entity
is set to the handle of the retrieved entity, if any, or to NULL, if
none is found.  (In GDB_DISTANCE searches,
.I search_spec->found_entity
always equals
.I *entity
upon return.)
.PP
.I gdb_create_block
creates a block with name
.I name,
which should be a null-terminated ascii string, and sets
.I *block
to the new block's handle.
.I gdb_generate_unique_name
can be used to generate unique names just as with entities.  In
the call to
.I gdb_create_block, If
.I leave_open
is nonzero, the block is left "open".  This means that entities
subsequently entered into the database are automatically added to this
block.
.I gdb_open_block
can be used to open a block which is currently
closed.  There may be no more than one block open at a time.
The currently open block can be closed with a call to
.I gdb_close_block.
.I gdb_delete_block
deletes the block whose handle is
.I block
from the database. It does not delete the entities contained in the
block.
.PP
.I gdb_add_to_block
adds the entity whose handle is
.I entity
to the block whose handle is
.I block.
This block need not (but may) be open at the time.
.I gdb_subtract_from_block
subtracts the given entity from the given block.  If the entity is not
contained in the block,
.I gdb_subtract_from_block
does nothing. In any case, the entity is not deleted from the database.
.I gdb_empty_block
empties out the block whose handle is
.I block.
It does not delete the entities from the database, but removes them
all from the block.
.I gdb_block_entity_count
returns the number of entities currently in the given block.
.I gdb_block_entity_list
returns in the array
.I harray 
a list of the handles of all entities in the given block.
.I gdb_delete_block_entities
deletes each of a given block's entities from the database after
removing it from all blocks which contain it.  The given block is
not deleted; it is returned empty.
.PP
.I gdb_block_name
returns a block's name.
.I gdb_retrieve_block
retrieves a block's handle based on its contents or other attributes.
The arguments
.I search_type
and
.I search_spec
are analogous to the arguments to
.I gdb_retrieve_entity
(see above). When the search type is GDB_DISTANCE,
.I gdb_retrieve_block
searches for a block which contains an entity within the given
tolerance of the given entity.  It sets
.I search_type->found_entity
to the handle of the matching entity in this block.  In all
cases,
.I block
is set to the entity of the retrieved block, if any, or to NULL if
none.
.PP
.I gdb_delete_all
deletes the entire database.
.I gdb_save
writes the current database into a file named
.I fname,
and sets 
.I *success
to nonzero to indicate success, 0 to indicate failure.  This
file is binary, and is meant only to be read back in by
.I gdb_load,
which restores a database from a file, after clearing out the
current database.
.SH "SEE ALSO"
gdbintro(3X)
.SH AUTHOR
Mark Phillips
.br
Department of Mathematics
.br
University of Maryland
.br
College Park, Maryland  20742
.br
mbp@lakisis.umd.edu
.br
(301) 454-6550
