/* $Id$
 *
 * help.c: procedures for reading and displaying help file in a window
 */

/**************************************************************************
 *     Copyright (C) 1990 by Mark B. Phillips and Robert R. Miner	  *
 * 									  *
 * Permission to use, copy, modify, and distribute this software, its	  *
 * documentation, and any images it generates for any purpose and without *
 * fee is hereby granted, provided that					  *
 * 									  *
 * (1) the above copyright notice appear in all copies and that both that *
 *     copyright notice and this permission notice appear in supporting	  *
 *     documentation, and that the names of Mark B.  Phillips, Robert R.  *
 *     Miner, or the University of Maryland not be used in advertising or *
 *     publicity pertaining to distribution of the software without	  *
 *     specific, written prior permission.				  *
 *									  *
 * (2) Explicit written credit be given to the authors Mark B.  Phillips  *
 *     and Robert R. Miner in any publication which uses part or all of	  *
 *     any image produced by this software.				  *
 *									  *
 * This software is provided "as is" without express or implied warranty. *
 **************************************************************************/

#include <stdio.h>
#include "internal.h"
#include <suntool/textsw.h>

/* Help subframe has one panel and one text subwindow for displaying
 * help page */
static Frame	help_frame = NULL;
static Panel	help_panel = NULL;
static Textsw	help_textsw = NULL;

/* Gadgets for help panel: */
static Panel_item help_done_button;

/* Notification procedure for button in help panel: */
static int help_done_button_proc();

/* Name of file to display in help window; this should be set
 * by the Makefile, but just in case: */
#ifndef HELP_FILE
#define HELP_FILE "/.help"
#endif

/*-----------------------------------------------------------------------
 * Function:	wHelp
 * Description:	pop up the help frame (help button notify proc)
 * Args:	(none)
 * Returns:	nothing
 * Author:	mbp
 * Date:	Mon Apr  9 00:11:39 1990
 * Notes:       The file is read and the window created on the first
 *		call.  After that, we just redisplay the
 *		already-created window.
 */
int
  wHelp()
{
  /* If the help frame hasn't been created yet, create it */
  if (help_frame==NULL) {

    if (!wFileOpenable(HELP_FILE, "r")) {
      printf("Can't open help file \"%s\"\n", HELP_FILE);
      return;
    }

    help_frame =
      window_create(wFrame, FRAME,
		    WIN_FONT,		wFont1,
		    FRAME_LABEL,	"Help Window",
		    FRAME_SHOW_LABEL,	TRUE,
		    0);
    if (help_frame == NULL) {
      printf("Cannot open any more windows !\n");
      return;
      }

    help_panel =
      window_create(help_frame, PANEL,
		    WIN_X, 0,
		    WIN_Y, 3,
		    WIN_HEIGHT,	ATTR_ROW(1)+4,
		    WIN_FONT,	wFont1,
		    0);
    if (help_panel == NULL) {
      printf("Cannot open any more windows !\n");
      window_destroy(help_frame);
      help_frame = NULL;
      return;
      }

    help_done_button = 
      panel_create_item(help_panel, PANEL_BUTTON, 
			PANEL_ITEM_X, ATTR_COL(0),
			PANEL_ITEM_Y, ATTR_ROW(0),
			PANEL_LABEL_IMAGE,
			  panel_button_image(help_panel, "Done", 3, 0),
			PANEL_NOTIFY_PROC, help_done_button_proc,
			0);

    help_textsw =
      window_create(help_frame, TEXTSW,
		    WIN_ERROR_MSG, "I can't find the help file !",
		    WIN_FONT,		    pf_default(),
		    WIN_X,                  0,
		    WIN_Y,		    ATTR_ROW(2)+5,
		    WIN_HEIGHT,             ATTR_ROW(30),
		    WIN_WIDTH,              ATTR_COL(78),
		    TEXTSW_IGNORE_LIMIT,    TEXTSW_INFINITY,
		    TEXTSW_AUTO_INDENT,     TRUE,
		    TEXTSW_BROWSING,        TRUE,
		    TEXTSW_DISABLE_LOAD,    TRUE,
		    TEXTSW_DISABLE_CD,      TRUE,
		    TEXTSW_FILE,    	HELP_FILE,
		    0);
    if (help_textsw == NULL) {
      printf("I can't create the help page\n");
      window_destroy(help_frame);
      help_frame = NULL;
      return;
      }

    window_fit(help_frame);

  }  /* end of "if (help_frame==NULL) ..." */

  /* Now display the help frame */
  if (help_frame!=NULL)
    window_set(help_frame, WIN_SHOW, TRUE, 0);
}

static int
  help_done_button_proc()
{
  window_set(help_frame, WIN_SHOW, FALSE, 0);
}

  
