/*
 * Copyright 1993 by the University of Pennsylvania
 *
 * Permission to use, copy, and distribute for non-commercial purposes,
 * is hereby granted without fee, providing that the above copyright
 * notice appear in all copies and that both the copyright notice and this
 * permission notice appear in supporting documentation.
 *
 * The software may be modified for your own purposes, but modified versions
 * may not be distributed.
 *
 * This software is provided "as is" without any expressed or implied warranty.
 */

/**************************************************************
  Creates MPEGTool Encoder dialog that allows to set following
  parameters: N, M, Quantization Scale, DCT coefficients,
  Start Frame, Number of Frame, Dataname. There are three buttons,
  Start, Configure and Quit. "Start" will start the MPEG encode.
  "Configure" will open MPEGTool Encoder Configuration dialog.
  "Quit" will return to the main menu.
**************************************************************/
#ifdef MOTIF_NEW
#include <Xm/VendorS.h>
#else
#include <Xm/VendorE.h>
#endif
#include <Xm/DialogS.h>
#include <Xm/PushBG.h>
#include <Xm/PushB.h>
#include <Xm/PanedW.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <stdio.h>
#include <malloc.h>

#include "global.h"
/*********************
   extern definition 
**********************/
void init_mpeg_param();
void error_popup();
Widget CreateLabeledTextForm();
Widget CreateLabeledTextForm2();
/********************************
       call back function
 ********************************/
void
  encoder_pushed2(w, P) /* execute mpeg encoder */
Widget w;
MPEG_param *P;
{
  if(mpeg_encoder_param_set(P)) error_popup(w);
}
/************************************************************
                  MPEGTool Encoder dialog
 ************************************************************/
void
  mpeg_pushed(w, app)
Widget w, app;
{
  static Widget dialog;
  Widget form, pane, rc, pb, textform;
  MPEG_param *P;
  extern void SetSensitive();
  extern void quit_dialog();
  extern void configure_pushed();
  extern void encoder_pushed();
/*------------------ Initialize general parameter for mpeg encoder ----------*/
  P = (MPEG_param *)malloc(sizeof(MPEG_param));
  init_mpeg_param(P,(char *)0);  
/*------------------ Creating the dialog ------------------------------------*/
  dialog = XtVaCreatePopupShell("dialog",
               xmDialogShellWidgetClass,  w,
               XmNtitle,          "MPEGTool: Encoder", 
               XmNdeleteResponse, XmDESTROY,
               XmNx,   WidthOfScreen(XtScreen(w)) / 4,
               XmNy,   HeightOfScreen(XtScreen(w)) / 4,
               XmNwidth,  365,
               XmNheight, 285,
               XmNmaxWidth,  365,
               XmNminWidth,  365,
               XmNmaxHeight, 285,
               XmNminHeight, 285,
               NULL);
/*------------------ Creating the pane window (BASE widget) -----------------*/
  pane = XtVaCreateWidget("pane",
           xmPanedWindowWidgetClass,  dialog,
           XmNsashWidth,  1,
           XmNsashHeight, 1,
           NULL);
/*------- Creating 2 rowcolumns -------------------------------------------*/
  form = XtVaCreateWidget("rc",
           xmFormWidgetClass, pane,
           XmNfractionBase,   9,
           XmNpaneMinimum,    230,
           XmNpaneMaximum,    230,
           NULL);
/*--------- Creating each text entry left side on rc widget ---------------*/
  rc = XtVaCreateWidget(NULL,
         xmRowColumnWidgetClass, form,
         XmNleftAttachment,   XmATTACH_FORM,
         XmNrightAttachment,  XmATTACH_POSITION,
         XmNrightPosition,    4,
         XmNtopAttachment,    XmATTACH_FORM,
         XmNbottomAttachment, XmATTACH_FORM,
         XmNleftOffset,       15,
         XmNorientation,      XmVERTICAL,
         NULL);

  textform = CreateLabeledTextForm(rc, "N:", &P->N);
  XtManageChild(textform);
  textform = CreateLabeledTextForm(rc, "M:", &P->M);
  XtManageChild(textform);
  textform = CreateLabeledTextForm(rc, "Quantization Scale:", &P->quant);
  XtManageChild(textform);
  textform = CreateLabeledTextForm(rc, "DCT Coefficients:", &P->Beta);
  XtManageChild(textform);

  XtManageChild(rc);
/*--------- Creating each text entry right side on rc widget ---------------*/
  rc = XtVaCreateWidget(NULL,
         xmRowColumnWidgetClass, form,
         XmNleftAttachment,   XmATTACH_POSITION,
         XmNleftPosition,     5,
         XmNrightAttachment,  XmATTACH_FORM,
         XmNtopAttachment,    XmATTACH_FORM,
         XmNbottomAttachment, XmATTACH_FORM,
         XmNrightOffset,      15,
         XmNorientation,      XmVERTICAL,
         NULL);

  textform = CreateLabeledTextForm (rc, "Start Frame:", &P->start_frame);
  XtManageChild(textform);
  textform = CreateLabeledTextForm (rc, "Number of Frames:", &P->num_of_frame);
  XtManageChild(textform);
  textform = CreateLabeledTextForm2(rc, "Data Name:", &P->data_name);
  XtManageChild(textform);

  XtManageChild(rc);  
  XtManageChild(form);  
/*---------- Creating the pushbutton "Start" that starts encoding ---------*/
  form = XtVaCreateWidget("form", 
           xmFormWidgetClass, pane,
           XmNfractionBase,  13,
           XmNpaneMinimum, 40,
           XmNpaneMaximum, 40,
           NULL);
  pb = XtVaCreateManagedWidget("Start", 
         xmPushButtonGadgetClass, form,
         XmNtopAttachment,    XmATTACH_FORM,
         XmNbottomAttachment, XmATTACH_FORM,
         XmNleftAttachment,   XmATTACH_POSITION,
         XmNleftPosition,     1,
         XmNrightAttachment,  XmATTACH_POSITION,
         XmNrightPosition,    4,
         XmNshowAsDefault,    True,
         XmNdefaultButtonShadowThickness, 1,
         XmNuserData,         app,
         NULL);
  XtAddCallback(pb, XmNactivateCallback, encoder_pushed, P);

/*----------- Creating the pushbutton "Configure" that pops up new window---*/
  pb = XtVaCreateManagedWidget("Configure",
         xmPushButtonGadgetClass, form,
         XmNtopAttachment,    XmATTACH_FORM,
         XmNbottomAttachment, XmATTACH_FORM,
         XmNleftAttachment,   XmATTACH_POSITION,
         XmNleftPosition,     5,
         XmNrightAttachment,  XmATTACH_POSITION,
         XmNrightPosition,    8,
         XmNshowAsDefault,    False,
         XmNdefaultButtonShadowThickness, 1,
         NULL);
   XtAddCallback(pb, XmNactivateCallback, configure_pushed, P);
/*------------ Creates the pushbutton "Cancel" to return to the main menu ----*/
  pb = XtVaCreateManagedWidget("Cancel",
         xmPushButtonWidgetClass, form,
         XmNtopAttachment,     XmATTACH_FORM,
         XmNbottomAttachment,  XmATTACH_FORM,
         XmNleftAttachment,    XmATTACH_POSITION,
         XmNleftPosition,      9,
         XmNrightAttachment,   XmATTACH_POSITION,
         XmNrightPosition,     12,
         XmNshowAsDefault,     False,
         XmNdefaultButtonShadowThickness, 1,
         NULL);
  XtAddCallback(pb, XmNactivateCallback, SetSensitive, w);
        /* reactivete mpeg button on main menu */
  XtAddCallback(pb, XmNactivateCallback, quit_dialog, dialog);

  XtManageChild(form);
/*------------ Creates childs ----*/
  XtManageChild(pane);
  XtPopup(dialog, XtGrabNone);
}
