/*
 * Copyright 1993 by the University of Pennsylvania
 *
 * Permission to use, copy, and distribute for non-commercial purposes,
 * is hereby granted without fee, providing that the above copyright
 * notice appear in all copies and that both the copyright notice and this
 * permission notice appear in supporting documentation.
 *
 * The software may be modified for your own purposes, but modified versions
 * may not be distributed.
 *
 * This software is provided "as is" without any expressed or implied warranty.
 */

/**************************************************************************
  Creates the MPEGTool Statistics dialog. This dialog sets graph
  options such as Statistics, Level, Priority, Create PostScript File
  by toggle switches and MPEGTool Statistics Data File, Start Frame, Frame 
  Number and PostScript File Name by text label. MPEGTool Statistics Data 
  File can be easily selected by clicking BROWSE button, which creates file 
  selection dialog box. "Makegraph" makes graph, whcih are generated by 
  gnuplot with plot.dat and plot.gnu file. "Makegraph" button changes to
  "Clear" button while graph are displayed and click this to clear graph.
 ***************************************************************************/
#include <Xm/DialogS.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/PanedW.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/TextF.h>
#include <Xm/ToggleBG.h>
#include <Xm/PushB.h>

#include <stdio.h>
#include <malloc.h>
#include <ctype.h>

#include "global.h"

Widget CreateLabeledTextRC();
Widget CreateLabeledTextForm2();
Widget CreatManagedIntegerTextField();
void SetUnmanage();
void SetManage();

STAT_param* init_stat_param();
/*-------------------------------------------------------------------------*/
/*----------------------- Call make graph routine -------------------------*/
/*-------------------------------------------------------------------------*/
void
  make_graph_cb(w,S)
Widget w;
STAT_param* S;
{
  Widget pb;

  if(stat_main(S)) 
    error_popup(w);
  else {
    XtVaGetValues(w, XmNuserData, &pb, NULL);
    XtUnmanageChild(w);
    XtManageChild(pb);
  }
}

void
  label_select_cb(parent,w)
Widget parent, w;
{
  int *level;
  char* curr_str;
  char* replace_str; 

  XtVaGetValues(w,
    XmNuserData, &level,
    XmNlabelString, &curr_str,
    NULL);
  switch(*level) {
    case 0: case 3: /* frame */
      replace_str = XmStringCreateSimple("     Frame Number:");break;
    case 1: case 4: /* slice */
      replace_str = XmStringCreateSimple("     Slice Number:");break;
    case 2: /* MB */
      replace_str = XmStringCreateSimple("MacroBlock Number:");break;
    default:
      replace_str = XmStringCreateSimple("?????????? Number:");
  }
  if(!XmStringCompare(curr_str, replace_str)) {
    XtVaSetValues(w, XmNlabelString, replace_str, NULL);
  }
  XtFree(curr_str);
  XtFree(replace_str);
}

void
  label_frame_cb(parent,w)
Widget parent, w;
{
  char* curr_str;
  char* frame = XmStringCreateSimple("     Frame Number:");
  XtVaGetValues(w,
    XmNlabelString, &curr_str,
    NULL);
  if(!XmStringCompare(curr_str, frame)) {
    XtVaSetValues(w, 
      XmNlabelString, frame, 
      NULL);
  }
  XtFree(frame);
}
/*-------------------------------------------------------------------------*/
/*-------------------------  stat dialog main routine ---------------------*/
/*-------------------------------------------------------------------------*/
void
  stat_pushed(w)
Widget w;
{
  STAT_param *S;
  Widget dialog, form, frame, pane, pb, pb2, pb3, label, text,
         FB_toggle, FA_toggle, SB_toggle, SA_toggle, MB_toggle,
         dist_toggle, gen_toggle, ac_toggle, at_toggle,
         toggle, toggle1, toggle2, toggle_box, level_toggle_box;
  /*--- call backs ---*/
  extern void stat_pushed();
  extern void quit_dialog();
  extern void make_graph();
  extern void toggle_set();
  extern void file_selected();
  extern void browse_stat_file();
  extern void result_text();
  extern void SetSensitive();
  extern void SetUnsensitive();
  extern void SetManage();
  extern void SetUnmanage();
  extern void pipe_send_msg();
/*--------------- set init parameter valu ------------------*/
  S = init_stat_param();
/*------------- Creating the Statistics dialog -------------*/
  dialog = XtVaCreatePopupShell("dialog",
             xmDialogShellWidgetClass, w,
	     XmNtitle, "MPEGTool: Statistics",
	     XmNdeleteResponse, XmDESTROY,
	     XmNx,  WidthOfScreen(XtScreen(w)) / 5,
	     XmNy,  HeightOfScreen(XtScreen(w)) / 5,
             XmNwidth,  396,
             XmNheight, 518,
             XmNmaxWidth,  396,
             XmNminWidth,  396,
             XmNmaxHeight, 518,
             XmNminHeight, 518,
             NULL);
/*------- Creating a pane window for the Statistics window ---------*/
  pane = XtVaCreateWidget("pane",
           xmPanedWindowWidgetClass,  dialog,
           XmNsashWidth, 1,
           XmNsashHeight, 1,
           NULL);
/*---------------------------------------------------------------------*/
/*------- Create the stat data info and stat file browse button -------*/
/*---------------------------------------------------------------------*/
  form = XtVaCreateWidget("fileform", 
           xmFormWidgetClass, pane,
           XmNpaneMinimum, 75,
           XmNpaneMaximum, 75,
           XmNhorizontalSpacing, 8,
           XmNverticalSpacing, 10,
           NULL);
  label = XtVaCreateManagedWidget("MPEGTool Statistic Data File:",
            xmLabelWidgetClass, form,
            XmNtopAttachment,   XmATTACH_FORM,
            XmNleftAttachment,  XmATTACH_FORM,
            NULL);
/*------ file name text entry ------*/
  text = XtVaCreateManagedWidget("text",
           xmTextFieldWidgetClass, form,
           XmNcolumns,         50,
           XmNtopAttachment,   XmATTACH_WIDGET,
           XmNtopWidget,       label,
           XmNtopOffset,       5,
           XmNbottomAttachment,XmATTACH_FORM,
           XmNleftAttachment,  XmATTACH_FORM,
           XmNvalue,           S->stat_file_name,
           XmNuserData,        S->stat_file_name,
           NULL);

  XtAddCallback(text, XmNactivateCallback, file_selected, text);
  XtAddCallback(text, XmNactivateCallback,
    XmProcessTraversal, XmTRAVERSE_NEXT_TAB_GROUP);
/*----- make browse buttom -----*/
  pb = XtVaCreateManagedWidget("BROWSE", 
         xmPushButtonWidgetClass, form,
         XmNtopAttachment,   XmATTACH_WIDGET,
         XmNtopWidget,       label,
         XmNtopOffset,       7,
         XmNrightAttachment, XmATTACH_FORM,
         XmNleftAttachment,  XmATTACH_WIDGET,
         XmNleftWidget,      text,
         XmNleftOffset,      7,
         NULL, 0);
  
  XtAddCallback(pb, XmNactivateCallback, browse_stat_file, text);  

  XtManageChild(form);
/*---------------------------------------------------------------------*/
/*------------------------ Creating toggle boxes ----------------------*/
/*---------------------------------------------------------------------*/
  form = XtVaCreateWidget("form", 
           xmFormWidgetClass, pane,
	   XmNfractionBase, 5,
/*         XmNpaneMinimum, 135,
	   XmNpaneMaximum, 135,*/
           XmNhorizontalSpacing, 8,
           XmNverticalSpacing, 10,
	   NULL);
/*------------- Creates stats toggle box -------------*/
  label = XtVaCreateManagedWidget("Statistics:",
            xmLabelWidgetClass, form,
            XmNtopAttachment,   XmATTACH_FORM,
            XmNtopOffset,       31,
            XmNleftAttachment,  XmATTACH_FORM,
            NULL);
  frame = XtVaCreateWidget("frame",
            xmFrameWidgetClass, form,
            XmNtopAttachment,   XmATTACH_FORM,
            XmNleftAttachment,  XmATTACH_POSITION,
            XmNleftPosition,    1,
            NULL);
  toggle_box = XmCreateRadioBox(frame, "toggle_box", NULL, 0);
  XtVaSetValues(toggle_box,
    XmNnumColumns, 2,
    XmNpacking,    XmPACK_COLUMN,
    NULL);
  dist_toggle   = XtVaCreateManagedWidget("Distribution",
             xmToggleButtonGadgetClass, toggle_box,
             XmNset,       (S->kind_of_stat == 0),
             XmNuserData,  &S->kind_of_stat,
             NULL);
  XtAddCallback(dist_toggle,XmNvalueChangedCallback,toggle_set,0);
  gen_toggle    = XtVaCreateManagedWidget("Generation Record",
             xmToggleButtonGadgetClass, toggle_box,
             XmNset,       (S->kind_of_stat == 1),
             XmNuserData,  &S->kind_of_stat,
             NULL);
  XtAddCallback(gen_toggle,XmNvalueChangedCallback,toggle_set,1);
  ac_toggle     = XtVaCreateManagedWidget("Autocorrelation",
             xmToggleButtonGadgetClass, toggle_box,
             XmNset,       (S->kind_of_stat == 2),
             XmNuserData,  &S->kind_of_stat,
             NULL);
  XtAddCallback(ac_toggle,XmNvalueChangedCallback,toggle_set,2);
  at_toggle     = XtVaCreateManagedWidget("Interarrival Time",
             xmToggleButtonGadgetClass, toggle_box,
             XmNset,       (S->kind_of_stat == 3),
             XmNuserData,  &S->kind_of_stat,
             NULL);
  XtAddCallback(at_toggle,XmNvalueChangedCallback,toggle_set,3);
  XtManageChild(toggle_box);
  XtManageChild(frame);
/*------------- Creates the "BIT" and "ATM" toggle box  -------------*/
  label = XtVaCreateManagedWidget("Level:",
            xmLabelWidgetClass, form,
            XmNtopAttachment,   XmATTACH_WIDGET,
            XmNtopWidget,       frame,
            XmNtopOffset,       38,
            XmNleftAttachment,  XmATTACH_FORM,
            NULL);
  frame = XtVaCreateWidget("frame",
            xmFrameWidgetClass, form,
            XmNtopAttachment,   XmATTACH_WIDGET,
            XmNtopWidget,       frame,
            XmNtopOffset,       7,
            XmNleftAttachment,  XmATTACH_POSITION,
            XmNleftPosition,    1,
            NULL);
  level_toggle_box = XmCreateRadioBox(frame, "toggle_box", NULL, 0);
  XtVaSetValues(level_toggle_box,
    XmNnumColumns, 2,
    XmNpacking,    XmPACK_COLUMN,
    NULL);
  FB_toggle = XtVaCreateManagedWidget("Bit/Frame",
             xmToggleButtonGadgetClass, level_toggle_box,
             XmNset,	  (S->level ==0),
             XmNuserData,  &S->level,
             NULL);
  XtAddCallback(FB_toggle, XmNvalueChangedCallback, toggle_set,0);
  SB_toggle = XtVaCreateManagedWidget("Bit/Slice",
             xmToggleButtonGadgetClass, level_toggle_box,
             XmNset,	   (S->level ==1),
             XmNuserData,  &S->level,
             NULL);
  XtAddCallback(SB_toggle, XmNvalueChangedCallback, toggle_set,1);
  MB_toggle = XtVaCreateManagedWidget("Bit/MacroBlock",
             xmToggleButtonGadgetClass, level_toggle_box,
             XmNset,	   (S->level ==2),
             XmNuserData,  &S->level,
             NULL);
  XtAddCallback(MB_toggle, XmNvalueChangedCallback, toggle_set,2);
  FA_toggle = XtVaCreateManagedWidget("ATM/Frame",
             xmToggleButtonGadgetClass, level_toggle_box,
             XmNset,	   (S->level ==3),
             XmNuserData,  &S->level,
             NULL);
  XtAddCallback(FA_toggle, XmNvalueChangedCallback, toggle_set,3);
  SA_toggle = XtVaCreateManagedWidget("ATM/Slice",
             xmToggleButtonGadgetClass, level_toggle_box,
             XmNset,	   (S->level ==4),
             XmNuserData,  &S->level,
             NULL);
  XtAddCallback(SA_toggle, XmNvalueChangedCallback, toggle_set,4);
  XtManageChild(level_toggle_box);
  XtManageChild(frame);
/*------------- Creates priority toggle box  -------------*/
  label = XtVaCreateManagedWidget("Priority:",
            xmLabelWidgetClass, form,
            XmNtopAttachment,   XmATTACH_WIDGET,
            XmNtopWidget,       frame,
            XmNtopOffset,       14,
            XmNleftAttachment,  XmATTACH_FORM,
            NULL);
  frame = XtVaCreateWidget("frame",
            xmFrameWidgetClass, form,
            XmNtopAttachment,   XmATTACH_WIDGET,
            XmNtopWidget,       frame,
            XmNtopOffset,       7,
            XmNbottomAttachment,XmATTACH_FORM, 
            XmNleftAttachment,  XmATTACH_POSITION,
            XmNleftPosition,     1,
            NULL);
  toggle_box = XmCreateRadioBox(frame, "toggle_box", NULL, 0);
  XtVaSetValues(toggle_box,
    XmNnumColumns, 4,
    XmNpacking,    XmPACK_COLUMN,
    NULL);
  toggle = XtVaCreateManagedWidget("HP&LP",
             xmToggleButtonGadgetClass, toggle_box,
             XmNset, (S->priority == 0),
             XmNuserData,  &S->priority,
             NULL);
  XtAddCallback(toggle, XmNvalueChangedCallback, toggle_set,0);
  toggle = XtVaCreateManagedWidget("HP",
             xmToggleButtonGadgetClass, toggle_box,
             XmNset, (S->priority == 1),
             XmNuserData,  &S->priority,
             NULL);
  XtAddCallback(toggle, XmNvalueChangedCallback, toggle_set,1);
  toggle = XtVaCreateManagedWidget("LP",
             xmToggleButtonGadgetClass, toggle_box,
             XmNset, (S->priority == 2),
             XmNuserData,  &S->priority,
             NULL);
  XtAddCallback(toggle, XmNvalueChangedCallback, toggle_set,2);
  toggle = XtVaCreateManagedWidget("HP+LP",
             xmToggleButtonGadgetClass, toggle_box,
             XmNset, (S->priority == 3),
             XmNuserData,  &S->priority,
             NULL);
  XtAddCallback(toggle, XmNvalueChangedCallback, toggle_set,3);
  XtManageChild(toggle_box);
  XtManageChild(frame);
  XtManageChild(form);
/*------------------------------------------------------------------*/
/*------Entry box for start frame and item number ------------------*/
/*------------------------------------------------------------------*/
  form = XtVaCreateWidget("form",
           xmFormWidgetClass, pane,
           XmNfractionBase, 4,
           XmNverticalSpacing, 10,
           NULL);

  label = XtVaCreateManagedWidget("Start Frame: ",
            xmLabelGadgetClass,  form,
            XmNtopAttachment,   XmATTACH_FORM,
            XmNtopOffset,       15,
            XmNleftAttachment,  XmATTACH_FORM,
            XmNleftOffset,    5,
            NULL);

  text = CreatManagedIntegerTextField(form, &S->start_frame, 8);
  XtVaSetValues(text,
    XmNtopAttachment,   XmATTACH_FORM,
    XmNbottomAttachment,XmATTACH_FORM,
    XmNleftAttachment,  XmATTACH_WIDGET,
    XmNleftWidget,      label,
    NULL,0);

  label = XtVaCreateManagedWidget("Frame Number: ",
            xmLabelGadgetClass, form,
            XmNtopAttachment,   XmATTACH_FORM,
            XmNtopOffset,       15,
            XmNleftAttachment,  XmATTACH_POSITION,
            XmNleftPosition,    2,
            XmNuserData,        &S->level,
            NULL);

  label_select_cb(NULL,label); /* select label string */

  text = CreatManagedIntegerTextField(form, &S->stat_num, 8);
  XtVaSetValues(text,
    XmNtopAttachment,   XmATTACH_FORM,
    XmNbottomAttachment,XmATTACH_FORM,
    XmNleftAttachment,  XmATTACH_WIDGET,
    XmNleftWidget,      label,
    NULL,0);
  XtManageChild(form);
/*--------------------------------------------------------------*/
/*               Sensitivity/Management control                 */
/*--------------------------------------------------------------*/
  if(S->kind_of_stat == 3) { /* inter_arr */
    XtSetSensitive(level_toggle_box, False);
  }
  XtAddCallback(dist_toggle, XmNvalueChangedCallback,
                              SetSensitive, level_toggle_box);
  XtAddCallback(gen_toggle, XmNvalueChangedCallback,
                              SetSensitive, level_toggle_box);
  XtAddCallback(ac_toggle, XmNvalueChangedCallback,
                              SetSensitive, level_toggle_box);
  XtAddCallback(at_toggle, XmNvalueChangedCallback,
                              SetUnsensitive, level_toggle_box);



  XtAddCallback(dist_toggle, XmNvalueChangedCallback, label_select_cb, label);
  XtAddCallback(gen_toggle,  XmNvalueChangedCallback, label_select_cb, label);
  XtAddCallback(ac_toggle,   XmNvalueChangedCallback, label_select_cb, label);
  XtAddCallback(at_toggle,   XmNvalueChangedCallback, label_frame_cb, label);

  XtAddCallback(FB_toggle, XmNvalueChangedCallback, label_select_cb, label);
  XtAddCallback(FA_toggle, XmNvalueChangedCallback, label_select_cb, label);
  XtAddCallback(SB_toggle, XmNvalueChangedCallback, label_select_cb, label);
  XtAddCallback(SA_toggle, XmNvalueChangedCallback, label_select_cb, label);
  XtAddCallback(MB_toggle, XmNvalueChangedCallback, label_select_cb, label);


/*-----------------------------------------------------------------------*/
/*------------------ PS output selection sectionon ----------------------*/
/*-----------------------------------------------------------------------*/
  form = XtVaCreateWidget("form2", 
           xmFormWidgetClass, pane,
	   XmNfractionBase, 5,
/*         XmNpaneMinimum, 80,
	   XmNpaneMaximum, 80,*/
           XmNverticalSpacing, 10,
	   NULL);
/*------------- Creates stats toggle box -------------*/
  label = XtVaCreateManagedWidget("Create PostScript File:",
            xmLabelWidgetClass, form,
            XmNtopAttachment,   XmATTACH_FORM,
            XmNtopOffset,       14,
            XmNleftAttachment,  XmATTACH_FORM,
            XmNleftOffset,      5,
            NULL);

  frame = XtVaCreateWidget("frame",
            xmFrameWidgetClass, form,
            XmNtopAttachment,   XmATTACH_FORM,
            XmNleftAttachment,  XmATTACH_POSITION,
            XmNleftPosition,    2,
            XmNleftOffset,      1,
            NULL);

  toggle_box = XmCreateRadioBox(frame, "toggle_box", NULL, 0);
  XtVaSetValues(toggle_box,
                  XmNnumColumns,  2,
                  XmNpacking,     XmPACK_COLUMN,
                  NULL);

  toggle1 = XtVaCreateManagedWidget("Yes ",
             xmToggleButtonGadgetClass, toggle_box, 
             XmNset,	(S->ps_out==1),
             XmNuserData, &S->ps_out,
	     NULL);
  XtAddCallback(toggle1, XmNvalueChangedCallback, toggle_set,1);
  toggle2 = XtVaCreateManagedWidget("No  ",
             xmToggleButtonGadgetClass, toggle_box, 
             XmNset,	(S->ps_out==0),
             XmNuserData, &S->ps_out,
	     NULL);
  XtAddCallback(toggle2, XmNvalueChangedCallback, toggle_set,0);

  XtManageChild(toggle_box);
  XtManageChild(frame);
/*--------- ps file name entry box ---------------*/
  label = XtVaCreateManagedWidget("PostScript File Name:",
            xmLabelWidgetClass, form,
            XmNtopAttachment,   XmATTACH_WIDGET,
            XmNtopWidget,       frame,
            XmNtopOffset,       8,
            XmNleftAttachment,  XmATTACH_FORM,
            XmNleftOffset,      5,
            NULL);

  text = XtVaCreateManagedWidget("text",
            xmTextFieldWidgetClass, form,
            XmNtopAttachment,   XmATTACH_WIDGET,
            XmNtopWidget,       frame,
            XmNtopOffset,       5,
            XmNbottomAttachment,XmATTACH_FORM,
            XmNleftAttachment,  XmATTACH_POSITION,
            XmNleftPosition,    2,
            XmNcolumns,         20,
            XmNvalue,           &S->ps_file_name,
            NULL);

  XtAddCallback(text, XmNactivateCallback, result_text, &S->ps_file_name); 
  XtAddCallback(text, XmNactivateCallback,
    XmProcessTraversal, XmTRAVERSE_NEXT_TAB_GROUP);

  XtAddCallback(toggle1, XmNvalueChangedCallback, SetSensitive,label);
  XtAddCallback(toggle1, XmNvalueChangedCallback, SetSensitive,text);
  XtAddCallback(toggle2, XmNvalueChangedCallback, SetUnsensitive,label);
  XtAddCallback(toggle2, XmNvalueChangedCallback, SetUnsensitive,text);
  if(S->ps_out==0) {
    XtSetSensitive(label, False);
    XtSetSensitive(text,  False);
  }
  XtManageChild(form);
/*------------------------------------------------------------------*/
/*-------------------------- Action Area ---------------------------*/
/*------------------------------------------------------------------*/
  form = XtVaCreateWidget("button_form",
           xmFormWidgetClass, pane,
           XmNfractionBase,	5,
           XmNpaneMinimum,	40,
           XmNpaneMaximum,	40,
           NULL);
/*------------- Creating the pushbutton "Makegraph" -------------*/
  pb = XtVaCreateManagedWidget("Makegraph",
         xmPushButtonGadgetClass, form,
         XmNtopAttachment,	XmATTACH_FORM,
         XmNbottomAttachment, 	XmATTACH_FORM,
         XmNleftAttachment,	XmATTACH_POSITION,
         XmNleftPosition,	1,
         XmNrightAttachment,	XmATTACH_POSITION,
         XmNrightPosition,	2,
         XmNshowAsDefault,	True,
         XmNdefaultButtonShadowThickness,	1,
         NULL);
/*------------- Creating the pushbutton "Makegraph" -------------*/
  pb2 = XtVaCreateWidget("Clear",
         xmPushButtonGadgetClass, form,
         XmNtopAttachment,	XmATTACH_FORM,
         XmNbottomAttachment, 	XmATTACH_FORM,
         XmNleftAttachment,	XmATTACH_POSITION,
         XmNleftPosition,	1,
         XmNrightAttachment,	XmATTACH_POSITION,
         XmNrightPosition,	2,
         XmNshowAsDefault,	False,
         XmNdefaultButtonShadowThickness,	1,
         NULL);
/*------------- Creating the pushbutton "Return_to_menu" -------------*/
  pb3 = XtVaCreateManagedWidget("Cancel",
         xmPushButtonGadgetClass, form,
         XmNtopAttachment,       XmATTACH_FORM,
         XmNbottomAttachment,    XmATTACH_FORM,
         XmNleftAttachment,      XmATTACH_POSITION,
         XmNleftPosition,        3,
         XmNrightAttachment,     XmATTACH_POSITION,
         XmNrightPosition,       4,
         XmNshowAsDefault,       False,
         XmNdefaultButtonShadowThickness,        1,
         NULL);

  XtVaSetValues(pb, XmNuserData, pb2, NULL);

  XtAddCallback(pb, XmNactivateCallback, make_graph_cb, S);
  XtAddCallback(pb, XmNactivateCallback, 
                XmProcessTraversal, XmTRAVERSE_CURRENT);

  XtAddCallback(pb2, XmNactivateCallback, SetManage, pb);
  XtAddCallback(pb2, XmNactivateCallback, SetUnmanage, pb2);
  XtAddCallback(pb2, XmNactivateCallback, pipe_send_msg, NULL);

  XtAddCallback(pb3, XmNactivateCallback, pipe_send_msg, NULL);
  XtAddCallback(pb3, XmNactivateCallback, SetSensitive, w); 
                        /* Restore stat botton at main window */
  XtAddCallback(pb3, XmNactivateCallback, quit_dialog, dialog);

  XtManageChild(form);
  XtManageChild(pane);
  XtPopup(dialog, XtGrabNone);
}

