#!/bin/csh -f
#
#  Generate ray origin and direction from view parameters and image point
#
set cal=( -f /usr/local/lib/ray/lib/proj.cal )
set def=""
while ($#argv > 0)
	switch ($argv[1])
	case -f:
		set cal=( $cal -f $argv[2] )
		shift argv
		breaksw
	case -e:
		set def="${def}$argv[2];"
		shift argv
		breaksw
	case -vp:
		set def="${def}VPx=$argv[2];VPy=$argv[3];VPz=$argv[4];"
		shift argv; shift argv; shift argv
		breaksw
	case -vd:
		set def="${def}VDx=$argv[2];VDy=$argv[3];VDz=$argv[4];"
		shift argv; shift argv; shift argv
		breaksw
	case -vu:
		set def="${def}VUx=$argv[2];VUy=$argv[3];VUz=$argv[4];"
		shift argv; shift argv; shift argv
		breaksw
	case -vh:
		set def="${def}VH=$argv[2];"
		shift argv
		breaksw
	case -vv:
		set def="${def}VV=$argv[2];"
		shift argv
		breaksw
	case -x:
		set def="${def}X=$argv[2];"
		shift argv
		breaksw
	case -y:
		set def="${def}Y=$argv[2];"
		shift argv
		breaksw
	default:
		echo bad option $argv[1]
		exit 1
	endsw
	shift argv
end
#
#  Precompute increments and normalized view direction for speed
#
set hvd=(`rcalc -n $cal -e "$def" -e '$1=IHx;$2=IHy;$3=IHz;$4=IVx;$5=IVy;$6=IVz;$7=NVDx;$8=NVDy;$9=NVDz;'`)
#
#  Execute rcalc
#
exec rcalc $cal -e "$def" -e "IHx=$hvd[1];IHy=$hvd[2];IHz=$hvd[3];" \
		-e "IVx=$hvd[4];IVy=$hvd[5];IVz=$hvd[6];" \
		-e "NVDx=$hvd[7];NVDy=$hvd[8];NVDz=$hvd[9];" \
		-e 'x=$1;y=$2;' \
		-e '$1=VPx;$2=VPy;$3=VPz;$4=PDx;$5=PDy;$6=PDz;'
