/* setup.c
 *
 * $Log:	setup.c,v $
 * Revision 4.0  91/07/17  14:47:24  kolb
 * Initial version.
 *
 */
#include "rayshade.h"
#include "defaults.h"
#include "surface.h"
#include "atmosphe.h"
#include "light.h"
#include "infinite.h"
#include "list.h"
#include "options.h"
#include "stats.h"
#include "viewing.h"
#include "picture.h"
#include "symtab.h" 
#ifdef MULTIMAX
#include <parallel.h>
#define SHARED_BYTES	23	/* 2^23 bytes of shared memory */
#endif
#ifdef RPC
#include <rpc/rpc.h>
#include "progspec.h"
#include <librr/rrloops.h>
#endif

extern GeomList *Defstack;
 
static void SetupWorld();
 
/*
 * Set default parameters
 */
void
RSSetup()
{
	extern SurfList *CurSurf;
	extern Medium TopMedium;
	extern void NoiseInit();
#ifdef MULTIMAX
	unsigned int bytes;
	/*
	 * Initialize shared memory stuff.
	 */
	bytes = 1 << SHARED_BYTES;
	if (share_malloc_init(bytes) == -1) {
		RLerror(RL_PANIC, "Cannot share_malloc %d bytes.\n",bytes);
	} else
		fprintf(fstats,"Malloced %d bytes of shared memory.\n",
				bytes);
#endif
 
	Camera.hfov = HFOV;
	Camera.vfov = UNSET;
	Camera.pos.x = EYEX;
	Camera.pos.y = EYEY;
	Camera.pos.z = EYEZ;
	Camera.lookp.x = LOOKX;
	Camera.lookp.y = LOOKY;
	Camera.lookp.z = LOOKZ;
	Camera.up.x = UPX;
	Camera.up.y = UPY;
	Camera.up.z = UPZ;
	Camera.focaldist = UNSET;
	Camera.aperture = 0.;
	Screen.xres = Screen.yres = UNSET;
 
	Options.maxdepth = MAXDEPTH;
	Options.report_freq = REPORTFREQ;
	Options.jitter = TRUE;
	Options.samples = UNSET;
	Options.gaussian = GAUSSIAN;
	Options.filterwidth = UNSET;
	Options.contrast.r = UNSET;
	Options.ambient.r = Options.ambient.g =
		Options.ambient.b = 1.0;
	Options.cutoff.r = UNSET;
	Options.cache = TRUE;
	Options.shadowtransp = TRUE;
	Options.xmin = Options.ymin = 0.;
	Options.xmax = Options.ymax = 1.;
	Stats.fstats = stderr;
	Options.pictfile = stdout;
#ifdef URT
	Options.alpha = TRUE;
	Options.exp_output = FALSE;
#endif
	Options.gamma = GAMMA;
	Options.eyesep = UNSET;
#ifdef LINDA
	Options.workers = WORKERS;
#endif
	Options.totalframes = 1;
	Options.startframe = 0;
	Options.starttime = 0.;
	Options.framelength = 1.;
	Options.shutterspeed = 0.;
 
	TopMedium.index = DEFAULT_INDEX;
	TopMedium.statten = 1.0;
	NoiseInit();			/* Initialize values for Noise() */
 
	/*
	 * Top of object definition stack points to the World object.
	 * The World object is always a list.
	 */
	Defstack = GeomStackPush(GeomListCreate(), (GeomList *)NULL);
        Defstack->obj->name = (char*)strsave("World");
	/* Initialize surface stack */
	CurSurf = SurfPush((Surface *)NULL, (SurfList *)NULL);
}
 
/*
 * cleanup()
 *
 * Initialize options/variables not set on command line or in input file.
 * Perform sanity checks on widow dimension, maxdepth, etc.
 */
void
RSCleanup()
{
	extern Light *Lights;
	extern void OpenStatsFile();
	extern FILE *yyin;
 
	yyin = (FILE *)NULL;	/* mark that we're done reading input */
 
	if (Options.samples == UNSET)
		Options.samples = DEFSAMPLES;
 
	if (Options.filterwidth == UNSET) {
		if (Options.gaussian)
			Options.filterwidth = FILTERWIDTH;
		else
			/* Default box filter width of 1.0 */
			Options.filterwidth = 1.0;
	}
 
	Options.endframe = Options.startframe + Options.totalframes -1;
 
	OpenStatsFile();
 
	ViewingSetup();
 
	if (Options.cutoff.r == UNSET)
		Options.cutoff.r = Options.cutoff.g =
			Options.cutoff.b = DEFCUTOFF;
 
	/*
	 * Set contrast.
	 */
	if (Options.contrast.r == UNSET) {
		Options.contrast.r = DEFREDCONT;
		Options.contrast.g = DEFGREENCONT;
		Options.contrast.b = DEFBLUECONT;
	}
 
	/*
	 * Image gamma is inverse of display gamma.
	 */
	if (fabs(Options.gamma) > EPSILON)
		Options.gamma = 1. / Options.gamma;
	else
		Options.gamma = FAR_AWAY;
 
	if (Options.maxdepth < 0)
		Options.maxdepth = 0;
 
 
	LightSetup();
}
 
void
RSStartFrame(frame)
int frame;
{
	/*
	 * Set the frame start time
	 */
	Options.framenum = frame;
	Options.framestart = Options.starttime +
			Options.framenum*Options.framelength;
	SamplingSetTime(Options.framestart, Options.shutterspeed,
			Options.framenum);
	/*
	 * Set up viewing parameters.
	 */
	RSViewing();
	/*
	 * Initialize world
	 */
	WorldSetup();
}
 
/*
 * Initialize non-time-varying goodies.
 */
void
RSInitialize(argc, argv)
int argc;
char **argv;
{
	/*
 	 * Initialize variables, etc.
	 */
	RSSetup();
	/*
	 * Parse options from command line.
	 */
	RSOptionsSet(argc, argv);
	/*
	 * Process input file.
	 */
	if (Options.verbose) {
		VersionPrint();
		fprintf(Stats.fstats,"Reading input file...\n");
		(void)fflush(Stats.fstats);
	}
#ifdef RPC

{
	int i;
	FILE *serverfile;
		RayshadeArg arg;
		bzero (&arg,sizeof(RayshadeArg));

		RRProg.name="RAYSHADE 4.0";
		RRProg.RRxdr_fnct=xdr_RayshadeArg;
		RRProg.RR_fnct=remote_rayshade;
		RRProg.arg=(RRArg*) &arg;
		RRProg.argsize=sizeof(RayshadeArg);
		RRProg.RRWriteLine_fnct=raywriteline;

	if(Options.is_rpc_client){
	 	RSReadInputFile();
	        RSCleanup();
	        SamplingSetOptions(Options.samples, Options.gaussian,
			   Options.filterwidth);
		serverfile=fopen(Options.serverfilename,"rb");
                if(!serverfile){
                	fprintf(stderr,"can`t open server file %s \n",Options.serverfilename);
                }       
		WorldSetup();
		
		RRProg.minx=Screen.minx;
		RRProg.maxx=Screen.maxx;
		RRProg.miny=Screen.miny;
		RRProg.maxy=Screen.maxy;
		RRProg.squaresize=Options.squaresize;
		RRProg.startframe=Options.startframe;
		RRProg.endframe=Options.endframe;
		if(Options.display==TRUE){
			extern void display_refresh();
			display_init(Screen.xsize,Screen.ysize,"dadel");
			RRProg.RRPlot_fnct=PlotSquare;
			RRProg.RRRefresh_fnct=display_refresh;
		}

		RSStartFrame(Options.startframe);

		PictureStart(argv);
		
		if (Options.verbose) {
                	/* World object info. */
                	AggregatePrintInfo(World, Stats.fstats);
                	/* Print info about rendering options and the like. */
                	RSOptionsList();
        	}

                rpc_client(serverfile);
		PictureEnd();
		exit(0);
        } else { 
		if (Options.is_rpc_server){
			(void)rpc_server(Options.serverexestring);
		} else {
			RSReadInputFile();
			RSCleanup();
			SamplingSetOptions(Options.samples, Options.gaussian,
                       		    Options.filterwidth);
		}
	}
}
#else
	 RSReadInputFile();

	/*
	 * Set variables that weren't set on command line
	 * or in input file.
	 */
	RSCleanup();
	/*
	 * Set sampling options.
	 */
	SamplingSetOptions(Options.samples, Options.gaussian,
			   Options.filterwidth);
#endif
}
