# GPL License and Copyright Notice ============================================
#  This file is part of Wrye Bash.
#
#  Wrye Bash is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  Wrye Bash is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with Wrye Bash; if not, write to the Free Software Foundation,
#  Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#  Wrye Bash copyright (C) 2005, 2006, 2007 Wrye 
#
# =============================================================================

"""This module starts the Wrye Bash application. Basically, it runs some 
initialization functions, and then starts the main application loop.

Arguments: 

-u userPath: Specify the user profile path. This is only useful/needed on 
systems where HOMEDRIVE and HOMEPATH are not defined as they should be. UserPath 
should be something like "C:\Documents and Settings\Wrye" (replace "Wrye" with 
your user name). 

0 -- Send debug text to the console rather than to a newly created debug window. 
Useful if bash is crashing on startup or if you want to print a lot of 
information (e.g. while developing or debugging).
"""

# Imports ---------------------------------------------------------------------
import getopt
import os
import sys
if sys.version[:3] == '2.4':
    import wxversion
    wxversion.select("2.5.3.1")
import bosh, basher

# Main ------------------------------------------------------------------------
if __name__ == '__main__':
    #--Parse arguments
    optlist,args = getopt.getopt(sys.argv[1:],'u:')
    optdict = dict(optlist)
    if '-u' in optdict:
        drive,path = os.path.splitdrive(optdict['-u'])
        os.environ['HOMEDRIVE'] = drive
        os.environ['HOMEPATH'] = path
    #--Initialize Directories
    #os.environ['HOMEPATH'] = r'\Documents and Settings\Wrye' #--In case of registry problems.
    bosh.initDirs()
    #--More Initialization
    basher.InitSettings()
    basher.InitLinks()
    basher.InitImages()
    #--Start application
    if args and args[0] == '0':
        app = basher.BashApp(0)
    else:
        app = basher.BashApp()
    app.MainLoop()
