/*
 *****************************************************************************
 *                                                                           *
 *  UNIVERSITY OF LOWELL Motif/C++ Binding				     *	
 *                                                                           *
 *  COPYRIGHT (c) 1990 BY  UNIVERSITY OF LOWELL, DEPARTMENT OF COMPUTER      *
 *  SCIENCE, LOWELL, MA 01854                                                *
 *                                                                           *
 *  LICENSED MATERIAL - PROGRAM PROPERTY OF UNIVERSITY OF LOWELL. ALL RIGHTS *
 *  RESERVED.                                                                *
 *                                                                           *
 *  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED    *
 *  ONLY  IN  ACCORDANCE  WITH  THE TERMS OF  SUCH  LICENSE  AND WITH THE    *
 *  INCLUSION OF THE  ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER    *
 *  COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY    *
 *  OTHER PERSON.  NO TITLE TO  OR OWNERSHIP OF  THE  SOFTWARE  IS HEREBY    *
 *  TRANSFERRED.                                                             *
 *                                                                           *
 *  THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE    *
 *  AND  SHOULD  NOT BE CONSTRUED AS A COMMITMENT BY UNIVERSITY OF LOWELL    *
 *                                                                           *
 *****************************************************************************
 *                                                                           *
 * File Name      :                                                          *
 * Author         :                                                          *
 * Created        :                                                          *
 * Description    :                                                          *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 * Edit History   :                                                          *
 * date         who                     what                                 *
 *                                                                           *
 *****************************************************************************
 */
/*
//-----------------------------------------------------------------------------
//
// $Source: /usr/proj/grl/motifplb/design_review_1_efforts/lib_1/XMString.hh,v $
// $Revision: 1.1 $
// $State: Exp $
// $Author: kseethar $
// $Date: 89/12/11 12:45:40 $
// $Locker:  $
//
// $Log:	XMString.hh,v $
Revision 1.1  89/12/11  12:45:40  kseethar
Initial revision


//-----------------------------------------------------------------------------
*/


/*   ----- Modified  2/15/91   X. Li -----   */
typedef short int  Byte;


#ifndef XMString_hh
#define XMString_hh


#include "XMFontList.hh"                       // FontList include file


class XMString;

class XMString {
 private:
      XmString s_s;                            // actual string

 protected :

     // ****CONSTRUCTORS****
     XMString ();
     
 public :
     // ****DESTRUCTOR****
     ~XMString ();                            // XmStringFree
     // ****CONSTRUCTORS****

     XMString (char*);
     XMString (char*, XmStringCharSet, Boolean LtoR = False);   // Create & CreateLtoR
     XMString (XmStringDirection );                // XmStringDirectionCreate
     XMString (char*, XmStringCharSet, XmStringDirection, Boolean);   // SegmentCreate
     XMString (Boolean);                           // SeparatorCreate

     Dimension Baseline      (XMFontList* );
     Boolean   ByteCompare   (XMString*); 
     Boolean   Compare       (XMString*);
     XMString  Concat        (XMString*);
     XMString  Copy          ();

     void      Draw          (Display*, Window, XMFontList*, GC, Position, Position, Dimension, Byte, Byte, XRectangle*);
     void      DrawImage     (Display*, Window, XMFontList*, GC, Position, Position, Dimension, Byte, Byte, XRectangle*);
     void      DrawUnderline (Display*, Drawable, XMFontList*, GC, Position, Position, Dimension, Byte, Byte, XRectangle*, XMString*);


     Boolean   Empty         ();
     void      Extent        (XMFontList*, Dimension*, Dimension* );
     Boolean   GetLtoR       (XmStringCharSet, char**);
     Dimension Height        (XMFontList*);
     Boolean   InitContext   (XmStringContext*);
     int       Length        ();
     int       LineCount     ();
     XMString  NConcat       (XMString*, int);
     XMString  NCopy         (int);
     Dimension Width         (XMFontList*);

     XmString  get_string () { return s_s; };
     void      set_string (XmString s) { s_s = s; }

/* what to do about these functions */
/*
FontListAdd ();
FontListCreate ();
FontListFree ();

FreeContext ();
GetNextComponent ();
GetNextSegment ();
PeekNextComponent ();
*/


};

#endif     // XMString_hh

// dont add stuff after this endif
